/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StudioPathManager {
    private static final String ROOT_FROM_BUNDLED_SDK = "../../";
    private static final String ROOT_FROM_UNBUNDLED_SDK = "../../../../../../";

    public static boolean isRunningFromSources() {
        if (PluginManagerCore.isRunningFromSources()) {
            return true;
        }
        if (StudioPathManager.isRunningInBazelTest()) {
            return true;
        }
        return StudioPathManager.isRunningFromStudioSources();
    }

    @NotNull
    public static Path resolvePathFromSourcesRoot(@NotNull String relativePath) {
        if (relativePath == null) {
            StudioPathManager.$$$reportNull$$$0(0);
        }
        relativePath = FileUtil.normalize((String)relativePath);
        HashMap<String, CallSite> pathMappings = new HashMap<String, CallSite>();
        pathMappings.put("tools/adt/idea", (CallSite)((Object)(PathManager.getCommunityHomePath() + "/android")));
        pathMappings.put("prebuilts/tools/common/kotlin-plugin/Kotlin", (CallSite)((Object)(PathManager.getHomePath() + "/out/artifacts/KotlinPlugin")));
        for (Map.Entry entry : pathMappings.entrySet()) {
            String aospPathPrefix = (String)entry.getKey();
            String ijPathPrefix = (String)entry.getValue();
            if (!relativePath.startsWith(aospPathPrefix)) continue;
            String ijFile = ijPathPrefix + relativePath.substring(aospPathPrefix.length());
            Path path = Paths.get(ijFile, new String[0]).normalize();
            if (path == null) {
                StudioPathManager.$$$reportNull$$$0(1);
            }
            return path;
        }
        Path path = Paths.get(StudioPathManager.getSourcesRootInternal(), new String[0]).resolve(relativePath).normalize();
        if (path == null) {
            StudioPathManager.$$$reportNull$$$0(2);
        }
        return path;
    }

    @Deprecated
    @NotNull
    public static String getSourcesRoot() {
        return StudioPathManager.getSourcesRootInternal();
    }

    @NotNull
    private static String getSourcesRootInternal() {
        assert (StudioPathManager.isRunningFromSources());
        if (PluginManagerCore.isRunningFromSources()) {
            String string = StudioPathManager.getSourcesRootBundled();
            if (string == null) {
                StudioPathManager.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (StudioPathManager.isRunningInBazelTest()) {
            if (PathManager.getHomePath().contains("/prebuilts/studio/intellij-sdk/") || PathManager.getHomePath().contains("\\prebuilts\\studio\\intellij-sdk\\")) {
                String string = StudioPathManager.getSourcesRootUnbundled();
                if (string == null) {
                    StudioPathManager.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = StudioPathManager.getSourcesRootBundled();
            if (string == null) {
                StudioPathManager.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = StudioPathManager.getSourcesRootUnbundled();
        if (string == null) {
            StudioPathManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static String getBinariesRoot() {
        return StudioPathManager.isRunningInBazelTest() ? "" : StudioPathManager.getSourcesRootInternal() + "/bazel-bin";
    }

    private static boolean isRunningInBazelTest() {
        return false;
    }

    private static boolean isRunningFromStudioSources() {
        return PathUtil.toSystemIndependentName((String)PathManager.getHomePath()).contains("/prebuilts/studio/intellij-sdk/");
    }

    private static String getSourcesRootBundled() {
        return Paths.get(PathManager.getHomePath(), ROOT_FROM_BUNDLED_SDK).normalize().toString();
    }

    private static String getSourcesRootUnbundled() {
        Object relative = ROOT_FROM_UNBUNDLED_SDK;
        if (SystemInfo.isMac) {
            relative = (String)relative + "../";
        }
        return Paths.get(PathManager.getHomePath(), new String[]{relative}).normalize().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/util/StudioPathManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/util/StudioPathManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePathFromSourcesRoot";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesRootInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathFromSourcesRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

