/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.ide.environment.EnvironmentService;
import com.intellij.ide.impl.ProjectOpenKeyProvider;
import com.intellij.ide.warmup.WarmupStatus;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleCommandLineProjectConfiguratorKt;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationListener;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationManager;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsTaskId;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleImportHint;
import org.jetbrains.plugins.gradle.settings.GradleImportHintService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.startup.GradleProjectSettingsUpdater;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "getName", "importProjects", "linkGradleHintProjects", "", "basePath", "linkProjects", "linkRootProject", "LoggingNotificationListener", "StateExternalAnnotationNotificationListener", "StateNotificationListener", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradleCommandLineProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCommandLineProjectConfigurator.kt\norg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n43#2,3:267\n1855#3,2:270\n*S KotlinDebug\n*F\n+ 1 GradleCommandLineProjectConfigurator.kt\norg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator\n*L\n69#1:267,3\n113#1:270,2\n*E\n"})
public final class GradleCommandLineProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "gradle";
    }

    @NotNull
    public String getDescription() {
        String string2 = GradleBundle.message("gradle.commandline.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"gradle.commandline.description\")");
        return string2;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CommandLineInspectionProjectConfigurator.ConfiguratorContext $this$configureEnvironment_u24lambda_u240 = context;
        boolean bl = false;
        Registry.get((String)"external.system.auto.import.disabled").setValue(true);
        Registry.get((String)"gradle.auto.auto.jdk.fix.disabled").setValue(true);
        Registry.get((String)"android.gradle.project.startup.activity.disabled").setValue(true);
        Registry.get((String)"android.sdk.local.properties.update.disabled").setValue(true);
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        CommandLineInspectionProgressReporter commandLineInspectionProgressReporter = context.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)commandLineInspectionProgressReporter, (String)"context.logger");
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)new LoggingNotificationListener(commandLineInspectionProgressReporter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = project.getBasePath();
        if (string2 == null) {
            return;
        }
        String basePath = string2;
        boolean $i$f$service = false;
        Class<EnvironmentService> serviceClass$iv = EnvironmentService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        EnvironmentService service = (EnvironmentService)object;
        String projectSelectionKey2 = (String)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(service, null){
            int label;
            final /* synthetic */ EnvironmentService $service;
            {
                this.$service = $service;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$service.getEnvironmentValue(ProjectOpenKeyProvider.Companion.getPROJECT_OPEN_PROCESSOR(), "Gradle", (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (!Intrinsics.areEqual((Object)projectSelectionKey2, (Object)"Gradle")) {
            return;
        }
        GradleImportHint state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
        if (state.getSkip()) {
            return;
        }
        if (GradleSettings.getInstance(project).getLinkedProjectsSettings().isEmpty()) {
            this.linkProjects(basePath, project);
        }
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        StateNotificationListener notificationListener2 = new StateNotificationListener(project);
        ExternalAnnotationsProgressNotificationManager externalAnnotationsNotificationManager = ExternalAnnotationsProgressNotificationManager.Companion.getInstance();
        StateExternalAnnotationNotificationListener externalAnnotationsProgressListener = new StateExternalAnnotationNotificationListener();
        try {
            externalAnnotationsNotificationManager.addNotificationListener(externalAnnotationsProgressListener);
            progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)notificationListener2);
            this.importProjects(project);
            notificationListener2.waitForImportEnd();
            externalAnnotationsProgressListener.waitForResolveExternalAnnotationEnd();
        }
        finally {
            progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)notificationListener2);
            externalAnnotationsNotificationManager.removeNotificationListener(externalAnnotationsProgressListener);
        }
    }

    private final void linkProjects(String basePath, Project project) {
        if (this.linkGradleHintProjects(basePath, project)) {
            return;
        }
        this.linkRootProject(basePath, project);
    }

    private final void importProjects(Project project) {
        Collection collection = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getInstance(project).linkedProjectsSettings");
        Collection linkedProjectsSettings = collection;
        if (linkedProjectsSettings.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = linkedProjectsSettings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleProjectSettings it = (GradleProjectSettings)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)it), (String)"it");
            GradleProjectSettingsUpdater.Util.INSTANCE.updateGradleJvm(project, it).get(10L, TimeUnit.MINUTES);
        }
        AutoImportProjectTracker.Companion.onceIgnoreDisableAutoReloadRegistry();
        AutoImportProjectTracker.Companion.getInstance(project).scheduleProjectRefresh();
    }

    private final boolean linkRootProject(String basePath, Project project) {
        String gradleGroovyDslFile = basePath + "/build.gradle";
        String kotlinDslGradleFile = basePath + "/build.gradle.kts";
        String[] stringArray = new String[]{gradleGroovyDslFile, kotlinDslGradleFile};
        if (FileUtil.findFirstThatExist((String[])stringArray) == null) {
            return false;
        }
        GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Link gradle project from root directory");
        Path path = Paths.get(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(basePath)");
        GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(path, project);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
        return true;
    }

    private final boolean linkGradleHintProjects(String basePath, Project project) {
        GradleImportHint state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
        if (!((Collection)state.getProjectsToImport()).isEmpty()) {
            for (String projectPath : state.getProjectsToImport()) {
                Path buildFile = new File(basePath).toPath().resolve(projectPath);
                if (buildFile.toFile().exists()) {
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Link gradle project from intellij.yaml: " + projectPath);
                    Path path = buildFile.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"buildFile.parent");
                    GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(path, project);
                    ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
                    continue;
                }
                GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("File for linking gradle project doesn't exist: " + buildFile.toAbsolutePath());
                return false;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$LoggingNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "logger", "Lcom/intellij/ide/CommandLineInspectionProgressReporter;", "(Lcom/intellij/ide/CommandLineInspectionProgressReporter;)V", "getLogger", "()Lcom/intellij/ide/CommandLineInspectionProgressReporter;", "onEnd", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onTaskOutput", "text", "", "stdOut", "", "processMessage", "gradleText", "intellij.gradle.common"})
    public static final class LoggingNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final CommandLineInspectionProgressReporter logger;

        public LoggingNotificationListener(@NotNull CommandLineInspectionProgressReporter logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        @NotNull
        public final CommandLineInspectionProgressReporter getLogger() {
            return this.logger;
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String gradleText = (stdOut ? "" : "STDERR: ") + text;
            GradleCommandLineProjectConfiguratorKt.access$getGradleLogWriter$p().write(gradleText);
            String croppedMessage = this.processMessage(gradleText);
            if (croppedMessage != null) {
                this.logger.reportMessage(1, croppedMessage);
            }
        }

        private final String processMessage(String gradleText) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
            if (!Intrinsics.areEqual((Object)WarmupStatus.Companion.currentStatus(application), (Object)WarmupStatus.InProgress.INSTANCE)) {
                return gradleText;
            }
            char[] cArray = new char[]{'\r'};
            String string2 = StringsKt.trimStart((String)gradleText, (char[])cArray);
            cArray = new char[]{'\n'};
            String cropped = StringsKt.trimEnd((String)string2, (char[])cArray);
            if (StringsKt.startsWith$default((String)cropped, (String)"Download", (boolean)false, (int)2, null)) {
                if (StringsKt.contains$default((CharSequence)cropped, (CharSequence)" took ", (boolean)false, (int)2, null)) {
                    return cropped;
                }
                return null;
            }
            return cropped;
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getGradleLogWriter$p().flush();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0006\u0010\u000b\u001a\u00020\bR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateExternalAnnotationNotificationListener;", "Lorg/jetbrains/plugins/gradle/service/notification/ExternalAnnotationsProgressNotificationListener;", "()V", "externalAnnotationsState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/gradle/service/notification/ExternalAnnotationsTaskId;", "Ljava/util/concurrent/CompletableFuture;", "onFinishResolve", "", "id", "onStartResolve", "waitForResolveExternalAnnotationEnd", "intellij.gradle.common"})
    @SourceDebugExtension(value={"SMAP\nGradleCommandLineProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCommandLineProjectConfigurator.kt\norg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateExternalAnnotationNotificationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n1855#2,2:267\n*S KotlinDebug\n*F\n+ 1 GradleCommandLineProjectConfigurator.kt\norg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateExternalAnnotationNotificationListener\n*L\n170#1:267,2\n*E\n"})
    private static final class StateExternalAnnotationNotificationListener
    implements ExternalAnnotationsProgressNotificationListener {
        @NotNull
        private final ConcurrentHashMap<ExternalAnnotationsTaskId, CompletableFuture<ExternalAnnotationsTaskId>> externalAnnotationsState = new ConcurrentHashMap();

        @Override
        public void onStartResolve(@NotNull ExternalAnnotationsTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            ((Map)this.externalAnnotationsState).put(id, new CompletableFuture());
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle resolving external annotations started " + id.getProjectId());
        }

        @Override
        public void onFinishResolve(@NotNull ExternalAnnotationsTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            CompletableFuture<ExternalAnnotationsTaskId> completableFuture = this.externalAnnotationsState.get(id);
            if (completableFuture == null) {
                return;
            }
            CompletableFuture<ExternalAnnotationsTaskId> feature = completableFuture;
            feature.complete(id);
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle resolving external annotations completed " + id.getProjectId());
        }

        public final void waitForResolveExternalAnnotationEnd() {
            Collection<CompletableFuture<ExternalAnnotationsTaskId>> collection = this.externalAnnotationsState.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"externalAnnotationsState.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletableFuture it = (CompletableFuture)element$iv;
                boolean bl = false;
                it.get();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u001c\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0006\u0010\u0014\u001a\u00020\nJ\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0007H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "externalSystemState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Ljava/util/concurrent/CompletableFuture;", "onCancel", "", "id", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "workingDir", "", "onSuccess", "waitForImportEnd", "isGradleProjectResolveTask", "", "intellij.gradle.common"})
    @SourceDebugExtension(value={"SMAP\nGradleCommandLineProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCommandLineProjectConfigurator.kt\norg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateNotificationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n1855#2,2:267\n*S KotlinDebug\n*F\n+ 1 GradleCommandLineProjectConfigurator.kt\norg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$StateNotificationListener\n*L\n229#1:267,2\n*E\n"})
    public static final class StateNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final Project project;
        @NotNull
        private final ConcurrentHashMap<ExternalSystemTaskId, CompletableFuture<ExternalSystemTaskId>> externalSystemState;

        public StateNotificationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.externalSystemState = new ConcurrentHashMap();
        }

        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!this.isGradleProjectResolveTask(id)) {
                return;
            }
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle resolve stage finished with success: " + id.getIdeProjectId());
            SimpleMessageBusConnection connection = this.project.getMessageBus().simpleConnect();
            Topic topic = ProjectDataImportListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new ProjectDataImportListener(id, this){
                final /* synthetic */ ExternalSystemTaskId $id;
                final /* synthetic */ StateNotificationListener this$0;
                {
                    this.$id = $id;
                    this.this$0 = $receiver;
                }

                public void onImportStarted(@Nullable String projectPath) {
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle data import stage started: " + this.$id.getIdeProjectId());
                }

                public void onImportFinished(@Nullable String projectPath) {
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle data import stage finished with success: " + this.$id.getIdeProjectId());
                }

                public void onFinalTasksFinished(@Nullable String projectPath) {
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle data import(final tasks) stage finished: " + this.$id.getIdeProjectId());
                    CompletableFuture completableFuture = (CompletableFuture)StateNotificationListener.access$getExternalSystemState$p(this.this$0).get(this.$id);
                    if (completableFuture == null) {
                        return;
                    }
                    CompletableFuture future = completableFuture;
                    future.complete(this.$id);
                }

                public void onFinalTasksStarted(@Nullable String projectPath) {
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle data import(final tasks) stage started: " + this.$id.getIdeProjectId());
                }

                public void onImportFailed(@Nullable String projectPath, @NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle data import stage finished with failure: " + this.$id.getIdeProjectId());
                    CompletableFuture completableFuture = (CompletableFuture)StateNotificationListener.access$getExternalSystemState$p(this.this$0).get(this.$id);
                    if (completableFuture == null) {
                        return;
                    }
                    CompletableFuture future = completableFuture;
                    future.completeExceptionally(new IllegalStateException("Gradle project " + this.$id.getIdeProjectId() + " import failed.", t));
                }
            });
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.isGradleProjectResolveTask(id)) {
                return;
            }
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("Gradle resolve stage finished with failure " + id.getIdeProjectId(), (Throwable)e);
            CompletableFuture<ExternalSystemTaskId> completableFuture = this.externalSystemState.get(id);
            if (completableFuture == null) {
                return;
            }
            CompletableFuture<ExternalSystemTaskId> future = completableFuture;
            future.completeExceptionally(new IllegalStateException("Gradle project " + id.getIdeProjectId() + " resolve failed.", e));
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!this.isGradleProjectResolveTask(id)) {
                return;
            }
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("Gradle resolve stage canceled " + id.getIdeProjectId());
            CompletableFuture<ExternalSystemTaskId> completableFuture = this.externalSystemState.get(id);
            if (completableFuture == null) {
                return;
            }
            CompletableFuture<ExternalSystemTaskId> future = completableFuture;
            future.completeExceptionally(new IllegalStateException("Resolve of " + id.getIdeProjectId() + " was canceled"));
        }

        public void onStart(@NotNull ExternalSystemTaskId id, @NotNull String workingDir) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (!this.isGradleProjectResolveTask(id)) {
                return;
            }
            ((Map)this.externalSystemState).put(id, new CompletableFuture());
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle resolve stage started " + id.getIdeProjectId() + ", working dir: " + workingDir);
        }

        public final void waitForImportEnd() {
            Collection<CompletableFuture<ExternalSystemTaskId>> collection = this.externalSystemState.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"externalSystemState.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletableFuture it = (CompletableFuture)element$iv;
                boolean bl = false;
                it.get();
            }
        }

        private final boolean isGradleProjectResolveTask(ExternalSystemTaskId $this$isGradleProjectResolveTask) {
            return Intrinsics.areEqual((Object)$this$isGradleProjectResolveTask.getProjectSystemId(), (Object)GradleConstants.SYSTEM_ID) && $this$isGradleProjectResolveTask.getType() == ExternalSystemTaskType.RESOLVE_PROJECT;
        }

        public static final /* synthetic */ ConcurrentHashMap access$getExternalSystemState$p(StateNotificationListener $this) {
            return $this.externalSystemState;
        }
    }
}

