/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.UnsupportedGradleJvmIssueChecker;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleJvmIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "DescriptionBuilder", "Util", "intellij.gradle.common"})
public final class UnsupportedGradleJvmIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        BuildEnvironment buildEnvironment = issueData.getBuildEnvironment();
        if (buildEnvironment == null) {
            return null;
        }
        BuildEnvironment buildEnvironment2 = buildEnvironment;
        GradleVersion gradleVersion2 = GradleVersion.version((String)buildEnvironment2.getGradle().getGradleVersion());
        File javaHome = buildEnvironment2.getJava().getJavaHome();
        String string2 = javaHome.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaHome.path");
        if (Util.isJavaHomeUnsupportedByIdea(string2)) {
            String title = GradleBundle.message("gradle.build.issue.gradle.jvm.unsupported.title", new Object[0]);
            DescriptionBuilder description = new DescriptionBuilder();
            JavaVersion oldestSupportedJavaVersion = GradleJvmSupportMatrix.Companion.getOldestSupportedJavaVersionByIdea();
            Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), oldestSupportedJavaVersion.feature};
            String string3 = GradleBundle.message("gradle.build.issue.gradle.jvm.unsupported.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\n          \"grad\u2026Version.feature\n        )");
            description.addDescription(string3);
            GradleSettingsQuickFix gradleSettingsFix = new GradleSettingsQuickFix(issueData.getProjectPath(), true, GradleSettingsQuickFix.GradleJvmChangeDetector.INSTANCE, GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            boolean isAndroidStudio = Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix());
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"gradleVersion");
            JavaVersion oldestCompatibleJavaVersion = GradleJvmSupportMatrix.Companion.suggestOldestSupportedJavaVersion(gradleVersion2);
            if (!isAndroidStudio && oldestCompatibleJavaVersion != null) {
                Object[] objectArray2 = new Object[]{oldestCompatibleJavaVersion, gradleSettingsFix.getId()};
                String string4 = GradleBundle.message("gradle.build.quick.fix.gradle.jvm", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"gradle.build.qu\u2026on, gradleSettingsFix.id)");
                description.addQuickFixPrompt(string4);
            }
            return new BuildIssue(title, description, gradleSettingsFix){
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<GradleSettingsQuickFix> quickFixes;
                {
                    this.title = $title;
                    this.description = $description.toString();
                    this.quickFixes = CollectionsKt.listOf((Object)$gradleSettingsFix);
                }

                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<GradleSettingsQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    return null;
                }
            };
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\t2\u000b\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleJvmIssueChecker$DescriptionBuilder;", "", "()V", "descriptions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "quickFixPrompts", "addDescription", "", "description", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "addQuickFixPrompt", "prompt", "toString", "intellij.gradle.common"})
    private static final class DescriptionBuilder {
        @NotNull
        private final ArrayList<String> descriptions = new ArrayList();
        @NotNull
        private final ArrayList<String> quickFixPrompts = new ArrayList();

        public final void addDescription(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.descriptions.add(description);
        }

        public final void addQuickFixPrompt(@NotNull String prompt) {
            Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
            this.quickFixPrompts.add(prompt);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)this.descriptions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\n");
            if (!((Collection)this.quickFixPrompts).isEmpty()) {
                $this$toString_u24lambda_u240.append(GradleBundle.message("gradle.build.quick.fix.title", new Object[0])).append("\n");
                $this$toString_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)this.quickFixPrompts, (CharSequence)"\n", null, null, (int)0, null, (Function1)toString.1.1.INSTANCE, (int)30, null)).append("\n");
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleJvmIssueChecker$Util;", "", "()V", "isJavaHomeUnsupportedByIdea", "", "javaHome", "", "intellij.gradle.common"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @JvmStatic
        public static final boolean isJavaHomeUnsupportedByIdea(@NotNull String javaHome) {
            Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType()");
            SdkType javaSdkType = sdkType;
            String string2 = javaSdkType.getVersionString(javaHome);
            if (string2 == null) {
                return false;
            }
            String javaVersionString = string2;
            JavaVersion javaVersion = JavaVersion.tryParse((String)javaVersionString);
            if (javaVersion == null) {
                return false;
            }
            JavaVersion javaVersion2 = javaVersion;
            return !GradleJvmSupportMatrix.Companion.isJavaSupportedByIdea(javaVersion2);
        }
    }
}

