/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportDefaultDataKt;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataStorage;
import org.jetbrains.plugins.gradle.jvmcompat.VersionMapping;
import org.jetbrains.plugins.gradle.util.Ranges;

@State(name="GradleJvmSupportMatrix", storages={@Storage(value="other.xml")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J.\u0010\u0011\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00070\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020\u0002H\u0014J\u0010\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0002H\u0014J\u0012\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\tH\u0002R,\u0010\u0004\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00070\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix;", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;", "Lorg/jetbrains/plugins/gradle/jvmcompat/GradleCompatibilityState;", "()V", "myCompatibility", "", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/gradle/util/Ranges;", "Lcom/intellij/util/lang/JavaVersion;", "Lorg/gradle/util/GradleVersion;", "mySupportedGradleVersions", "mySupportedJavaVersions", "applyState", "", "state", "getAllSupportedGradleVersionsByIdeaImpl", "getAllSupportedJavaVersionsByIdeaImpl", "getCompatibilityRanges", "data", "getOldestRecommendedGradleVersionByIdeaImpl", "getOldestRecommendedJavaVersionByIdeaImpl", "getOldestSupportedGradleVersionByIdeaImpl", "getOldestSupportedJavaVersionByIdeaImpl", "getSupportedGradleVersionsImpl", "javaVersion", "getSupportedJavaVersionsImpl", "gradleVersion", "isGradleDeprecatedByIdeaImpl", "", "isGradleSupportedByIdeaImpl", "isJavaSupportedByIdeaImpl", "isSupportedImpl", "newState", "onStateChanged", "suggestLatestGradleVersionImpl", "suggestLatestJavaVersionImpl", "suggestOldestCompatibleGradleVersionImpl", "suggestOldestCompatibleJavaVersionImpl", "Companion", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradleJvmSupportMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1549#2:213\n1620#2,3:214\n1549#2:217\n1620#2,3:218\n1549#2:221\n1620#2,3:222\n1747#2,3:225\n766#2:228\n857#2,2:229\n766#2:231\n857#2,2:232\n*S KotlinDebug\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix\n*L\n28#1:213\n28#1:214,3\n29#1:217\n29#1:218,3\n39#1:221\n39#1:222,3\n53#1:225,3\n71#1:228\n71#1:229,2\n77#1:231\n77#1:232,2\n*E\n"})
public final class GradleJvmSupportMatrix
extends IdeVersionedDataStorage<GradleCompatibilityState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile List<? extends GradleVersion> mySupportedGradleVersions = CollectionsKt.emptyList();
    @NotNull
    private volatile List<JavaVersion> mySupportedJavaVersions = CollectionsKt.emptyList();
    @NotNull
    private volatile List<Pair<Ranges<JavaVersion>, Ranges<GradleVersion>>> myCompatibility = CollectionsKt.emptyList();

    public GradleJvmSupportMatrix() {
        super(GradleCompatibilityDataParser.INSTANCE, (IdeVersionedDataState)GradleJvmSupportDefaultDataKt.getDEFAULT_DATA());
        this.applyState(GradleJvmSupportDefaultDataKt.getDEFAULT_DATA());
    }

    private final void applyState(GradleCompatibilityState state) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.myCompatibility = this.getCompatibilityRanges(state);
        Iterable iterable = state.getSupportedGradleVersions();
        GradleJvmSupportMatrix gradleJvmSupportMatrix = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GradleVersion.version((String)p0));
        }
        gradleJvmSupportMatrix.mySupportedGradleVersions = (List)destination$iv$iv;
        $this$map$iv = state.getSupportedJavaVersions();
        gradleJvmSupportMatrix = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JavaVersion.parse((String)p0));
        }
        gradleJvmSupportMatrix.mySupportedJavaVersions = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected GradleCompatibilityState newState() {
        return new GradleCompatibilityState();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Ranges<JavaVersion>, Ranges<GradleVersion>>> getCompatibilityRanges(GradleCompatibilityState data) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = data.getCompatibility();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            String gradleVersionInfo;
            void entry;
            VersionMapping versionMapping = (VersionMapping)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = entry.getGradleVersionInfo();
            if (string3 == null) {
                string3 = gradleVersionInfo = "";
            }
            if ((string2 = entry.getJavaVersionInfo()) == null) {
                string2 = "";
            }
            String javaVersionInfo = string2;
            char[] cArray = new char[]{','};
            Ranges gradleRange2 = IdeVersionedDataParser.Companion.parseRange(StringsKt.split$default((CharSequence)gradleVersionInfo, (char[])cArray, (boolean)false, (int)0, (int)6, null), getCompatibilityRanges.1.gradleRange.1.INSTANCE);
            char[] cArray2 = new char[]{','};
            Ranges javaRange2 = IdeVersionedDataParser.Companion.parseRange(StringsKt.split$default((CharSequence)javaVersionInfo, (char[])cArray2, (boolean)false, (int)0, (int)6, null), getCompatibilityRanges.1.javaRange.1.INSTANCE);
            collection.add(TuplesKt.to(javaRange2, gradleRange2));
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void onStateChanged(@NotNull GradleCompatibilityState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.applyState(newState);
    }

    private final boolean isSupportedImpl(GradleVersion gradleVersion2, JavaVersion javaVersion) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.myCompatibility;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    Ranges javaVersions = (Ranges)pair.component1();
                    Ranges gradleVersions = (Ranges)pair.component2();
                    if (!(javaVersions.contains((Comparable)javaVersion) && gradleVersions.contains((Comparable)gradleVersion2))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isJavaSupportedByIdeaImpl(JavaVersion javaVersion) {
        return this.getOldestSupportedJavaVersionByIdeaImpl().compareTo(javaVersion) <= 0;
    }

    private final boolean isGradleSupportedByIdeaImpl(GradleVersion gradleVersion2) {
        return this.getOldestSupportedGradleVersionByIdeaImpl().compareTo(gradleVersion2) <= 0;
    }

    private final boolean isGradleDeprecatedByIdeaImpl(GradleVersion gradleVersion2) {
        return gradleVersion2.compareTo(this.getOldestRecommendedGradleVersionByIdeaImpl()) < 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GradleVersion> getSupportedGradleVersionsImpl(JavaVersion javaVersion) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllSupportedGradleVersionsByIdeaImpl();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleVersion it = (GradleVersion)element$iv$iv;
            boolean bl = false;
            if (!this.isSupportedImpl(it, javaVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaVersion> getSupportedJavaVersionsImpl(GradleVersion gradleVersion2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllSupportedJavaVersionsByIdeaImpl();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaVersion it = (JavaVersion)element$iv$iv;
            boolean bl = false;
            if (!this.isSupportedImpl(gradleVersion2, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final GradleVersion suggestLatestGradleVersionImpl(JavaVersion javaVersion) {
        return (GradleVersion)CollectionsKt.lastOrNull(this.getSupportedGradleVersionsImpl(javaVersion));
    }

    private final JavaVersion suggestLatestJavaVersionImpl(GradleVersion gradleVersion2) {
        return (JavaVersion)CollectionsKt.lastOrNull(this.getSupportedJavaVersionsImpl(gradleVersion2));
    }

    private final GradleVersion suggestOldestCompatibleGradleVersionImpl(JavaVersion javaVersion) {
        return (GradleVersion)CollectionsKt.firstOrNull(this.getSupportedGradleVersionsImpl(javaVersion));
    }

    private final JavaVersion suggestOldestCompatibleJavaVersionImpl(GradleVersion gradleVersion2) {
        return (JavaVersion)CollectionsKt.firstOrNull(this.getSupportedJavaVersionsImpl(gradleVersion2));
    }

    private final List<GradleVersion> getAllSupportedGradleVersionsByIdeaImpl() {
        return this.mySupportedGradleVersions;
    }

    private final List<JavaVersion> getAllSupportedJavaVersionsByIdeaImpl() {
        return this.mySupportedJavaVersions;
    }

    private final GradleVersion getOldestSupportedGradleVersionByIdeaImpl() {
        return (GradleVersion)CollectionsKt.minOrThrow((Iterable)this.getAllSupportedGradleVersionsByIdeaImpl());
    }

    private final GradleVersion getOldestRecommendedGradleVersionByIdeaImpl() {
        GradleVersion gradleVersion2 = GradleVersion.version((String)"4.5");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"version(\"4.5\")");
        return gradleVersion2;
    }

    private final JavaVersion getOldestSupportedJavaVersionByIdeaImpl() {
        return (JavaVersion)CollectionsKt.minOrThrow((Iterable)this.getAllSupportedJavaVersionsByIdeaImpl());
    }

    private final JavaVersion getOldestRecommendedJavaVersionByIdeaImpl() {
        JavaVersion javaVersion = JavaVersion.compose((int)8);
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"compose(8)");
        return javaVersion;
    }

    @JvmStatic
    @NotNull
    public static final GradleJvmSupportMatrix getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final boolean isSupported(@NotNull GradleVersion gradleVersion2, @NotNull JavaVersion javaVersion) {
        return Companion.isSupported(gradleVersion2, javaVersion);
    }

    @JvmStatic
    public static final boolean isJavaSupportedByIdea(@NotNull JavaVersion javaVersion) {
        return Companion.isJavaSupportedByIdea(javaVersion);
    }

    @JvmStatic
    public static final boolean isGradleSupportedByIdea(@NotNull GradleVersion gradleVersion2) {
        return Companion.isGradleSupportedByIdea(gradleVersion2);
    }

    @JvmStatic
    public static final boolean isGradleDeprecatedByIdea(@NotNull GradleVersion gradleVersion2) {
        return Companion.isGradleDeprecatedByIdea(gradleVersion2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J\b\u0010\b\u001a\u00020\tH\u0007J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0007J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix$Companion;", "", "()V", "getAllSupportedGradleVersionsByIdea", "", "Lorg/gradle/util/GradleVersion;", "getAllSupportedJavaVersionsByIdea", "Lcom/intellij/util/lang/JavaVersion;", "getInstance", "Lorg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix;", "getOldestRecommendedGradleVersionByIdea", "getOldestRecommendedJavaVersionByIdea", "getOldestSupportedGradleVersionByIdea", "getOldestSupportedJavaVersionByIdea", "getSupportedGradleVersions", "javaVersion", "getSupportedJavaVersions", "gradleVersion", "isGradleDeprecatedByIdea", "", "isGradleSupportedByIdea", "isJavaSupportedByIdea", "isSupported", "suggestLatestSupportedGradleVersion", "suggestLatestSupportedJavaVersion", "suggestOldestSupportedGradleVersion", "suggestOldestSupportedJavaVersion", "intellij.gradle.common"})
    @SourceDebugExtension(value={"SMAP\nGradleJvmSupportMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,212:1\n43#2,3:213\n*S KotlinDebug\n*F\n+ 1 GradleJvmSupportMatrix.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleJvmSupportMatrix$Companion\n*L\n126#1:213,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleJvmSupportMatrix getInstance() {
            boolean $i$f$service = false;
            Class<GradleJvmSupportMatrix> serviceClass$iv = GradleJvmSupportMatrix.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GradleJvmSupportMatrix)object;
        }

        @JvmStatic
        public final boolean isSupported(@NotNull GradleVersion gradleVersion2, @NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().isSupportedImpl(gradleVersion2, javaVersion);
        }

        @JvmStatic
        public final boolean isJavaSupportedByIdea(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().isJavaSupportedByIdeaImpl(javaVersion);
        }

        @JvmStatic
        public final boolean isGradleSupportedByIdea(@NotNull GradleVersion gradleVersion2) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            return this.getInstance().isGradleSupportedByIdeaImpl(gradleVersion2);
        }

        @JvmStatic
        public final boolean isGradleDeprecatedByIdea(@NotNull GradleVersion gradleVersion2) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            return this.getInstance().isGradleDeprecatedByIdeaImpl(gradleVersion2);
        }

        @NotNull
        public final List<GradleVersion> getSupportedGradleVersions(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().getSupportedGradleVersionsImpl(javaVersion);
        }

        @NotNull
        public final List<JavaVersion> getSupportedJavaVersions(@NotNull GradleVersion gradleVersion2) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            return this.getInstance().getSupportedJavaVersionsImpl(gradleVersion2);
        }

        @Nullable
        public final GradleVersion suggestLatestSupportedGradleVersion(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().suggestLatestGradleVersionImpl(javaVersion);
        }

        @Nullable
        public final JavaVersion suggestLatestSupportedJavaVersion(@NotNull GradleVersion gradleVersion2) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            return this.getInstance().suggestLatestJavaVersionImpl(gradleVersion2);
        }

        @Nullable
        public final GradleVersion suggestOldestSupportedGradleVersion(@NotNull JavaVersion javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            return this.getInstance().suggestOldestCompatibleGradleVersionImpl(javaVersion);
        }

        @Nullable
        public final JavaVersion suggestOldestSupportedJavaVersion(@NotNull GradleVersion gradleVersion2) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            return this.getInstance().suggestOldestCompatibleJavaVersionImpl(gradleVersion2);
        }

        @NotNull
        public final List<GradleVersion> getAllSupportedGradleVersionsByIdea() {
            return this.getInstance().getAllSupportedGradleVersionsByIdeaImpl();
        }

        @NotNull
        public final List<JavaVersion> getAllSupportedJavaVersionsByIdea() {
            return this.getInstance().getAllSupportedJavaVersionsByIdeaImpl();
        }

        @NotNull
        public final GradleVersion getOldestSupportedGradleVersionByIdea() {
            return this.getInstance().getOldestSupportedGradleVersionByIdeaImpl();
        }

        @NotNull
        public final GradleVersion getOldestRecommendedGradleVersionByIdea() {
            return this.getInstance().getOldestRecommendedGradleVersionByIdeaImpl();
        }

        @NotNull
        public final JavaVersion getOldestSupportedJavaVersionByIdea() {
            return this.getInstance().getOldestSupportedJavaVersionByIdeaImpl();
        }

        @NotNull
        public final JavaVersion getOldestRecommendedJavaVersionByIdea() {
            return this.getInstance().getOldestRecommendedJavaVersionByIdeaImpl();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

