/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.statistics;

import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.project.Project;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.statistics.AggregatedTaskReport;
import org.jetbrains.plugins.gradle.service.execution.statistics.GradleExecutionStageHandler;
import org.jetbrains.plugins.gradle.service.execution.statistics.TaskGraphExecutionReport;
import org.jetbrains.plugins.gradle.statistics.GradleExecutionPerformanceCollector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\r*\u00020\u00032\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cH\u0002J\u0014\u0010\u001a\u001a\u00020\r*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001dH\u0002J\u0014\u0010\u001a\u001a\u00020\r*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001dH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleExecutionStageFusHandler;", "Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleExecutionStageHandler;", "taskId", "", "project", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/project/Project;", "(JLjava/lang/ref/WeakReference;)V", "getProject", "()Ljava/lang/ref/WeakReference;", "getTaskId", "()J", "onContainerCallbackExecuted", "", "duration", "onGradleBuildLoaded", "onGradleExecutionCompleted", "onGradleProjectLoaded", "onGradleSettingsEvaluated", "onTaskExecuted", "task", "Lorg/jetbrains/plugins/gradle/service/execution/statistics/AggregatedTaskReport;", "onTaskGraphCalculated", "onTaskGraphExecuted", "report", "Lorg/jetbrains/plugins/gradle/service/execution/statistics/TaskGraphExecutionReport;", "emit", "target", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "intellij.gradle.common"})
public final class GradleExecutionStageFusHandler
implements GradleExecutionStageHandler {
    private final long taskId;
    @NotNull
    private final WeakReference<Project> project;

    public GradleExecutionStageFusHandler(long taskId, @NotNull WeakReference<Project> project) {
        Intrinsics.checkNotNullParameter(project, (String)"project");
        this.taskId = taskId;
        this.project = project;
    }

    public final long getTaskId() {
        return this.taskId;
    }

    @NotNull
    public final WeakReference<Project> getProject() {
        return this.project;
    }

    @Override
    public void onGradleExecutionCompleted(long duration) {
        this.emit(duration, GradleExecutionPerformanceCollector.Companion.getEXECUTION_COMPLETED());
    }

    @Override
    public void onGradleBuildLoaded(long duration) {
        this.emit(duration, GradleExecutionPerformanceCollector.Companion.getBUILD_LOADED());
    }

    @Override
    public void onGradleSettingsEvaluated(long duration) {
        this.emit(duration, GradleExecutionPerformanceCollector.Companion.getSETTINGS_EVALUATED());
    }

    @Override
    public void onGradleProjectLoaded(long duration) {
        this.emit(duration, GradleExecutionPerformanceCollector.Companion.getPROJECT_LOADED());
    }

    @Override
    public void onContainerCallbackExecuted(long duration) {
        this.emit(duration, GradleExecutionPerformanceCollector.Companion.getCONTAINER_CALLBACK_EXECUTED());
    }

    @Override
    public void onTaskGraphCalculated(long duration) {
        this.emit(duration, GradleExecutionPerformanceCollector.Companion.getTASK_GRAPH_CALCULATED());
    }

    @Override
    public void onTaskGraphExecuted(@NotNull TaskGraphExecutionReport report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        this.emit(report, GradleExecutionPerformanceCollector.Companion.getTASK_GRAPH_EXECUTED());
    }

    @Override
    public void onTaskExecuted(@NotNull AggregatedTaskReport task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.emit(task2, GradleExecutionPerformanceCollector.Companion.getTASK_EXECUTED());
    }

    private final void emit(long $this$emit, EventId2<? super Long, ? super Long> target) {
        target.log((Project)this.project.get(), (Object)this.taskId, (Object)$this$emit);
    }

    private final void emit(TaskGraphExecutionReport $this$emit, VarargEventId target) {
        Object[] objectArray = new EventPair[]{GradleExecutionPerformanceCollector.Companion.getEXTERNAL_TASK_ID().with((Object)this.taskId), EventFields.DurationMs.with((Object)$this$emit.getDurationMs()), EventFields.Count.with((Object)$this$emit.getCount()), GradleExecutionPerformanceCollector.Companion.getUP_TO_DATE_COUNT().with((Object)$this$emit.getUpToDateCount()), GradleExecutionPerformanceCollector.Companion.getFROM_CACHE_COUNT().with((Object)$this$emit.getFromCacheCount()), GradleExecutionPerformanceCollector.Companion.getEXECUTED().with((Object)$this$emit.getExecuted())};
        List events = CollectionsKt.listOf((Object[])objectArray);
        target.log((Project)this.project.get(), events);
    }

    private final void emit(AggregatedTaskReport $this$emit, VarargEventId target) {
        Object[] objectArray = new EventPair[]{GradleExecutionPerformanceCollector.Companion.getEXTERNAL_TASK_ID().with((Object)this.taskId), GradleExecutionPerformanceCollector.Companion.getSUM_DURATION_MS().with((Object)$this$emit.getSumDurationMs()), GradleExecutionPerformanceCollector.Companion.getNAME().with((Object)$this$emit.getName()), GradleExecutionPerformanceCollector.Companion.getGRADLE_PLUGIN().with((Object)$this$emit.getPlugin()), GradleExecutionPerformanceCollector.Companion.getUP_TO_DATE_COUNT().with((Object)$this$emit.getUpToDateCount()), GradleExecutionPerformanceCollector.Companion.getFROM_CACHE_COUNT().with((Object)$this$emit.getFromCacheCount()), EventFields.Count.with((Object)$this$emit.getCount()), GradleExecutionPerformanceCollector.Companion.getUP_TO_DATE_DURATION_MS().with((Object)$this$emit.getUpToDateDuration()), GradleExecutionPerformanceCollector.Companion.getFROM_CACHE_DURATION_MS().with((Object)$this$emit.getFromCacheDuration()), GradleExecutionPerformanceCollector.Companion.getFAILED_COUNT().with((Object)$this$emit.getFailed())};
        List events = CollectionsKt.listOf((Object[])objectArray);
        target.log((Project)this.project.get(), events);
    }
}

