/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.GradleVersion;
import com.android.utils.XmlUtils;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "readUrlDataAsString", "url", "android.sdktools.sdk-common"})
@JvmName(name="UpdateGoogleMavenRepositoryCache")
public final class UpdateGoogleMavenRepositoryCache {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)ArraysKt.singleOrNull((Object[])args);
        if (string == null) {
            throw new IllegalStateException("You have to specify the repo root as only argument.".toString());
        }
        String root = string;
        if (!new File(root, ".repo").isDirectory()) {
            throw new IllegalStateException("Invalid directory: should be pointing to the root of a tools checkout directory.".toString());
        }
        File dir = new File(root, "tools/base/sdk-common/src/main/resources/versions-offline/");
        if (!dir.exists()) {
            throw new IllegalStateException((dir.getAbsolutePath() + " does not exist.").toString());
        }
        FilesKt.deleteRecursively((File)dir);
        dir.mkdir();
        String master = UpdateGoogleMavenRepositoryCache.readUrlDataAsString(GoogleMavenRepositoryKt.GMAVEN_BASE_URL + "master-index.xml");
        File masterFile = new File(dir, "master-index.xml");
        Files.asCharSink((File)masterFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)master);
        System.out.println((Object)("Wrote " + masterFile));
        Document document = XmlUtils.parseDocumentSilently((String)master, (boolean)false);
        Intrinsics.checkNotNull((Object)document);
        Document masterDoc = document;
        Element current = XmlUtils.getFirstSubTag((Node)masterDoc.getDocumentElement());
        while (current != null) {
            String group = current.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)group, (String)"group");
            String relative = StringsKt.replace$default((String)group, (char)'.', (char)'/', (boolean)false, (int)4, null);
            String groupIndex = UpdateGoogleMavenRepositoryCache.readUrlDataAsString(GoogleMavenRepositoryKt.GMAVEN_BASE_URL + relative + "/group-index.xml");
            StringBuilder sb = new StringBuilder();
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)groupIndex);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                int start = StringsKt.indexOf$default((CharSequence)line, (String)"versions=\"", (int)0, (boolean)false, (int)6, null);
                boolean done = false;
                if (start != -1) {
                    String sub;
                    int end = StringsKt.indexOf$default((CharSequence)line, (String)"\"", (int)(start += 10), (boolean)false, (int)4, null);
                    Intrinsics.checkNotNullExpressionValue((Object)line.substring(start, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    GradleVersion max = null;
                    TreeMap maxStablePerMajor = new TreeMap(Collections.reverseOrder());
                    String[] stringArray = new String[]{","};
                    Sequence $this$forEach$iv2 = StringsKt.splitToSequence$default((CharSequence)sub, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        GradleVersion v;
                        String it = (String)element$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)GradleVersion.parse(it), (String)"parse(it)");
                        if (max == null || v.compareTo(max) > 0) {
                            max = v;
                        }
                        if (v.isPreview()) continue;
                        maxStablePerMajor.compute(v.getMajor(), new BiFunction(v){
                            final /* synthetic */ GradleVersion $v;
                            {
                                this.$v = $v;
                            }

                            @Nullable
                            public final GradleVersion apply(@NotNull Integer n, @Nullable GradleVersion old) {
                                Intrinsics.checkNotNullParameter((Object)n, (String)"<anonymous parameter 0>");
                                GradleVersion gradleVersion = old;
                                return gradleVersion == null ? this.$v : (GradleVersion)ComparisonsKt.maxOf((Comparable)gradleVersion, (Comparable)this.$v);
                            }
                        });
                    }
                    if (max != null) {
                        String string2 = line.substring(0, start);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        sb.append(string2);
                        Collection collection = maxStablePerMajor.values();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"maxStablePerMajor.values");
                        CollectionsKt.joinTo$default((Iterable)CollectionsKt.toSortedSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.take((Iterable)collection, (int)2), (Object)max)), (Appendable)sb, (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
                        String string3 = line.substring(end);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                        sb.append(string3);
                        sb.append("\n");
                        done = true;
                    }
                }
                if (done) continue;
                sb.append(line).append("\n");
            }
            File file = new File(dir, StringsKt.replace$default((String)relative, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null) + File.separatorChar + "group-index.xml");
            file.getParentFile().mkdirs();
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)sb);
            System.out.println((Object)("Wrote " + file));
            current = XmlUtils.getNextTag((Node)current);
        }
        System.out.println((Object)"Updated indices. NOTE: You may need to update the JarContentsTest gradle integration test if the set of packaged xml files has changed. See JarContentsTest for instructions on how to update the test.");
    }

    private static final String readUrlDataAsString(String url) {
        String string = Resources.asCharSource((URL)new URL(url), (Charset)Charsets.UTF_8).read();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asCharSource(URL(url), Charsets.UTF_8).read()");
        return string;
    }
}

