/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.GrammaticalGenderQualifier;
import com.android.ide.common.resources.configuration.HighDynamicRangeQualifier;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.resources.configuration.WideGamutColorQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class FolderConfiguration
implements Comparable<FolderConfiguration>,
Serializable {
    private static final ResourceQualifier[] DEFAULT_QUALIFIERS;
    public static final Splitter QUALIFIER_SPLITTER;
    private static final int INDEX_COUNTRY_CODE = 0;
    private static final int INDEX_NETWORK_CODE = 1;
    private static final int INDEX_LOCALE = 2;
    private static final int INDEX_GRAMMATICAL_GENDER = 3;
    private static final int INDEX_LAYOUT_DIR = 4;
    private static final int INDEX_SMALLEST_SCREEN_WIDTH = 5;
    private static final int INDEX_SCREEN_WIDTH = 6;
    private static final int INDEX_SCREEN_HEIGHT = 7;
    private static final int INDEX_SCREEN_LAYOUT_SIZE = 8;
    private static final int INDEX_SCREEN_RATIO = 9;
    private static final int INDEX_SCREEN_ROUND = 10;
    private static final int INDEX_WIDE_COLOR_GAMUT = 11;
    private static final int INDEX_HIGH_DYNAMIC_RANGE = 12;
    private static final int INDEX_SCREEN_ORIENTATION = 13;
    private static final int INDEX_UI_MODE = 14;
    private static final int INDEX_NIGHT_MODE = 15;
    private static final int INDEX_PIXEL_DENSITY = 16;
    private static final int INDEX_TOUCH_TYPE = 17;
    private static final int INDEX_KEYBOARD_STATE = 18;
    private static final int INDEX_TEXT_INPUT_METHOD = 19;
    private static final int INDEX_NAVIGATION_STATE = 20;
    private static final int INDEX_NAVIGATION_METHOD = 21;
    private static final int INDEX_SCREEN_DIMENSION = 22;
    private static final int INDEX_VERSION = 23;
    private static final int INDEX_COUNT = 24;
    private static final ResourceQualifier[] NULL_QUALIFIERS;
    private final ResourceQualifier[] mQualifiers = new ResourceQualifier[24];
    private String mQualifierString;

    public FolderConfiguration() {
        this(NULL_QUALIFIERS);
        this.mQualifierString = "";
    }

    private FolderConfiguration(ResourceQualifier[] qualifiers) {
        System.arraycopy(qualifiers, 0, this.mQualifiers, 0, 24);
    }

    public static FolderConfiguration getConfig(String[] folderSegments) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])folderSegments);
        if (iterator.hasNext()) {
            iterator.next();
        }
        return FolderConfiguration.getConfigFromQualifiers((Iterator<String>)iterator);
    }

    public static FolderConfiguration getConfig(Iterable<String> folderSegments) {
        Iterator<String> iterator = folderSegments.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return FolderConfiguration.getConfigFromQualifiers(iterator);
    }

    public static FolderConfiguration getConfigFromQualifiers(Iterable<String> qualifiers) {
        return FolderConfiguration.getConfigFromQualifiers(qualifiers.iterator());
    }

    public static FolderConfiguration getConfigFromQualifiers(Iterator<String> qualifiers) {
        String seg;
        FolderConfiguration config = new FolderConfiguration();
        int qualifierIndex = 0;
        int qualifierCount = DEFAULT_QUALIFIERS.length;
        if (!qualifiers.hasNext()) {
            return config;
        }
        while (qualifiers.hasNext()) {
            seg = qualifiers.next();
            if (seg.isEmpty()) {
                return null;
            }
            seg = seg.toLowerCase(Locale.US);
            while (qualifierIndex < 2 && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                ++qualifierIndex;
            }
            if (qualifierIndex == 2) {
                boolean handle = true;
                if (DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                    ++qualifierIndex;
                    if (qualifiers.hasNext()) {
                        seg = qualifiers.next();
                        if (seg.isEmpty()) {
                            return null;
                        }
                        if (LocaleQualifier.isRegionSegment(seg)) {
                            LocaleQualifier localeQualifier = config.getLocaleQualifier();
                            assert (localeQualifier != null);
                            localeQualifier.setRegionSegment(seg);
                            handle = false;
                        } else {
                            seg = seg.toLowerCase(Locale.US);
                        }
                    } else {
                        return config;
                    }
                }
                if (!handle) break;
                while (qualifierIndex < qualifierCount && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                    ++qualifierIndex;
                }
                if (qualifierIndex == qualifierCount) {
                    return null;
                }
                ++qualifierIndex;
                break;
            }
            ++qualifierIndex;
        }
        while (qualifiers.hasNext()) {
            seg = qualifiers.next();
            if (seg.isEmpty()) {
                return null;
            }
            seg = seg.toLowerCase(Locale.US);
            while (qualifierIndex < qualifierCount && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                ++qualifierIndex;
            }
            if (qualifierIndex == qualifierCount) {
                return null;
            }
            ++qualifierIndex;
        }
        return config;
    }

    public static Set<String> getLanguageConfigFromQualifiers(String qualifierString) {
        if (qualifierString.isEmpty()) {
            return ImmutableSet.of();
        }
        FolderConfiguration config = new FolderConfiguration();
        int start = 0;
        int qualifierIndex = 0;
        boolean stop = false;
        while (qualifierIndex < 2 && !stop) {
            int end = qualifierString.indexOf(45, start);
            String qualifier = end == -1 ? qualifierString.substring(start) : qualifierString.substring(start, end);
            qualifier = qualifier.toLowerCase(Locale.US);
            while (qualifierIndex < 2 && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(qualifier, config)) {
                ++qualifierIndex;
            }
            if (end == -1) {
                stop = true;
                continue;
            }
            if (qualifierIndex == 2) continue;
            start = end + 1;
        }
        if (stop) {
            return ImmutableSet.of();
        }
        int languageStart = start;
        int end = qualifierString.length() - 1;
        qualifierIndex = 23;
        while (qualifierIndex > 2 && !stop) {
            start = qualifierString.lastIndexOf(45, end);
            String qualifier = start == -1 ? qualifierString : qualifierString.substring(start + 1, end + 1);
            qualifier = qualifier.toLowerCase(Locale.US);
            while (qualifierIndex > 2 && !FolderConfiguration.checkQualifier(config, qualifierIndex, qualifier)) {
                --qualifierIndex;
            }
            if (start == -1) {
                stop = true;
                continue;
            }
            if (qualifierIndex == 2) continue;
            end = start - 1;
        }
        String languages = qualifierString.substring(languageStart, end + 1);
        return Streams.stream((Iterable)Splitter.on((String)",").split((CharSequence)languages)).map(locale -> {
            DEFAULT_QUALIFIERS[2].checkAndSet((String)locale, config);
            if (config.getLocaleQualifier() != null) {
                return config.getLocaleQualifier().getLanguage();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean checkQualifier(FolderConfiguration config, int qualifierIndex, String qualifierValue) {
        if (DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(qualifierValue, config)) {
            return true;
        }
        if (qualifierIndex == 12) {
            return DEFAULT_QUALIFIERS[11].checkAndSet(qualifierValue, config);
        }
        if (qualifierIndex == 11) {
            return DEFAULT_QUALIFIERS[12].checkAndSet(qualifierValue, config);
        }
        return false;
    }

    public static FolderConfiguration getConfigForFolder(String folderName) {
        return FolderConfiguration.getConfig(QUALIFIER_SPLITTER.split((CharSequence)folderName));
    }

    public static FolderConfiguration copyOf(FolderConfiguration original) {
        return new FolderConfiguration(original.mQualifiers);
    }

    public static FolderConfiguration getConfigForQualifierString(String qualifierString) {
        if (qualifierString.isEmpty()) {
            return new FolderConfiguration();
        }
        return FolderConfiguration.getConfigFromQualifiers(QUALIFIER_SPLITTER.split((CharSequence)qualifierString));
    }

    public static int getQualifierCount() {
        return 24;
    }

    public void set(FolderConfiguration config) {
        this.set(config, false);
    }

    public void set(FolderConfiguration config, boolean nonFakeValuesOnly) {
        if (config != null) {
            for (int i = 0; i < 24; ++i) {
                ResourceQualifier q = config.mQualifiers[i];
                if (nonFakeValuesOnly && q != null && q.hasFakeValue()) continue;
                this.mQualifiers[i] = q;
                this.mQualifierString = null;
            }
        }
    }

    public void reset() {
        System.arraycopy(NULL_QUALIFIERS, 0, this.mQualifiers, 0, 24);
        this.mQualifierString = "";
    }

    public void substract(FolderConfiguration config) {
        for (int i = 0; i < 24; ++i) {
            if (!ResourceQualifier.isValid(config.mQualifiers[i])) continue;
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
            this.mQualifierString = null;
        }
    }

    public void add(FolderConfiguration config) {
        for (int i = 0; i < 24; ++i) {
            if (config.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            this.mQualifiers[i] = config.mQualifiers[i];
            this.mQualifierString = null;
        }
    }

    public ResourceQualifier getInvalidQualifier() {
        for (int i = 0; i < 24; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i].isValid()) continue;
            return this.mQualifiers[i];
        }
        return null;
    }

    public void addQualifier(ResourceQualifier qualifier) {
        if (qualifier instanceof CountryCodeQualifier) {
            this.mQualifiers[0] = qualifier;
        } else if (qualifier instanceof NetworkCodeQualifier) {
            this.mQualifiers[1] = qualifier;
        } else if (qualifier instanceof LocaleQualifier) {
            this.mQualifiers[2] = qualifier;
        } else if (qualifier instanceof LayoutDirectionQualifier) {
            this.mQualifiers[4] = qualifier;
        } else if (qualifier instanceof SmallestScreenWidthQualifier) {
            this.mQualifiers[5] = qualifier;
        } else if (qualifier instanceof ScreenWidthQualifier) {
            this.mQualifiers[6] = qualifier;
        } else if (qualifier instanceof ScreenHeightQualifier) {
            this.mQualifiers[7] = qualifier;
        } else if (qualifier instanceof ScreenSizeQualifier) {
            this.mQualifiers[8] = qualifier;
        } else if (qualifier instanceof ScreenRatioQualifier) {
            this.mQualifiers[9] = qualifier;
        } else if (qualifier instanceof ScreenRoundQualifier) {
            this.mQualifiers[10] = qualifier;
        } else if (qualifier instanceof WideGamutColorQualifier) {
            this.mQualifiers[11] = qualifier;
        } else if (qualifier instanceof HighDynamicRangeQualifier) {
            this.mQualifiers[12] = qualifier;
        } else if (qualifier instanceof ScreenOrientationQualifier) {
            this.mQualifiers[13] = qualifier;
        } else if (qualifier instanceof UiModeQualifier) {
            this.mQualifiers[14] = qualifier;
        } else if (qualifier instanceof NightModeQualifier) {
            this.mQualifiers[15] = qualifier;
        } else if (qualifier instanceof DensityQualifier) {
            this.mQualifiers[16] = qualifier;
        } else if (qualifier instanceof TouchScreenQualifier) {
            this.mQualifiers[17] = qualifier;
        } else if (qualifier instanceof KeyboardStateQualifier) {
            this.mQualifiers[18] = qualifier;
        } else if (qualifier instanceof TextInputMethodQualifier) {
            this.mQualifiers[19] = qualifier;
        } else if (qualifier instanceof NavigationStateQualifier) {
            this.mQualifiers[20] = qualifier;
        } else if (qualifier instanceof NavigationMethodQualifier) {
            this.mQualifiers[21] = qualifier;
        } else if (qualifier instanceof ScreenDimensionQualifier) {
            this.mQualifiers[22] = qualifier;
        } else if (qualifier instanceof VersionQualifier) {
            this.mQualifiers[23] = qualifier;
        } else if (qualifier instanceof GrammaticalGenderQualifier) {
            this.mQualifiers[3] = qualifier;
        }
        this.mQualifierString = null;
    }

    public void removeQualifier(ResourceQualifier qualifier) {
        for (int i = 0; i < 24; ++i) {
            if (this.mQualifiers[i] != qualifier) continue;
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
            this.mQualifierString = null;
            return;
        }
    }

    public ResourceQualifier getQualifier(int index) {
        return this.mQualifiers[index];
    }

    public void forEach(Consumer<? super ResourceQualifier> action) {
        for (int i = 0; i < 24; ++i) {
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == null || qualifier == NULL_QUALIFIERS[i]) continue;
            action.accept(qualifier);
        }
    }

    public boolean any(Predicate<? super ResourceQualifier> predicate) {
        for (int i = 0; i < 24; ++i) {
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == null || qualifier == NULL_QUALIFIERS[i] || !predicate.test(qualifier)) continue;
            return true;
        }
        return false;
    }

    public void setCountryCodeQualifier(CountryCodeQualifier qualifier) {
        this.mQualifiers[0] = qualifier == null ? NULL_QUALIFIERS[0] : qualifier;
        this.mQualifierString = null;
    }

    public CountryCodeQualifier getCountryCodeQualifier() {
        return (CountryCodeQualifier)this.mQualifiers[0];
    }

    public void setNetworkCodeQualifier(NetworkCodeQualifier qualifier) {
        this.mQualifiers[1] = qualifier == null ? NULL_QUALIFIERS[1] : qualifier;
        this.mQualifierString = null;
    }

    public NetworkCodeQualifier getNetworkCodeQualifier() {
        return (NetworkCodeQualifier)this.mQualifiers[1];
    }

    public void setLocaleQualifier(LocaleQualifier qualifier) {
        this.mQualifiers[2] = qualifier == null ? NULL_QUALIFIERS[2] : qualifier;
        this.mQualifierString = null;
    }

    public LocaleQualifier getLocaleQualifier() {
        return (LocaleQualifier)this.mQualifiers[2];
    }

    public void setLayoutDirectionQualifier(LayoutDirectionQualifier qualifier) {
        this.mQualifiers[4] = qualifier == null ? NULL_QUALIFIERS[4] : qualifier;
        this.mQualifierString = null;
    }

    public LayoutDirectionQualifier getLayoutDirectionQualifier() {
        return (LayoutDirectionQualifier)this.mQualifiers[4];
    }

    public void setSmallestScreenWidthQualifier(SmallestScreenWidthQualifier qualifier) {
        this.mQualifiers[5] = qualifier == null ? NULL_QUALIFIERS[5] : qualifier;
        this.mQualifierString = null;
    }

    public SmallestScreenWidthQualifier getSmallestScreenWidthQualifier() {
        return (SmallestScreenWidthQualifier)this.mQualifiers[5];
    }

    public void setScreenWidthQualifier(ScreenWidthQualifier qualifier) {
        this.mQualifiers[6] = qualifier == null ? NULL_QUALIFIERS[6] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenWidthQualifier getScreenWidthQualifier() {
        return (ScreenWidthQualifier)this.mQualifiers[6];
    }

    public void setScreenHeightQualifier(ScreenHeightQualifier qualifier) {
        this.mQualifiers[7] = qualifier == null ? NULL_QUALIFIERS[7] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenHeightQualifier getScreenHeightQualifier() {
        return (ScreenHeightQualifier)this.mQualifiers[7];
    }

    public void setScreenSizeQualifier(ScreenSizeQualifier qualifier) {
        this.mQualifiers[8] = qualifier == null ? NULL_QUALIFIERS[8] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenSizeQualifier getScreenSizeQualifier() {
        return (ScreenSizeQualifier)this.mQualifiers[8];
    }

    public void setScreenRatioQualifier(ScreenRatioQualifier qualifier) {
        this.mQualifiers[9] = qualifier == null ? NULL_QUALIFIERS[9] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenRatioQualifier getScreenRatioQualifier() {
        return (ScreenRatioQualifier)this.mQualifiers[9];
    }

    public void setScreenRoundQualifier(ScreenRoundQualifier qualifier) {
        this.mQualifiers[10] = qualifier == null ? NULL_QUALIFIERS[10] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenRoundQualifier getScreenRoundQualifier() {
        return (ScreenRoundQualifier)this.mQualifiers[10];
    }

    public void setWideColorGamutQualifier(WideGamutColorQualifier qualifier) {
        this.mQualifiers[11] = qualifier == null ? NULL_QUALIFIERS[11] : qualifier;
        this.mQualifierString = null;
    }

    public WideGamutColorQualifier getWideColorGamutQualifier() {
        return (WideGamutColorQualifier)this.mQualifiers[11];
    }

    public void setHighDynamicRangeQualifier(HighDynamicRangeQualifier qualifier) {
        this.mQualifiers[12] = qualifier == null ? NULL_QUALIFIERS[12] : qualifier;
        this.mQualifierString = null;
    }

    public HighDynamicRangeQualifier getHighDynamicRangeQualifier() {
        return (HighDynamicRangeQualifier)this.mQualifiers[12];
    }

    public void setScreenOrientationQualifier(ScreenOrientationQualifier qualifier) {
        this.mQualifiers[13] = qualifier == null ? NULL_QUALIFIERS[13] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenOrientationQualifier getScreenOrientationQualifier() {
        return (ScreenOrientationQualifier)this.mQualifiers[13];
    }

    public void setUiModeQualifier(UiModeQualifier qualifier) {
        this.mQualifiers[14] = qualifier == null ? NULL_QUALIFIERS[14] : qualifier;
        this.mQualifierString = null;
    }

    public UiModeQualifier getUiModeQualifier() {
        return (UiModeQualifier)this.mQualifiers[14];
    }

    public void setNightModeQualifier(NightModeQualifier qualifier) {
        this.mQualifiers[15] = qualifier == null ? NULL_QUALIFIERS[15] : qualifier;
        this.mQualifierString = null;
    }

    public NightModeQualifier getNightModeQualifier() {
        return (NightModeQualifier)this.mQualifiers[15];
    }

    public void setDensityQualifier(DensityQualifier qualifier) {
        this.mQualifiers[16] = qualifier == null ? NULL_QUALIFIERS[16] : qualifier;
        this.mQualifierString = null;
    }

    public DensityQualifier getDensityQualifier() {
        return (DensityQualifier)this.mQualifiers[16];
    }

    public void setTouchTypeQualifier(TouchScreenQualifier qualifier) {
        this.mQualifiers[17] = qualifier == null ? NULL_QUALIFIERS[17] : qualifier;
        this.mQualifierString = null;
    }

    public TouchScreenQualifier getTouchTypeQualifier() {
        return (TouchScreenQualifier)this.mQualifiers[17];
    }

    public void setKeyboardStateQualifier(KeyboardStateQualifier qualifier) {
        this.mQualifiers[18] = qualifier == null ? NULL_QUALIFIERS[18] : qualifier;
        this.mQualifierString = null;
    }

    public KeyboardStateQualifier getKeyboardStateQualifier() {
        return (KeyboardStateQualifier)this.mQualifiers[18];
    }

    public void setTextInputMethodQualifier(TextInputMethodQualifier qualifier) {
        this.mQualifiers[19] = qualifier == null ? NULL_QUALIFIERS[19] : qualifier;
        this.mQualifierString = null;
    }

    public TextInputMethodQualifier getTextInputMethodQualifier() {
        return (TextInputMethodQualifier)this.mQualifiers[19];
    }

    public void setNavigationStateQualifier(NavigationStateQualifier qualifier) {
        this.mQualifiers[20] = qualifier == null ? NULL_QUALIFIERS[20] : qualifier;
        this.mQualifierString = null;
    }

    public NavigationStateQualifier getNavigationStateQualifier() {
        return (NavigationStateQualifier)this.mQualifiers[20];
    }

    public void setNavigationMethodQualifier(NavigationMethodQualifier qualifier) {
        this.mQualifiers[21] = qualifier == null ? NULL_QUALIFIERS[21] : qualifier;
        this.mQualifierString = null;
    }

    public NavigationMethodQualifier getNavigationMethodQualifier() {
        return (NavigationMethodQualifier)this.mQualifiers[21];
    }

    public void setScreenDimensionQualifier(ScreenDimensionQualifier qualifier) {
        this.mQualifiers[22] = qualifier == null ? NULL_QUALIFIERS[22] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenDimensionQualifier getScreenDimensionQualifier() {
        return (ScreenDimensionQualifier)this.mQualifiers[22];
    }

    public void setVersionQualifier(VersionQualifier qualifier) {
        this.mQualifiers[23] = qualifier == null ? NULL_QUALIFIERS[23] : qualifier;
        this.mQualifierString = null;
    }

    public VersionQualifier getVersionQualifier() {
        return (VersionQualifier)this.mQualifiers[23];
    }

    public void setGrammaticalGenderQualifier(GrammaticalGenderQualifier qualifier) {
        this.mQualifiers[3] = qualifier == null ? NULL_QUALIFIERS[3] : qualifier;
        this.mQualifierString = null;
    }

    public GrammaticalGenderQualifier getGrammaticalGenderQualifier() {
        return (GrammaticalGenderQualifier)this.mQualifiers[3];
    }

    public void normalizeByAddingImpliedVersionQualifier() {
        int minSdk = 1;
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            int min;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (min = qualifier.since()) <= minSdk) continue;
            minSdk = min;
        }
        if (minSdk == 1) {
            return;
        }
        if (this.mQualifiers[23] == NULL_QUALIFIERS[23] || ((VersionQualifier)this.mQualifiers[23]).getVersion() < minSdk) {
            this.setVersionQualifier(new VersionQualifier(minSdk));
        }
    }

    public void normalizeByRemovingRedundantVersionQualifier() {
        VersionQualifier versionQualifier = this.getVersionQualifier();
        if (versionQualifier == NULL_QUALIFIERS[23]) {
            return;
        }
        int version = versionQualifier.getVersion();
        if (version == 1) {
            this.setVersionQualifier(null);
            return;
        }
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            ResourceQualifier qualifier;
            if (i == 23 || (qualifier = this.mQualifiers[i]) == NULL_QUALIFIERS[i] || qualifier.since() < version) continue;
            this.setVersionQualifier(null);
            break;
        }
    }

    public void updateScreenWidthAndHeight() {
        ResourceQualifier sizeQ = this.mQualifiers[22];
        ResourceQualifier densityQ = this.mQualifiers[16];
        ResourceQualifier orientQ = this.mQualifiers[13];
        if (sizeQ != NULL_QUALIFIERS[22] && densityQ != NULL_QUALIFIERS[16] && orientQ != NULL_QUALIFIERS[13]) {
            int size2;
            Density density = ((DensityQualifier)densityQ).getValue();
            if (density == Density.NODPI || density == Density.ANYDPI) {
                return;
            }
            ScreenOrientation orientation = ((ScreenOrientationQualifier)orientQ).getValue();
            int size1 = ((ScreenDimensionQualifier)sizeQ).getValue1();
            if (size1 < (size2 = ((ScreenDimensionQualifier)sizeQ).getValue2())) {
                int a = size1;
                size1 = size2;
                size2 = a;
            }
            assert (density != null);
            int dp1 = FolderConfiguration.divideWithRoundingUp(size1 * Density.DEFAULT_DENSITY, density.getDpiValue());
            int dp2 = FolderConfiguration.divideWithRoundingUp(size2 * Density.DEFAULT_DENSITY, density.getDpiValue());
            this.setSmallestScreenWidthQualifier(new SmallestScreenWidthQualifier(dp2));
            switch (orientation) {
                case PORTRAIT: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp2));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp1));
                    break;
                }
                case LANDSCAPE: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp1));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp2));
                    break;
                }
                case SQUARE: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp2));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp2));
                }
            }
        }
    }

    private static int divideWithRoundingUp(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FolderConfiguration)) {
            return false;
        }
        FolderConfiguration fc = (FolderConfiguration)obj;
        for (int i = 0; i < 24; ++i) {
            ResourceQualifier qualifier = this.mQualifiers[i];
            ResourceQualifier fcQualifier = fc.mQualifiers[i];
            if (Objects.equals(qualifier, fcQualifier)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getQualifierString().hashCode();
    }

    public boolean isDefault() {
        return this.getQualifierString().isEmpty();
    }

    public String getFolderName(ResourceFolderType folder) {
        StringBuilder result2 = new StringBuilder(folder.getName());
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            String segment;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
            result2.append("-");
            result2.append(segment);
        }
        return result2.toString();
    }

    public String getQualifierString() {
        if (this.mQualifierString == null) {
            StringBuilder result2 = null;
            for (int i = 0; i < this.mQualifiers.length; ++i) {
                String segment;
                ResourceQualifier qualifier = this.mQualifiers[i];
                if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(40);
                } else {
                    result2.append("-");
                }
                result2.append(segment);
            }
            this.mQualifierString = result2 == null ? "" : result2.toString();
        }
        return this.mQualifierString;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder result2 = null;
        int index = 0;
        while (index < 24) {
            ResourceQualifier qualifier = this.mQualifiers[index];
            if (qualifier == NULL_QUALIFIERS[index++]) continue;
            if (result2 == null) {
                result2 = new StringBuilder();
            } else {
                result2.append(", ");
            }
            result2.append(qualifier.getLongDisplayValue());
        }
        return result2 == null ? "" : result2.toString();
    }

    public String toShortDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder result2 = new StringBuilder(100);
        int index = 0;
        while (index < 24) {
            ResourceQualifier qualifier = this.mQualifiers[index];
            if (qualifier == NULL_QUALIFIERS[index++]) continue;
            if (result2.length() > 0) {
                result2.append(',');
            }
            result2.append(qualifier.getShortDisplayValue());
        }
        return result2.toString();
    }

    @Override
    public int compareTo(FolderConfiguration folderConfig) {
        if (this.isDefault()) {
            if (folderConfig.isDefault()) {
                return 0;
            }
            return -1;
        }
        for (int i = 0; i < 24; ++i) {
            ResourceQualifier qualifier1 = this.mQualifiers[i];
            ResourceQualifier qualifier2 = folderConfig.mQualifiers[i];
            if (Objects.equals(qualifier1, qualifier2)) continue;
            if (qualifier1 != null && qualifier2 != null) {
                return qualifier1.compareTo(qualifier2);
            }
            return qualifier1 == NULL_QUALIFIERS[i] ? -1 : 1;
        }
        return 0;
    }

    public <T extends Configurable> T findMatchingConfigurable(Collection<T> configurables) {
        List<T> matches = this.findMatchingConfigurables(configurables);
        return (T)(matches.isEmpty() ? null : (Configurable)matches.get(0));
    }

    public <T extends Configurable> List<T> findMatchingConfigurables(Collection<T> configurables) {
        if (configurables == null) {
            return Collections.emptyList();
        }
        ArrayList<Configurable> matchingConfigurables = new ArrayList<Configurable>();
        for (Configurable res : configurables) {
            FolderConfiguration configuration = res.getConfiguration();
            if (!configuration.isMatchFor(this)) continue;
            matchingConfigurables.add(res);
        }
        if (matchingConfigurables.size() < 2) {
            return matchingConfigurables;
        }
        int count = FolderConfiguration.getQualifierCount();
        for (int q = 0; q < count; ++q) {
            ResourceQualifier referenceQualifier = this.getQualifier(q);
            if (referenceQualifier == NULL_QUALIFIERS[q] || referenceQualifier == null) continue;
            boolean found = false;
            ResourceQualifier bestMatch = null;
            for (Configurable configurable : matchingConfigurables) {
                ResourceQualifier qualifier = configurable.getConfiguration().getQualifier(q);
                if (qualifier == null) continue;
                found = true;
                if (!qualifier.isBetterMatchThan(bestMatch, referenceQualifier)) continue;
                bestMatch = qualifier;
            }
            if (!found) continue;
            int i = 0;
            while (i < matchingConfigurables.size()) {
                Configurable configurable;
                configurable = (Configurable)matchingConfigurables.get(i);
                FolderConfiguration configuration = configurable.getConfiguration();
                ResourceQualifier qualifier = configuration.getQualifier(q);
                if (qualifier == null) {
                    matchingConfigurables.remove(configurable);
                    continue;
                }
                if (bestMatch != null && !bestMatch.equals(qualifier)) {
                    matchingConfigurables.remove(configurable);
                    continue;
                }
                ++i;
            }
            if (matchingConfigurables.size() < 2) break;
        }
        return matchingConfigurables;
    }

    public boolean isMatchFor(FolderConfiguration referenceConfig) {
        if (referenceConfig == null) {
            return false;
        }
        for (int i = 0; i < 24; ++i) {
            ResourceQualifier testQualifier = this.mQualifiers[i];
            ResourceQualifier referenceQualifier = referenceConfig.mQualifiers[i];
            if (testQualifier == null || testQualifier.equals(testQualifier.getNullQualifier()) || referenceQualifier == null || referenceQualifier.equals(referenceQualifier.getNullQualifier()) || testQualifier.isMatchFor(referenceQualifier)) continue;
            return false;
        }
        return true;
    }

    public int getHighestPriorityQualifier(int startIndex) {
        for (int i = startIndex; i < 24; ++i) {
            if (this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            return i;
        }
        return -1;
    }

    public static FolderConfiguration createDefault() {
        FolderConfiguration config = new FolderConfiguration();
        config.mQualifiers[0] = new CountryCodeQualifier();
        config.mQualifiers[1] = new NetworkCodeQualifier();
        config.mQualifiers[2] = new LocaleQualifier();
        config.mQualifiers[4] = new LayoutDirectionQualifier();
        config.mQualifiers[5] = new SmallestScreenWidthQualifier();
        config.mQualifiers[6] = new ScreenWidthQualifier();
        config.mQualifiers[7] = new ScreenHeightQualifier();
        config.mQualifiers[8] = new ScreenSizeQualifier();
        config.mQualifiers[9] = new ScreenRatioQualifier();
        config.mQualifiers[10] = new ScreenRoundQualifier();
        config.mQualifiers[11] = new WideGamutColorQualifier();
        config.mQualifiers[12] = new HighDynamicRangeQualifier();
        config.mQualifiers[13] = new ScreenOrientationQualifier();
        config.mQualifiers[14] = new UiModeQualifier();
        config.mQualifiers[15] = new NightModeQualifier();
        config.mQualifiers[16] = new DensityQualifier();
        config.mQualifiers[17] = new TouchScreenQualifier();
        config.mQualifiers[18] = new KeyboardStateQualifier();
        config.mQualifiers[19] = new TextInputMethodQualifier();
        config.mQualifiers[20] = new NavigationStateQualifier();
        config.mQualifiers[21] = new NavigationMethodQualifier();
        config.mQualifiers[22] = new ScreenDimensionQualifier();
        config.mQualifiers[23] = new VersionQualifier();
        config.mQualifiers[3] = new GrammaticalGenderQualifier();
        return config;
    }

    public ResourceQualifier[] getQualifiers() {
        int count = 0;
        for (int i = 0; i < 24; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            ++count;
        }
        ResourceQualifier[] array = new ResourceQualifier[count];
        int index = 0;
        for (int i = 0; i < 24; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            array[index++] = this.mQualifiers[i];
        }
        return array;
    }

    public static String getQualifier(String folderName) {
        int dashPos = folderName.indexOf(45);
        return dashPos < 0 ? "" : folderName.substring(dashPos + 1);
    }

    static {
        QUALIFIER_SPLITTER = Splitter.on((char)'-');
        NULL_QUALIFIERS = new ResourceQualifier[24];
        FolderConfiguration defaultConfig = FolderConfiguration.createDefault();
        DEFAULT_QUALIFIERS = defaultConfig.mQualifiers;
        for (int i = 0; i < DEFAULT_QUALIFIERS.length; ++i) {
            FolderConfiguration.NULL_QUALIFIERS[i] = DEFAULT_QUALIFIERS[i].getNullQualifier();
        }
    }
}

