/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common.util;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class FileCharsetDetector
extends AbstractLogEnabled {
    private final String charset;

    public FileCharsetDetector(File detectedFile) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(detectedFile);
             BufferedInputStream is = new BufferedInputStream(fileInputStream);){
            CharsetDetector detector = new CharsetDetector();
            detector.setText(is);
            CharsetMatch match = detector.detect();
            this.charset = match.getName().toUpperCase(Locale.ENGLISH);
        }
    }

    public FileCharsetDetector(InputStream detectedStream) throws IOException {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(detectedStream);
        CharsetMatch match = detector.detect();
        this.charset = match.getName().toUpperCase(Locale.ENGLISH);
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isFound() {
        return true;
    }
}

