/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.loader;

import com.intellij.platform.runtime.repository.IncludedRuntimeModule;
import com.intellij.platform.runtime.repository.ProductModules;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.serialization.RuntimeModuleRepositorySerialization;
import com.intellij.util.lang.PathClassLoader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;

public final class IntellijLoader {
    private static final String RUNTIME_REPOSITORY_PATH_PROPERTY = "intellij.platform.runtime.repository.path";
    private static final String PLATFORM_ROOT_MODULE_PROPERTY = "intellij.platform.root.module";

    public static void main(String[] args) throws Throwable {
        String productModulesPath;
        RuntimeModuleRepository repository;
        RuntimeModuleDescriptor rootModule;
        InputStream moduleGroupStream;
        String rootModuleName;
        String repositoryPathString = System.getProperty(RUNTIME_REPOSITORY_PATH_PROPERTY);
        if (repositoryPathString == null) {
            IntellijLoader.reportError("intellij.platform.runtime.repository.path is not specified");
        }
        if ((rootModuleName = System.getProperty(PLATFORM_ROOT_MODULE_PROPERTY)) == null) {
            IntellijLoader.reportError("intellij.platform.root.module is not specified");
        }
        if ((moduleGroupStream = (rootModule = (repository = RuntimeModuleRepository.create(Path.of(repositoryPathString, new String[0]))).getModule(RuntimeModuleId.module(rootModuleName))).readFile(productModulesPath = "META-INF/" + rootModuleName + "/product-modules.xml")) == null) {
            IntellijLoader.reportError(productModulesPath + " is not found in " + rootModuleName + " module");
        }
        ProductModules productModules = RuntimeModuleRepositorySerialization.loadProductModules(moduleGroupStream, productModulesPath, repository);
        String bootstrapModuleName = System.getProperty("intellij.platform.bootstrap.module", "intellij.platform.bootstrap");
        LinkedHashSet<Path> classpath = new LinkedHashSet<Path>(repository.getModule(RuntimeModuleId.module(bootstrapModuleName)).getModuleClasspath());
        for (IncludedRuntimeModule item : productModules.getMainModuleGroup().getIncludedModules()) {
            classpath.addAll(item.getModuleDescriptor().getResourceRootPaths());
        }
        PathClassLoader classLoader = new PathClassLoader(UrlClassLoader.build().files(new ArrayList<Path>(classpath)).parent(IntellijLoader.class.getClassLoader()));
        String bootstrapClassName = "com.intellij.platform.bootstrap.ModularMain";
        Class<?> bootstrapClass = Class.forName(bootstrapClassName, true, classLoader);
        MethodHandles.publicLookup().findStatic(bootstrapClass, "main", MethodType.methodType(Void.TYPE, RuntimeModuleRepository.class, ProductModules.class, String[].class)).invokeExact(repository, productModules, args);
    }

    @Contract(value="_ -> fail")
    private static void reportError(String message) {
        System.err.println(message);
        System.exit(3);
    }
}

