/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxRootTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public class JavaFxImportsOptimizer
implements ImportOptimizer {
    public boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            JavaFxImportsOptimizer.$$$reportNull$$$0(0);
        }
        return JavaFxFileTypeFactory.isFxml(file);
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        XmlProlog newImportList;
        VirtualFile vFile;
        if (file == null) {
            JavaFxImportsOptimizer.$$$reportNull$$$0(1);
        }
        if ((vFile = file.getVirtualFile()) instanceof VirtualFileWindow) {
            vFile = ((VirtualFileWindow)vFile).getDelegate();
        }
        Project project = file.getProject();
        if (vFile == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInSourceContent(vFile)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JavaFxImportsOptimizer.$$$reportNull$$$0(2);
            }
            return runnable;
        }
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>();
        HashSet<String> demandedForNested = new HashSet<String>();
        JavaFxImportsOptimizer.collectNamesToImport(names, demandedForNested, (XmlFile)file);
        names.sort((o1, o2) -> StringUtil.compare((String)((String)o1.first), (String)((String)o2.first), (boolean)true));
        JavaCodeStyleSettings settings = JavaCodeStyleSettings.getInstance((PsiFile)file);
        List sortedNames = ImportHelper.sortItemsAccordingToSettings(names, (JavaCodeStyleSettings)settings);
        HashMap<String, Boolean> onDemand = new HashMap<String, Boolean>();
        ImportHelper.collectOnDemandImports((List)sortedNames, (JavaCodeStyleSettings)settings, onDemand);
        for (String s : demandedForNested) {
            onDemand.put(s, false);
        }
        HashSet<String> imported = new HashSet<String>();
        ArrayList<CallSite> imports = new ArrayList<CallSite>();
        for (Pair pair : sortedNames) {
            String qName = (String)pair.first;
            String packageName = StringUtil.getPackageName((String)qName);
            if (imported.contains(packageName) || imported.contains(qName)) continue;
            if (onDemand.containsKey(packageName)) {
                imported.add(packageName);
                imports.add((CallSite)((Object)("<?import " + packageName + ".*?>")));
                continue;
            }
            imported.add(qName);
            imports.add((CallSite)((Object)("<?import " + qName + "?>")));
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)file.getProject());
        XmlFile dummyFile = (XmlFile)factory.createFileFromText("_Dummy_.fxml", (FileType)XmlFileType.INSTANCE, (CharSequence)StringUtil.join(imports, (String)"\n"));
        XmlDocument document = dummyFile.getDocument();
        XmlProlog xmlProlog = newImportList = document != null ? document.getProlog() : null;
        if (newImportList == null) {
            Runnable runnable = EmptyRunnable.getInstance();
            if (runnable == null) {
                JavaFxImportsOptimizer.$$$reportNull$$$0(3);
            }
            return runnable;
        }
        Runnable runnable = () -> {
            XmlProlog prolog;
            XmlDocument xmlDocument = ((XmlFile)file).getDocument();
            XmlProlog xmlProlog = prolog = xmlDocument != null ? xmlDocument.getProlog() : null;
            if (prolog != null) {
                Collection instructions = PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class);
                for (XmlProcessingInstruction instruction : instructions) {
                    ASTNode node = instruction.getNode();
                    ASTNode nameNode = node.findChildByType(XmlTokenType.XML_NAME);
                    if (nameNode == null || !nameNode.getText().equals("import")) continue;
                    instruction.delete();
                }
                prolog.add((PsiElement)newImportList);
            } else {
                document.addBefore((PsiElement)newImportList, (PsiElement)document.getRootTag());
            }
        };
        if (runnable == null) {
            JavaFxImportsOptimizer.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private static void collectNamesToImport(final @NotNull Collection<Pair<String, Boolean>> names, final @NotNull Collection<String> demandedForNested, @NotNull XmlFile file) {
        if (names == null) {
            JavaFxImportsOptimizer.$$$reportNull$$$0(5);
        }
        if (demandedForNested == null) {
            JavaFxImportsOptimizer.$$$reportNull$$$0(6);
        }
        if (file == null) {
            JavaFxImportsOptimizer.$$$reportNull$$$0(7);
        }
        file.accept((PsiElementVisitor)new JavaFxUsedClassesVisitor(){

            @Override
            protected void appendClassName(String fqn) {
                names.add(Pair.create((Object)fqn, (Object)false));
            }

            @Override
            protected void appendDemandedPackageName(@NotNull String packageName) {
                if (packageName == null) {
                    1.$$$reportNull$$$0(0);
                }
                demandedForNested.add(packageName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer$1", "appendDemandedPackageName"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "demandedForNested";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectNamesToImport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static abstract class JavaFxUsedClassesVisitor
    extends XmlRecursiveElementVisitor {
        public void visitXmlProlog(@NotNull XmlProlog prolog) {
            if (prolog == null) {
                JavaFxUsedClassesVisitor.$$$reportNull$$$0(0);
            }
        }

        public void visitXmlProcessingInstruction(@NotNull XmlProcessingInstruction processingInstruction) {
            if (processingInstruction == null) {
                JavaFxUsedClassesVisitor.$$$reportNull$$$0(1);
            }
        }

        public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
            XmlAttributeDescriptor descriptor;
            if (attribute == null) {
                JavaFxUsedClassesVisitor.$$$reportNull$$$0(2);
            }
            if ((descriptor = attribute.getDescriptor()) instanceof JavaFxStaticSetterAttributeDescriptor) {
                PsiElement declaration = descriptor.getDeclaration();
                if (declaration instanceof PsiMember) {
                    this.appendClassName((PsiElement)((PsiMember)declaration).getContainingClass());
                }
            } else if (descriptor instanceof JavaFxRootTagDescriptor.RootTagTypeAttributeDescriptor) {
                this.appendClassName((PsiElement)JavaFxPsiUtil.findPsiClass(attribute.getValue(), (PsiElement)attribute));
            }
        }

        public void visitXmlTag(@NotNull XmlTag tag) {
            PsiElement declaration;
            if (tag == null) {
                JavaFxUsedClassesVisitor.$$$reportNull$$$0(3);
            }
            super.visitXmlTag(tag);
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor instanceof JavaFxClassTagDescriptorBase) {
                this.appendClassName(descriptor.getDeclaration());
            } else if (descriptor instanceof JavaFxPropertyTagDescriptor && ((JavaFxPropertyTagDescriptor)descriptor).isStatic() && (declaration = descriptor.getDeclaration()) instanceof PsiMember) {
                this.appendClassName((PsiElement)((PsiMember)declaration).getContainingClass());
            }
        }

        private void appendClassName(PsiElement declaration) {
            if (declaration instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)declaration;
                String ownerClassQN = JavaFxUsedClassesVisitor.getTopmostOwnerClassQualifiedName(psiClass);
                if (ownerClassQN != null) {
                    this.appendClassName(ownerClassQN);
                    String ownerClassPackageName = StringUtil.getPackageName((String)ownerClassQN);
                    if (!StringUtil.isEmpty((String)ownerClassPackageName)) {
                        this.appendDemandedPackageName(ownerClassPackageName);
                    }
                } else {
                    String classQN = psiClass.getQualifiedName();
                    if (classQN != null) {
                        this.appendClassName(classQN);
                    }
                }
            }
        }

        @Nullable
        private static String getTopmostOwnerClassQualifiedName(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                JavaFxUsedClassesVisitor.$$$reportNull$$$0(4);
            }
            PsiClass ownerClass = null;
            for (PsiClass aClass = psiClass.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
                ownerClass = aClass;
            }
            if (ownerClass != null) {
                return ownerClass.getQualifiedName();
            }
            return null;
        }

        protected abstract void appendClassName(String var1);

        protected abstract void appendDemandedPackageName(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prolog";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processingInstruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer$JavaFxUsedClassesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlProlog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlProcessingInstruction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlAttribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTopmostOwnerClassQualifiedName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

