/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.JavaFxImportsOptimizer;

public class JavaFxUnusedImportsInspection
extends XmlSuppressableInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            JavaFxUnusedImportsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            JavaFxUnusedImportsInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(file)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file).getDocument();
        if (document == null) {
            return null;
        }
        final HashSet usedNames = new HashSet();
        file.accept((PsiElementVisitor)new JavaFxImportsOptimizer.JavaFxUsedClassesVisitor(){

            @Override
            protected void appendClassName(String fqn) {
                usedNames.add(fqn);
                String packageName = StringUtil.getPackageName((String)fqn);
                if (!StringUtil.isEmpty((String)packageName)) {
                    usedNames.add(packageName);
                }
            }

            @Override
            protected void appendDemandedPackageName(@NotNull String packageName) {
                if (packageName == null) {
                    1.$$$reportNull$$$0(0);
                }
                usedNames.add(packageName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$1", "appendDemandedPackageName"));
            }
        });
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)file.getProject());
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        Collection instructions = PsiTreeUtil.findChildrenOfType((PsiElement)document.getProlog(), XmlProcessingInstruction.class);
        LinkedHashMap<String, XmlProcessingInstruction> targetProcessingInstructions = new LinkedHashMap<String, XmlProcessingInstruction>();
        for (XmlProcessingInstruction instruction : instructions) {
            String target = JavaFxPsiUtil.getInstructionTarget("import", instruction);
            if (target == null) continue;
            targetProcessingInstructions.put(target, instruction);
        }
        for (String target : targetProcessingInstructions.keySet()) {
            XmlProcessingInstruction instruction = (XmlProcessingInstruction)targetProcessingInstructions.get(target);
            if (target.endsWith(".*")) {
                if (usedNames.contains(StringUtil.trimEnd((String)target, (String)".*"))) continue;
                problems.add(inspectionManager.createProblemDescriptor((PsiElement)instruction, JavaFXBundle.message("inspection.javafx.unused.imports.problem", new Object[0]), (LocalQuickFix)new JavaFxOptimizeImportsFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            if (usedNames.contains(target) && !targetProcessingInstructions.containsKey(StringUtil.getPackageName((String)target) + ".*")) continue;
            problems.add(inspectionManager.createProblemDescriptor((PsiElement)instruction, JavaFXBundle.message("inspection.javafx.unused.imports.problem", new Object[0]), (LocalQuickFix)new JavaFxOptimizeImportsFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JavaFxOptimizeImportsFix
    implements LocalQuickFix {
        private JavaFxOptimizeImportsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"optimize.imports.fix", (Object[])new Object[0]);
            if (string == null) {
                JavaFxOptimizeImportsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                JavaFxOptimizeImportsFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                JavaFxOptimizeImportsFix.$$$reportNull$$$0(2);
            }
            if ((psiElement = descriptor.getPsiElement()) == null) {
                return;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null || !JavaFxFileTypeFactory.isFxml(file)) {
                return;
            }
            new JavaFxImportsOptimizer().processFile(file).run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$JavaFxOptimizeImportsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnusedImportsInspection$JavaFxOptimizeImportsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

