/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public class JavaFxExpandAttributeIntention
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(JavaFxExpandAttributeIntention.class);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiType propertyType;
        PsiType itemType;
        if (project == null) {
            JavaFxExpandAttributeIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JavaFxExpandAttributeIntention.$$$reportNull$$$0(1);
        }
        XmlAttribute attr = (XmlAttribute)element.getParent();
        String name = attr.getName();
        XmlAttributeDescriptor descriptor = attr.getDescriptor();
        LOG.assertTrue(descriptor != null);
        String value = attr.getValue();
        PsiElement declaration = descriptor.getDeclaration();
        if (declaration instanceof PsiMember && (itemType = JavaGenericsUtil.getCollectionItemType((PsiType)(propertyType = PropertyUtilBase.getPropertyType((PsiMember)((PsiMember)declaration))), (GlobalSearchScope)declaration.getResolveScope())) != null) {
            String typeNode = itemType.getPresentableText();
            JavaFxPsiUtil.insertImportWhenNeeded((XmlFile)attr.getContainingFile(), typeNode, itemType.getCanonicalText());
            Object[] vals = value != null ? value.split(",") : ArrayUtilRt.EMPTY_STRING_ARRAY;
            value = StringUtil.join((Object[])vals, s -> "<" + typeNode + " fx:value=\"" + s.trim() + "\"/>", (String)"\n");
        }
        XmlTag childTag = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<" + name + ">" + value + "</" + name + ">"));
        attr.getParent().add((PsiElement)childTag);
        attr.delete();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        XmlAttributeDescriptor descriptor;
        PsiElement parent;
        if (project == null) {
            JavaFxExpandAttributeIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JavaFxExpandAttributeIntention.$$$reportNull$$$0(3);
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME && (parent = element.getParent()) instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) instanceof JavaFxPropertyAttributeDescriptor && !(descriptor instanceof JavaFxBuiltInAttributeDescriptor)) {
            PsiClass tagClass;
            PsiType tagType = null;
            PsiElement declaration = descriptor.getDeclaration();
            if (declaration instanceof PsiMember) {
                tagType = PropertyUtilBase.getPropertyType((PsiMember)((PsiMember)declaration));
            }
            if ((tagClass = PsiUtil.resolveClassInType((PsiType)(tagType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)tagType).getBoxedType(parent) : tagType))) != null && JavaFxPsiUtil.isAbleToInstantiate(tagClass) || descriptor instanceof JavaFxStaticSetterAttributeDescriptor) {
                this.setText(JavaFXBundle.message("javafx.expand.attribute.to.tag.intention", ((XmlAttribute)parent).getName()));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaFXBundle.message("javafx.expand.attribute.to.tag.intention.family.name", new Object[0]);
        if (string == null) {
            JavaFxExpandAttributeIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

