/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

public class TypeUnifier {
    @NotNull
    public static UnificationResult unify(@NotNull TypeProjection knownProjection, @NotNull TypeProjection projectWithVariables, @NotNull Predicate<TypeConstructor> isVariable) {
        if (knownProjection == null) {
            TypeUnifier.$$$reportNull$$$0(0);
        }
        if (projectWithVariables == null) {
            TypeUnifier.$$$reportNull$$$0(1);
        }
        if (isVariable == null) {
            TypeUnifier.$$$reportNull$$$0(2);
        }
        UnificationResultImpl result2 = new UnificationResultImpl();
        TypeUnifier.doUnify(knownProjection, projectWithVariables, isVariable, result2);
        UnificationResultImpl unificationResultImpl = result2;
        if (unificationResultImpl == null) {
            TypeUnifier.$$$reportNull$$$0(3);
        }
        return unificationResultImpl;
    }

    private static void doUnify(TypeProjection knownProjection, TypeProjection projectWithVariables, Predicate<TypeConstructor> isVariable, UnificationResultImpl result2) {
        boolean structuralMismatch;
        Variance withVariablesProjectionKind;
        KotlinType known = knownProjection.getType();
        KotlinType withVariables = projectWithVariables.getType();
        Variance knownProjectionKind = knownProjection.getProjectionKind();
        if (knownProjectionKind == (withVariablesProjectionKind = projectWithVariables.getProjectionKind()) && knownProjectionKind != Variance.INVARIANT) {
            TypeUnifier.doUnify(new TypeProjectionImpl(known), new TypeProjectionImpl(withVariables), isVariable, result2);
            return;
        }
        if (known.isMarkedNullable() && withVariables.isMarkedNullable()) {
            TypeUnifier.doUnify(new TypeProjectionImpl(knownProjectionKind, TypeUtils.makeNotNullable(known)), new TypeProjectionImpl(withVariablesProjectionKind, TypeUtils.makeNotNullable(withVariables)), isVariable, result2);
            return;
        }
        if (knownProjectionKind != withVariablesProjectionKind && withVariablesProjectionKind != Variance.INVARIANT) {
            result2.fail();
            return;
        }
        if (!known.isMarkedNullable() && withVariables.isMarkedNullable()) {
            result2.fail();
            return;
        }
        TypeConstructor maybeVariable = withVariables.getConstructor();
        if (isVariable.test(maybeVariable)) {
            result2.put(maybeVariable, knownProjection);
            return;
        }
        boolean bl = structuralMismatch = known.isMarkedNullable() != withVariables.isMarkedNullable() || knownProjectionKind != withVariablesProjectionKind || !known.getConstructor().equals(withVariables.getConstructor());
        if (structuralMismatch) {
            result2.fail();
            return;
        }
        if (known.getArguments().size() != withVariables.getArguments().size()) {
            result2.fail();
            return;
        }
        if (known.getArguments().isEmpty()) {
            return;
        }
        List<TypeProjection> knownArguments = known.getArguments();
        List<TypeProjection> withVariablesArguments = withVariables.getArguments();
        for (int i = 0; i < knownArguments.size(); ++i) {
            TypeProjection knownArg = knownArguments.get(i);
            TypeProjection withVariablesArg = withVariablesArguments.get(i);
            TypeUnifier.doUnify(knownArg, withVariablesArg, isVariable, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownProjection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectWithVariables";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isVariable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/TypeUnifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/TypeUnifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unify";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnificationResultImpl
    implements UnificationResult {
        private boolean success = true;
        private final Map<TypeConstructor, TypeProjection> substitution = CollectionsKt.newHashMapWithExpectedSize((int)1);
        private final Set<TypeConstructor> failedVariables = CollectionsKt.newHashSetWithExpectedSize((int)0);

        private UnificationResultImpl() {
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        public void fail() {
            this.success = false;
        }

        @Override
        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution() {
            Map<TypeConstructor, TypeProjection> map = this.substitution;
            if (map == null) {
                UnificationResultImpl.$$$reportNull$$$0(0);
            }
            return map;
        }

        public void put(TypeConstructor key, TypeProjection value2) {
            if (this.failedVariables.contains(key)) {
                return;
            }
            TypeProjection oldValue = this.substitution.put(key, value2);
            if (oldValue != null && !oldValue.equals(value2)) {
                this.substitution.remove(key);
                this.failedVariables.add(key);
                this.fail();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUnifier$UnificationResultImpl", "getSubstitution"));
        }
    }

    public static interface UnificationResult {
        public boolean isSuccess();

        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution();
    }
}

