/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.icons.AllIcons;
import com.intellij.icons.ExpUiIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetHelper;", "", "()V", "Companion", "WorkspaceAction", "intellij.vcs.perforce"})
public final class PerforceToolbarWidgetHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ'\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eJ'\u0010\u0013\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ!\u0010\u0014\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\b\b\u0001\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetHelper$Companion;", "", "()V", "getConnection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "settings", "Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;", "getDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "workspace", "isNoConnections", "", "isOnline", "getIcon", "Ljavax/swing/Icon;", "isNewUi", "getText", "getWorkspaceLabel", "workspaceDir", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final P4Connection getConnection(@NotNull AnActionEvent e, @NotNull PerforceSettings settings) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Collection<P4Connection> allConnections = settings.getAllConnections();
            Intrinsics.checkNotNullExpressionValue(allConnections, (String)"allConnections");
            if (allConnections.size() == 1) {
                return (P4Connection)CollectionsKt.single((Iterable)allConnections);
            }
            FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR);
            if ((fileEditor == null || (fileEditor = fileEditor.getFile()) == null) && (fileEditor = (VirtualFile)e.getData(PlatformCoreDataKeys.VIRTUAL_FILE)) == null && (fileEditor = (VirtualFile)e.getData(PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY)) == null) {
                Collection<P4Connection> collection = settings.getAllConnections();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"settings.allConnections");
                return (P4Connection)CollectionsKt.firstOrNull((Iterable)collection);
            }
            FileEditor file = fileEditor;
            return settings.getConnectionForFile((VirtualFile)file);
        }

        @NotNull
        public final String getText(@Nls @Nullable String workspace, boolean isNoConnections, boolean isOnline) {
            if (isNoConnections) {
                String string = PerforceBundle.message("connection.no.valid.connections.short", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"connection.no.valid.connections.short\")");
                return string;
            }
            String string = workspace;
            if (string == null) {
                String string2 = PerforceBundle.message("action.Perforce.Toolbar.multiple.workspaces", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"action.Perforce\u2026bar.multiple.workspaces\")");
            }
            String text = string;
            if (isOnline) {
                return text;
            }
            String string3 = ColorUtil.toHex((Color)UIUtil.getErrorForeground());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toHex(UIUtil.getErrorForeground())");
            String color = string3;
            HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.html().addText(text + " ").child((HtmlChunk)HtmlChunk.font((String)color).addText(PerforceBundle.message("connection.status.offline", new Object[0]))));
            String string4 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
            return string4;
        }

        @NotNull
        public final String getDescription(@NlsSafe @Nullable String workspace, boolean isNoConnections, boolean isOnline) {
            if (!isOnline) {
                String string = PerforceBundle.message("connection.cannot.connect", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"connection.cannot.connect\")");
                return string;
            }
            if (isNoConnections) {
                String string = PerforceBundle.message("connection.no.valid.connections", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"connection.no.valid.connections\")");
                return string;
            }
            if (workspace != null) {
                Object[] objectArray = new Object[]{workspace};
                String string = PerforceBundle.message("action.Perforce.Toolbar.WorkspaceAction.description", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.Perforce\u2026.description\", workspace)");
                return string;
            }
            String string = PerforceBundle.message("action.Perforce.Toolbar.multiple.workspaces.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.Perforce\u2026.workspaces.description\")");
            return string;
        }

        @NotNull
        public final Icon getIcon(@NotNull PerforceSettings settings, boolean isNoConnections, boolean isNewUi) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (isNoConnections || !settings.ENABLED) {
                Icon icon = AllIcons.General.Warning;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
                return icon;
            }
            if (isNewUi) {
                Icon icon = ExpUiIcons.General.Vcs;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vcs");
                return icon;
            }
            Icon icon = AllIcons.Vcs.Branch;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Branch");
            return icon;
        }

        private final String getWorkspaceLabel(@NlsSafe String workspace, @NlsSafe String workspaceDir) {
            String string = ColorUtil.toHex((Color)((Color)JBColor.GRAY));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(JBColor.GRAY)");
            String color = string;
            HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.html().addText(workspace + " ").child((HtmlChunk)HtmlChunk.font((String)color).addText("(" + workspaceDir + ")")));
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/perforce/actions/PerforceToolbarWidgetHelper$WorkspaceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "workspace", "", "workspaceDir", "(Ljava/lang/String;Ljava/lang/String;)V", "workspaceLabel", "Lcom/intellij/openapi/util/NlsSafe;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.perforce"})
    public static final class WorkspaceAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final String workspaceLabel;

        public WorkspaceAction(@NotNull String workspace, @NotNull String workspaceDir) {
            Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
            Intrinsics.checkNotNullParameter((Object)workspaceDir, (String)"workspaceDir");
            this.workspaceLabel = Companion.getWorkspaceLabel(workspace, workspaceDir);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(this.workspaceLabel, false);
            e.getPresentation().setEnabled(false);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    }
}

