/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ClientVersion;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceClientImpl;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceShelf;
import org.jetbrains.idea.perforce.application.TracerProperties;
import org.jetbrains.idea.perforce.perforce.OutputMessageParser;
import org.jetbrains.idea.perforce.perforce.P4Command;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.View;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;
import org.jetbrains.idea.perforce.util.tracer.LongCallsParameters;
import org.jetbrains.idea.perforce.util.tracer.TracerManager;
import org.jetbrains.idea.perforce.util.tracer.TracerParameters;

@Service
public final class PerforceManager {
    private final Project myProject;
    private final PerforceLoginManager myLoginManager;
    private static final Logger LOG = Logger.getInstance(PerforceManager.class);
    private static final Logger LOG_RELATIVE_PATH = Logger.getInstance((String)"#Log_relative_path");
    private static final Logger TRACER_LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceManager_TRACER");
    private final Map<P4Connection, PerforceClient> myClientMap;
    private static final boolean ourTraceCalls = Boolean.TRUE.equals(Boolean.getBoolean("perforce.trace.calls"));
    private static final String ourTracerProperties = System.getProperty("perforce.trace.calls.properties");
    private TracerManager<P4Command> myTracer;
    private final ClientRootsCache myClientRootsCache;
    private final PerforceBaseInfoWorker myPerforceBaseInfoWorker;
    private final VirtualFileListener myListener;
    private volatile ClientVersion myClientVersion;
    private volatile boolean myActive;
    private final LocalFileSystem myLfs;
    private final PerforceShelf myShelf;

    public static PerforceManager getInstance(Project project) {
        return (PerforceManager)project.getService(PerforceManager.class);
    }

    public PerforceManager(@NotNull Project project) {
        if (project == null) {
            PerforceManager.$$$reportNull$$$0(0);
        }
        this.myClientMap = new HashMap<P4Connection, PerforceClient>();
        this.myProject = project;
        this.myLoginManager = PerforceLoginManager.getInstance(project);
        this.myListener = new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                boolean wasWritable;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!event.isFromRefresh()) {
                    return;
                }
                if (event.getPropertyName().equals("writable") && (wasWritable = ((Boolean)event.getOldValue()).booleanValue())) {
                    event.getFile().putUserData(P4File.KEY, null);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!event.isFromRefresh()) {
                    return;
                }
                if (!event.getFile().isWritable()) {
                    event.getFile().putUserData(P4File.KEY, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myClientRootsCache = (ClientRootsCache)project.getService(ClientRootsCache.class);
        this.myPerforceBaseInfoWorker = (PerforceBaseInfoWorker)project.getService(PerforceBaseInfoWorker.class);
        if (ourTraceCalls) {
            this.myTracer = PerforceManager.createTracer();
        }
        this.myLfs = LocalFileSystem.getInstance();
        this.myShelf = new PerforceShelf(project);
    }

    private static TracerManager<P4Command> createTracer() {
        if (ourTracerProperties != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(ourTracerProperties));
                boolean logAverageTimes = Boolean.TRUE.equals(Boolean.parseBoolean(properties.getProperty("perforce.tracer.average.gather")));
                TracerParameters averageParameters = logAverageTimes ? new TracerParameters(TracerProperties.averageTimesInterval.getValue(properties), (int)TracerProperties.averageTimesQueueSize.getValue(properties)) : null;
                boolean logConcurrentThreads = Boolean.TRUE.equals(Boolean.parseBoolean(properties.getProperty("perforce.tracer.number.concurrent.threads.gather")));
                TracerParameters concurrentThreadsParameters = logConcurrentThreads ? new TracerParameters(TracerProperties.numberConcurrentThreadsInterval.getValue(properties), (int)TracerProperties.numberConcurrentThreadsQueueSize.getValue(properties)) : null;
                boolean logLongCalls = Boolean.TRUE.equals(Boolean.parseBoolean(properties.getProperty("perforce.tracer.long.calls.gather")));
                LongCallsParameters longCallsParameters = logLongCalls ? new LongCallsParameters(TracerProperties.longCallsInterval.getValue(properties), (int)TracerProperties.longCallsQueueSize.getValue(properties), (int)TracerProperties.longCallsMaxKept.getValue(properties), TracerProperties.longCallsLowerBound.getValue(properties)) : null;
                return new TracerManager<P4Command>(averageParameters, concurrentThreadsParameters, longCallsParameters, TRACER_LOG, TracerProperties.outputInterval.getValue(properties));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new TracerManager<P4Command>(new TracerParameters(TracerProperties.averageTimesInterval.getDefault(), (int)TracerProperties.averageTimesQueueSize.getDefault()), new TracerParameters(TracerProperties.numberConcurrentThreadsInterval.getDefault(), (int)TracerProperties.numberConcurrentThreadsQueueSize.getDefault()), new LongCallsParameters(TracerProperties.longCallsInterval.getDefault(), (int)TracerProperties.longCallsQueueSize.getDefault(), (int)TracerProperties.longCallsMaxKept.getDefault(), TracerProperties.longCallsLowerBound.getDefault()), TRACER_LOG, TracerProperties.outputInterval.getDefault());
    }

    @Nullable
    public ClientVersion getClientVersion() {
        ClientVersion version = this.myClientVersion;
        if (version == null) {
            this.myClientVersion = version = PerforceRunner.getInstance(this.myProject).getClientVersion();
        }
        return version;
    }

    public void startListening(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceManager.$$$reportNull$$$0(1);
        }
        this.myActive = true;
        VirtualFileManager.getInstance().addVirtualFileListener(this.myListener, parentDisposable);
        this.myLoginManager.startListening(parentDisposable);
        this.myPerforceBaseInfoWorker.start();
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myActive = false;
            this.myPerforceBaseInfoWorker.stop();
        });
    }

    @NotNull
    Map<String, List<String>> getCachedInfo(P4Connection connection) throws VcsException {
        Map<String, List<String>> info = this.myPerforceBaseInfoWorker.getInfo(connection);
        if (info == null) {
            ProgressManager.checkCanceled();
            throw new VcsException(PerforceBundle.message("error.info.is.not.available", new Object[0]));
        }
        Map<String, List<String>> map = info;
        if (map == null) {
            PerforceManager.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    ClientData getCachedClients(@Nullable P4Connection connection) throws VcsException {
        ClientData client = this.myPerforceBaseInfoWorker.getClient(connection);
        if (client == null) {
            ProgressManager.checkCanceled();
            throw new VcsException(PerforceBundle.message("error.info.is.not.available", new Object[0]));
        }
        ClientData clientData = client;
        if (clientData == null) {
            PerforceManager.$$$reportNull$$$0(3);
        }
        return clientData;
    }

    @Nullable
    private Map<String, List<String>> getInfoOnlyCached(P4Connection connection) throws VcsException {
        return this.myPerforceBaseInfoWorker.getCachedInfo(connection);
    }

    @Nullable
    ClientData getClientOnlyCached(P4Connection connection) throws VcsException {
        return this.myPerforceBaseInfoWorker.getCachedClient(connection);
    }

    @Nullable
    public String getClientRoot(@Nullable P4Connection connection) throws VcsException {
        return (String)ContainerUtil.getFirstItem(this.getClientRoots(connection));
    }

    @NotNull
    public List<String> getClientRoots(@Nullable P4Connection connection) throws VcsException {
        List list = ContainerUtil.filter(this.getCachedClients(connection).getAllRoots(), mainRootValue -> {
            File file = new File((String)mainRootValue);
            VirtualFile vf = this.myLfs.findFileByIoFile(file);
            return vf != null && vf.isDirectory() || PerforceClientRootsChecker.isDirectory(file);
        });
        if (list == null) {
            PerforceManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public long getServerVersionYear(@Nullable P4Connection connection) throws VcsException {
        Map<String, List<String>> map = this.getCachedInfo(connection);
        List<String> serverVersions = map.get("Server version:");
        if (serverVersions == null || serverVersions.isEmpty()) {
            return -1L;
        }
        return OutputMessageParser.parseServerVersion(serverVersions.get(0)).getVersionYear();
    }

    public long getServerVersionYearCached(@Nullable P4Connection connection) throws VcsException {
        Map<String, List<String>> map = this.getInfoOnlyCached(connection);
        if (map == null) {
            return -1L;
        }
        List<String> serverVersions = map.get("Server version:");
        if (serverVersions == null || serverVersions.isEmpty()) {
            return -1L;
        }
        return OutputMessageParser.parseServerVersion(serverVersions.get(0)).getVersionYear();
    }

    @Nullable
    public ServerVersion getServerVersion(@Nullable P4Connection connection) throws VcsException {
        List<String> serverVersions = this.getCachedInfo(connection).get("Server version:");
        if (serverVersions == null || serverVersions.isEmpty()) {
            return null;
        }
        return OutputMessageParser.parseServerVersion(serverVersions.get(0));
    }

    public boolean isUnderPerforceRoot(@NotNull VirtualFile virtualFile) throws VcsException {
        if (virtualFile == null) {
            PerforceManager.$$$reportNull$$$0(5);
        }
        P4Connection connection = PerforceSettings.getSettings(this.myProject).getConnectionForFile(virtualFile);
        return this.getClientRoots(connection).stream().anyMatch(path -> this.isUnderClientRoot(virtualFile, (String)path));
    }

    private boolean isUnderClientRoot(VirtualFile virtualFile, String path) {
        Application application = ApplicationManager.getApplication();
        return (Boolean)application.runReadAction(() -> {
            VirtualFile root = this.myLfs.findFileByIoFile(new File(path));
            if (root != null && (Comparing.equal((Object)root, (Object)virtualFile) || VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)virtualFile, (boolean)false))) {
                return true;
            }
            return false;
        });
    }

    @Nullable
    private static String getRelativePath(String filePath, PerforceClient client) throws VcsException {
        return View.getRelativePath(P4File.unescapeWildcards(filePath), client.getName(), client.getViews());
    }

    @Nullable
    public static File getFileByDepotName(String depotPath, PerforceClient client) throws VcsException {
        int revNumStart = depotPath.indexOf("#");
        String relativePath = revNumStart >= 0 ? PerforceManager.getRelativePath(depotPath.substring(0, revNumStart), client) : PerforceManager.getRelativePath(depotPath, client);
        if (relativePath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(PerforceManager.missingLocalFileDiagnostics(depotPath, client));
            }
            return null;
        }
        Project project = client.getProject();
        List<String> roots = client.getRoots();
        List<File> resultCandidates = roots.isEmpty() ? Collections.singletonList(new File(FileUtil.toSystemDependentName((String)relativePath.trim()))) : ContainerUtil.map(roots, clientRoot -> new File((String)clientRoot, relativePath.trim()));
        File resultInProject = (File)ContainerUtil.find(resultCandidates, result -> project == null || PerforceConnectionManager.getInstance(project).isUnderProjectConnections((File)result));
        if (LOG_RELATIVE_PATH.isDebugEnabled()) {
            LOG_RELATIVE_PATH.debug("depot: '" + depotPath + "' result: '" + resultInProject + "'" + (String)(resultInProject == null ? " checked " + resultCandidates : ""));
        }
        return resultInProject;
    }

    private static String missingLocalFileDiagnostics(String depotPath, PerforceClient client) throws VcsException {
        StringBuilder message = new StringBuilder();
        for (View view : client.getViews()) {
            message.append('\n');
            message.append("View ");
            message.append(view.toString());
        }
        message.append('\n');
        message.append("Cannot find local file for depot path: ").append(depotPath);
        return message.toString();
    }

    @NotNull
    public synchronized PerforceClient getClient(@NotNull P4Connection connection) {
        PerforceClient client;
        if (connection == null) {
            PerforceManager.$$$reportNull$$$0(6);
        }
        if ((client = this.myClientMap.get(connection)) == null) {
            client = new PerforceClientImpl(this.myProject, connection);
            this.myClientMap.put(connection, client);
        }
        PerforceClient perforceClient = client;
        if (perforceClient == null) {
            PerforceManager.$$$reportNull$$$0(7);
        }
        return perforceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged() {
        PerforceManager perforceManager = this;
        synchronized (perforceManager) {
            this.myClientMap.clear();
        }
        if (!this.myActive) {
            return;
        }
        this.myLoginManager.clearAll();
        this.clearInfoClientCache();
        ApplicationManager.getApplication().invokeLater(() -> {
            P4File.invalidateFstat(this.myProject);
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }, this.myProject.getDisposed());
    }

    public void clearInfoClientCache() {
        this.myPerforceBaseInfoWorker.scheduleRefresh();
    }

    @Contract(value="null->null; !null->!null")
    @Nullable
    public String getRawRoot(@Nullable String convertedRoot) {
        return this.myClientRootsCache.getRaw(convertedRoot);
    }

    public String convertP4ParsedPath(@Nullable String convertedClientRoot, @NotNull String s) {
        if (s == null) {
            PerforceManager.$$$reportNull$$$0(8);
        }
        String result = this.myClientRootsCache.convertPath(convertedClientRoot, s);
        LOG_RELATIVE_PATH.debug("convertion, s: '" + s + "' converted: '" + result + "' convertedRoot: '" + convertedClientRoot + "'");
        return result;
    }

    @Nullable
    public Object traceEnter(P4Command command, String commandPresentation) {
        if (this.myTracer != null) {
            return this.myTracer.start(command, commandPresentation);
        }
        return null;
    }

    public void traceExit(Object context, P4Command command, String commandPresentation) {
        if (this.myTracer != null) {
            this.myTracer.stop(context, command, commandPresentation);
        }
    }

    public boolean isTraceEnabled() {
        return ourTraceCalls;
    }

    public void resetClientVersion() {
        this.myClientVersion = null;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public static void ensureValidClient(@NotNull Project project, @NotNull P4Connection connection) throws VcsException {
        PerforceClient client;
        if (project == null) {
            PerforceManager.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            PerforceManager.$$$reportNull$$$0(10);
        }
        if ((client = PerforceManager.getInstance(project).getClient(connection)).getName() == null) {
            throw new VcsException(PerforceBundle.message("error.missing.perforce.workspace", new Object[0]));
        }
        if (client.getUserName() == null) {
            throw new VcsException(PerforceBundle.message("error.missing.perforce.user.name", new Object[0]));
        }
        if (client.getServerPort() == null) {
            throw new VcsException(PerforceBundle.message("error.missing.perforce.server.port", new Object[0]));
        }
    }

    public PerforceShelf getShelf() {
        return this.myShelf;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedClients";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startListening";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderPerforceRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertP4ParsedPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidClient";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

