/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ProcessingContext;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4DeleteOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationOnPath;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class P4AddOperation
extends VcsOperationOnPath {
    public P4AddOperation() {
    }

    public P4AddOperation(String changeList, String path) {
        super(changeList, path);
    }

    public P4AddOperation(String changeList, VirtualFile file) {
        super(changeList, file.getPath());
    }

    @Override
    public void execute(Project project, ProcessingContext context) throws VcsException {
        P4File p4File = P4File.createInefficientFromLocalPath(this.myPath);
        FStat p4FStat = p4File.getFstat(project, true);
        if (p4FStat.status == FStat.STATUS_NOT_IN_CLIENTSPEC || p4FStat.status == FStat.STATUS_UNKNOWN) {
            return;
        }
        if (p4FStat.local == FStat.LOCAL_ADDING || p4FStat.local == FStat.LOCAL_BRANCHING || p4FStat.local == FStat.LOCAL_CHECKED_OUT || p4FStat.local == FStat.LOCAL_INTEGRATING || p4FStat.local == FStat.LOCAL_MOVE_ADDING) {
            return;
        }
        long changeListNumber = this.getPerforceChangeList(project, p4File, context);
        PerforceRunner runner = PerforceRunner.getInstance(project);
        if (p4FStat.local == FStat.Local.DELETING || p4FStat.local == FStat.Local.MOVE_DELETING) {
            runner.revert(p4File, true);
            runner.edit(p4File);
        } else {
            runner.add(p4File, changeListNumber);
        }
        FilePath path = this.getFilePath();
        ((PerforceChangeProvider)PerforceVcs.getInstance(project).getChangeProvider()).clearUnversionedStatus(path);
        p4File.clearCache();
        VcsUtil.markFileAsDirty((Project)project, (String)this.myPath);
    }

    @Override
    public void prepareOffline(Project project) {
        VcsUtil.markFileAsDirty((Project)project, (String)this.myPath);
    }

    @Override
    public Change getChange(Project project, ChangeListManagerGate addGate) {
        return new Change(null, CurrentContentRevision.create((FilePath)this.getFilePath()));
    }

    @Override
    public VcsOperation checkMerge(VcsOperation oldOp) {
        if (oldOp instanceof P4DeleteOperation && ((P4DeleteOperation)oldOp).getPath().equals(this.myPath)) {
            return new P4EditOperation(this.myChangeList, this.myPath);
        }
        return super.checkMerge(oldOp);
    }
}

