/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;

public class FullSearchSpecificator
implements JobsSearchSpecificator {
    public static final int ourMaxLines = 500;
    private final List<Pair<Parts, String>> myStandard = new ArrayList<Pair<Parts, String>>();
    private final List<FreePart> myFree = new ArrayList<FreePart>();

    public void addStandardConstraint(Parts part, String pattern) {
        this.myStandard.add((Pair<Parts, String>)Pair.create((Object)((Object)part), (Object)pattern));
    }

    @Override
    public String[] addParams(String[] s) {
        ArrayList<String> list = new ArrayList<String>(s.length + 2);
        ContainerUtil.addAll(list, (Object[])s);
        list.add("-m");
        list.add("501");
        if (!this.myStandard.isEmpty() || !this.myFree.isEmpty()) {
            list.add("-e");
            list.add(this.createPatterns());
        }
        return ArrayUtilRt.toStringArray(list);
    }

    @Override
    public int getMaxCount() {
        return 500;
    }

    private String createPatterns() {
        StringBuilder sb = new StringBuilder();
        for (Pair<Parts, String> pair : this.myStandard) {
            sb.append("(");
            ((Parts)((Object)pair.getFirst())).add(sb, (String)pair.getSecond());
            sb.append(") ");
        }
        for (FreePart part : this.myFree) {
            sb.append("(");
            part.add(sb);
            sb.append(") ");
        }
        return sb.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Parts {
        jobname("Job"){

            @Override
            protected void addImpl(StringBuilder sb, String pattern) {
                sb.append("=").append(pattern);
            }
        }
        ,
        status("Status"){

            @Override
            protected void addImpl(StringBuilder sb, String pattern) {
                sb.append("=").append(pattern);
            }
        }
        ,
        user("User"){

            @Override
            protected void addImpl(StringBuilder sb, String pattern) {
                sb.append("=").append(pattern);
            }
        }
        ,
        dateBefore("Date"){

            @Override
            protected void addImpl(StringBuilder sb, String pattern) {
                sb.append("<=").append(pattern);
            }
        }
        ,
        dateAfter("Date"){

            @Override
            protected void addImpl(StringBuilder sb, String pattern) {
                sb.append(">=").append(pattern);
            }
        }
        ,
        description("Description"){

            @Override
            protected void addImpl(StringBuilder sb, String pattern) {
                sb.append("=").append(pattern);
            }
        };

        private final String myName;

        private Parts(String pattern) {
            this.myName = pattern;
        }

        public void add(StringBuilder sb, String pattern) {
            sb.append(this.myName);
            this.addImpl(sb, pattern);
        }

        protected abstract void addImpl(StringBuilder var1, String var2);
    }

    private static final class FreePart {
        private final String myPattern;
        private final String myFieldName;
        private final String mySign;

        private FreePart(String fieldName, String sign, String pattern) {
            this.myPattern = pattern;
            this.myFieldName = fieldName;
            this.mySign = sign;
        }

        private void add(StringBuilder sb) {
            sb.append(this.myFieldName).append(this.mySign).append(this.myPattern);
        }
    }
}

