/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.DefaultChatRoomListener;
import org.jitsi.utils.logging2.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Presence;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public abstract class BaseBrewery<T extends ExtensionElement>
implements XmppProvider.Listener {
    private final Logger logger;
    private final ChatRoomListener chatRoomListener = new ChatRoomListenerImpl();
    private final EntityBareJid breweryJid;
    private final XmppProvider xmppProvider;
    private ChatRoom chatRoom;
    protected final List<BrewInstance> instances = new CopyOnWriteArrayList<BrewInstance>();
    private final String extensionElementName;
    private final String extensionNamespace;

    public BaseBrewery(@NotNull XmppProvider xmppProvider, @NotNull EntityBareJid breweryJid, String presenceExtensionElementName, String presenceExtensionNamespace, Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.xmppProvider = xmppProvider;
        this.breweryJid = breweryJid;
        this.logger.addContext("brewery", breweryJid.getLocalpartOrThrow().toString());
        this.extensionElementName = presenceExtensionElementName;
        this.extensionNamespace = presenceExtensionNamespace;
        this.logger.info((Object)("Initialized with JID=" + String.valueOf(breweryJid)));
    }

    public boolean isAnyInstanceConnected() {
        return this.instances.size() > 0;
    }

    public void init() {
        this.xmppProvider.addListener(this);
        this.maybeStart();
    }

    private void maybeStart() {
        if (this.chatRoom == null && this.xmppProvider.getRegistered()) {
            this.start();
        }
    }

    public void shutdown() {
        this.xmppProvider.removeListener(this);
        this.stop();
    }

    @Override
    public synchronized void registrationChanged(boolean registered) {
        if (registered) {
            this.maybeStart();
        } else {
            this.stop();
        }
    }

    private void start() {
        block2: {
            try {
                this.chatRoom = this.xmppProvider.createRoom(this.breweryJid);
                this.chatRoom.addListener(this.chatRoomListener);
                this.chatRoom.join();
                this.logger.info((Object)"Joined the room.");
            }
            catch (InterruptedException | XmppProvider.RoomExistsException | SmackException | XMPPException e) {
                this.logger.error((Object)"Failed to create room.", e);
                if (this.chatRoom == null) break block2;
                this.chatRoom.removeListener(this.chatRoomListener);
                this.chatRoom = null;
            }
        }
    }

    private void stop() {
        try {
            if (this.chatRoom != null) {
                this.chatRoom.removeListener(this.chatRoomListener);
                this.chatRoom.leave();
                this.logger.info((Object)"Left the room.");
            }
        }
        finally {
            this.chatRoom = null;
            this.instances.forEach(this::removeInstance);
        }
    }

    public void processMemberPresence(@NotNull ChatRoomMember member) {
        Presence presence = member.getPresence();
        if (presence == null) {
            return;
        }
        ExtensionElement ext = presence.getExtensionElement(this.extensionElementName, this.extensionNamespace);
        if (ext == null) {
            return;
        }
        this.processInstanceStatusChanged(member.getOccupantJid(), ext);
    }

    protected void processInstanceStatusChanged(@NotNull EntityFullJid jid, @NotNull T extension) {
        BrewInstance instance = this.find((Jid)jid);
        if (instance == null) {
            instance = new BrewInstance(this, jid, extension);
            this.addInstance(instance);
        } else {
            instance.status = extension;
        }
        this.logger.debug((Object)("New presence from " + String.valueOf(jid) + ": " + String.valueOf(extension.toXML())));
        this.onInstanceStatusChanged(jid, extension);
    }

    public int getInstanceCount() {
        return this.instances.size();
    }

    public int getInstanceCount(@NotNull Predicate<? super BrewInstance> filter) {
        return (int)this.instances.stream().filter(filter).count();
    }

    protected abstract void onInstanceStatusChanged(@NotNull EntityFullJid var1, @NotNull T var2);

    private BrewInstance find(Jid jid) {
        return this.instances.stream().filter(i -> i.jid.equals((CharSequence)jid)).findFirst().orElse(null);
    }

    private void addInstance(BrewInstance i) {
        this.instances.add(i);
        this.logger.info((Object)("Added brewery instance: " + String.valueOf(i.jid)));
    }

    private void removeInstance(@NotNull BrewInstance i) {
        this.instances.remove(i);
        this.logger.info((Object)("Removed brewery instance: " + String.valueOf(i.jid)));
        this.notifyInstanceOffline((Jid)i.jid);
    }

    protected abstract void notifyInstanceOffline(@NotNull Jid var1);

    private class ChatRoomListenerImpl
    extends DefaultChatRoomListener {
        private ChatRoomListenerImpl() {
        }

        @Override
        public void memberJoined(@NotNull ChatRoomMember member) {
            BaseBrewery.this.processMemberPresence(member);
        }

        @Override
        public void memberLeft(@NotNull ChatRoomMember member) {
            this.removeInstanceForMember(member);
        }

        @Override
        public void memberKicked(@NotNull ChatRoomMember member) {
            this.removeInstanceForMember(member);
        }

        @Override
        public void memberPresenceChanged(@NotNull ChatRoomMember member) {
            BaseBrewery.this.processMemberPresence(member);
        }

        private void removeInstanceForMember(@NotNull ChatRoomMember member) {
            BrewInstance instance = BaseBrewery.this.find((Jid)member.getOccupantJid());
            if (instance != null) {
                BaseBrewery.this.removeInstance(instance);
            }
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class BrewInstance {
        @NotNull
        public final EntityFullJid jid;
        @NotNull
        public T status;
        final /* synthetic */ BaseBrewery this$0;

        BrewInstance(@NotNull EntityFullJid jid, T status) {
            this.this$0 = this$0;
            this.jid = jid;
            this.status = status;
        }
    }
}

