/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.behaviour;

import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.behaviour.DoubleActivityBase;

public class Loop
extends DoubleActivityBase
implements Serializable {
    private double _from;
    private double _to;
    private double _duration;
    private double _timeout;

    public Loop() {
        this._timeout = 0.0;
        this._duration = 0.0;
        this._to = 0.0;
        this._from = 0.0;
    }

    public Loop(double d, double d2, double d3) {
        this._from = d;
        this._to = d2;
        this._duration = d3;
        this._timeout = 0.0;
    }

    public double getFrom() {
        return this._from;
    }

    public void setFrom(double d) {
        this._from = d;
    }

    public double getTo() {
        return this._to;
    }

    public void setTo(double d) {
        this._to = d;
    }

    public double getDuration() {
        return this._duration;
    }

    public void setDuration(double d) {
        this._duration = d;
    }

    public double getValue() {
        return this._from + this.ratio() * (this._to - this._from);
    }

    public boolean isFinite() {
        return false;
    }

    public void reset() {
        this._timeout = 0.0;
        this.postUpdate(this.getValue());
    }

    public void performActivity(double d) {
        this._timeout += d;
        while (this._timeout >= this._duration) {
            this._timeout -= this._duration;
            this.postActivityComplete();
        }
        this.postUpdate(this.getValue());
    }

    private final double ratio() {
        return this._timeout / this._duration;
    }

    public final DoubleBehaviourListener newFromAdapter() {
        return new FromAdapter();
    }

    public final DoubleBehaviourListener newToAdapter() {
        return new ToAdapter();
    }

    public final DoubleBehaviourListener newDurationAdapter() {
        return new DurationAdapter();
    }

    class DurationAdapter
    implements DoubleBehaviourListener,
    Serializable {
        DurationAdapter() {
        }

        public void behaviourUpdated(double d) {
            Loop.this.setDuration(d);
        }
    }

    class ToAdapter
    implements DoubleBehaviourListener,
    Serializable {
        ToAdapter() {
        }

        public void behaviourUpdated(double d) {
            Loop.this.setTo(d);
        }
    }

    class FromAdapter
    implements DoubleBehaviourListener,
    Serializable {
        FromAdapter() {
        }

        public void behaviourUpdated(double d) {
            Loop.this.setFrom(d);
        }
    }
}

