const fs = require('fs'),
    mime = require('mime-types'),
    path = require('path');

let audioFile = fs.readFileSync(path.resolve(process.cwd(), process.env.AUDIO)),
    audioMimeType = mime.lookup(process.env.AUDIO),
    videoFile = fs.readFileSync(path.resolve(process.cwd(), process.env.VIDEO)),
    videoMimeType = mime.lookup(process.env.VIDEO);

let code = `/* global Blob */
// This file is generated. Do not edit this file directly.
// Command: 'npm run generate' should be used to update the content.

/**
 * @type {Blob}
 */
export const AUDIO = new Blob([new Uint8Array([${[...audioFile].join(', ')}])], {type: '${audioMimeType}'})

/**
 * @type {Blob}
 */
export const VIDEO = new Blob([new Uint8Array([${[...videoFile].join(', ')}])], {type: '${videoMimeType}'})
`;

console.log('Writing file...');

fs.writeFileSync(
    path.resolve(process.cwd(), process.env.OUTPUT),
    code,
    {encoding: 'utf8'}
);



