/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IModuleScope;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.ILocalVariableVisitor;
import org.jrubyparser.util.MethodDefVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SClassNode
extends Node
implements ILocalScope,
IModuleScope {
    private Node receiverNode;
    private StaticScope scope;
    private Node bodyNode;

    public SClassNode(SourcePosition position, Node recvNode, StaticScope scope, Node bodyNode) {
        super(position);
        assert (scope != null) : "scope is not null";
        assert (recvNode != null) : "receiverNode is not null";
        this.receiverNode = this.adopt(recvNode);
        this.scope = scope;
        this.bodyNode = this.adopt(bodyNode);
    }

    @Override
    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        SClassNode other = (SClassNode)node;
        if (this.getBody() == null && other.getBody() == null) {
            return true;
        }
        if (this.getBody() == null || other.getBody() == null) {
            return false;
        }
        return this.getReceiver().isSame(other.getReceiver());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCLASSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = this.adopt(body);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiver() {
        return this.receiverNode;
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public void setReceiver(Node receiver) {
        this.receiverNode = this.adopt(receiver);
    }

    @Override
    public List<MethodDefNode> getMethodDefs() {
        return MethodDefVisitor.findMethodsIn(this);
    }

    @Override
    public List<ILocalVariable> getVariableReferencesNamed(String name) {
        return ILocalVariableVisitor.findOccurrencesIn(this, name);
    }
}

