/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcher {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                1.$$$reportNull$$$0(0);
            }
            return notificationGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher$1", "compute"));
        }
    };
    private final ManagingFS myManagingFS;
    private final MyFileWatcherNotificationSink myNotificationSink;
    private final PluggableFileWatcher[] myWatchers;
    private final AtomicBoolean myFailureShown;
    private volatile CanonicalPathMap myPathMap;
    private volatile List<Collection<String>> myManualWatchRoots;
    public static final String RESET = "(reset)";
    public static final String OTHER = "(other)";
    private volatile Consumer<String> myTestNotifier;

    FileWatcher(@NotNull ManagingFS managingFS) {
        if (managingFS == null) {
            FileWatcher.$$$reportNull$$$0(0);
        }
        this.myFailureShown = new AtomicBoolean(false);
        this.myPathMap = new CanonicalPathMap();
        this.myManualWatchRoots = Collections.emptyList();
        this.myTestNotifier = null;
        this.myManagingFS = managingFS;
        this.myNotificationSink = new MyFileWatcherNotificationSink();
        for (PluggableFileWatcher watcher : this.myWatchers = (PluggableFileWatcher[])PluggableFileWatcher.EP_NAME.getExtensions()) {
            watcher.initialize(this.myManagingFS, (FileWatcherNotificationSink)this.myNotificationSink);
        }
    }

    public void dispose() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.dispose();
        }
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean isSettingRoots() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DirtyPaths getDirtyPaths() {
        DirtyPaths dirtyPaths = this.myNotificationSink.getDirtyPaths();
        if (dirtyPaths == null) {
            FileWatcher.$$$reportNull$$$0(1);
        }
        return dirtyPaths;
    }

    @NotNull
    public Collection<String> getManualWatchRoots() {
        List<Collection<String>> manualWatchRoots = this.myManualWatchRoots;
        Collection<String> result2 = null;
        for (Collection<String> roots : manualWatchRoots) {
            if (result2 == null) {
                result2 = ContainerUtil.newHashSet(roots);
                continue;
            }
            result2.retainAll(roots);
        }
        Collection<String> collection = result2 != null ? result2 : Collections.emptyList();
        if (collection == null) {
            FileWatcher.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        CanonicalPathMap pathMap;
        if (recursive == null) {
            FileWatcher.$$$reportNull$$$0(3);
        }
        if (flat == null) {
            FileWatcher.$$$reportNull$$$0(4);
        }
        this.myPathMap = pathMap = new CanonicalPathMap(recursive, flat);
        this.myManualWatchRoots = ContainerUtil.createLockFreeCopyOnWriteList();
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.setWatchRoots(pathMap.getCanonicalRecursiveWatchRoots(), pathMap.getCanonicalFlatWatchRoots());
        }
    }

    public void notifyOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
        if (cause == null) {
            FileWatcher.$$$reportNull$$$0(5);
        }
        LOG.warn(cause);
        if (this.myFailureShown.compareAndSet(false, true)) {
            String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (cause == null) {
                    FileWatcher.$$$reportNull$$$0(6);
                }
                Notifications.Bus.notify((Notification)((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(title, cause, NotificationType.WARNING, listener2));
            }, ModalityState.NON_MODAL);
        }
    }

    private void notifyOnEvent(String path) {
        Consumer<String> notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.accept(path);
        }
    }

    public void startup(@Nullable Consumer<String> notifier) throws IOException {
        this.myTestNotifier = notifier;
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.startup();
        }
    }

    public void shutdown() throws InterruptedException {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.shutdown();
        }
        this.myTestNotifier = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/FileWatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/FileWatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyPaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManualWatchRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWatchRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnFailure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyOnFailure$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private final Object myLock = new Object();
        private DirtyPaths myDirtyPaths = new DirtyPaths();

        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DirtyPaths getDirtyPaths() {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            PluggableFileWatcher[] pluggableFileWatcherArray = this.myLock;
            synchronized (this.myLock) {
                if (!this.myDirtyPaths.isEmpty()) {
                    dirtyPaths = this.myDirtyPaths;
                    this.myDirtyPaths = new DirtyPaths();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (PluggableFileWatcher watcher : FileWatcher.this.myWatchers) {
                    watcher.resetChangedPaths();
                }
                return dirtyPaths;
            }
        }

        public void notifyManualWatchRoots(@NotNull Collection<String> roots) {
            if (roots == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(0);
            }
            FileWatcher.this.myManualWatchRoots.add(roots.isEmpty() ? Collections.emptySet() : ContainerUtil.newHashSet(roots));
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        public void notifyMapping(@NotNull Collection<Pair<String, String>> mapping) {
            if (mapping == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(1);
            }
            if (!mapping.isEmpty()) {
                FileWatcher.this.myPathMap.addMapping(mapping);
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPath(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(2);
            }
            if (!(paths = FileWatcher.this.myPathMap.getWatchedPaths(path, true)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String eachPath : paths) {
                        this.myDirtyPaths.addDirtyPath(eachPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathCreatedOrDeleted(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(3);
            }
            if (!(paths = FileWatcher.this.myPathMap.getWatchedPaths(path, true)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String p : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(p);
                        String parentPath = new File(p).getParent();
                        if (parentPath == null) continue;
                        this.myDirtyPaths.addDirtyPath(parentPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectory(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(4);
            }
            if (!(paths = FileWatcher.this.myPathMap.getWatchedPaths(path, false)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyDirectories.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPathRecursive(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(5);
            }
            if (!(paths = FileWatcher.this.myPathMap.getWatchedPaths(path, false)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String each : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(each);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyReset(@Nullable String path) {
            if (path != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.addDirtyPathRecursive(path);
                }
            }
            VirtualFile[] roots = FileWatcher.this.myManagingFS.getLocalRoots();
            Object object = this.myLock;
            synchronized (object) {
                for (VirtualFile root : roots) {
                    this.myDirtyPaths.addDirtyPathRecursive(root.getPresentableUrl());
                }
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.RESET);
        }

        public void notifyUserOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
            if (cause == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(6);
            }
            FileWatcher.this.notifyOnFailure(cause, listener2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/impl/local/FileWatcher$MyFileWatcherNotificationSink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyManualWatchRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyMapping";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyDirtyPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyPathCreatedOrDeleted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyDirtyDirectory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyDirtyPathRecursive";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyUserOnFailure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DirtyPaths {
        public final Set<String> dirtyPaths = ContainerUtil.newTroveSet();
        public final Set<String> dirtyPathsRecursive = ContainerUtil.newTroveSet();
        public final Set<String> dirtyDirectories = ContainerUtil.newTroveSet();
        public static final DirtyPaths EMPTY = new DirtyPaths();

        public boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }

        private void addDirtyPath(String path) {
            if (!this.dirtyPathsRecursive.contains(path)) {
                this.dirtyPaths.add(path);
            }
        }

        private void addDirtyPathRecursive(String path) {
            this.dirtyPaths.remove(path);
            this.dirtyPathsRecursive.add(path);
        }
    }
}

