/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.generation;

import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.generation.DrupalProjectGeneratorSettings;
import com.jetbrains.php.drupal.generation.DrupalProjectPeer;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import icons.DrupalIcons;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrupalProjectGenerator
extends WebProjectTemplate<DrupalProjectGeneratorSettings> {
    @NonNls
    private static final String HELP_ID = "reference.drupal.module.reference";

    @Nls
    @NotNull
    public String getName() {
        String string = DrupalBundle.message("drupal.drupal.module", new Object[0]);
        if (string == null) {
            DrupalProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getDescription() {
        return DrupalBundle.message("drupal.drupal.module", new Object[0]);
    }

    public Icon getIcon() {
        return DrupalIcons.Drupal;
    }

    @NotNull
    public ProjectGeneratorPeer<DrupalProjectGeneratorSettings> createPeer() {
        DrupalProjectPeer drupalProjectPeer = new DrupalProjectPeer();
        if (drupalProjectPeer == null) {
            DrupalProjectGenerator.$$$reportNull$$$0(1);
        }
        return drupalProjectPeer;
    }

    public boolean isPrimaryGenerator() {
        return PlatformUtils.isPhpStorm();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull DrupalProjectGeneratorSettings settings, @NotNull Module module) {
        if (project == null) {
            DrupalProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            DrupalProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            DrupalProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            DrupalProjectGenerator.$$$reportNull$$$0(5);
        }
        DrupalDataService dataService = DrupalDataService.getInstance(project);
        dataService.setState(settings.getDrupalState());
        String moduleName = baseDir.getName();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (baseDir == null) {
                DrupalProjectGenerator.$$$reportNull$$$0(10);
            }
            if (project == null) {
                DrupalProjectGenerator.$$$reportNull$$$0(11);
            }
            try {
                DrupalVersion version = dataService.getVersion();
                DrupalProjectGenerator.generateInfoFile(moduleName, version, baseDir);
                DrupalProjectGenerator.generateModuleFile(moduleName, version, baseDir);
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)DrupalBundle.message("drupal.error.creating.drupal.module.0", e.getMessage()), (String)DrupalBundle.message("drupal.create.drupal.module", new Object[0]));
            }
            baseDir.refresh(false, true);
        });
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (baseDir == null) {
                DrupalProjectGenerator.$$$reportNull$$$0(6);
            }
            if (project == null) {
                DrupalProjectGenerator.$$$reportNull$$$0(7);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (baseDir == null) {
                    DrupalProjectGenerator.$$$reportNull$$$0(8);
                }
                if (project == null) {
                    DrupalProjectGenerator.$$$reportNull$$$0(9);
                }
                baseDir.getFileSystem().refresh(false);
                DrupalProjectGenerator.openFilesInEditor(project, baseDir, moduleName + ".info", moduleName + ".module");
            });
        });
    }

    private static void openFilesInEditor(Project project, VirtualFile baseDir, String ... fileNames) {
        if (baseDir == null) {
            return;
        }
        PsiDirectory psiBaseDir = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (psiBaseDir != null) {
            for (String fileName : fileNames) {
                PsiFile psiFile = psiBaseDir.findFile(fileName);
                if (psiFile == null) continue;
                psiFile.navigate(fileName == fileNames[fileNames.length - 1]);
            }
        }
    }

    private static void generateInfoFile(String moduleName, DrupalVersion version, VirtualFile contentRoot) throws IOException {
        String fileName;
        switch (version) {
            case SIX: {
                fileName = moduleName + ".info";
                break;
            }
            case SEVEN: {
                fileName = moduleName + ".info";
                break;
            }
            case EIGHT: {
                fileName = moduleName + ".info.yml";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Drupal version: " + (Object)((Object)version));
            }
        }
        File targetFile = new File(contentRoot.getPath(), fileName);
        if (targetFile.exists()) {
            return;
        }
        String template = DrupalProjectGenerator.loadTemplate("module.info", version);
        String improvedModuleName = DrupalProjectGenerator.improveModuleName(moduleName);
        if (!StringUtil.isEmpty((String)(improvedModuleName = StringUtil.wordsToBeginFromUpperCase((String)improvedModuleName)))) {
            template = template.replaceFirst("<Module name>", improvedModuleName);
        }
        FileUtil.writeToFile((File)targetFile, (String)template);
    }

    private static String improveModuleName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(2 * name.length());
        boolean wasLowercaseLetter = false;
        boolean wasSpace = false;
        for (char c : name.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && !wasSpace) {
                sb.append(' ');
                wasSpace = true;
                wasLowercaseLetter = false;
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(c);
                wasSpace = false;
                wasLowercaseLetter = false;
                continue;
            }
            if (wasSpace) {
                c = Character.toUpperCase(c);
            }
            if (wasLowercaseLetter && Character.isUpperCase(c)) {
                sb.append(' ').append(c);
                wasSpace = false;
                wasLowercaseLetter = false;
                continue;
            }
            sb.append(c);
            wasSpace = false;
            wasLowercaseLetter = Character.isLowerCase(c);
        }
        return sb.toString();
    }

    private static void generateModuleFile(String moduleName, DrupalVersion version, VirtualFile contentRoot) throws IOException {
        String fileName;
        switch (version) {
            case SIX: 
            case SEVEN: 
            case EIGHT: {
                fileName = moduleName + ".module";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Drupal version: " + (Object)((Object)version));
            }
        }
        DrupalProjectGenerator.copyIfNotExist(contentRoot, fileName, "module.module", version);
    }

    private static void copyIfNotExist(VirtualFile contentRoot, String fileName, @NonNls String templateName, DrupalVersion version) throws IOException {
        File targetFile = new File(contentRoot.getPath(), fileName);
        if (targetFile.exists()) {
            return;
        }
        String template = DrupalProjectGenerator.loadTemplate(templateName, version);
        FileUtil.writeToFile((File)targetFile, (String)template);
    }

    private static String loadTemplate(@NonNls String name, DrupalVersion version) throws IOException {
        Class<DrupalBundle> baseClass = DrupalBundle.class;
        Package aPackage = baseClass.getPackage();
        String resourceName = "/" + aPackage.getName().replace(".", "/") + "/templates/" + name + "." + version.getNumber() + ".txt";
        InputStream in = baseClass.getResourceAsStream(resourceName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        return FileUtil.loadTextAndClose((Reader)reader);
    }

    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/drupal/generation/DrupalProjectGenerator";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/drupal/generation/DrupalProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$2";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

