/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintUtil {
    public static final String PACKAGE_NAME = "stylelint";
    public static final String DEFAULT_CONFIG_PREFIX = ".stylelintrc";
    public static final String IGNORE_FILE = ".stylelintignore";
    private static final String CONFIG_JS_FILE_NAME = "stylelint.config.js";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final HashSet<String> CONFIG_FILENAMES = ContainerUtil.newHashSet();

    @Nullable
    public static VirtualFile findWorkingDirectory(@NotNull VirtualFile fileToLint) {
        VirtualFile parent;
        if (fileToLint == null) {
            StylelintUtil.$$$reportNull$$$0(0);
        }
        if ((parent = fileToLint.getParent()) == null) {
            return null;
        }
        CommonProcessors.FindProcessor<VirtualFile> processor = new CommonProcessors.FindProcessor<VirtualFile>(){

            protected boolean accept(VirtualFile file2) {
                return file2.isValid() && !file2.isDirectory() && StylelintUtil.IGNORE_FILE.equals(file2.getName());
            }
        };
        StylelintUtil.processFromDirectoryUp(parent, (Processor<VirtualFile>)processor);
        VirtualFile ignoreFile = (VirtualFile)processor.getFoundValue();
        VirtualFile ignoreFileParent = ignoreFile != null ? ignoreFile.getParent() : null;
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)ignoreFileParent, (Object)parent);
    }

    @NotNull
    public static Collection<VirtualFile> getPossibleConfigs(@NotNull VirtualFile dir, final boolean withPackageJson) {
        if (dir == null) {
            StylelintUtil.$$$reportNull$$$0(1);
        }
        CommonProcessors.CollectProcessor<VirtualFile> processor = new CommonProcessors.CollectProcessor<VirtualFile>((Collection)ContainerUtil.newSmartList()){

            protected boolean accept(VirtualFile file2) {
                if (!withPackageJson && PackageJsonUtil.isPackageJsonFile(file2)) {
                    return false;
                }
                boolean configFile = StylelintUtil.isStylelintConfigFile(file2);
                if (configFile && JSLinterGuesser.LOG.isDebugEnabled()) {
                    JSLinterGuesser.LOG.debug("Found Stylelint config: " + file2.getPath());
                }
                return configFile;
            }
        };
        StylelintUtil.processFromDirectoryUp(dir, (Processor<VirtualFile>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            StylelintUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public static boolean isStylelintConfigFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StylelintUtil.$$$reportNull$$$0(3);
        }
        return file2.isValid() && !file2.isDirectory() && CONFIG_FILENAMES.contains(file2.getName());
    }

    private static void processFromDirectoryUp(@NotNull VirtualFile dir, @NotNull Processor<VirtualFile> processor) {
        if (dir == null) {
            StylelintUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            StylelintUtil.$$$reportNull$$$0(5);
        }
        while (dir != null) {
            for (VirtualFile file2 : dir.getChildren()) {
                if (processor.process((Object)file2)) continue;
                return;
            }
            dir = dir.getParent();
        }
    }

    static {
        CONFIG_FILENAMES.add("package.json");
        CONFIG_FILENAMES.add(CONFIG_JS_FILE_NAME);
        CONFIG_FILENAMES.add(IGNORE_FILE);
        for (String CONFIG_EXTENSION : CONFIG_EXTENSIONS) {
            CONFIG_FILENAMES.add(DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSION);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/linter/stylelint/StylelintUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/linter/stylelint/StylelintUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findWorkingDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleConfigs";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStylelintConfigFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processFromDirectoryUp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

