/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlers;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        JSClass containingClass;
        PsiElement grandParentParent;
        PsiElement parent = context.getParent();
        if (ES6CompletionKeywordsContributor.addFromOrAsKeyword(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addExtendsImplements(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExportDefault(consumer, parent)) {
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
        if (ES6PsiUtil.isAsyncContext(function)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "await");
        }
        if (function != null && function.isGenerator()) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "yield");
        }
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (function != null && grandParent instanceof JSExpressionStatement) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "return");
        }
        boolean isModuleContext = false;
        if (parent instanceof JSReferenceExpression && grandParent instanceof JSExpressionStatement && (grandParentParent instanceof JSFile || grandParentParent instanceof TypeScriptModule || grandParentParent instanceof JSEmbeddedContent)) {
            PsiElement prevPrevSibling;
            PsiElement prevSibling = JSPsiImplUtils.findPrevCodeElement(grandParent);
            if (prevSibling instanceof PsiErrorElement && JSBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]).equals(((PsiErrorElement)prevSibling).getErrorDescription()) && (prevPrevSibling = JSPsiImplUtils.findPrevCodeElement(prevSibling)) instanceof JSAttributeList && ((JSAttributeList)prevPrevSibling).hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                this.appendKeywordsAfterExport(consumer);
                return false;
            }
            isModuleContext = true;
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "import", "export");
        }
        if (!isModuleContext && DialectDetector.isES6(context) && !(parent instanceof Es6MetaProperty)) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "import()");
        }
        if (parent instanceof JSVariable && grandParent instanceof JSVarStatement && grandParent.getParent() instanceof ES6Class) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)context).SPACE_BEFORE_METHOD_PARENTHESES, "constructor");
            consumer.consume(JSLookupPriority.SMART_PRIORITY, true, "static");
            return false;
        }
        JSFunction parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        if ((containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) != null && parentFunction.getJSContext() != JSContext.STATIC && !containingClass.isInterface() && containingClass.getExtendsList() != null && !(grandParent instanceof ES6Property)) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, false, "super");
        }
        return super.process(consumer, context);
    }

    @Contract(value="_, null -> false")
    private static boolean addAfterExportDefault(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prev instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        if (!((prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev)) instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.EXPORT_KEYWORD) {
            return false;
        }
        consumer.consume(JSLookupPriority.SMART_PRIORITY, true, "class", "function");
        return true;
    }

    @Contract(value="_, null -> false")
    public static boolean addExtendsImplements(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        if (!(prevSiblingPrevSibling instanceof JSClass)) {
            return false;
        }
        PsiElement lastChild = prevSiblingPrevSibling.getLastChild();
        if (!(lastChild instanceof PsiErrorElement)) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        if (prev instanceof JSReferenceExpression) {
            PsiElement prevPrev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev);
            if (prevPrev instanceof LeafPsiElement) {
                IElementType type = ((LeafPsiElement)prevPrev).getElementType();
                if (type == JSTokenTypes.CLASS_KEYWORD) {
                    if (consumer != null) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends", "implements");
                    }
                    return true;
                }
                if (type == JSTokenTypes.INTERFACE_KEYWORD) {
                    if (consumer != null) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
                    }
                    return true;
                }
                if (type == JSTokenTypes.ENUM_KEYWORD) {
                    return true;
                }
            }
        } else if (prev instanceof JSReferenceList) {
            IElementType type;
            PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)prevSiblingPrevSibling.getFirstChild());
            if (possibleClassKeyword instanceof LeafPsiElement && (type = ((LeafPsiElement)possibleClassKeyword).getElementType()) == JSTokenTypes.CLASS_KEYWORD) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "implements");
                }
                return true;
            }
        } else if (prev instanceof TypeScriptTypeParameter) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
            }
            return true;
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean addFromOrAsKeyword(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof JSReferenceExpression)) {
            return ES6CompletionKeywordsContributor.addAsKeywordForImportExportSpecifier(consumer, parent);
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        boolean isImport = prevSiblingPrevSibling instanceof ES6ImportDeclaration;
        boolean isExport = prevSiblingPrevSibling instanceof ES6ExportDeclaration;
        if (isImport || isExport) {
            PsiElement prev;
            PsiElement lastLast;
            PsiElement last = prevSiblingPrevSibling.getLastChild();
            if (last != null && (lastLast = last.getLastChild()) instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastLast)) != null && prev.getNode().getElementType() == JSTokenTypes.MULT) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, isImport ? "as" : "from");
                }
                return true;
            }
            if (prevSiblingPrevSibling.getNode().findChildByType(FILE_REFERENCES) == null) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "from");
                }
                return true;
            }
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAsKeywordForImportExportSpecifier(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        PsiElement prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prevNode instanceof PsiErrorElement)) {
            return false;
        }
        if (!((prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevNode)) instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "as");
        }
        return true;
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        super.appendSpecificKeywords(consumer);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class", "extends", "private", "public", "static", "yield", "async", "await", "of");
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "constructor");
    }

    @Override
    public void appendExpressionContextKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
        super.appendExpressionContextKeywords(consumer);
        consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "yield", "async", "await");
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class");
    }

    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "class", "var", "const", "let", "function", "default");
    }

    @Override
    @Nullable
    public InsertHandler<LookupElement> createInsertHandlerForKeyword(String keyword) {
        if ("class".equals(keyword)) {
            return JSKeywordInsertHandlers.CLASS_KEYWORD_INSERT_HANDLER;
        }
        return super.createInsertHandlerForKeyword(keyword);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "consumer";
        objectArray2[1] = "com/intellij/lang/javascript/completion/ES6CompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExportDefault";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendExpressionContextKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

