/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.inspections.JSArrowFunctionBracesCanBeRemovedInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.react.ReactFunctionalToClassComponentHandler;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactClassToFunctionalComponentHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_TITLE = JSBundle.message((String)"refactoring.react.class.to.functional.refactoring.title", (Object[])new Object[0]);
    private static final String[] CONVERTIBLE_NAMES = new String[]{"propTypes", "defaultProps", "render"};
    private static final String DEFAULT_COMPONENT_NAME = "Component";

    public boolean isAvailable(@NotNull JSClass<?> clazz) {
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(0);
        }
        if (ReactXmlExtension.isAcceptableClassComponent(clazz) == ThreeState.NO) {
            return false;
        }
        for (JSElement member : clazz.getMembers()) {
            if (member instanceof JSNamedElement && ArrayUtil.indexOf((Object[])CONVERTIBLE_NAMES, (Object)member.getName()) < 0) {
                return false;
            }
            if (!ReactClassToFunctionalComponentHandler.referencesState(member)) continue;
            return false;
        }
        if (JSPsiImplUtils.hasModifier(clazz, JSAttributeList.ModifierType.ABSTRACT)) {
            return false;
        }
        return JSClassSearch.searchClassInheritors(clazz, false).findFirst() == null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(2);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, editor, file2);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        JSClass clazz;
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(6);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), JSClass.class, (boolean)false)) == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"react.class.to.function.caret.at.class", (Object[])new Object[0]));
            ReactClassToFunctionalComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz, editor, REFACTORING_TITLE)) {
            return;
        }
        String propTypesInitializer = ReactClassToFunctionalComponentHandler.getFieldInitializer(clazz, "propTypes");
        String defaultPropsInitializer = ReactClassToFunctionalComponentHandler.getFieldInitializer(clazz, "defaultProps");
        String introducedName = clazz.getName();
        if (StringUtil.isEmpty((String)introducedName)) {
            if (!StringUtil.isEmpty((String)propTypesInitializer) || !StringUtil.isEmpty((String)defaultPropsInitializer)) {
                introducedName = ReactClassToFunctionalComponentHandler.showNameDialog(project, (JSNamedElement)clazz);
                if (StringUtil.isEmpty((String)introducedName)) {
                    return;
                }
            } else {
                introducedName = DEFAULT_COMPONENT_NAME;
            }
        }
        ArrayList typeUsages = new ArrayList();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            SearchScope useScope = clazz.getUseScope();
            String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)clazz, (boolean)false));
            ReferencesSearch.search((PsiElement)clazz, (SearchScope)useScope).forEach(psiReference -> {
                PsiElement refElement = psiReference.getElement();
                if (refElement instanceof JSReferenceExpression && refElement.getParent() instanceof TypeScriptSingleType) {
                    typeUsages.add((TypeScriptSingleType)refElement.getParent());
                } else if (refElement instanceof JSXmlLiteralExpression && ((JSXmlLiteralExpression)refElement).getAttribute("ref") != null) {
                    conflicts.putValue((Object)refElement, (Object)JSBundle.message((String)"refactoring.react.class.to.functional.conflict.used.with.ref", (Object[])new Object[]{elementDescription}));
                }
            });
        }), JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!JSRefactoringUtil.showConflictsDialog(project, (MultiMap<PsiElement, String>)conflicts)) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_TITLE, null, () -> {
            if (editor == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(51);
            }
            ReactClassToFunctionalComponentHandler.doRefactoringInWriteAction(finalIntroducedName, clazz, editor, propTypesInitializer, defaultPropsInitializer, typeUsages);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void doRefactoringInWriteAction(@NotNull String introducedName, @NotNull JSClass clazz, @NotNull Editor editor, @Nullable String propTypesInitializer, @Nullable String defaultPropsInitializer, @NotNull List<TypeScriptSingleType> typeUsages) {
        JSElement replacementPsi;
        String replacementText;
        boolean hasSfcTypeDeclaration;
        JSParameterList createdFunctionParameterList;
        String codeTemplateName;
        JSNamedElement createdNamedElement;
        if (introducedName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(9);
        }
        if (typeUsages == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(10);
        }
        boolean isTypedDialect = DialectDetector.hasFeature((PsiElement)clazz, JSLanguageFeature.TYPES);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)clazz.getProject());
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)introducedName)) {
            properties.setProperty("NAME", introducedName);
        }
        if (!isTypedDialect && !StringUtil.isEmpty((String)propTypesInitializer)) {
            properties.setProperty("PROP_TYPES", propTypesInitializer);
        }
        if (!StringUtil.isEmpty((String)defaultPropsInitializer)) {
            properties.setProperty("DEFAULT_PROPS", defaultPropsInitializer);
        }
        PsiFile createdFile = (createdNamedElement = ReactExtractComponentHandler.expandTemplate((PsiElement)clazz, properties, codeTemplateName = ReactExtractComponentHandler.getCodeTemplateName(ReactExtractComponentHandler.ComponentType.Function, isTypedDialect), JSNamedElement.class)) != null ? createdNamedElement.getContainingFile() : null;
        JSFunction createdFunction = JSPsiImplUtils.getPossibleFunction((PsiElement)createdNamedElement);
        JSElement createdFunctionBody = (JSElement)ObjectUtils.coalesce((Object)ReactFunctionalToClassComponentHandler.findFunctionBlockBody(createdFunction), (Object)JSPsiImplUtils.tryGetArrowFunctionReturnExpression(createdFunction));
        JSParameterList jSParameterList = createdFunctionParameterList = createdFunction != null ? createdFunction.getParameterList() : null;
        if (createdFunctionBody == null || createdFunctionParameterList == null) {
            String message = JSBundle.message((String)"refactoring.react.could.not.find.in.template", (Object[])new Object[]{introducedName, codeTemplateName});
            ReactClassToFunctionalComponentHandler.showErrorHint(clazz.getProject(), editor, message);
            return;
        }
        JSFunction renderMethod = clazz.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE);
        JSBlockStatement renderMethodBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(renderMethod);
        JSExpression renderReturnExpression = JSArrowFunctionBracesCanBeRemovedInspection.getSingleExpression(renderMethodBody);
        String typedDialectPropsType = ReactClassToFunctionalComponentHandler.getPropsTypeFromClassGenericArgument(clazz);
        String propsParameterName = ReactClassToFunctionalComponentHandler.getParameterName(createdFunctionParameterList, 0, "props");
        String contextParameterName = ReactClassToFunctionalComponentHandler.getParameterName(createdFunctionParameterList, 1, "context");
        TypeScriptSingleType createdSfcTypeDeclaration = ReactFunctionalToClassComponentHandler.getSFCTypeDeclaration(createdNamedElement);
        if (createdNamedElement instanceof JSAttributeListOwner) {
            ReactFunctionalToClassComponentHandler.copyExportStatus((JSNamedElement)clazz, (JSAttributeListOwner)createdNamedElement);
        }
        ReactFunctionalToClassComponentHandler.copyReturnType((JSNamedElement)renderMethod, (JSNamedElement)createdFunction);
        boolean bl = hasSfcTypeDeclaration = createdSfcTypeDeclaration != null;
        if (hasSfcTypeDeclaration && !StringUtil.isEmpty((String)typedDialectPropsType)) {
            String genericSfcText = createdSfcTypeDeclaration.getQualifiedTypeName() + "<" + typedDialectPropsType + ">";
            createdSfcTypeDeclaration.replace((PsiElement)JSChangeUtil.createTypeScriptType(genericSfcText, (PsiElement)createdSfcTypeDeclaration));
        }
        Ref hasProps = new Ref((Object)Boolean.FALSE);
        Ref hasContext = new Ref((Object)Boolean.FALSE);
        if (createdFunctionBody instanceof JSExpression && renderReturnExpression != null) {
            replacementText = ReactClassToFunctionalComponentHandler.processRenderMethod((JSElement)renderReturnExpression, propsParameterName, contextParameterName, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = (JSElement)JSChangeUtil.createExpressionPsiWithContext((String)ObjectUtils.coalesce((Object)replacementText, (Object)"null"), (PsiElement)clazz, JSExpression.class);
        } else {
            replacementText = ReactClassToFunctionalComponentHandler.processRenderMethod((JSElement)renderMethodBody, propsParameterName, contextParameterName, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = (JSElement)JSChangeUtil.createStatementPsiFromTextWithContext((String)ObjectUtils.coalesce((Object)replacementText, (Object)"{}"), (PsiElement)clazz, JSBlockStatement.class);
        }
        createdFunctionBody.replace((PsiElement)replacementPsi);
        createdFunctionParameterList.replace((PsiElement)ReactClassToFunctionalComponentHandler.createParameterList(hasProps.get() == Boolean.TRUE ? propsParameterName : null, !hasSfcTypeDeclaration ? typedDialectPropsType : null, hasContext.get() == Boolean.TRUE ? contextParameterName : null, (PsiElement)createdFunction));
        PsiElement resultElement = ReactClassToFunctionalComponentHandler.expressionAwareReplace((JSNamedElement)clazz, createdFile, createdNamedElement);
        ReactClassToFunctionalComponentHandler.moveCaretToElement(editor, resultElement);
        FormatFixer.create(resultElement, FormatFixer.Mode.Reformat).fixFormat();
        ES6CreateImportUtil.optimizeImports(resultElement);
        for (TypeScriptSingleType typeUsage : typeUsages) {
            typeUsage.replace((PsiElement)JSChangeUtil.createTypeScriptType("typeof " + typeUsage.getText(), (PsiElement)typeUsage));
        }
    }

    @NotNull
    public static PsiElement expressionAwareReplace(@NotNull JSNamedElement toReplace, @NotNull PsiFile createdFile, @NotNull JSNamedElement createdDeclaration) {
        if (toReplace == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(11);
        }
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(12);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(13);
        }
        boolean templateHasMultipleTopLevelEntities = ReactClassToFunctionalComponentHandler.getFileLevelEntitiesCount(createdFile) > 1;
        boolean declarationCanBeConvertedToExpression = createdDeclaration instanceof JSFunctionDeclaration || createdDeclaration instanceof JSClass;
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)toReplace);
        if (toReplace instanceof JSExpression) {
            JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class);
            assert (sourceElement != null);
            if (declarationCanBeConvertedToExpression) {
                if (toReplace.getParent() instanceof ES6ExportDefaultAssignment) {
                    PsiElement result2 = toReplace.replace((PsiElement)ReactClassToFunctionalComponentHandler.convertToExpression(createdDeclaration));
                    if (templateHasMultipleTopLevelEntities) {
                        createdDeclaration.delete();
                        JSChangeUtil.doAddRangeAfter(sourceElement.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), (PsiElement)sourceElement);
                    }
                    PsiElement psiElement = result2;
                    if (psiElement == null) {
                        ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(14);
                    }
                    return psiElement;
                }
                if (!templateHasMultipleTopLevelEntities) {
                    JSExpression expression = ReactClassToFunctionalComponentHandler.convertToExpression(createdDeclaration);
                    PsiElement result3 = toReplace.replace((PsiElement)expression);
                    JSDocumentationUtils.moveJSDoc(docComment, result3);
                    PsiElement psiElement = result3;
                    if (psiElement == null) {
                        ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(15);
                    }
                    return psiElement;
                }
            }
            JSNamedElement jsDocTarget = createdDeclaration instanceof JSVariable ? createdDeclaration.getParent() : createdDeclaration;
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)jsDocTarget);
            JSChangeUtil.doAddRangeBefore(sourceElement.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), (PsiElement)sourceElement);
            PsiElement psiElement = toReplace.replace((PsiElement)ReactClassToFunctionalComponentHandler.createReferenceTo(createdDeclaration));
            if (psiElement == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(16);
            }
            return psiElement;
        }
        PsiElement psiElement = ReactClassToFunctionalComponentHandler.replaceSourceElement((PsiElement)toReplace, createdDeclaration, createdFile, docComment);
        if (psiElement == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    private static int getFileLevelEntitiesCount(@NotNull PsiFile createdFile) {
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(18);
        }
        return (int)Arrays.stream(createdFile.getChildren()).filter(JSChangeUtil::isSourceElementOrComment).count();
    }

    public static void moveCaretToElement(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(19);
        }
        if (element == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(20);
        }
        editor.getCaretModel().moveToOffset(element.getTextOffset());
    }

    private static JSExpression convertToExpression(@NotNull JSNamedElement declaration) {
        if (declaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(21);
        }
        assert (declaration instanceof JSFunctionDeclaration || declaration instanceof JSClass);
        return JSChangeUtil.createExpressionPsiWithContext(declaration.getText(), (PsiElement)declaration, JSExpression.class);
    }

    private static JSReferenceExpression createReferenceTo(@NotNull JSNamedElement createdDeclaration) {
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(22);
        }
        String name = createdDeclaration.getName();
        assert (name != null);
        return JSChangeUtil.createExpressionPsiWithContext(name, (PsiElement)createdDeclaration, JSReferenceExpression.class);
    }

    @NotNull
    private static PsiElement replaceSourceElement(@NotNull PsiElement toReplace, @NotNull JSNamedElement createdDeclaration, @NotNull PsiFile createdFile, @Nullable PsiComment docComment) {
        if (toReplace == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(23);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(24);
        }
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(25);
        }
        JSSourceElement sourceElementToReplace = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class, (boolean)false);
        JSSourceElement createdSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)createdDeclaration, JSSourceElement.class, (boolean)false);
        assert (sourceElementToReplace != null && createdSourceElement != null);
        PsiElement resultDeclaration = sourceElementToReplace.replace((PsiElement)createdSourceElement);
        PsiElement jsDocTarget = resultDeclaration instanceof JSVariable ? resultDeclaration.getParent() : resultDeclaration;
        JSDocumentationUtils.moveJSDoc(docComment, jsDocTarget);
        createdDeclaration.delete();
        if (ReactClassToFunctionalComponentHandler.getFileLevelEntitiesCount(createdFile) > 0) {
            JSChangeUtil.doAddRangeAfter(resultDeclaration.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), resultDeclaration);
        }
        Object object = resultDeclaration instanceof JSVarStatement ? ((JSVarStatement)resultDeclaration).getVariables()[0] : resultDeclaration;
        if (object == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(26);
        }
        return object;
    }

    @Nullable
    private static String getFieldInitializer(@NotNull JSClass clazz, @NotNull String name) {
        JSField field;
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(27);
        }
        if (name == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(28);
        }
        if ((field = clazz.findFieldByName(name)) != null && field.getInitializer() != null) {
            return field.getInitializer().getText();
        }
        return null;
    }

    @Nullable
    private static String getPropsTypeFromClassGenericArgument(@NotNull JSClass clazz) {
        JSReferenceList extendsList;
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(29);
        }
        if ((extendsList = clazz.getExtendsList()) == null) {
            return null;
        }
        JSReferenceListMember[] extendsListMembers = extendsList.getMembers();
        if (extendsListMembers.length == 0) {
            return null;
        }
        JSTypeDeclaration[] typeArguments = extendsListMembers[0].getTypeArguments();
        if (typeArguments.length == 0) {
            return null;
        }
        return typeArguments[0].getText();
    }

    @NotNull
    private static JSParameterList createParameterList(@Nullable String propsParameterName, @Nullable String propsTypeText, @Nullable String contextParameterName, @NotNull PsiElement context) {
        if (context == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(30);
        }
        StringBuilder text = new StringBuilder("(");
        if (!StringUtil.isEmpty((String)propsParameterName)) {
            text.append(propsParameterName);
            if (!StringUtil.isEmpty((String)propsTypeText)) {
                text.append(": ").append(propsTypeText);
            }
        }
        if (!StringUtil.isEmpty((String)contextParameterName)) {
            text.append(", ").append(contextParameterName);
        }
        text.append(")");
        JSFunction function = JSChangeUtil.createStatementPsiFromTextWithContext("function dummy" + text + "{}", context, JSFunction.class);
        assert (function != null && function.getParameterList() != null);
        JSParameterList jSParameterList = function.getParameterList();
        if (jSParameterList == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(31);
        }
        return jSParameterList;
    }

    @Nullable
    private static String processRenderMethod(@Nullable JSElement toProcess, @NotNull String propsParameterName, @NotNull String contextParameterName, @NotNull Ref<Boolean> hasProps, @NotNull Ref<Boolean> hasContext) {
        if (propsParameterName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(32);
        }
        if (contextParameterName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(33);
        }
        if (hasProps == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(34);
        }
        if (hasContext == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(35);
        }
        if (toProcess == null) {
            return null;
        }
        HashMap referencesToReplace = new HashMap();
        ReactClassToFunctionalComponentHandler.processThisReferences(toProcess, (Processor<JSReferenceExpression>)((Processor)element -> {
            if (propsParameterName == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(47);
            }
            if (hasProps == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(48);
            }
            if (contextParameterName == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(49);
            }
            if (hasContext == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(50);
            }
            if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"props")) {
                referencesToReplace.put(element, propsParameterName);
                hasProps.set((Object)Boolean.TRUE);
            } else if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"context")) {
                referencesToReplace.put(element, contextParameterName);
                hasContext.set((Object)Boolean.TRUE);
            }
            return true;
        }));
        return ReactExtractComponentHandler.replaceOccurrences(toProcess, toProcess.getTextRange(), referencesToReplace.keySet(), expression -> (String)ObjectUtils.assertNotNull(referencesToReplace.get(expression)));
    }

    private static boolean referencesState(@NotNull JSElement member) {
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(36);
        }
        return !ReactClassToFunctionalComponentHandler.processThisReferences(member, (Processor<JSReferenceExpression>)((Processor)referenceExpression -> !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"state") && !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"setState")));
    }

    private static boolean processThisReferences(@NotNull JSElement member, @NotNull Processor<JSReferenceExpression> processor) {
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(38);
        }
        return PsiTreeUtil.processElements((PsiElement)member, element -> {
            JSReferenceExpression referenceExpression;
            if (processor == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(46);
            }
            return !(element instanceof JSReferenceExpression) || !((referenceExpression = (JSReferenceExpression)element).getQualifier() instanceof JSThisExpression) || processor.process((Object)referenceExpression);
        });
    }

    @NotNull
    private static String getParameterName(@NotNull JSParameterList createdFunctionParameters, int index, String defaultName) {
        String name;
        JSParameterListElement[] parameters;
        if (createdFunctionParameters == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(39);
        }
        if ((parameters = createdFunctionParameters.getParameters()).length > index && !StringUtil.isEmpty((String)(name = parameters[index].getName()))) {
            String string = name;
            if (string == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = defaultName;
        if (string == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    public static String showNameDialog(@NotNull Project project, @NotNull JSNamedElement elementForName) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(42);
        }
        if (elementForName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(43);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return DEFAULT_COMPONENT_NAME;
        }
        PsiElement scope = (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.getNameScope(elementForName), (Object)elementForName.getContainingFile());
        InputValidatorEx nameValidator = ReactExtractComponentHandler.createNameValidator(scope);
        return Messages.showInputDialog((Project)project, (String)"Component Name:", (String)REFACTORING_TITLE, (Icon)Messages.getQuestionIcon(), null, (InputValidator)nameValidator);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, String message) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(44);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(45);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_TITLE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 9: 
            case 19: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeUsages";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 12: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 13: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeclaration";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/ReactClassToFunctionalComponentHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsParameterName";
                break;
            }
            case 33: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextParameterName";
                break;
            }
            case 34: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasProps";
                break;
            }
            case 35: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasContext";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFunctionParameters";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementForName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/ReactClassToFunctionalComponentHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionAwareReplace";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSourceElement";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expressionAwareReplace";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 40: 
            case 41: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelEntitiesCount";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertToExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTo";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFieldInitializer";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromClassGenericArgument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processRenderMethod";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "referencesState";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processThisReferences";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParameterName";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showNameDialog";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processThisReferences$7";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRenderMethod$4";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

