/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateStepFixBase;
import org.jetbrains.plugins.cucumber.inspections.CucumberStepDefinitionCreationContext;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberCreateAllStepsFix
extends CucumberCreateStepFixBase {
    @NotNull
    public String getName() {
        String string = CucumberBundle.message("cucumber.create.all.steps.title", new Object[0]);
        if (string == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void createStepOrSteps(GherkinStep sourceStep, @NotNull CucumberStepDefinitionCreationContext fileAndFrameworkType) {
        PsiFile probableGherkinFile;
        if (fileAndFrameworkType == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(1);
        }
        if (!((probableGherkinFile = sourceStep.getContainingFile()) instanceof GherkinFile)) {
            return;
        }
        HashSet<String> createdStepDefPatterns = new HashSet<String>();
        GherkinFile gherkinFile = (GherkinFile)probableGherkinFile;
        for (GherkinFeature feature : gherkinFile.getFeatures()) {
            for (GherkinStepsHolder stepsHolder : feature.getScenarios()) {
                for (GherkinStep step : stepsHolder.getSteps()) {
                    PsiReference[] references;
                    for (PsiReference reference : references = step.getReferences()) {
                        AbstractStepDefinition definition;
                        if (!(reference instanceof CucumberStepReference) || (definition = ((CucumberStepReference)reference).resolveToDefinition()) != null) continue;
                        String pattern = Pattern.quote(step.getStepName());
                        pattern = StringUtil.trimEnd((String)StringUtil.trimStart((String)pattern, (String)"\\Q"), (String)"\\E");
                        if (createdStepDefPatterns.contains(pattern = CucumberUtil.prepareStepRegexp(pattern))) continue;
                        this.createFileOrStepDefinition(step, fileAndFrameworkType);
                        createdStepDefPatterns.add(pattern);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/CucumberCreateAllStepsFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAndFrameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/CucumberCreateAllStepsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStepOrSteps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

