/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.parser.BladeCompositeElement;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeDirectiveParameterPsiImpl;
import com.jetbrains.php.blade.psi.BladeDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladePhpBlockPsiImpl;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;

public class BladePsiElementCreator {
    public static PsiElement create(ASTNode node) {
        IElementType type = node.getElementType();
        if (BladeElementTypes.DIRECTIVE == type) {
            return new BladeDirectivePsiImpl(node);
        }
        if (BladeElementTypes.DIRECTIVE_PARAMETER == type) {
            return new BladeDirectiveParameterPsiImpl(node);
        }
        if (BladeElementTypes.PHP_DIRECTIVE_BLOCK == type) {
            return new BladePhpBlockPsiImpl(node);
        }
        BladeInjectionInfo info = BladeInjectionMappingService.getNonDirectiveInfo(type);
        if (info != null) {
            return new BladePsiLanguageInjectionHost(node, true);
        }
        return new BladeCompositeElement(node);
    }
}

