/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.generators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConstructorGenerator {
    public static final String PHP_CONSTRUCTOR_TEMPLATE = "PHP Constructor";
    private static final String ARRAY_HINT = "array";
    private static final String CALLABLE_HINT = "callable";
    public static final String CLASS_NAME_ATTR = "CLASS_NAME";
    public static final String PARAM_LIST_ATTR = "PARAM_LIST";
    public static final String PARAM_DOC_ATTR = "PARAM_DOC";
    public static final String THROWS_DOC_ATTR = "THROWS_DOC";
    public static final String BODY_ATTR = "BODY";
    @NotNull
    private final Collection<PhpNamedElement> myElements;
    @NotNull
    private final PhpClass myClass;

    public PhpConstructorGenerator(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(0);
        }
        this.myElements = new ArrayList<PhpNamedElement>();
        this.myClass = phpClass;
    }

    public PhpConstructorGenerator withFields(@NotNull Collection<Field> fields) {
        if (fields == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(1);
        }
        this.myElements.addAll(fields);
        return this;
    }

    public PhpConstructorGenerator withParameters(@NotNull Collection<Parameter> parameters) {
        if (parameters == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(2);
        }
        this.myElements.addAll(parameters);
        return this;
    }

    @Nullable
    public Pair<PhpDocComment, Method> createConstructor() throws PhpInvalidTemplateException {
        String constructorTemplate = PhpCodeUtil.getCodeTemplate(PHP_CONSTRUCTOR_TEMPLATE, this.getConstructorAttributes(), this.myClass.getProject());
        constructorTemplate = constructorTemplate.replaceAll("(\\s*\\n)+", "\n");
        return PhpConstructorGenerator.createConstructorFromTemplate(this.myClass.getProject(), this.myClass.isInterface(), constructorTemplate);
    }

    @NotNull
    public static Pair<PhpDocComment, Method> createConstructorFromTemplate(Project project, boolean isInterface, String constructorTemplate) throws PhpInvalidTemplateException {
        Method constructor = PhpCodeUtil.createMethodFromTemplate(project, isInterface, constructorTemplate);
        if (constructor == null) {
            throw new PhpInvalidTemplateException("Invalid template:\n" + constructorTemplate);
        }
        Pair pair = Pair.create((Object)PhpConstructorGenerator.getPhpDoc(constructor), (Object)constructor);
        if (pair == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    private static PhpDocComment getPhpDoc(@NotNull Method constructor) {
        PhpPsiElement prev;
        if (constructor == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(4);
        }
        if ((prev = constructor.getPrevPsiSibling()) instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof PhpDocComment) {
            return (PhpDocComment)prev;
        }
        return null;
    }

    private Properties getConstructorAttributes() {
        Properties attributes = new Properties();
        attributes.setProperty(CLASS_NAME_ATTR, this.myClass.getName());
        attributes.setProperty(PARAM_LIST_ATTR, this.getParameterList());
        attributes.setProperty(PARAM_DOC_ATTR, this.getParameterDoc());
        attributes.setProperty(THROWS_DOC_ATTR, "");
        attributes.setProperty(BODY_ATTR, this.getBody());
        return attributes;
    }

    private String getParameterDoc() {
        StringBuilder sb = new StringBuilder();
        for (PhpNamedElement element : this.myElements) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("* ").append("@param ");
            String typeStr = PhpDocUtil.getTypePresentation(this.myClass.getProject(), element.getType(), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)element));
            if (!typeStr.isEmpty()) {
                sb.append(typeStr).append(' ');
            }
            sb.append('$').append(element.getName());
        }
        return sb.toString();
    }

    protected String getParameterList() {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        for (PhpNamedElement element : this.myElements) {
            PsiElement defaultValue;
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            String typeHint = this.getTypeHint(element);
            if (typeHint != null && !typeHint.isEmpty()) {
                buf.append(typeHint).append(' ');
            }
            buf.append("$").append(element.getName());
            if (!(element instanceof Parameter) || (defaultValue = ((Parameter)element).getDefaultValue()) == null) continue;
            buf.append(" = ").append(defaultValue.getText());
        }
        return buf.toString();
    }

    private String getBody() {
        StringBuilder fieldAssignments = new StringBuilder();
        StringBuilder parentCallList = new StringBuilder();
        for (PhpNamedElement element : this.myElements) {
            if (element instanceof Field) {
                String fieldName = element.getName();
                fieldAssignments.append("$this->").append(fieldName);
                fieldAssignments.append("=").append('$').append(fieldName);
                fieldAssignments.append(";\n");
                continue;
            }
            if (!(element instanceof Parameter)) continue;
            if (parentCallList.length() > 0) {
                parentCallList.append(',');
            }
            parentCallList.append('$').append(element.getName());
        }
        StringBuilder result = new StringBuilder();
        if (parentCallList.length() > 0) {
            result.append("parent::__construct(").append((CharSequence)parentCallList).append(");");
            if (fieldAssignments.length() > 0) {
                result.append('\n');
            }
        }
        if (fieldAssignments.length() > 0) {
            result.append((CharSequence)fieldAssignments);
        }
        return result.toString().trim();
    }

    @Nullable
    private String getTypeHint(@NotNull PhpNamedElement element) {
        PhpType filteredNullType;
        if (element == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(5);
        }
        PhpType filedType = element.getType().global(this.myClass.getProject());
        Set typeStrings = filedType.getTypes();
        String typeString = null;
        if (typeStrings.size() == 1) {
            typeString = this.convertTypeToString(element, typeStrings);
        }
        if (typeStrings.size() == 2 && (filteredNullType = PhpConstructorGenerator.filterNullCaseInsensitive(filedType)).getTypes().size() == 1) {
            typeString = PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.NULLABLES) ? "?" + this.convertTypeToString(element, filteredNullType.getTypes()) : this.convertTypeToString(element, filteredNullType.getTypes());
        }
        return typeString;
    }

    private static PhpType filterNullCaseInsensitive(PhpType filedType) {
        if (filedType.getTypes().isEmpty()) {
            return PhpType.EMPTY;
        }
        PhpType phpType = new PhpType();
        for (String type : filedType.getTypes()) {
            if (type.equalsIgnoreCase("\\null")) continue;
            phpType.add(type);
        }
        return phpType;
    }

    @Nullable
    private String convertTypeToString(@NotNull PhpNamedElement element, Set<String> typeStrings) {
        if (element == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(6);
        }
        String simpleType = typeStrings.iterator().next();
        if (!PhpType.isPrimitiveType((String)(simpleType = StringUtil.trimStart((String)simpleType, (String)"\\"))) || PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || ARRAY_HINT.equalsIgnoreCase(simpleType) || CALLABLE_HINT.equalsIgnoreCase(simpleType)) {
            String typeString;
            String string = typeString = simpleType.endsWith("]") ? ARRAY_HINT : this.getFieldTypeString(element, PhpConstructorGenerator.filterNullCaseInsensitive(element.getType()));
            if (!typeString.isEmpty()) {
                return typeString;
            }
        }
        return null;
    }

    private String getFieldTypeString(PhpNamedElement element, @NotNull PhpType type) {
        if (type == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(7);
        }
        return PhpDocUtil.getTypePresentation(this.myClass.getProject(), type, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/generators/PhpConstructorGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/generators/PhpConstructorGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorFromTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withFields";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPhpDoc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertTypeToString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFieldTypeString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

