/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfo;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUnitCoversIndex;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.testFramework.PhpSuffixBasedTestDescriptor;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import com.jetbrains.php.testFramework.PhpUnit6TestCreateInfo;
import com.jetbrains.php.testFramework.PhpUnitTestCreateInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitTestDescriptor
extends PhpSuffixBasedTestDescriptor {
    public static final PhpUnitTestDescriptor INSTANCE = new PhpUnitTestDescriptor();
    public static final List<String> SUFFIXES = ContainerUtil.newSmartList((Object)"Test");
    private static final List<PhpTestCreateInfo> TEST_CREATE_INFOS = ContainerUtil.newSmartList((Object[])new PhpTestCreateInfo[]{PhpUnitTestCreateInfo.INSTANCE, PhpUnit6TestCreateInfo.INSTANCE});
    private static final String TEST_METHOD_NAME_PREFIX = "test";

    @Override
    @NotNull
    protected Collection<String> getNameSuffixes() {
        List<String> list = SUFFIXES;
        if (list == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PhpTestCreateInfo> getTestCreateInfos() {
        List<PhpTestCreateInfo> list = TEST_CREATE_INFOS;
        if (list == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PhpClass> findTests(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(2);
        }
        Project project = clazz.getProject();
        HashSet result = ContainerUtil.newHashSet(super.findTests(clazz));
        result.addAll(PhpIndex.getInstance((Project)project).getCoveringTestClasses(project, clazz.getFQN()));
        HashSet hashSet = result;
        if (hashSet == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getCoveredClassesFQN(@NotNull PhpClass testClass) {
        if (testClass == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(4);
        }
        String defaultCoveredClassName = PhpUnitUtil.getDefaultCoveredClassName(testClass);
        Set result = StreamEx.of(PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)testClass, null)).map(PhpPathInfo::getClassFQN).toSet();
        PhpClassHierarchyUtils.processMethods((PhpClass)testClass, (PhpClass)testClass, (method, subClass, baseClass) -> {
            if (!(method instanceof PhpDocMethod)) {
                PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)method, defaultCoveredClassName).forEach(path -> result.add(path.getClassFQN()));
            }
            return true;
        }, (boolean)true);
        Set set = result;
        if (set == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<PhpClass> findClasses(@NotNull PhpClass test, @NotNull String testName) {
        if (test == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(6);
        }
        if (testName == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(7);
        }
        PhpIndex index = PhpIndex.getInstance((Project)test.getProject());
        Set coveredClasses = (Set)StreamEx.of(PhpUnitTestDescriptor.getCoveredClassesFQN(test)).toFlatCollection(arg_0 -> ((PhpIndex)index).getClassesByFQN(arg_0), ContainerUtil::newHashSet);
        HashSet result = ContainerUtil.newHashSet(super.findClasses(test, testName));
        result.addAll(coveredClasses);
        HashSet hashSet = result;
        if (hashSet == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<Method> findTests(@NotNull Method method) {
        if (method == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(9);
        }
        HashSet result = ContainerUtil.newHashSet();
        Project project = method.getProject();
        result.addAll(PhpIndex.getInstance((Project)project).getCoveringTestMethods(project, method));
        this.addTestMethodsByName(method, result);
        HashSet hashSet = result;
        if (hashSet == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    public void addTestMethodsByName(@NotNull Method method, @NotNull Collection<Method> result) {
        PhpClass containingClass;
        if (method == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(11);
        }
        if (result == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(12);
        }
        if ((containingClass = method.getContainingClass()) != null) {
            String testMethodName = TEST_METHOD_NAME_PREFIX + StringUtil.capitalize((String)method.getName());
            for (PhpClass testClass : this.findTests(containingClass)) {
                ContainerUtil.addIfNotNull(result, (Object)testClass.findOwnMethodByName((CharSequence)testMethodName));
            }
        }
    }

    @Override
    @NotNull
    public Collection<Method> findMethods(@NotNull Method testMethod) {
        if (testMethod == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(13);
        }
        HashSet result = ContainerUtil.newHashSet();
        PhpIndex index = PhpIndex.getInstance((Project)testMethod.getProject());
        PhpClass testClass = testMethod.getContainingClass();
        for (PhpPathInfo path : PhpUnitCoversIndex.getCoveredPaths((PhpNamedElement)testMethod, PhpUnitUtil.getDefaultCoveredClassName(testClass))) {
            for (PhpClass clazz : index.getClassesByFQN(path.getClassFQN())) {
                if (!path.getAccess().isEmpty()) {
                    PhpUnitTestDescriptor.addMethodsByAccess(result, path, clazz);
                    continue;
                }
                if (StringUtil.isNotEmpty((String)path.getMethodName())) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)clazz.findOwnMethodByName((CharSequence)path.getMethodName()));
                    continue;
                }
                ContainerUtil.addAll((Collection)result, (Object[])clazz.getOwnMethods());
            }
        }
        this.addMethodsByName(testMethod, testClass, result);
        HashSet hashSet = result;
        if (hashSet == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private void addMethodsByName(@NotNull Method testMethod, @Nullable PhpClass testClass, @NotNull Collection<Method> result) {
        String testMethodName;
        if (testMethod == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(15);
        }
        if (result == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(16);
        }
        if (testClass != null && StringUtil.startsWith((CharSequence)(testMethodName = testMethod.getName()), (CharSequence)TEST_METHOD_NAME_PREFIX)) {
            String targetMethodName = StringUtil.decapitalize((String)testMethodName.substring(4));
            for (PhpClass targetClass : this.findClasses(testClass, testClass.getName())) {
                ContainerUtil.addIfNotNull(result, (Object)targetClass.findOwnMethodByName((CharSequence)targetMethodName));
            }
        }
    }

    private static void addMethodsByAccess(@NotNull Set<Method> result, @NotNull PhpPathInfo path, @NotNull PhpClass clazz) {
        if (result == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(17);
        }
        if (path == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(18);
        }
        if (clazz == null) {
            PhpUnitTestDescriptor.$$$reportNull$$$0(19);
        }
        PhpClassHierarchyUtils.processMethods((PhpClass)clazz, (PhpClass)clazz, (method, subClass, baseClass) -> {
            if (path == null) {
                PhpUnitTestDescriptor.$$$reportNull$$$0(20);
            }
            if (result == null) {
                PhpUnitTestDescriptor.$$$reportNull$$$0(21);
            }
            if (!(method instanceof PhpDocMethod)) {
                boolean accessMatches = StringUtil.equals((CharSequence)method.getAccess().toString(), (CharSequence)path.getAccess());
                if (path.isInverseAccess() && !accessMatches || !path.isInverseAccess() && accessMatches) {
                    result.add(method);
                }
            }
            return true;
        }, (boolean)true);
    }

    @Nullable
    public static String getTargetClassName(@Nullable PhpClass testClass) {
        if (testClass == null) {
            return null;
        }
        String testName = testClass.getName();
        if (testName.length() <= 4) {
            return null;
        }
        return StringUtil.trimEnd((String)testName, (String)"Test");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitTestDescriptor";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEST_METHOD_NAME_PREFIX;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSuffixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCreateInfos";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestDescriptor";
                break;
            }
            case 3: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findTests";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredClassesFQN";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTests";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredClassesFQN";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTestMethodsByName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMethods";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addMethodsByName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMethodsByAccess";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMethodsByAccess$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

