/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssReplaceWithShorthandUnsafelyInspection
extends CssBaseInspection {
    private static final Map<String, Class<? extends ShorthandRule>> NAME_TO_CLASS = new HashMap<String, Class<? extends ShorthandRule>>();

    private static void register(@NotNull Class<? extends ShorthandRule> ruleClass, String ... properties) {
        if (ruleClass == null) {
            CssReplaceWithShorthandUnsafelyInspection.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            CssReplaceWithShorthandUnsafelyInspection.$$$reportNull$$$0(1);
        }
        for (String propertyName : properties) {
            NAME_TO_CLASS.put(propertyName, ruleClass);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.replace.with.shorthand.unsafely", (Object[])new Object[0]);
        if (string == null) {
            CssReplaceWithShorthandUnsafelyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.DO_NOT_SHOW;
        if (highlightDisplayLevel == null) {
            CssReplaceWithShorthandUnsafelyInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    protected boolean handleFullLonghandSet() {
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssReplaceWithShorthandUnsafelyInspection.$$$reportNull$$$0(4);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssBlock(CssBlock block) {
                super.visitCssBlock(block);
                ShorthandRuleContainer container = new ShorthandRuleContainer(CssReplaceWithShorthandUnsafelyInspection.this.handleFullLonghandSet());
                for (CssDeclaration decl : block.getDeclarations()) {
                    ShorthandRule rule;
                    if (decl.isHack() || (rule = container.getOrCreateRule(decl)) == null) continue;
                    rule.addDeclaration(decl);
                }
                for (ShorthandRule rule : container.getRules()) {
                    if (!rule.isValid()) continue;
                    rule.registerProblem(holder);
                }
            }
        };
        if (cssElementVisitor == null) {
            CssReplaceWithShorthandUnsafelyInspection.$$$reportNull$$$0(5);
        }
        return cssElementVisitor;
    }

    static {
        CssReplaceWithShorthandUnsafelyInspection.register(BackgroundRule.class, "background", "background-color", "background-image", "background-repeat", "background-attachment", "background-position");
        CssReplaceWithShorthandUnsafelyInspection.register(ListStyleRule.class, "list-style", "list-style-type", "list-style-position", "list-style-image");
        CssReplaceWithShorthandUnsafelyInspection.register(CueRule.class, "cue", "cue-before", "cue-after");
        CssReplaceWithShorthandUnsafelyInspection.register(OutlineRule.class, "outline", "outline-color", "outline-style", "outline-width");
        CssReplaceWithShorthandUnsafelyInspection.register(MarginRule.class, "margin", "margin-left", "margin-right", "margin-top", "margin-bottom");
        CssReplaceWithShorthandUnsafelyInspection.register(PaddingRule.class, "padding", "padding-left", "padding-right", "padding-top", "padding-bottom");
        CssReplaceWithShorthandUnsafelyInspection.register(BorderRule.class, "border", "border-width", "border-color", "border-style", "border-left", "border-right", "border-top", "border-bottom", "border-top-color", "border-top-style", "border-top-width", "border-right-color", "border-right-style", "border-right-width", "border-bottom-color", "border-bottom-style", "border-bottom-width", "border-left-color", "border-left-style", "border-left-width");
        CssReplaceWithShorthandUnsafelyInspection.register(BorderRadiusRule.class, "border-radius", "border-bottom-left-radius", "border-top-left-radius", "border-bottom-right-radius", "border-top-right-radius");
        CssReplaceWithShorthandUnsafelyInspection.register(MozillaBorderRadiusRule.class, "-moz-border-radius", "-moz-border-radius-bottomleft", "-moz-border-radius-topleft", "-moz-border-radius-bottomright", "-moz-border-radius-topright");
        CssReplaceWithShorthandUnsafelyInspection.register(SafariBorderRadiusRule.class, "-webkit-border-radius", "-webkit-border-bottom-left-radius", "-webkit-border-top-left-radius", "-webkit-border-bottom-right-radius", "-webkit-border-top-right-radius");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SafariBorderRadiusRule
    extends BorderRadiusRule {
        private static final String prefix = "-webkit-";

        SafariBorderRadiusRule() {
            super(prefix);
        }
    }

    private static class MozillaBorderRadiusRule
    extends BorderRadiusRule {
        private static final String prefix = "-moz-";

        MozillaBorderRadiusRule() {
            super(prefix);
        }

        @Override
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                MozillaBorderRadiusRule.$$$reportNull$$$0(0);
            }
            if (suffix == null) {
                MozillaBorderRadiusRule.$$$reportNull$$$0(1);
            }
            return (String)this.myPropertiesMap.get(this.myPrefix + "border-" + suffix + '-' + side.replace("-", ""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "side";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suffix";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$MozillaBorderRadiusRule";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BorderRadiusRule
    extends CornerRule {
        protected BorderRadiusRule(@NonNls String prefix) {
            super(prefix, "border-radius");
        }

        BorderRadiusRule() {
            this("");
        }

        @Override
        @NotNull
        protected Map<String, String> optimizeBorder() {
            String[] radius = new String[4];
            boolean fullRadius = this.fill("radius", radius);
            String border = null;
            if (fullRadius) {
                border = BorderRadiusRule.commonValue(radius);
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            boolean allDefined = true;
            for (int i = 0; i < 4; ++i) {
                if (radius[i] != null) continue;
                allDefined = false;
            }
            if (allDefined) {
                StringBuilder argument = new StringBuilder(radius[0]);
                boolean hasDifferent = false;
                for (int i = 1; i < 4; ++i) {
                    argument.append(" ").append(radius[i]);
                    if (radius[0].equals(radius[i])) continue;
                    hasDifferent = true;
                }
                BorderRadiusRule.createValue(result, this.myPrefix + "border-radius", hasDifferent ? argument.toString() : border, null);
                LinkedHashMap<String, String> linkedHashMap = result;
                if (linkedHashMap == null) {
                    BorderRadiusRule.$$$reportNull$$$0(0);
                }
                return linkedHashMap;
            }
            BorderRadiusRule.createValue(result, this.myPrefix + "border-radius", border, null);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-top-left-radius", radius[0], border);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-top-right-radius", radius[1], border);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-bottom-right-radius", radius[2], border);
            BorderRadiusRule.createValue(result, this.myPrefix + "border-bottom-left-radius", radius[3], border);
            LinkedHashMap<String, String> linkedHashMap = result;
            if (linkedHashMap == null) {
                BorderRadiusRule.$$$reportNull$$$0(1);
            }
            return linkedHashMap;
        }

        @Nullable
        private static String commonValue(@NotNull String[] values) {
            if (values == null) {
                BorderRadiusRule.$$$reportNull$$$0(2);
            }
            for (int i = 0; i < 4; ++i) {
                int equals = 0;
                for (int j = 0; j < 4; ++j) {
                    if (!values[i].equals(values[j])) continue;
                    ++equals;
                }
                if (equals <= true) continue;
                return values[i];
            }
            return null;
        }

        private static void createValue(Map<String, String> map, @NonNls String key, String value, @Nullable String defaultValue) {
            if (value != null && !value.equals(defaultValue)) {
                map.put(key, value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$BorderRadiusRule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "optimizeBorder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$BorderRadiusRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "commonValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CornerRule
    extends BorderRule {
        @NonNls
        protected final String myPrefix;
        @NonNls
        protected final String myMainPropertyName;

        protected CornerRule(@NonNls String prefix, @NonNls String propertyName) {
            super(prefix + propertyName);
            this.myPrefix = prefix;
            this.myMainPropertyName = propertyName;
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.myPropertiesMap.size() == 4;
        }

        @Override
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                CornerRule.$$$reportNull$$$0(0);
            }
            if (suffix == null) {
                CornerRule.$$$reportNull$$$0(1);
            }
            return (String)this.myPropertiesMap.get(this.myPrefix + "border-" + side + "-" + suffix);
        }

        @Override
        @NonNls
        protected String[] getDefinedValues(@NotNull @NonNls String suffix) {
            String[] sides;
            if (suffix == null) {
                CornerRule.$$$reportNull$$$0(2);
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String side : sides = new String[]{"top-left", "top-right", "bottom-right", "bottom-left"}) {
                if (null == this.get(side, suffix)) continue;
                result.add(side);
            }
            return ArrayUtil.toStringArray(result);
        }

        @Override
        protected boolean fill(@NotNull @NonNls String suffix, @NotNull String[] values) {
            String[] sideValues;
            if (suffix == null) {
                CornerRule.$$$reportNull$$$0(3);
            }
            if (values == null) {
                CornerRule.$$$reportNull$$$0(4);
            }
            for (String side : sideValues = this.getDefinedValues(suffix)) {
                if ("top-left".equals(side)) {
                    values[0] = this.get(side, suffix);
                    continue;
                }
                if ("top-right".equals(side)) {
                    values[1] = this.get(side, suffix);
                    continue;
                }
                if ("bottom-right".equals(side)) {
                    values[2] = this.get(side, suffix);
                    continue;
                }
                if (!"bottom-left".equals(side)) continue;
                values[3] = this.get(side, suffix);
            }
            return sideValues.length == 4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$CornerRule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDefinedValues";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fill";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BorderRule
    extends BackgroundRule {
        protected Map<String, String> myOptimizedBorder;

        BorderRule() {
            super("border");
        }

        protected BorderRule(@NonNls String s) {
            super(s);
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand();
        }

        @Override
        public boolean isValid() {
            List<CssDeclaration> properties = this.getProperties();
            if (properties.size() < 2) {
                return false;
            }
            if (!this.fillPropertiesMap()) {
                return false;
            }
            if (this.isFullLonghandSet() != this.isHandleFullLonghandSet()) {
                return false;
            }
            this.myOptimizedBorder = this.optimizeBorder();
            return !this.myOptimizedBorder.isEmpty() && this.myOptimizedBorder.size() < properties.size();
        }

        @NotNull
        protected Map<String, String> optimizeBorder() {
            boolean moreThanOneFilledValues;
            String[] width = new String[4];
            String[] color = new String[4];
            String[] style = new String[4];
            boolean fullWidth = this.fill("width", width);
            boolean fullColor = this.fill("color", color);
            boolean fullStyle = this.fill("style", style);
            String[] border = new String[3];
            boolean bl = moreThanOneFilledValues = fullColor && fullWidth && fullStyle || !(fullColor ^ fullWidth ^ fullStyle);
            if (fullWidth) {
                Pair<String, String[]> widthPair = BorderRule.common(width);
                if (moreThanOneFilledValues || BorderRule.isNullArray((String[])widthPair.second)) {
                    border[0] = (String)widthPair.first;
                    String[] stringArray = width = border[0] == null ? width : (String[])widthPair.second;
                }
            }
            if (fullStyle) {
                Pair<String, String[]> stylePair = BorderRule.common(style);
                if (moreThanOneFilledValues || BorderRule.isNullArray((String[])stylePair.second)) {
                    border[1] = (String)stylePair.first;
                    String[] stringArray = style = border[1] == null ? style : (String[])stylePair.second;
                }
            }
            if (fullColor) {
                Pair<String, String[]> colorPair = BorderRule.common(color);
                if (moreThanOneFilledValues || BorderRule.isNullArray((String[])colorPair.second)) {
                    border[2] = (String)colorPair.first;
                    color = border[2] == null ? color : (String[])colorPair.second;
                }
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.createValue("border", result, border[0], border[1], border[2]);
            this.createValue("border-top", result, width[0], style[0], color[0]);
            this.createValue("border-right", result, width[1], style[1], color[1]);
            this.createValue("border-bottom", result, width[2], style[2], color[2]);
            this.createValue("border-left", result, width[3], style[3], color[3]);
            LinkedHashMap<String, String> linkedHashMap = result;
            if (linkedHashMap == null) {
                BorderRule.$$$reportNull$$$0(0);
            }
            return linkedHashMap;
        }

        private static boolean isNullArray(String[] array) {
            for (String s : array) {
                if (s == null) continue;
                return false;
            }
            return true;
        }

        private void createValue(@NotNull @NonNls String prefix, @NotNull Map<String, String> result, @Nullable String width, @Nullable String style, @Nullable String color) {
            if (prefix == null) {
                BorderRule.$$$reportNull$$$0(1);
            }
            if (result == null) {
                BorderRule.$$$reportNull$$$0(2);
            }
            String importantSuffix = this.myImportant ? " !important" : "";
            StringBuilder sb = new StringBuilder();
            if (width != null) {
                if (style == null && color == null) {
                    result.put(prefix + "-width", width + importantSuffix);
                    return;
                }
                sb.append(width);
            }
            if (style != null) {
                if (width == null && color == null) {
                    result.put(prefix + "-style", style + importantSuffix);
                    return;
                }
                sb.append(' ').append(style);
            }
            if (color != null) {
                if (width == null && style == null) {
                    result.put(prefix + "-color", color + importantSuffix);
                    return;
                }
                sb.append(' ').append(color);
            }
            if (sb.length() > 0) {
                result.put(prefix, sb.append(importantSuffix).toString().trim());
            }
        }

        @NotNull
        protected static Pair<String, String[]> common(@NotNull String[] values) {
            if (values == null) {
                BorderRule.$$$reportNull$$$0(3);
            }
            String[] result = null;
            int max_count = 0;
            String result_value = null;
            for (int i = 0; i < 4; ++i) {
                String v = values[i];
                int count = 4;
                String[] temp = new String[4];
                for (int k = 0; k < 4; ++k) {
                    if (values[k].equals(v)) continue;
                    temp[k] = values[k];
                    --count;
                }
                if (max_count >= count) continue;
                result = temp;
                max_count = count;
                result_value = v;
                if (max_count > 1) break;
            }
            Pair pair = Pair.create(result_value, result);
            if (pair == null) {
                BorderRule.$$$reportNull$$$0(4);
            }
            return pair;
        }

        protected boolean fill(@NotNull @NonNls String suffix, @NotNull String[] values) {
            String[] sideValues;
            if (suffix == null) {
                BorderRule.$$$reportNull$$$0(5);
            }
            if (values == null) {
                BorderRule.$$$reportNull$$$0(6);
            }
            for (String side : sideValues = this.getDefinedValues(suffix)) {
                if ("top".equals(side)) {
                    values[0] = this.get(side, suffix);
                    continue;
                }
                if ("right".equals(side)) {
                    values[1] = this.get(side, suffix);
                    continue;
                }
                if ("bottom".equals(side)) {
                    values[2] = this.get(side, suffix);
                    continue;
                }
                if (!"left".equals(side)) continue;
                values[3] = this.get(side, suffix);
            }
            return sideValues.length == 4;
        }

        @Nullable
        @NonNls
        protected String get(@NotNull @NonNls String side, @NotNull @NonNls String suffix) {
            if (side == null) {
                BorderRule.$$$reportNull$$$0(7);
            }
            if (suffix == null) {
                BorderRule.$$$reportNull$$$0(8);
            }
            return (String)this.myPropertiesMap.get("border-" + side + "-" + suffix);
        }

        protected String[] getDefinedValues(@NotNull @NonNls String suffix) {
            if (suffix == null) {
                BorderRule.$$$reportNull$$$0(9);
            }
            ArrayList<String> result = new ArrayList<String>();
            String[] sides = new String[]{"top", "right", "bottom", "left"};
            for (int i = 0; i < sides.length; ++i) {
                String side = sides[i];
                if (null == this.get(side, suffix)) continue;
                result.add(side);
            }
            return ArrayUtil.toStringArray(result);
        }

        @Override
        protected void doApplyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                BorderRule.$$$reportNull$$$0(10);
            }
            if (descriptor == null) {
                BorderRule.$$$reportNull$$$0(11);
            }
            try {
                CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssBlock.class);
                if (block == null) {
                    return;
                }
                List<CssDeclaration> properties = this.calcMyProperties(block);
                if (properties.isEmpty()) {
                    return;
                }
                CssDeclaration anchor = properties.get(properties.size() - 1);
                Set<String> names = this.myOptimizedBorder.keySet();
                ArrayList<String> reversed = new ArrayList<String>(names);
                Collections.reverse(reversed);
                for (String name : reversed) {
                    block.addDeclaration(name, this.myOptimizedBorder.get(name), anchor);
                }
                for (CssDeclaration property : properties) {
                    block.removeDeclaration(property);
                }
            }
            catch (IncorrectOperationException e) {
                CssBaseInspection.LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$BorderRule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 5: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "optimizeBorder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$BorderRule";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "common";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "common";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fill";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefinedValues";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PaddingRule
    extends MarginRule {
        PaddingRule() {
            super("padding");
        }

        @Override
        @NonNls
        @NotNull
        protected String getPrefix() {
            if ("padding-" == null) {
                PaddingRule.$$$reportNull$$$0(0);
            }
            return "padding-";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$PaddingRule", "getPrefix"));
        }
    }

    private static class MarginRule
    extends BackgroundRule {
        MarginRule() {
            super("margin");
        }

        protected MarginRule(@NotNull @NonNls String shorthandName) {
            if (shorthandName == null) {
                MarginRule.$$$reportNull$$$0(0);
            }
            super(shorthandName);
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand() || this.myPropertiesMap.size() == 4;
        }

        @Override
        public boolean isValid() {
            if (this.getProperties().size() < 2) {
                return false;
            }
            if (!this.fillPropertiesMap()) {
                return false;
            }
            if (this.isFullLonghandSet() != this.isHandleFullLonghandSet()) {
                return false;
            }
            return this.myPropertiesMap.size() >= 4;
        }

        @NonNls
        @NotNull
        private String get(@NotNull @NonNls String prefix) {
            if (prefix == null) {
                MarginRule.$$$reportNull$$$0(1);
            }
            String string = (String)this.myPropertiesMap.get(this.getPrefix() + prefix);
            if (string == null) {
                MarginRule.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NonNls
        @NotNull
        protected String getPrefix() {
            if ("margin-" == null) {
                MarginRule.$$$reportNull$$$0(3);
            }
            return "margin-";
        }

        @Override
        protected void doApplyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MarginRule.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                MarginRule.$$$reportNull$$$0(5);
            }
            try {
                CssBlock block;
                String top = this.get("top");
                String right = this.get("right");
                String bottom = this.get("bottom");
                String left = this.get("left");
                StringBuilder sb = new StringBuilder();
                if (top.equals(bottom) && left.equals(right)) {
                    if (top.equals(right)) {
                        sb.append(top);
                    } else {
                        sb.append(top).append(' ').append(right);
                    }
                } else if (left.equals(right)) {
                    sb.append(top).append(' ').append(right).append(' ').append(bottom);
                } else {
                    sb.append(top).append(' ').append(right).append(' ').append(bottom).append(' ').append(left);
                }
                if (this.myImportant) {
                    sb.append(" !important");
                }
                if ((block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssBlock.class)) == null) {
                    return;
                }
                List<CssDeclaration> properties = this.calcMyProperties(block);
                if (properties.isEmpty()) {
                    return;
                }
                CssDeclaration anchor = properties.get(properties.size() - 1);
                block.addDeclaration(this.getShorthandName(), sb.toString().trim(), anchor);
                for (CssDeclaration property : properties) {
                    block.removeDeclaration(property);
                }
            }
            catch (IncorrectOperationException e) {
                CssBaseInspection.LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shorthandName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$MarginRule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$MarginRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OutlineRule
    extends BackgroundRule {
        OutlineRule() {
            super("outline");
        }

        @Override
        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"outline-color", "outline-style", "outline-width"};
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand() || this.myPropertiesMap.size() == this.getShorthandProperties().length;
        }
    }

    private static class CueRule
    extends BackgroundRule {
        CueRule() {
            super("cue");
        }

        @Override
        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"cue-before", "cue-after"};
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand() || this.myPropertiesMap.size() == this.getShorthandProperties().length;
        }
    }

    private static class ListStyleRule
    extends BackgroundRule {
        ListStyleRule() {
            super("list-style");
        }

        @Override
        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"list-style-type", "list-style-position", "list-style-image"};
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand() || this.myPropertiesMap.size() == this.getShorthandProperties().length;
        }
    }

    private static class BackgroundRule
    extends ShorthandRule {
        protected final Map<String, String> myPropertiesMap;
        protected boolean myImportant;

        BackgroundRule() {
            super("background");
            this.myPropertiesMap = new HashMap<String, String>();
        }

        protected BackgroundRule(@NotNull @NonNls String shorthandName) {
            if (shorthandName == null) {
                BackgroundRule.$$$reportNull$$$0(0);
            }
            super(shorthandName);
            this.myPropertiesMap = new HashMap<String, String>();
        }

        @NonNls
        protected String[] getShorthandProperties() {
            return new String[]{"background-color", "background-image", "background-repeat", "background-attachment", "background-position"};
        }

        @Override
        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand();
        }

        @Override
        public boolean isValid() {
            List<CssDeclaration> properties = this.getProperties();
            if (properties.size() < 2) {
                return false;
            }
            if (!this.fillPropertiesMap()) {
                return false;
            }
            if (this.isFullLonghandSet() != this.isHandleFullLonghandSet()) {
                return false;
            }
            int inheritCount = 0;
            for (String value : this.myPropertiesMap.values()) {
                if (!"inherit".equals(value)) continue;
                ++inheritCount;
            }
            return !properties.isEmpty() && properties.size() > inheritCount + 1;
        }

        protected boolean fillPropertiesMap() {
            ArrayList<String> importantProperties = new ArrayList<String>();
            HashSet seenDeclarationNames = Sets.newHashSet();
            for (CssDeclaration property : this.getProperties()) {
                String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)property);
                if (seenDeclarationNames.contains(propertyName)) {
                    return false;
                }
                seenDeclarationNames.add(propertyName);
                if (property.isShorthandProperty()) {
                    String[] names;
                    for (String name : names = property.expandShorthandProperty()) {
                        String[] values = property.getShorthandValue(name);
                        if (values == null) continue;
                        if (values.length == 1) {
                            if (!property.isImportant() && importantProperties.contains(name)) continue;
                            this.myPropertiesMap.put(name, values[0]);
                            if (!property.isImportant()) continue;
                            importantProperties.add(name);
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (String value : values) {
                            if ("inherit".equals(value.toLowerCase())) continue;
                            sb.append(value).append(' ');
                        }
                        if (!property.isImportant() && importantProperties.contains(name)) continue;
                        this.myPropertiesMap.put(name, sb.toString().trim());
                        if (!property.isImportant()) continue;
                        importantProperties.add(name);
                    }
                    continue;
                }
                CssTermList propertyValue = property.getValue();
                if (propertyValue == null) {
                    return false;
                }
                if (!property.isImportant() && importantProperties.contains(propertyName)) continue;
                this.myPropertiesMap.put(propertyName, propertyValue.getText());
                if (!property.isImportant()) continue;
                importantProperties.add(propertyName);
            }
            if (importantProperties.isEmpty()) {
                this.myImportant = false;
                return true;
            }
            if (importantProperties.size() == this.myPropertiesMap.size()) {
                this.myImportant = true;
                return true;
            }
            return false;
        }

        @Override
        protected void doApplyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                BackgroundRule.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                BackgroundRule.$$$reportNull$$$0(2);
            }
            try {
                CssBlock block;
                HashMap<String, String> inherits = new HashMap<String, String>();
                StringBuilder sb = new StringBuilder();
                for (String name : this.getShorthandProperties()) {
                    String value = this.myPropertiesMap.get(name);
                    if (value == null) continue;
                    if ("inherit".equals(value.toLowerCase())) {
                        inherits.put(name, value);
                        continue;
                    }
                    sb.append(value).append(' ');
                }
                if (this.myImportant) {
                    sb.append("!important");
                }
                if ((block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssBlock.class)) == null) {
                    return;
                }
                List<CssDeclaration> properties = this.calcMyProperties(block);
                if (properties.isEmpty()) {
                    return;
                }
                CssDeclaration anchor = properties.get(properties.size() - 1);
                for (String inheritedProperty : inherits.keySet()) {
                    block.addDeclaration(inheritedProperty, (String)inherits.get(inheritedProperty), anchor);
                }
                block.addDeclaration(this.getShorthandName(), sb.toString().trim(), anchor);
                for (CssDeclaration property : properties) {
                    block.removeDeclaration(property);
                }
            }
            catch (IncorrectOperationException e) {
                CssBaseInspection.LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shorthandName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$BackgroundRule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApplyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ShorthandRule
    implements LocalQuickFix {
        private final List<CssDeclaration> myDeclarations;
        private final String myShorthandName;
        private boolean myHandleFullLonghandSet;

        protected ShorthandRule(@NotNull @NonNls String shorthandName) {
            if (shorthandName == null) {
                ShorthandRule.$$$reportNull$$$0(0);
            }
            this.myDeclarations = new ArrayList<CssDeclaration>();
            this.myShorthandName = shorthandName;
        }

        public void setHandleFullLonghandSet(boolean handleFullLonghandSet) {
            this.myHandleFullLonghandSet = handleFullLonghandSet;
        }

        public boolean isHandleFullLonghandSet() {
            return this.myHandleFullLonghandSet;
        }

        protected boolean isFullLonghandSet() {
            return this.alreadyContainsShorthand();
        }

        protected boolean alreadyContainsShorthand() {
            for (CssDeclaration property : this.getProperties()) {
                if (!CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)property).equals(this.getShorthandName())) continue;
                return true;
            }
            return false;
        }

        public String getShorthandName() {
            return this.myShorthandName;
        }

        public void addDeclaration(@NotNull CssDeclaration declaration) {
            if (declaration == null) {
                ShorthandRule.$$$reportNull$$$0(1);
            }
            this.myDeclarations.add(declaration);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                ShorthandRule.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myHandleFullLonghandSet ? CssBundle.message((String)"css.inspections.quick.fix.replace.with.shorthand.safely", (Object[])new Object[]{this.myShorthandName}) : CssBundle.message((String)"css.inspections.quick.fix.replace.with.shorthand.unsafely", (Object[])new Object[]{this.myShorthandName});
            if (string == null) {
                ShorthandRule.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected List<CssDeclaration> getProperties() {
            return this.myDeclarations;
        }

        protected List<CssDeclaration> calcMyProperties(@NotNull CssBlock block) {
            if (block == null) {
                ShorthandRule.$$$reportNull$$$0(4);
            }
            ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>();
            ShorthandRuleContainer container = new ShorthandRuleContainer(this.myHandleFullLonghandSet);
            for (CssDeclaration decl : block.getDeclarations()) {
                ShorthandRule rule;
                if (decl.isHack() || (rule = container.getOrCreateRule(decl)) == null || rule.getClass() != this.getClass()) continue;
                result.add(decl);
            }
            return result;
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ShorthandRule.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                ShorthandRule.$$$reportNull$$$0(6);
            }
            this.doApplyFix(project, descriptor);
        }

        protected abstract void doApplyFix(@NotNull Project var1, @NotNull ProblemDescriptor var2);

        public abstract boolean isValid();

        public void registerProblem(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                ShorthandRule.$$$reportNull$$$0(7);
            }
            for (CssDeclaration decl : this.getProperties()) {
                String message = this.isHandleFullLonghandSet() ? CssBundle.message((String)"css.inspections.replace.with.shorthand.0.safely", (Object[])new Object[]{this.myShorthandName}) : CssBundle.message((String)"css.inspections.replace.with.shorthand.0.unsafely", (Object[])new Object[]{this.myShorthandName});
                holder.registerProblem((PsiElement)decl, message, new LocalQuickFix[]{this});
            }
            this.getProperties().clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shorthandName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$ShorthandRule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$ShorthandRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addDeclaration";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcMyProperties";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ShorthandRuleContainer {
        private final boolean myHandleFullLonghandSet;
        private final Map<Class<? extends ShorthandRule>, ShorthandRule> myClass2Rule = new HashMap<Class<? extends ShorthandRule>, ShorthandRule>();

        private ShorthandRuleContainer(boolean handlefullLonghandSet) {
            this.myHandleFullLonghandSet = handlefullLonghandSet;
        }

        @Nullable
        public final ShorthandRule getOrCreateRule(@NotNull CssDeclaration decl) {
            if (decl == null) {
                ShorthandRuleContainer.$$$reportNull$$$0(0);
            }
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)decl);
            Class ruleClassName = (Class)NAME_TO_CLASS.get(propertyName);
            if (ruleClassName != null) {
                ShorthandRule rule = this.myClass2Rule.get(ruleClassName);
                if (rule != null) {
                    return rule;
                }
                try {
                    rule = (ShorthandRule)ruleClassName.newInstance();
                    rule.setHandleFullLonghandSet(this.myHandleFullLonghandSet);
                    this.myClass2Rule.put(ruleClassName, rule);
                    return rule;
                }
                catch (InstantiationException e) {
                    CssBaseInspection.LOG.error((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    CssBaseInspection.LOG.error((Throwable)e);
                }
            }
            return null;
        }

        public Collection<ShorthandRule> getRules() {
            return this.myClass2Rule.values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/inspections/CssReplaceWithShorthandUnsafelyInspection$ShorthandRuleContainer", "getOrCreateRule"));
        }
    }
}

