/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessWrapper;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.commandLine.TerminalExecutor;
import org.jetbrains.idea.svn.commandLine.WinTerminalProcessHandler;

public class WinTerminalExecutor
extends TerminalExecutor {
    private static final int TERMINAL_WINDOW_MAX_COLUMNS = 480;
    @Nullable
    private File myRedirectFile;
    @Nullable
    private FileInputStream myRedirectStream;

    public WinTerminalExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        if (exePath == null) {
            WinTerminalExecutor.$$$reportNull$$$0(0);
        }
        if (command == null) {
            WinTerminalExecutor.$$$reportNull$$$0(1);
        }
        super(exePath, command);
    }

    @Override
    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        WinTerminalProcessHandler winTerminalProcessHandler = new WinTerminalProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString(), this.needsUtf8Output(), this.needsBinaryOutput());
        if (winTerminalProcessHandler == null) {
            WinTerminalExecutor.$$$reportNull$$$0(2);
        }
        return winTerminalProcessHandler;
    }

    @Override
    protected void beforeCreateProcess() throws SvnBindException {
        super.beforeCreateProcess();
        this.createRedirectFile();
    }

    private void createRedirectFile() throws SvnBindException {
        this.myRedirectFile = WinTerminalExecutor.createTempFile("terminal-output", "");
        try {
            this.myRedirectStream = new FileInputStream(this.myRedirectFile);
        }
        catch (FileNotFoundException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteRedirectFile();
    }

    private void deleteRedirectFile() {
        if (this.myRedirectStream != null) {
            try {
                this.myRedirectStream.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        WinTerminalExecutor.deleteTempFile(this.myRedirectFile);
    }

    @Override
    @NotNull
    protected Process createProcess() throws ExecutionException {
        this.checkRedirectFile();
        List<String> parameters = this.escapeArguments(this.buildParameters());
        parameters.add(0, ExecUtil.getWindowsShellName());
        parameters.add(1, "/c");
        parameters.add(">>");
        parameters.add(WinTerminalExecutor.quote(this.myRedirectFile.getAbsolutePath()));
        Process process = this.createProcess(parameters);
        ProcessWrapper processWrapper = new ProcessWrapper(process){

            public InputStream getInputStream() {
                return WinTerminalExecutor.this.myRedirectStream;
            }

            public InputStream getErrorStream() {
                return this.getOriginalProcess().getInputStream();
            }
        };
        if (processWrapper == null) {
            WinTerminalExecutor.$$$reportNull$$$0(3);
        }
        return processWrapper;
    }

    private void checkRedirectFile() {
        if (this.myRedirectFile == null) {
            throw new IllegalStateException("No redirect file found");
        }
        if (this.myRedirectStream == null) {
            throw new IllegalStateException("No redirect stream found");
        }
    }

    @Override
    @NotNull
    protected List<String> escapeArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            WinTerminalExecutor.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.map(arguments, argument -> WinTerminalExecutor.needQuote(argument) && !WinTerminalExecutor.isQuoted(argument) ? WinTerminalExecutor.quote(argument) : argument);
        if (list == null) {
            WinTerminalExecutor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static String quote(@NotNull String argument) {
        if (argument == null) {
            WinTerminalExecutor.$$$reportNull$$$0(6);
        }
        String string = StringUtil.wrapWithDoubleQuote((String)argument);
        if (string == null) {
            WinTerminalExecutor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean needQuote(@NotNull String argument) {
        if (argument == null) {
            WinTerminalExecutor.$$$reportNull$$$0(8);
        }
        return argument.contains(" ");
    }

    private static boolean isQuoted(@NotNull String argument) {
        if (argument == null) {
            WinTerminalExecutor.$$$reportNull$$$0(9);
        }
        return StringUtil.startsWithChar((CharSequence)argument, (char)'\"') && StringUtil.endsWithChar((CharSequence)argument, (char)'\"');
    }

    static {
        if (SystemInfo.isWindows) {
            System.setProperty("win.pty.cols", String.valueOf(480));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeArguments";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "needQuote";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

