/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.actions.migrate.MigrateDiffTool;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.StringProperty;
import java.awt.Window;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DiffManager", storages={@Storage(value="diff.xml")})
@Deprecated
public class DiffManagerImpl
extends DiffManager
implements PersistentStateComponent<Element> {
    public static final int FULL_DIFF_DIVIDER_POLYGONS_OFFSET = 3;
    private static final Logger LOG = Logger.getInstance(DiffManagerImpl.class);
    private static final Externalizer<String> TOOL_PATH_UPDATE = new Externalizer<String>(){
        @NonNls
        private static final String NEW_VALUE = "newValue";

        public String readValue(Element dataElement) {
            String path = dataElement.getAttributeValue(NEW_VALUE);
            if (path != null) {
                return path;
            }
            String prevValue = dataElement.getAttributeValue("value");
            return prevValue != null ? prevValue.trim() : null;
        }

        public void writeValue(Element dataElement, String path) {
            dataElement.setAttribute("value", path);
            dataElement.setAttribute(NEW_VALUE, path);
        }
    };
    public static final StringProperty FOLDERS_TOOL = new StringProperty("foldersTool", "");
    public static final StringProperty FILES_TOOL = new StringProperty("filesTool", "");
    public static final StringProperty MERGE_TOOL = new StringProperty("mergeTool", "");
    public static final StringProperty MERGE_TOOL_PARAMETERS = new StringProperty("mergeToolParameters", "");
    public static final BooleanProperty ENABLE_FOLDERS = new BooleanProperty("enableFolders", false);
    public static final BooleanProperty ENABLE_FILES = new BooleanProperty("enableFiles", false);
    public static final BooleanProperty ENABLE_MERGE = new BooleanProperty("enableMerge", false);
    private final ExternalizablePropertyContainer myProperties;
    public static final DiffTool INTERNAL_DIFF = new FrameDiffTool();
    private static final MarkupEditorFilter DIFF_EDITOR_FILTER = editor -> DiffUtil.isDiffEditor(editor);
    private ComparisonPolicy myComparisonPolicy = ComparisonPolicy.DEFAULT;
    private HighlightMode myHighlightMode = HighlightMode.BY_WORD;
    @NonNls
    public static final String COMPARISON_POLICY_ATTR_NAME = "COMPARISON_POLICY";
    @NonNls
    public static final String HIGHLIGHT_MODE_ATTR_NAME = "HIGHLIGHT_MODE";

    public DiffManagerImpl() {
        this.myProperties = new ExternalizablePropertyContainer();
        this.myProperties.registerProperty(ENABLE_FOLDERS);
        this.myProperties.registerProperty((AbstractProperty)FOLDERS_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(ENABLE_FILES);
        this.myProperties.registerProperty((AbstractProperty)FILES_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(ENABLE_MERGE);
        this.myProperties.registerProperty((AbstractProperty)MERGE_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(MERGE_TOOL_PARAMETERS);
    }

    public DiffTool getIdeaDiffTool() {
        return MigrateDiffTool.INSTANCE;
    }

    public DiffTool getDiffTool() {
        return MigrateDiffTool.INSTANCE;
    }

    public MarkupEditorFilter getDiffEditorFilter() {
        return DIFF_EDITOR_FILTER;
    }

    public static DiffManagerImpl getInstanceEx() {
        return (DiffManagerImpl)DiffManager.getInstance();
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.myProperties.writeExternal(state);
        if (this.myComparisonPolicy != ComparisonPolicy.DEFAULT) {
            state.setAttribute(COMPARISON_POLICY_ATTR_NAME, this.myComparisonPolicy.getName());
        }
        if (this.myHighlightMode != HighlightMode.BY_WORD) {
            state.setAttribute(HIGHLIGHT_MODE_ATTR_NAME, this.myHighlightMode.name());
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        String modeName;
        if (state == null) {
            DiffManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProperties.readExternal(state);
        String policyName = state.getAttributeValue(COMPARISON_POLICY_ATTR_NAME);
        if (policyName != null) {
            for (ComparisonPolicy policy : ComparisonPolicy.getAllInstances()) {
                if (!policy.getName().equals(policyName)) continue;
                this.myComparisonPolicy = policy;
                break;
            }
        }
        if ((modeName = state.getAttributeValue(HIGHLIGHT_MODE_ATTR_NAME)) != null) {
            try {
                this.myHighlightMode = HighlightMode.valueOf((String)modeName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public AbstractProperty.AbstractPropertyContainer getProperties() {
        return this.myProperties;
    }

    static DiffPanel createDiffPanel(DiffRequest data, Window window, @NotNull Disposable parentDisposable, DiffTool tool) {
        if (parentDisposable == null) {
            DiffManagerImpl.$$$reportNull$$$0(1);
        }
        DiffPanelImpl diffPanel = null;
        try {
            diffPanel = new DiffPanelImpl(window, data.getProject(), true, true, 3, tool);
            Disposer.register((Disposable)parentDisposable, (Disposable)diffPanel);
            int contentCount = data.getContents().length;
            LOG.assertTrue(contentCount == 2, (Object)String.valueOf(contentCount));
            LOG.assertTrue(data.getContentTitles().length == contentCount);
            diffPanel.setDiffRequest(data);
            return diffPanel;
        }
        catch (RuntimeException e) {
            if (diffPanel != null) {
                Disposer.dispose(diffPanel);
            }
            throw e;
        }
    }

    @NotNull
    public ComparisonPolicy getComparisonPolicy() {
        ComparisonPolicy comparisonPolicy = this.myComparisonPolicy;
        if (comparisonPolicy == null) {
            DiffManagerImpl.$$$reportNull$$$0(2);
        }
        return comparisonPolicy;
    }

    public void setComparisonPolicy(@NotNull ComparisonPolicy value) {
        if (value == null) {
            DiffManagerImpl.$$$reportNull$$$0(3);
        }
        this.myComparisonPolicy = value;
    }

    @NotNull
    public HighlightMode getHighlightMode() {
        HighlightMode highlightMode = this.myHighlightMode;
        if (highlightMode == null) {
            DiffManagerImpl.$$$reportNull$$$0(4);
        }
        return highlightMode;
    }

    public void setHighlightMode(@NotNull HighlightMode highlightMode) {
        if (highlightMode == null) {
            DiffManagerImpl.$$$reportNull$$$0(5);
        }
        this.myHighlightMode = highlightMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/external/DiffManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/external/DiffManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparisonPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDiffPanel";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setComparisonPolicy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

