/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonErrorPriority;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaAnnotatorChecker {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = ContainerUtil.set((Object[])new JsonSchemaType[]{JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null});
    private final Map<PsiElement, JsonValidationError> myErrors;
    private final JsonComplianceCheckerOptions myOptions;
    private boolean myHadTypeError;
    private static final String ENUM_MISMATCH_PREFIX = "Value should be one of: ";
    private static final JsonSchemaType[] NO_TYPES = new JsonSchemaType[0];

    protected JsonSchemaAnnotatorChecker(JsonComplianceCheckerOptions options) {
        this.myOptions = options;
        this.myErrors = new HashMap<PsiElement, JsonValidationError>();
    }

    public Map<PsiElement, JsonValidationError> getErrors() {
        return this.myErrors;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result2, @NotNull JsonComplianceCheckerOptions options) {
        if (elementToCheck == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(1);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(2);
        }
        ArrayList<Object> checkers = new ArrayList<Object>();
        if (result2.myExcludingSchemas.isEmpty() && result2.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker(options);
            checker2.checkByScheme(elementToCheck, result2.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result2.mySchemas.isEmpty()) {
                checkers.add(JsonSchemaAnnotatorChecker.processSchemasVariants(result2.mySchemas, elementToCheck, false, options).getSecond());
            }
            if (!result2.myExcludingSchemas.isEmpty()) {
                List<JsonSchemaAnnotatorChecker> list2 = result2.myExcludingSchemas.stream().map(group -> {
                    if (elementToCheck == null) {
                        JsonSchemaAnnotatorChecker.$$$reportNull$$$0(50);
                    }
                    if (options == null) {
                        JsonSchemaAnnotatorChecker.$$$reportNull$$$0(51);
                    }
                    return (JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(group, elementToCheck, true, options).getSecond();
                }).collect(Collectors.toList());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(list2, options, result2.myExcludingSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        if (checkers.size() == 1) {
            return (JsonSchemaAnnotatorChecker)checkers.get(0);
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull List<JsonSchemaAnnotatorChecker> list2, @NotNull JsonComplianceCheckerOptions options, List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(4);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(options);
        for (JsonSchemaAnnotatorChecker ch : list2) {
            for (Map.Entry<PsiElement, JsonValidationError> element : ch.myErrors.entrySet()) {
                JsonValidationError error = element.getValue();
                if (error.getFixableIssueKind() == JsonValidationError.FixableIssueKind.ProhibitedProperty) {
                    String propertyName = ((JsonValidationError.ProhibitedPropertyIssueData)error.getIssueData()).propertyName;
                    boolean skip = false;
                    for (Collection<? extends JsonSchemaObject> objects : excludingSchemas) {
                        Set keys = objects.stream().map(o -> o.getProperties().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
                        if (!keys.contains(propertyName)) continue;
                        skip = true;
                    }
                    if (skip) continue;
                }
                checker.myErrors.put(element.getKey(), error);
            }
        }
        return checker;
    }

    private void error(String error, PsiElement holder, JsonErrorPriority priority) {
        this.error(error, holder, JsonValidationError.FixableIssueKind.None, null, priority);
    }

    private void error(PsiElement newHolder, JsonValidationError error) {
        this.error(error.getMessage(), newHolder, error.getFixableIssueKind(), error.getIssueData(), error.getPriority());
    }

    private void error(String error, PsiElement holder, JsonValidationError.FixableIssueKind fixableIssueKind, JsonValidationError.IssueData data, JsonErrorPriority priority) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, new JsonValidationError(error, fixableIssueKind, data, priority));
    }

    private void typeError(@NotNull PsiElement value, JsonSchemaType ... allowedTypes) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(5);
        }
        if (allowedTypes == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(6);
        }
        if (allowedTypes.length > 0) {
            if (allowedTypes.length == 1) {
                this.error(String.format("Type is not allowed. Expected: %s.", allowedTypes[0].getName()), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
            } else {
                String typesText = Arrays.stream(allowedTypes).map(JsonSchemaType::getName).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
                this.error(String.format("Type is not allowed. Expected one of: %s.", typesText), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
            }
        } else {
            this.error("Type is not allowed", value, JsonErrorPriority.TYPE_MISMATCH);
        }
        this.myHadTypeError = true;
    }

    public void checkByScheme(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonSchemaAnnotatorChecker checker;
        MatchResult result2;
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(7);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(8);
        }
        JsonSchemaType type = JsonSchemaType.getType(value);
        this.checkForEnum(value.getDelegate(), schema);
        boolean checkedNumber = false;
        boolean checkedString = false;
        boolean checkedArray = false;
        boolean checkedObject = false;
        if (type != null) {
            JsonSchemaType schemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type);
            if (schemaType != null && !schemaType.equals((Object)type)) {
                this.typeError(value.getDelegate(), schemaType);
            } else if (JsonSchemaType._string_number.equals((Object)type)) {
                this.checkNumber(value.getDelegate(), schema, type);
                checkedNumber = true;
                this.checkString(value.getDelegate(), schema);
                checkedString = true;
            } else if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                this.checkNumber(value.getDelegate(), schema, type);
                checkedNumber = true;
            } else if (JsonSchemaType._string.equals((Object)type)) {
                this.checkString(value.getDelegate(), schema);
                checkedString = true;
            } else if (JsonSchemaType._array.equals((Object)type)) {
                this.checkArray(value, schema);
                checkedArray = true;
            } else if (JsonSchemaType._object.equals((Object)type)) {
                this.checkObject(value, schema);
                checkedObject = true;
            }
        }
        if (!(this.myHadTypeError && !this.myErrors.isEmpty() || value.isShouldBeIgnored())) {
            PsiElement delegate = value.getDelegate();
            if (!checkedNumber && schema.hasNumericChecks() && value.isNumberLiteral()) {
                this.checkNumber(delegate, schema, JsonSchemaType._number);
            }
            if (!checkedString && schema.hasStringChecks() && value.isStringLiteral()) {
                this.checkString(delegate, schema);
                checkedString = true;
            }
            if (!checkedArray && schema.hasArrayChecks() && value.isArray()) {
                this.checkArray(value, schema);
                checkedArray = true;
            }
            if (JsonSchemaAnnotatorChecker.hasMinMaxLengthChecks(schema)) {
                if (value.isStringLiteral()) {
                    if (!checkedString) {
                        this.checkString(delegate, schema);
                    }
                } else if (value.isArray() && !checkedArray) {
                    this.checkArray(value, schema);
                }
            }
            if (!checkedObject && schema.hasObjectChecks() && value.isObject()) {
                this.checkObject(value, schema);
            }
        }
        if (schema.getNot() != null) {
            result2 = new JsonSchemaResolver(schema.getNot()).detailedResolve();
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            if (result2.mySchemas.stream().anyMatch(s -> {
                if (schema == null) {
                    JsonSchemaAnnotatorChecker.$$$reportNull$$$0(49);
                }
                return schema.getJsonObject().equals(s.getJsonObject());
            }) || result2.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> {
                if (schema == null) {
                    JsonSchemaAnnotatorChecker.$$$reportNull$$$0(48);
                }
                return schema.getJsonObject().equals(s.getJsonObject());
            })) {
                return;
            }
            checker = JsonSchemaAnnotatorChecker.checkByMatchResult(value, result2, this.myOptions);
            if (checker == null || checker.isCorrect()) {
                this.error("Validates against 'not' schema", value.getDelegate(), JsonErrorPriority.NOT_SCHEMA);
            }
        }
        if (schema.getIf() != null) {
            result2 = new JsonSchemaResolver(schema.getIf()).detailedResolve();
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            checker = JsonSchemaAnnotatorChecker.checkByMatchResult(value, result2, this.myOptions);
            if (checker != null) {
                if (checker.isCorrect()) {
                    JsonSchemaObject then = schema.getThen();
                    if (then == null) {
                        this.error("Validates against 'if' branch but no 'then' branch is present", value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    } else {
                        this.checkObjectBySchemaRecordErrors(then, value);
                    }
                } else {
                    JsonSchemaObject schemaElse = schema.getElse();
                    if (schemaElse == null) {
                        this.error("Validates counter 'if' branch but no 'else' branch is present", value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    } else {
                        this.checkObjectBySchemaRecordErrors(schemaElse, value);
                    }
                }
            }
        }
    }

    private void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object) {
        JsonSchemaAnnotatorChecker checker;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(9);
        }
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(10);
        }
        if ((checker = JsonSchemaAnnotatorChecker.checkByMatchResult(object, new JsonSchemaResolver(schema).detailedResolve(), this.myOptions)) != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    private void checkObject(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonObjectValueAdapter object;
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(11);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(12);
        }
        if ((object = value.getAsObject()) == null) {
            return;
        }
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set = new HashSet<String>();
        for (JsonPropertyAdapter property : propertyList) {
            JsonSchemaVariantsTreeBuilder.Step step;
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonValueAdapter nameValueAdapter;
            String name = StringUtil.notNullize((String)property.getName());
            JsonSchemaObject jsonSchemaObject = schema.getPropertyNamesSchema();
            if (jsonSchemaObject != null && (nameValueAdapter = property.getNameValueAdapter()) != null) {
                this.checkByScheme(nameValueAdapter, jsonSchemaObject);
            }
            if (ThreeState.NO.equals((pair = (step = JsonSchemaVariantsTreeBuilder.Step.createPropertyStep(name)).step(schema, true)).getFirst()) && !set.contains(name)) {
                this.error(JsonBundle.message("json.schema.annotation.not.allowed.property", name), property.getDelegate(), JsonValidationError.FixableIssueKind.ProhibitedProperty, new JsonValidationError.ProhibitedPropertyIssueData(name), JsonErrorPriority.LOW_PRIORITY);
            } else if (ThreeState.UNSURE.equals(pair.getFirst())) {
                for (JsonValueAdapter propertyValue : property.getValues()) {
                    this.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair.getSecond(), propertyValue);
                }
            }
            set.add(name);
        }
        if (object.shouldCheckIntegralRequirements()) {
            Map<String, JsonSchemaObject> schemaDependencies;
            Map<String, List<String>> dependencies;
            Set<String> required = schema.getRequired();
            if (required != null) {
                HashSet requiredNames = ContainerUtil.newHashSet(required);
                requiredNames.removeAll(set);
                if (!requiredNames.isEmpty()) {
                    JsonValidationError.MissingMultiplePropsIssueData data = JsonSchemaAnnotatorChecker.createMissingPropertiesData(schema, requiredNames);
                    this.error("Missing required " + data.getMessage(false), value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                this.error("Number of properties is less than " + schema.getMinProperties(), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                this.error("Number of properties is greater than " + schema.getMaxProperties(), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if ((dependencies = schema.getPropertyDependencies()) != null) {
                for (Map.Entry entry : dependencies.entrySet()) {
                    if (!set.contains(entry.getKey())) continue;
                    List list2 = (List)entry.getValue();
                    HashSet deps = ContainerUtil.newHashSet((Iterable)list2);
                    deps.removeAll(set);
                    if (deps.isEmpty()) continue;
                    JsonValidationError.MissingMultiplePropsIssueData data = JsonSchemaAnnotatorChecker.createMissingPropertiesData(schema, deps);
                    this.error("Dependency is violated: " + data.getMessage(false) + " must be specified, since '" + (String)entry.getKey() + "' is specified", value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if ((schemaDependencies = schema.getSchemaDependencies()) != null) {
                for (Map.Entry<String, JsonSchemaObject> entry : schemaDependencies.entrySet()) {
                    if (!set.contains(entry.getKey())) continue;
                    this.checkObjectBySchemaRecordErrors(entry.getValue(), value);
                }
            }
        }
        this.validateAsJsonSchema(object.getDelegate());
    }

    @Nullable
    private static Object getDefaultValueFromEnum(@NotNull JsonSchemaObject propertySchema, @NotNull Ref<Integer> enumCount) {
        List<Object> enumValues;
        if (propertySchema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(13);
        }
        if (enumCount == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(14);
        }
        if ((enumValues = propertySchema.getEnum()) != null) {
            enumCount.set((Object)enumValues.size());
            if (enumValues.size() == 1) {
                Object defaultObject = enumValues.get(0);
                return defaultObject instanceof String ? StringUtil.unquoteString((String)((String)defaultObject)) : defaultObject;
            }
        }
        return null;
    }

    @NotNull
    private static JsonValidationError.MissingMultiplePropsIssueData createMissingPropertiesData(@NotNull JsonSchemaObject schema, HashSet<String> requiredNames) {
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(15);
        }
        ArrayList allProps = ContainerUtil.newArrayList();
        for (String req : requiredNames) {
            JsonSchemaObject propertySchema = JsonSchemaAnnotatorChecker.resolvePropertySchema(schema, req);
            Object defaultValue = propertySchema == null ? null : propertySchema.getDefault();
            Ref enumCount = Ref.create((Object)0);
            JsonSchemaType type = null;
            if (propertySchema != null) {
                MatchResult result2 = null;
                Object valueFromEnum = JsonSchemaAnnotatorChecker.getDefaultValueFromEnum(propertySchema, (Ref<Integer>)enumCount);
                if (valueFromEnum != null) {
                    defaultValue = valueFromEnum;
                } else {
                    result2 = new JsonSchemaResolver(propertySchema).detailedResolve();
                    if (result2.mySchemas.size() == 1 && (valueFromEnum = JsonSchemaAnnotatorChecker.getDefaultValueFromEnum(result2.mySchemas.get(0), (Ref<Integer>)enumCount)) != null) {
                        defaultValue = valueFromEnum;
                    }
                }
                type = propertySchema.getType();
                if (type == null) {
                    if (result2 == null) {
                        result2 = new JsonSchemaResolver(propertySchema).detailedResolve();
                    }
                    if (result2.mySchemas.size() == 1) {
                        type = result2.mySchemas.get(0).getType();
                    }
                }
            }
            allProps.add(new JsonValidationError.MissingPropertyIssueData(req, type, defaultValue, (Integer)enumCount.get()));
        }
        JsonValidationError.MissingMultiplePropsIssueData missingMultiplePropsIssueData = new JsonValidationError.MissingMultiplePropsIssueData(allProps);
        if (missingMultiplePropsIssueData == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(16);
        }
        return missingMultiplePropsIssueData;
    }

    private static JsonSchemaObject resolvePropertySchema(@NotNull JsonSchemaObject schema, String req) {
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(17);
        }
        if (schema.getProperties().containsKey(req)) {
            return schema.getProperties().get(req);
        }
        JsonSchemaObject propertySchema = schema.getMatchingPatternPropertySchema(req);
        if (propertySchema != null) {
            return propertySchema;
        }
        JsonSchemaObject additionalPropertiesSchema = schema.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null) {
            return additionalPropertiesSchema;
        }
        return null;
    }

    private void validateAsJsonSchema(@NotNull PsiElement objElement) {
        JsonObject object;
        if (objElement == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(18);
        }
        if ((object = (JsonObject)ObjectUtils.tryCast((Object)objElement, JsonObject.class)) == null) {
            return;
        }
        if (!JsonSchemaService.isSchemaFile(objElement.getContainingFile())) {
            return;
        }
        VirtualFile schemaFile = object.getContainingFile().getVirtualFile();
        if (schemaFile == null) {
            return;
        }
        JsonSchemaObject schemaObject = JsonSchemaService.Impl.get(object.getProject()).getSchemaObjectForSchemaFile(schemaFile);
        if (schemaObject == null) {
            return;
        }
        List<JsonSchemaVariantsTreeBuilder.Step> position = JsonOriginalPsiWalker.INSTANCE.findPosition(object, true);
        if (position == null) {
            return;
        }
        List<JsonSchemaVariantsTreeBuilder.Step> steps = JsonSchemaAnnotatorChecker.skipProperties(position);
        MatchResult result2 = new JsonSchemaResolver(schemaObject, false, steps).detailedResolve();
        for (JsonSchemaObject s2 : result2.mySchemas) {
            this.reportInvalidPatternProperties(s2);
            this.reportPatternErrors(s2);
        }
        result2.myExcludingSchemas.stream().flatMap(Collection::stream).filter(s -> schemaFile.equals(s.getSchemaFile())).forEach(schema -> {
            this.reportInvalidPatternProperties((JsonSchemaObject)schema);
            this.reportPatternErrors((JsonSchemaObject)schema);
        });
    }

    private void reportPatternErrors(JsonSchemaObject schema) {
        for (JsonSchemaObject prop : schema.getProperties().values()) {
            JsonProperty pattern;
            JsonContainer element;
            String patternError = prop.getPatternError();
            if (patternError == null || prop.getPattern() == null || !((element = prop.getJsonObject()) instanceof JsonObject) || !element.isValid() || (pattern = ((JsonObject)element).findProperty("pattern")) == null) continue;
            this.error(StringUtil.convertLineSeparators((String)patternError), pattern.getValue(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private void reportInvalidPatternProperties(JsonSchemaObject schema) {
        Map<JsonContainer, String> invalidPatternProperties = schema.getInvalidPatternProperties();
        if (invalidPatternProperties == null) {
            return;
        }
        for (Map.Entry<JsonContainer, String> entry : invalidPatternProperties.entrySet()) {
            PsiElement parent;
            JsonContainer element = entry.getKey();
            if (element == null || !element.isValid() || !((parent = element.getParent()) instanceof JsonProperty)) continue;
            this.error(StringUtil.convertLineSeparators((String)entry.getValue()), ((JsonProperty)parent).getNameElement(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static List<JsonSchemaVariantsTreeBuilder.Step> skipProperties(List<JsonSchemaVariantsTreeBuilder.Step> position) {
        Iterator<JsonSchemaVariantsTreeBuilder.Step> iterator = position.iterator();
        boolean canSkip = true;
        while (iterator.hasNext()) {
            JsonSchemaVariantsTreeBuilder.Step step = iterator.next();
            if (canSkip && step.isFromObject() && "properties".equals(step.getName())) {
                iterator.remove();
                canSkip = false;
                continue;
            }
            canSkip = true;
        }
        return position;
    }

    private static boolean checkEnumValue(@NotNull Object object, @NotNull JsonLikePsiWalker walker, @Nullable JsonValueAdapter adapter, @NotNull String text, @NotNull BiFunction<String, String, Boolean> stringEq) {
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(19);
        }
        if (walker == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(20);
        }
        if (text == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(21);
        }
        if (stringEq == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(22);
        }
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return true;
        }
        if (object instanceof EnumArrayValueWrapper) {
            if (adapter instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> elements = ((JsonArrayValueAdapter)adapter).getElements();
                Object[] values = ((EnumArrayValueWrapper)object).getValues();
                if (elements.size() == values.length) {
                    for (int i = 0; i < values.length; ++i) {
                        if (JsonSchemaAnnotatorChecker.checkEnumValue(values[i], walker, elements.get(i), walker.getNodeTextForValidation(elements.get(i).getDelegate()), stringEq)) continue;
                        return false;
                    }
                    return true;
                }
            }
        } else if (object instanceof EnumObjectValueWrapper) {
            if (adapter instanceof JsonObjectValueAdapter) {
                List<JsonPropertyAdapter> props = ((JsonObjectValueAdapter)adapter).getPropertyList();
                Map<String, Object> values = ((EnumObjectValueWrapper)object).getValues();
                if (props.size() == values.size()) {
                    for (JsonPropertyAdapter prop : props) {
                        if (!values.containsKey(prop.getName())) {
                            return false;
                        }
                        for (JsonValueAdapter value : prop.getValues()) {
                            if (JsonSchemaAnnotatorChecker.checkEnumValue(values.get(prop.getName()), walker, value, walker.getNodeTextForValidation(value.getDelegate()), stringEq)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
        } else if (walker.onlyDoubleQuotesForStringLiterals() ? stringEq.apply(object.toString(), text) != false : JsonSchemaAnnotatorChecker.equalsIgnoreQuotes(object.toString(), text, walker.quotesForStringLiterals(), stringEq)) {
            return true;
        }
        return false;
    }

    private void checkForEnum(PsiElement value, JsonSchemaObject schema) {
        List<Object> enumItems = schema.getEnum();
        if (enumItems == null) {
            return;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(value, schema);
        if (walker == null) {
            return;
        }
        String text = StringUtil.notNullize((String)walker.getNodeTextForValidation(value));
        BiFunction<String, String, Boolean> eq = this.myOptions.isCaseInsensitiveEnumCheck() ? String::equalsIgnoreCase : String::equals;
        for (Object object : enumItems) {
            if (!JsonSchemaAnnotatorChecker.checkEnumValue(object, walker, walker.createValueAdapter(value), text, eq)) continue;
            return;
        }
        this.error(ENUM_MISMATCH_PREFIX + StringUtil.join(enumItems, o -> o.toString(), (String)", "), value, JsonValidationError.FixableIssueKind.NonEnumValue, null, JsonErrorPriority.MEDIUM_PRIORITY);
    }

    private static boolean equalsIgnoreQuotes(@NotNull String s1, @NotNull String s2, boolean requireQuotedValues, BiFunction<String, String, Boolean> eq) {
        if (s1 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(23);
        }
        if (s2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(24);
        }
        boolean quoted1 = StringUtil.isQuotedString((String)s1);
        boolean quoted2 = StringUtil.isQuotedString((String)s2);
        if (requireQuotedValues && quoted1 != quoted2) {
            return false;
        }
        if (requireQuotedValues && !quoted1) {
            return eq.apply(s1, s2);
        }
        return eq.apply(StringUtil.unquoteString((String)s1), StringUtil.unquoteString((String)s2));
    }

    private void checkArray(JsonValueAdapter value, JsonSchemaObject schema) {
        JsonArrayValueAdapter asArray = value.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        if (schema.getMinLength() != null && elements.size() < schema.getMinLength()) {
            this.error("Array is shorter than " + schema.getMinLength(), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        this.checkArrayItems(value, elements, schema);
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Collection<? extends JsonSchemaObject> collection, @NotNull JsonValueAdapter value, boolean isOneOf, JsonComplianceCheckerOptions options) {
        if (collection == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(25);
        }
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(26);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(options);
        JsonSchemaType type = JsonSchemaType.getType(value);
        JsonSchemaObject selected = null;
        if (type == null) {
            if (!value.isShouldBeIgnored()) {
                checker.typeError(value.getDelegate(), JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            }
        } else {
            ArrayList filtered = ContainerUtil.newArrayListWithCapacity((int)collection.size());
            for (JsonSchemaObject jsonSchemaObject : collection) {
                if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, type)) continue;
                filtered.add(jsonSchemaObject);
            }
            if (filtered.isEmpty()) {
                checker.typeError(value.getDelegate(), JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            } else if (filtered.size() == 1) {
                selected = (JsonSchemaObject)filtered.get(0);
                checker.checkByScheme(value, selected);
            } else {
                selected = isOneOf ? checker.processOneOf(value, filtered) : checker.processAnyOf(value, filtered);
            }
        }
        Pair pair = Pair.create(selected, (Object)checker);
        if (pair == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(27);
        }
        return pair;
    }

    private static JsonSchemaType[] getExpectedTypes(Collection<? extends JsonSchemaObject> schemas) {
        ArrayList<JsonSchemaType> list2 = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject jsonSchemaObject : schemas) {
            JsonSchemaType type = jsonSchemaObject.getType();
            if (type != null) {
                list2.add(type);
                continue;
            }
            Set<JsonSchemaType> variants = jsonSchemaObject.getTypeVariants();
            if (variants == null) continue;
            list2.addAll(variants);
        }
        return list2.isEmpty() ? NO_TYPES : list2.toArray(NO_TYPES);
    }

    public static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type) {
        JsonSchemaType matchingSchemaType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(28);
        }
        if (type == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(29);
        }
        if ((matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type)) != null) {
            return matchingSchemaType.equals((Object)type);
        }
        if (schema.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type);
        }
        return true;
    }

    @Nullable
    private static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(30);
        }
        if (input == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(31);
        }
        if (schema.getType() != null && (matchType = schema.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (JsonSchemaType._number.equals((Object)matchType) || JsonSchemaType._integer.equals((Object)matchType) || JsonSchemaType._string.equals((Object)matchType))) {
                return input;
            }
            return matchType;
        }
        if (schema.getTypeVariants() != null) {
            Set<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (matchTypes.contains((Object)JsonSchemaType._number) || matchTypes.contains((Object)JsonSchemaType._integer) || matchTypes.contains((Object)JsonSchemaType._string))) {
                return input;
            }
            return matchTypes.iterator().next();
        }
        if (!schema.getProperties().isEmpty() && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    private void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema) {
        if (array == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(32);
        }
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(33);
        }
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(array.getDelegate(), schema);
            assert (walker != null);
            for (JsonValueAdapter adapter : list2) {
                valueTexts.putValue((Object)walker.getNodeTextForValidation(adapter.getDelegate()), (Object)adapter);
            }
            for (Map.Entry entry : valueTexts.entrySet()) {
                if (((Collection)entry.getValue()).size() <= 1) continue;
                for (JsonValueAdapter item : (Collection)entry.getValue()) {
                    if (!item.shouldCheckAsValue()) continue;
                    this.error("Item is not unique", item.getDelegate(), JsonErrorPriority.TYPE_MISMATCH);
                }
            }
        }
        if (schema.getContainsSchema() != null) {
            boolean match = false;
            for (JsonValueAdapter item : list2) {
                JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(item, new JsonSchemaResolver(schema.getContainsSchema()).detailedResolve(), this.myOptions);
                if (checker != null && (checker.myErrors.size() != 0 || checker.myHadTypeError)) continue;
                match = true;
                break;
            }
            if (!match) {
                this.error("No match for 'contains' rule", array.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
        }
        if (schema.getItemsSchema() != null) {
            for (JsonValueAdapter item : list2) {
                this.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), item);
            }
        } else if (schema.getItemsSchemaList() != null) {
            Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator.hasNext()) {
                    this.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                    this.error("Additional items are not allowed", arrayValue.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    continue;
                }
                if (schema.getAdditionalItemsSchema() == null) continue;
                this.checkObjectBySchemaRecordErrors(schema.getAdditionalItemsSchema(), arrayValue);
            }
        }
        if (schema.getMinItems() != null && list2.size() < schema.getMinItems()) {
            this.error("Array is shorter than " + schema.getMinItems(), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxItems() != null && list2.size() > schema.getMaxItems()) {
            this.error("Array is longer than " + schema.getMaxItems(), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static boolean hasMinMaxLengthChecks(JsonSchemaObject schema) {
        return schema.getMinLength() != null || schema.getMaxLength() != null;
    }

    private void checkString(PsiElement propValue, JsonSchemaObject schema) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue, schema);
        assert (walker != null);
        JsonValueAdapter adapter = walker.createValueAdapter(propValue);
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return;
        }
        String value = StringUtil.unquoteString((String)walker.getNodeTextForValidation(propValue));
        if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
            this.error("String is shorter than " + schema.getMinLength(), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
            this.error("String is longer than " + schema.getMaxLength(), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema.getPattern() != null) {
            if (schema.getPatternError() != null) {
                this.error("Can not check string by pattern because of error: " + StringUtil.convertLineSeparators((String)schema.getPatternError()), propValue, JsonErrorPriority.LOW_PRIORITY);
            }
            if (!schema.checkByPattern(value)) {
                this.error("String is violating the pattern: '" + StringUtil.convertLineSeparators((String)schema.getPattern()) + "'", propValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }

    private void checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType) {
        double leftOver;
        Number value;
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue, schema);
        assert (walker != null);
        JsonValueAdapter adapter = walker.createValueAdapter(propValue);
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return;
        }
        String valueText = walker.getNodeTextForValidation(propValue);
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            try {
                value = Integer.valueOf(valueText);
            }
            catch (NumberFormatException e) {
                this.error("Integer value expected", propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                return;
            }
        }
        try {
            value = Double.valueOf(valueText);
        }
        catch (NumberFormatException e) {
            if (!JsonSchemaType._string_number.equals((Object)schemaType)) {
                this.error("Double value expected", propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
            }
            return;
        }
        Number multipleOf = schema.getMultipleOf();
        if (multipleOf != null && (leftOver = value.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            this.error("Is not multiple of " + multipleOfValue, propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        this.checkMinimum(schema, value, propValue, schemaType);
        this.checkMaximum(schema, value, propValue, schemaType);
    }

    private void checkMaximum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType propValueType) {
        Number maximum;
        Number exclusiveMaximumNumber;
        if (propValueType == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(34);
        }
        if ((exclusiveMaximumNumber = schema.getExclusiveMaximumNumber()) != null) {
            if (JsonSchemaType._integer.equals((Object)propValueType)) {
                int intValue = exclusiveMaximumNumber.intValue();
                if (value.intValue() >= intValue) {
                    this.error("Greater than an exclusive maximum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else {
                double doubleValue = exclusiveMaximumNumber.doubleValue();
                if (value.doubleValue() >= doubleValue) {
                    this.error("Greater than an exclusive maximum " + exclusiveMaximumNumber, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            }
        }
        if ((maximum = schema.getMaximum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMaximum());
        if (JsonSchemaType._integer.equals((Object)propValueType)) {
            int intValue = maximum.intValue();
            if (isExclusive) {
                if (value.intValue() >= intValue) {
                    this.error("Greater than an exclusive maximum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.intValue() > intValue) {
                this.error("Greater than a maximum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else {
            double doubleValue = maximum.doubleValue();
            if (isExclusive) {
                if (value.doubleValue() >= doubleValue) {
                    this.error("Greater than an exclusive maximum " + maximum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.doubleValue() > doubleValue) {
                this.error("Greater than a maximum " + maximum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }

    private void checkMinimum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType schemaType) {
        Number minimum;
        Number exclusiveMinimumNumber;
        if (schemaType == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(35);
        }
        if ((exclusiveMinimumNumber = schema.getExclusiveMinimumNumber()) != null) {
            if (JsonSchemaType._integer.equals((Object)schemaType)) {
                int intValue = exclusiveMinimumNumber.intValue();
                if (value.intValue() <= intValue) {
                    this.error("Less than an exclusive minimum" + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else {
                double doubleValue = exclusiveMinimumNumber.doubleValue();
                if (value.doubleValue() <= doubleValue) {
                    this.error("Less than an exclusive minimum " + exclusiveMinimumNumber, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            }
        }
        if ((minimum = schema.getMinimum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMinimum());
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            int intValue = minimum.intValue();
            if (isExclusive) {
                if (value.intValue() <= intValue) {
                    this.error("Less than an exclusive minimum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.intValue() < intValue) {
                this.error("Less than a minimum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else {
            double doubleValue = minimum.doubleValue();
            if (isExclusive) {
                if (value.doubleValue() <= doubleValue) {
                    this.error("Less than an exclusive minimum " + minimum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.doubleValue() < doubleValue) {
                this.error("Less than a minimum " + minimum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> oneOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(36);
        }
        ArrayList candidateErroneousCheckers = ContainerUtil.newArrayList();
        ArrayList candidateErroneousSchemas = ContainerUtil.newArrayList();
        SmartList correct = new SmartList();
        for (JsonSchemaObject object : oneOf) {
            if (object.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                candidateErroneousCheckers.clear();
                candidateErroneousSchemas.clear();
                correct.add(object);
                continue;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        if (correct.size() == 1) {
            return (JsonSchemaObject)correct.get(0);
        }
        if (correct.size() > 0) {
            JsonSchemaType type = JsonSchemaType.getType(value);
            if (type != null && ContainerUtil.newHashSet((Iterable)correct).size() > 1 && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error("Validates to more than one variant", value.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
            return (JsonSchemaObject)ContainerUtil.getLastItem((List)correct);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, true);
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list2) {
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(37);
        }
        return list2.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    @NotNull
    private static AverageFailureAmount getAverageFailureAmount(@NotNull JsonSchemaAnnotatorChecker checker) {
        if (checker == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(38);
        }
        int lowPriorityCount = 0;
        boolean hasMedium = false;
        boolean hasMissing = false;
        boolean hasHard = false;
        Collection<JsonValidationError> values = checker.getErrors().values();
        for (JsonValidationError value : values) {
            switch (value.getPriority()) {
                case LOW_PRIORITY: {
                    ++lowPriorityCount;
                    break;
                }
                case MISSING_PROPS: {
                    hasMissing = true;
                    break;
                }
                case MEDIUM_PRIORITY: {
                    hasMedium = true;
                    break;
                }
                case TYPE_MISMATCH: {
                    hasHard = true;
                    break;
                }
                case NOT_SCHEMA: {
                    AverageFailureAmount averageFailureAmount = AverageFailureAmount.NotSchema;
                    if (averageFailureAmount == null) {
                        JsonSchemaAnnotatorChecker.$$$reportNull$$$0(39);
                    }
                    return averageFailureAmount;
                }
            }
        }
        if (hasHard) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Hard;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(40);
            }
            return averageFailureAmount;
        }
        if (hasMissing) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.MissingItems;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(41);
            }
            return averageFailureAmount;
        }
        if (hasMedium) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Medium;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(42);
            }
            return averageFailureAmount;
        }
        AverageFailureAmount averageFailureAmount = lowPriorityCount <= 3 ? AverageFailureAmount.Light : AverageFailureAmount.Medium;
        if (averageFailureAmount == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(43);
        }
        return averageFailureAmount;
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> anyOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(44);
        }
        ArrayList candidateErroneousCheckers = ContainerUtil.newArrayList();
        ArrayList candidateErroneousSchemas = ContainerUtil.newArrayList();
        for (JsonSchemaObject object : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                return object;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, false);
    }

    @Nullable
    private JsonSchemaObject showErrorsAndGetLeastErroneous(@NotNull List<JsonSchemaAnnotatorChecker> candidateErroneousCheckers, @NotNull List<JsonSchemaObject> candidateErroneousSchemas, boolean isOneOf) {
        if (candidateErroneousCheckers == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(45);
        }
        if (candidateErroneousSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(46);
        }
        JsonSchemaObject current = null;
        JsonSchemaObject currentWithMinAverage = null;
        Optional<AverageFailureAmount> minAverage = candidateErroneousCheckers.stream().map(c -> JsonSchemaAnnotatorChecker.getAverageFailureAmount(c)).min(Comparator.comparingInt(c -> c.ordinal()));
        int min = minAverage.orElse(AverageFailureAmount.Hard).ordinal();
        int minErrorCount = candidateErroneousCheckers.stream().map(c -> c.getErrors().size()).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
        MultiMap errorsWithMinAverage = MultiMap.create();
        MultiMap allErrors = MultiMap.create();
        for (int i = 0; i < candidateErroneousCheckers.size(); ++i) {
            boolean isMoreThanAverage;
            JsonSchemaAnnotatorChecker checker = candidateErroneousCheckers.get(i);
            boolean isMoreThanMinErrors = checker.getErrors().size() > minErrorCount;
            boolean bl = isMoreThanAverage = JsonSchemaAnnotatorChecker.getAverageFailureAmount(checker).ordinal() > min;
            if (isMoreThanMinErrors) continue;
            if (isMoreThanAverage) {
                currentWithMinAverage = candidateErroneousSchemas.get(i);
            } else {
                current = candidateErroneousSchemas.get(i);
            }
            for (Map.Entry<Object, JsonValidationError> entry : checker.getErrors().entrySet()) {
                (isMoreThanAverage ? errorsWithMinAverage : allErrors).putValue(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (allErrors.isEmpty()) {
            allErrors = errorsWithMinAverage;
        }
        for (Map.Entry entry : allErrors.entrySet()) {
            Collection value = (Collection)entry.getValue();
            if (value.size() == 0) continue;
            if (value.size() == 1) {
                this.error((PsiElement)entry.getKey(), (JsonValidationError)value.iterator().next());
                continue;
            }
            JsonValidationError error = JsonSchemaAnnotatorChecker.tryMergeErrors(value, isOneOf);
            if (error != null) {
                this.error((PsiElement)entry.getKey(), error);
                continue;
            }
            for (JsonValidationError jsonValidationError : value) {
                this.error((PsiElement)entry.getKey(), jsonValidationError);
            }
        }
        if (current == null) {
            current = currentWithMinAverage;
        }
        if (current == null) {
            current = (JsonSchemaObject)ContainerUtil.getLastItem(candidateErroneousSchemas);
        }
        return current;
    }

    @Nullable
    private static JsonValidationError tryMergeErrors(@NotNull Collection<JsonValidationError> errors, boolean isOneOf) {
        if (errors == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(47);
        }
        JsonValidationError.FixableIssueKind commonIssueKind = null;
        for (JsonValidationError error : errors) {
            JsonValidationError.FixableIssueKind currentIssueKind = error.getFixableIssueKind();
            if (currentIssueKind == JsonValidationError.FixableIssueKind.None) {
                return null;
            }
            if (commonIssueKind == null) {
                commonIssueKind = currentIssueKind;
                continue;
            }
            if (currentIssueKind == commonIssueKind) continue;
            return null;
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.NonEnumValue) {
            return new JsonValidationError(ENUM_MISMATCH_PREFIX + errors.stream().map(e -> StringUtil.trimStart((String)e.getMessage(), (String)ENUM_MISMATCH_PREFIX)).map(e -> StringUtil.split((String)e, (String)", ")).flatMap(e -> e.stream()).distinct().collect(Collectors.joining(", ")), commonIssueKind, null, errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.MissingProperty) {
            String prefix = isOneOf ? "One of the following property sets is required: " : "Should have at least one of the following property sets: ";
            return new JsonValidationError(prefix + errors.stream().map(e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData()).map(d -> d.getMessage(false)).collect(Collectors.joining(", or ")), isOneOf ? JsonValidationError.FixableIssueKind.MissingOneOfProperty : JsonValidationError.FixableIssueKind.MissingAnyOfProperty, new JsonValidationError.MissingOneOfPropsIssueData(errors.stream().map(e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData()).collect(Collectors.toList())), errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.ProhibitedType) {
            Set allTypes = errors.stream().map(e -> (JsonValidationError.TypeMismatchIssueData)e.getIssueData()).flatMap(d -> Arrays.stream(d.expectedTypes)).collect(Collectors.toSet());
            if (allTypes.size() == 1) {
                return errors.iterator().next();
            }
            String commonTypeMessage = "Type is not allowed. Expected one of: " + allTypes.stream().map(t -> t.getDescription()).sorted().collect(Collectors.joining(", ")) + ".";
            return new JsonValidationError(commonTypeMessage, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData((JsonSchemaType[])ContainerUtil.toArray(allTypes, JsonSchemaType[]::new)), errors.iterator().next().getPriority());
        }
        return null;
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 27: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 27: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 26: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTypes";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 28: 
            case 30: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySchema";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumCount";
                break;
            }
            case 16: 
            case 27: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringEq";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValueType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousCheckers";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousSchemas";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMissingPropertiesData";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "processSchemasVariants";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAverageFailureAmount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkByMatchResult";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergeErrors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "typeError";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkByScheme";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectBySchemaRecordErrors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkObject";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueFromEnum";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMissingPropertiesData";
                break;
            }
            case 16: 
            case 27: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertySchema";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateAsJsonSchema";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumValue";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoreQuotes";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processSchemasVariants";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "areSchemaTypesCompatible";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingSchemaType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayItems";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkMaximum";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkMinimum";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processOneOf";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "schemesDifferWithNotCheckedProperties";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAverageFailureAmount";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processAnyOf";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "showErrorsAndGetLeastErroneous";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeErrors";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkByScheme$4";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkByScheme$3";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkByMatchResult$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 27: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum AverageFailureAmount {
        Light,
        MissingItems,
        Medium,
        Hard,
        NotSchema;

    }
}

