/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseModelLoader {
    private static final Logger LOG = Logger.getInstance(DatabaseModelLoader.class);
    private static final BasicNamespace[] NO_NAMESPACES = new BasicNamespace[0];

    public static boolean matches(@NotNull DasObject o, @NotNull IntrospectionScope scope) {
        if (o == null) {
            DatabaseModelLoader.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(1);
        }
        if (o.getKind() == ObjectKind.DATABASE) {
            return DatabaseModelLoader.databaseMatches(o, scope);
        }
        if (DbImplUtil.isSchema(o)) {
            return DatabaseModelLoader.schemaMatches(o, scope);
        }
        return true;
    }

    public static boolean databaseMatches(@NotNull DasObject database, @NotNull IntrospectionScope scope) {
        if (database == null) {
            DatabaseModelLoader.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(3);
        }
        String name = database.getName();
        boolean cur = database instanceof BasicNamespace && ((BasicNamespace)database).isCurrent();
        return cur && scope.containsDatabase("@") || scope.containsDatabase(name);
    }

    public static boolean schemaMatches(@NotNull DasObject schema, @NotNull IntrospectionScope scope) {
        if (schema == null) {
            DatabaseModelLoader.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(5);
        }
        String name = schema.getName();
        boolean cur = schema instanceof BasicNamespace && ((BasicNamespace)schema).isCurrent();
        DasObject db = schema.getDasParent();
        if (db != null && db.getKind() != ObjectKind.DATABASE) {
            db = null;
        }
        String dbName = db == null ? "*" : db.getName();
        boolean dbCur = db == null || db instanceof BasicNamespace && ((BasicNamespace)db).isCurrent();
        return scope.containsSchema(dbName, name) || dbCur && scope.containsSchema("@", name) || cur && scope.containsSchema(dbName, "@") || dbCur && cur && scope.containsSchema("@", "@");
    }

    public static IntrospectionScope updateIntrospectionScope(@NotNull BasicModel model, @NotNull IntrospectionScope scope, boolean merge) {
        String dbName;
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(7);
        }
        MultiMap pairs2 = MultiMap.createLinkedSet();
        if (merge) {
            for (String db : scope.databases()) {
                pairs2.getModifiable((Object)db).addAll(scope.schemas(db));
            }
        }
        for (BasicSchema schema : ((JBTreeTraverser)model.traverser(true).expandAndSkip(o -> o instanceof BasicRoot || o instanceof BasicDatabase)).filter(BasicSchema.class)) {
            if (!schema.isVisible()) continue;
            BasicNamespaceOwner p2 = schema.getParent();
            if (p2 != null && p2.getKind() != ObjectKind.DATABASE) {
                p2 = null;
            }
            if (merge && DatabaseModelLoader.schemaMatches(schema, scope)) continue;
            dbName = DatabaseModelLoader.getDbName(p2, scope, merge);
            String scName = DatabaseModelLoader.getNameOrCurrent(schema, true);
            pairs2.putValue((Object)dbName, (Object)scName);
        }
        Family<? extends BasicElement> dbs2 = model.getRoot().familyOf(ObjectKind.DATABASE);
        if (dbs2 != null) {
            for (BasicNamespace db : dbs2.jbi().filter(BasicNamespace.class)) {
                if (!db.isVisible()) continue;
                dbName = DatabaseModelLoader.getDbName(db, scope, merge);
                pairs2.getModifiable((Object)dbName);
            }
        }
        return IntrospectionScopes.scopeOf((MultiMap<String, String>)pairs2);
    }

    @NotNull
    private static String getDbName(BasicElement p2, @NotNull IntrospectionScope scope, boolean merge) {
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(8);
        }
        String dbName = DatabaseModelLoader.getNameOrCurrent(p2, true);
        if (merge && dbName == "@") {
            String dbName2 = DatabaseModelLoader.getNameOrCurrent(p2, false);
            if (!scope.containsDatabase(dbName) && scope.containsDatabase(dbName2)) {
                String string = dbName2;
                if (string == null) {
                    DatabaseModelLoader.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        String string = dbName;
        if (string == null) {
            DatabaseModelLoader.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String getNameOrCurrent(BasicElement p2, boolean substituteCurrent) {
        if (p2 == null) {
            if ("*" == null) {
                DatabaseModelLoader.$$$reportNull$$$0(11);
            }
            return "*";
        }
        if (substituteCurrent && p2 instanceof BasicMateNamespace && ((BasicMateNamespace)p2).isCurrent()) {
            if ("@" == null) {
                DatabaseModelLoader.$$$reportNull$$$0(12);
            }
            return "@";
        }
        String string = p2.getName();
        if (string == null) {
            DatabaseModelLoader.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void updateModelVisibility(@NotNull DasModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(15);
        }
        if (model instanceof BasicModModel) {
            DatabaseModelLoader.updateModelVisibility((BasicModModel)model, scope);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static BasicNamespace[] getNamespacesToIntrospect(@NotNull LoaderContext context, @NotNull BasicModModel model) {
        List namespaces;
        boolean allSchemas;
        if (context == null) {
            DatabaseModelLoader.$$$reportNull$$$0(16);
        }
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(17);
        }
        if (context.isSchemaListOnly()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(18);
            }
            return NO_NAMESPACES;
        }
        if (context.getSelection().contains("*")) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(19);
            }
            return NO_NAMESPACES;
        }
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(DasObject.class).filterMap(o -> {
            DasObject db;
            DasObject sc = DasUtil.getSchemaObject((DasObject)o);
            DasObject dasObject = db = sc == null ? DasUtil.getCatalogObject((DasObject)o) : sc.getDasParent();
            if (db != null && db.getKind() != ObjectKind.DATABASE) {
                db = null;
            }
            if (sc == null && db == null) {
                return null;
            }
            return sc == null ? IntrospectionScope.scopeOf(db.getName(), "*") : IntrospectionScope.scopeOf(db == null ? "*" : db.getName(), sc.getName());
        });
        @NotNull JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s -> IntrospectionScopes.importScope(s));
        List scopes = fromStringPatterns.append((Iterable)fromDasObjects).unique().toList();
        boolean bl = allSchemas = !JBIterable.from((Iterable)scopes).filter(s -> s.containsSchema("*", "*")).isEmpty();
        if (allSchemas) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(20);
            }
            return NO_NAMESPACES;
        }
        JBIterable visibleNamespaces = ((JBTreeTraverser)model.traverser(false).expand(object -> !DbImplUtil.isSchema(object))).filter(BasicNamespace.class);
        int nonLimitedCount = visibleNamespaces.filter(n -> DbImplUtil.isSchema(n) || n.getKind() == ObjectKind.DATABASE && !n.hasChildren()).size();
        if (nonLimitedCount == (namespaces = visibleNamespaces.filter(object -> {
            if (DbImplUtil.isSchema(object)) {
                for (IntrospectionScope scope : scopes) {
                    if (!DatabaseModelLoader.schemaMatches(object, scope)) continue;
                    return true;
                }
            }
            if (object.getKind() == ObjectKind.DATABASE && !object.hasChildren()) {
                for (IntrospectionScope scope : scopes) {
                    if (!scope.containsDatabase(object.getName())) continue;
                    return true;
                }
            }
            return false;
        }).toList()).size()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(21);
            }
            return NO_NAMESPACES;
        }
        BasicNamespace[] basicNamespaceArray = namespaces.toArray(new BasicNamespace[0]);
        if (basicNamespaceArray == null) {
            DatabaseModelLoader.$$$reportNull$$$0(22);
        }
        return basicNamespaceArray;
    }

    private static Set<BasicDatabase> getDatabases(LoaderContext context) {
        if (context.getSelection().contains("*")) {
            return Collections.emptySet();
        }
        DasModel model = context.getDataSource().getModel();
        JBIterable sel = JBIterable.from(context.getSelection());
        return DatabaseModelLoader.getBasicElements((JBIterable<Object>)sel).filterMap(o -> o.getDatabase()).filter(o -> o.getModel() == model).append((Iterable)sel.filter(String.class).flatten(s -> DatabaseModelLoader.scopeToDatabases(model, IntrospectionScopes.importScope(s)))).toSet();
    }

    private static JBIterable<BasicElement> getBasicElements(JBIterable<Object> sel) {
        return sel.map(o -> {
            if (o instanceof DeObject) {
                o = ((DeObject)o).getEditedObject();
            }
            if (o instanceof DbElement) {
                o = ((DbElement)o).getDelegate();
            }
            return o;
        }).filter(BasicElement.class);
    }

    private static Set<BasicDatabase> getDatabasesFromScope(LoaderContext context) {
        LocalDataSource source = context.getDataSource();
        IntrospectionScope scope = source.getIntrospectionScope();
        if (scope.isEmpty()) {
            return Collections.emptySet();
        }
        DasModel model = source.getModel();
        JBIterable<BasicDatabase> dbs2 = DatabaseModelLoader.scopeToDatabases(model, scope);
        return dbs2.toSet();
    }

    @NotNull
    private static JBIterable<BasicDatabase> scopeToDatabases(DasModel model, IntrospectionScope scope) {
        JBIterable dbs2 = model.getModelRoots().filter(BasicDatabase.class);
        if (scope.containsDatabase("*")) {
            JBIterable jBIterable = dbs2;
            if (jBIterable == null) {
                DatabaseModelLoader.$$$reportNull$$$0(23);
            }
            return jBIterable;
        }
        JBIterable jBIterable = dbs2.filter(db -> db.isCurrent() && scope.containsDatabase("@") || scope.containsDatabase(db.getName()));
        if (jBIterable == null) {
            DatabaseModelLoader.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    static void updateModelVisibility(@NotNull BasicModModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(26);
        }
        model.modify(BasicModRoot.class, r -> {
            if (scope == null) {
                DatabaseModelLoader.$$$reportNull$$$0(30);
            }
            DatabaseModelLoader.updateDatabasesVisibility(r.familyOf(ObjectKind.DATABASE), scope);
            DatabaseModelLoader.updateSchemasVisibility(r.familyOf(ObjectKind.SCHEMA), null, scope);
            DatabaseModelLoader.updateSchemasVisibility(r.familyOf(ObjectKind.EXTERNAL_SCHEMA), null, scope);
        });
    }

    private static void updateDatabasesVisibility(@Nullable Family<? extends BasicElement> databases, @NotNull IntrospectionScope scope) {
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(27);
        }
        if (databases == null) {
            return;
        }
        boolean all = scope.containsDatabase("*");
        for (BasicModMateDatabase database : databases.jbi().filter(BasicModMateDatabase.class)) {
            boolean visible = all || scope.containsDatabase(database.getName()) || database.isCurrent() && scope.containsDatabase("@");
            database.setVisible(visible);
            DatabaseModelLoader.updateSchemasVisibility(database.familyOf(ObjectKind.SCHEMA), database, scope);
            DatabaseModelLoader.updateSchemasVisibility(database.familyOf(ObjectKind.EXTERNAL_SCHEMA), database, scope);
        }
    }

    private static void updateSchemasVisibility(@Nullable Family<? extends BasicElement> schemas2, @Nullable BasicDatabase database, @NotNull IntrospectionScope scope) {
        boolean hasDatabase;
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(28);
        }
        if (schemas2 == null) {
            return;
        }
        String db = database == null ? "*" : database.getName();
        boolean dbCurrent = database != null && database.isCurrent();
        boolean bl = hasDatabase = scope.containsDatabase(db) || dbCurrent && scope.containsDatabase("@");
        if (!hasDatabase) {
            schemas2.jbi().filter(BasicModMateNamespace.class).forEach(s -> s.setVisible(false));
            return;
        }
        for (BasicModMateNamespace schema : schemas2.jbi().filter(BasicModMateNamespace.class)) {
            boolean visible = scope.containsSchema(db, schema.getName());
            visible |= dbCurrent && scope.containsSchema("@", schema.getName());
            visible |= schema.isCurrent() && scope.containsSchema(db, "@");
            schema.setVisible(visible |= schema.isCurrent() && dbCurrent && scope.containsSchema("@", "@"));
        }
    }

    @NotNull
    private static DBIntrospectionOptions getIntrospectionOptions(LocalDataSource dataSource) {
        DBIntrospectionOptions.SourceLoading withSources = dataSource.getSourceLoading();
        DBIntrospectionOptions dBIntrospectionOptions = new DBIntrospectionOptions(withSources);
        if (dBIntrospectionOptions == null) {
            DatabaseModelLoader.$$$reportNull$$$0(29);
        }
        return dBIntrospectionOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 6: 
            case 14: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseModelLoader";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameOrCurrent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesToIntrospect";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeToDatabases";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "databaseMatches";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "schemaMatches";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateIntrospectionScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDbName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                break;
            }
            case 14: 
            case 15: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateModelVisibility";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesToIntrospect";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabasesVisibility";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateSchemasVisibility";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateModelVisibility$12";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class IntrospectionSession {
        public static final String SINGLE_DB_WARNING = "ignore.single.db.warning";
        private final LoaderContext myContext;
        private final ProgressIndicator myIndicator;
        private final TransactionId myTransactionId;
        private final DatabaseProcessor myProcessor;
        private DBIntrospector myIntrospector;
        private GuardedRef mySrcSession;
        private boolean myFirstTime;
        private boolean myUpdateScopeFromIntrospector;
        private boolean mySingleModeReported;

        public IntrospectionSession(@NotNull LoaderContext context, @NotNull ProgressIndicator indicator, @Nullable TransactionId transactionId) {
            if (context == null) {
                IntrospectionSession.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                IntrospectionSession.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myIndicator = indicator;
            this.myTransactionId = transactionId;
            this.mySingleModeReported = "true".equals(this.myContext.getDataSource().getAdditionalJdbcProperties().get(SINGLE_DB_WARNING));
            this.myProcessor = context.isOutdatedCheck() ? new OutdatedProcessor() : new IntrospectionProcessor();
        }

        public abstract void perform(@Nullable ObjectPath var1, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> var2) throws SQLException;

        public void run() throws SQLException {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Introspection should not be run in EDT");
            }
            this.myIndicator.checkCanceled();
            if (this.myContext.loadNothing()) {
                this.perform(null, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> {}));
                DatabaseModelLoader.updateModelVisibility(this.myContext.getDataSource().getModel(), this.myContext.getDataSource().getIntrospectionScope());
            } else {
                this.myContext.getDataSource().performBatch(() -> {
                    try {
                        this.introspect();
                    }
                    catch (SQLException e) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                        ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspect() throws SQLException {
            try {
                MultiMap tasks = MultiMap.createLinkedSet();
                ObjectPath initial = this.getInitialConnectionPath();
                this.perform(initial, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> this.withFacade((DatabaseConnection)connection2, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)facade -> {
                    try {
                        this.prepareIntrospection((DatabaseConnection)facade);
                        this.checkSingleDbModeNecessity(initial, connection2.getConnectionPoint(), this.myIntrospector.getCurrentDatabase());
                        this.myFirstTime = this.myIntrospector.getModel().getModelRoots().isEmpty();
                        this.myProcessor.processFirstDatabase();
                        this.distributeDatabaseTasks(this.myIntrospector.getCurrentDatabase(), (MultiMap<ObjectPath, BasicDatabase>)tasks);
                        if (tasks.isEmpty()) {
                            this.myProcessor.processDatabases(Collections.emptyList());
                        } else {
                            Collection databases = tasks.remove(null);
                            if (!ContainerUtil.isEmpty((Collection)databases)) {
                                this.myProcessor.processDatabases(databases);
                            }
                        }
                    }
                    finally {
                        if (this.myIntrospector != null) {
                            this.myIntrospector.detachFromDB();
                        }
                    }
                }))));
                boolean noReconnect = JdbcUrlParserUtil.isDatabaseBounded(this.myContext.getDataSource()) && !JdbcUrlParserUtil.isReboundable(this.myContext.getDataSource());
                for (Map.Entry task : tasks.entrySet()) {
                    if (task.getKey() == null || ((Collection)task.getValue()).isEmpty()) continue;
                    if (noReconnect) {
                        this.reportSingleDbModeInconsistent(tasks.keySet());
                        break;
                    }
                    this.reconnectAndIntrospectDatabases((ObjectPath)task.getKey(), (Collection)task.getValue());
                }
                String extra = this.myContext.isSchemaListOnly() ? " [schemas only]" : "";
                this.myIndicator.setText("Finishing introspection (" + this.myContext.getDbms().getName() + ")" + extra);
            }
            finally {
                if (this.mySrcSession != null) {
                    this.mySrcSession.close();
                }
            }
        }

        private void checkSingleDbModeNecessity(ObjectPath initialPath, DatabaseConnectionPoint point, String currentDb) {
            String db;
            if (this.mySingleModeReported || currentDb == null) {
                return;
            }
            if (!JdbcUrlParserUtil.isDatabaseBounded(point) || !JdbcUrlParserUtil.isReboundable(point)) {
                return;
            }
            String string = db = initialPath == null ? JdbcUrlParserUtil.getBoundParameter(point) : initialPath.name;
            if (db == null || db.equalsIgnoreCase(currentDb)) {
                return;
            }
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(this.myContext.getDataSource().getName(), "Connection to " + db + " expected, but connected to " + currentDb + ".<br>Multi database support may not work properly.<br><a href=ignore>Ignore</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=enable>Enable single database mode</a>", NotificationType.WARNING, (notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (event.getDescription().equals("ignore")) {
                    this.myContext.getDataSource().getAdditionalJdbcProperties().put(SINGLE_DB_WARNING, "true");
                } else if (event.getDescription().equals("enable")) {
                    this.setSingleDbMode(true);
                }
            }).notify(this.myContext.getProject());
            this.mySingleModeReported = true;
        }

        private void reportSingleDbModeInconsistent(Set<ObjectPath> set) {
            String ignored = StringUtil.join((Iterable)JBIterable.from(set).filter(Conditions.notNull()), ObjectPath::getDisplayName, (String)", ");
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(this.myContext.getDataSource().getName() + " is in the single database mode", "Databases ignored: " + ignored + "<br><a href=hide>Exclude from introspection</a><br><a href=disable>Disable single database mode</a>", NotificationType.WARNING, (notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (event.getDescription().equals("hide")) {
                    this.hideNamespaces(set);
                } else if (event.getDescription().equals("disable")) {
                    this.setSingleDbMode(false);
                }
            }).notify(this.myContext.getProject());
        }

        private void setSingleDbMode(boolean enable) {
            this.myContext.getDataSource().setRewriteBounds(!enable);
            DataSourceUiUtil.performAutoSyncTask(this.myContext);
        }

        private void hideNamespaces(Set<ObjectPath> set) {
            NamingFamily dbs2;
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)this.myContext.getDataSource().getModel(), BasicModel.class);
            NamingFamily namingFamily = dbs2 = model == null ? null : (NamingFamily)ObjectUtils.tryCast(model.getRoot().familyOf(ObjectKind.DATABASE), NamingFamily.class);
            if (dbs2 == null) {
                return;
            }
            JBIterable namespaces = JBIterable.from(set).filterMap(o -> o == null ? null : (BasicNamespace)dbs2.get(o.name));
            DataSourceUiUtil.setNamespacesVisible(this.myContext.getProject(), this.myContext.getDataSource(), (Iterable<? extends BasicNamespace>)namespaces, false);
        }

        @Nullable
        private ObjectPath getInitialConnectionPath() {
            Family databases;
            LocalDataSource dataSource = this.myContext.getDataSource();
            if (!JdbcUrlParserUtil.isDatabaseBounded(dataSource) || !JdbcUrlParserUtil.isReboundable(dataSource)) {
                return null;
            }
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)this.myContext.getDataSource().getModel(), BasicModel.class);
            Family family = databases = model == null ? null : (NamingFamily)ObjectUtils.tryCast(model.getRoot().familyOf(ObjectKind.DATABASE), NamingFamily.class);
            if (databases == null || databases.jbi().filter(BasicMateNamespace.class).filter(BasicMateNamespace::isVisible).isEmpty()) {
                return null;
            }
            IntrospectionScope scope = dataSource.getIntrospectionScope();
            MultiMap<String, String> scopeMap = scope.to((MultiMap<String, String>)MultiMap.createLinkedSet());
            MultiMap<String, String> contextMap = IntrospectionSession.contextToMap(this.myContext);
            String any = IntrospectionSession.getAnyFromIntersection(scopeMap.keySet(), contextMap.keySet(), databases);
            return any == null ? null : ObjectPath.create((String)any, (ObjectKind)ObjectKind.DATABASE);
        }

        @Nullable
        private static String getAnyFromIntersection(@NotNull Collection<String> set1, @NotNull Collection<String> set2, @NotNull NamingFamily<?> databases) {
            String any;
            if (set1 == null) {
                IntrospectionSession.$$$reportNull$$$0(2);
            }
            if (set2 == null) {
                IntrospectionSession.$$$reportNull$$$0(3);
            }
            if (databases == null) {
                IntrospectionSession.$$$reportNull$$$0(4);
            }
            if (set1.contains("@") || set2.contains("@")) {
                return null;
            }
            Condition existingDb = x -> {
                if (databases == null) {
                    IntrospectionSession.$$$reportNull$$$0(17);
                }
                if ("*".equals(x)) {
                    return false;
                }
                BasicMateNamespace db = (BasicMateNamespace)databases.get((String)x);
                return db != null && db.isVisible();
            };
            if (set2.contains("*") && (any = (String)ContainerUtil.find(set1, (Condition)existingDb)) != null) {
                return any;
            }
            if (set1.contains("*") && (any = (String)ContainerUtil.find(set2, (Condition)existingDb)) != null) {
                return any;
            }
            return (String)ContainerUtil.find((Iterable)JBIterable.from(set1).filter(set2::contains), (Condition)existingDb);
        }

        @NotNull
        private static MultiMap<String, String> contextToMap(@NotNull LoaderContext context) {
            if (context == null) {
                IntrospectionSession.$$$reportNull$$$0(5);
            }
            MultiMap map = MultiMap.createLinkedSet();
            for (Object o : context.getSelection()) {
                if (o instanceof DasObject) {
                    DasObject sc = DasUtil.getSchemaObject((DasObject)((DasObject)o));
                    DasObject db = DasUtil.getCatalogObject((DasObject)sc);
                    if (sc == null) continue;
                    map.putValue((Object)(db == null ? "*" : db.getName()), (Object)sc.getName());
                    continue;
                }
                if (!(o instanceof String)) continue;
                IntrospectionScopes.importScope((String)o).to((MultiMap<String, String>)map);
            }
            MultiMap multiMap = map;
            if (multiMap == null) {
                IntrospectionSession.$$$reportNull$$$0(6);
            }
            return multiMap;
        }

        private void reconnectAndIntrospectDatabases(@NotNull ObjectPath destination, @NotNull Collection<BasicDatabase> databases) throws SQLException {
            if (destination == null) {
                IntrospectionSession.$$$reportNull$$$0(7);
            }
            if (databases == null) {
                IntrospectionSession.$$$reportNull$$$0(8);
            }
            this.perform(destination, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> {
                if (destination == null) {
                    IntrospectionSession.$$$reportNull$$$0(13);
                }
                if (databases == null) {
                    IntrospectionSession.$$$reportNull$$$0(14);
                }
                this.withFacade((DatabaseConnection)connection2, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)facade -> {
                    if (destination == null) {
                        IntrospectionSession.$$$reportNull$$$0(15);
                    }
                    if (databases == null) {
                        IntrospectionSession.$$$reportNull$$$0(16);
                    }
                    this.myIndicator.setText("Performing " + (this.myFirstTime ? "complete" : "incremental") + " introspection (" + facade.getDbms().getDisplayName() + ") of " + destination.kind.code() + " " + destination.getName());
                    try {
                        this.myIntrospector.attachToDB((DatabaseConnection)facade);
                        this.checkSingleDbModeNecessity(destination, connection2.getConnectionPoint(), this.myIntrospector.getCurrentDatabase());
                        this.myProcessor.processDatabases(databases);
                    }
                    finally {
                        this.myIntrospector.detachFromDB();
                    }
                }));
            }));
        }

        private void distributeDatabaseTasks(@Nullable String currentDb, @NotNull MultiMap<ObjectPath, BasicDatabase> tasks) {
            DatabaseDriver driver;
            if (tasks == null) {
                IntrospectionSession.$$$reportNull$$$0(9);
            }
            DatabaseDriver.Bounds bounds = (driver = this.myContext.getDataSource().getDatabaseDriver()) == null ? null : driver.getConnectionBounds();
            Set<BasicDatabase> databases = this.getDatabasesForIntrospection();
            if (bounds == null || bounds.boundTo != ObjectKind.DATABASE) {
                tasks.put(null, databases);
                return;
            }
            for (BasicDatabase database : databases) {
                if (database.getName().equals(currentDb)) {
                    tasks.putValue(null, (Object)database);
                    continue;
                }
                tasks.putValue((Object)ObjectPaths.of(database), (Object)database);
            }
        }

        private Set<BasicDatabase> getDatabasesForIntrospection() {
            Set dbs2 = DatabaseModelLoader.getDatabases(this.myContext);
            return dbs2.isEmpty() ? DatabaseModelLoader.getDatabasesFromScope(this.myContext) : dbs2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspectDatabaseList() {
            IntrospectionScope firstScope;
            IntrospectionScope introspectionScope = firstScope = this.myContext.getDataSource().getIntrospectionScope();
            BasicModModel model = this.myIntrospector.getModel();
            try {
                this.myIntrospector.introspectNamespaces();
                this.updateCurrentDb(model);
                introspectionScope = this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
            }
            catch (Throwable throwable) {
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
                if (this.myUpdateScopeFromIntrospector) {
                    introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                } else if (!introspectionScope.equals(firstScope)) {
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                }
                throw throwable;
            }
            if (this.myUpdateScopeFromIntrospector) {
                introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            } else if (!introspectionScope.equals(firstScope)) {
                this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            }
        }

        private void updateCurrentDb(BasicModModel model) {
            Couple<String> fakeCurrent = this.getFakeCurrentSchema();
            if (fakeCurrent == null) {
                this.updateBoundedDb(model);
                return;
            }
            NamingFamily<? extends BasicMateNamespace> namespaces = model.getRoot().getNamespaces();
            if (namespaces.isEmpty()) {
                return;
            }
            if (!namespaces.jbi().filter(n -> n.isCurrent()).isEmpty()) {
                return;
            }
            if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                if (fakeCurrent.first != null) {
                    model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, (String)fakeCurrent.first, ObjectKind.DATABASE));
                }
            } else if (fakeCurrent.second != null) {
                model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, (String)fakeCurrent.second, ObjectKind.SCHEMA));
            }
        }

        private void updateBoundedDb(BasicModModel model) {
            if (!JdbcUrlParserUtil.isDatabaseBounded(this.myContext.getDataSource()) || !JdbcUrlParserUtil.isReboundable(this.myContext.getDataSource())) {
                return;
            }
            String db = JdbcUrlParserUtil.getBoundParameter(this.myContext.getDataSource());
            if (db == null) {
                return;
            }
            model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, db, ObjectKind.DATABASE));
        }

        private void setFakeCurrentSc(BasicModModel model) {
            Couple<String> fakeCurrent = this.getFakeCurrentSchema();
            if (fakeCurrent == null || fakeCurrent.second == null) {
                return;
            }
            BasicDatabase database = model.getRoot().getCurrentDatabase();
            if (database == null) {
                return;
            }
            model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r.mod(database), (String)fakeCurrent.second, ObjectKind.SCHEMA));
        }

        private static void setCurrent(BasicModElement parent2, String name, ObjectKind kind) {
            ModNamingFamily dbs2 = (ModNamingFamily)ObjectUtils.tryCast((Object)parent2.familyOf(kind), ModNamingFamily.class);
            if (dbs2 == null) {
                return;
            }
            for (BasicModNamedElement db : dbs2) {
                BasicModMateNamespace nsp = (BasicModMateNamespace)ObjectUtils.tryCast((Object)db, BasicModMateNamespace.class);
                if (nsp == null) continue;
                nsp.setCurrent(nsp.getName().equals(name));
            }
        }

        @Nullable
        private Couple<String> getFakeCurrentSchema() {
            return "GenericIntrospector".equals(this.myIntrospector.getClass().getSimpleName()) ? this.myContext.getDataSource().getFakeCurrentSchema() : null;
        }

        private void prepareIntrospection(@NotNull DatabaseConnection facade) {
            LocalDataSource dataSource;
            if (facade == null) {
                IntrospectionSession.$$$reportNull$$$0(10);
            }
            ModelFactory modelFactory = DbSrcModelStorage.createFactory((dataSource = this.myContext.getDataSource()).isGlobal() ? null : this.myContext.getProject(), dataSource.getUniqueId());
            DBIntrospectionOptions options = DatabaseModelLoader.getIntrospectionOptions(dataSource);
            this.initIntrospector(facade, dataSource, modelFactory, options);
        }

        private void initIntrospector(DatabaseConnection facade, LocalDataSource dataSource, ModelFactory modelFactory, DBIntrospectionOptions options) {
            DbSrcModelStorage storage;
            if (this.myIntrospector != null || this.mySrcSession != null) {
                throw new AssertionError((Object)"Already have introspector");
            }
            this.myIntrospector = DBIntrospectorFactory.createIntrospector(this.myContext.getProject(), modelFactory, facade, dataSource);
            this.myIntrospector.setOptions(options);
            this.myIntrospector.setErrorSink((PairConsumer<String, Throwable>)((PairConsumer)this.myContext.getErrorHandler()::addError));
            this.myIntrospector.setProgressIndicator(this.myIndicator);
            BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class);
            this.myIntrospector.init(model);
            model = this.myIntrospector.getModel();
            if (model != dataSource.getModel()) {
                dataSource.setModel(model);
            }
            if ((storage = (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class)) != null) {
                this.mySrcSession = storage.startWriteSession(model, this.myTransactionId, false);
            }
        }

        private void withFacade(@NotNull DatabaseConnection connection2, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> consumer2) {
            if (connection2 == null) {
                IntrospectionSession.$$$reportNull$$$0(11);
            }
            if (consumer2 == null) {
                IntrospectionSession.$$$reportNull$$$0(12);
            }
            try {
                consumer2.consume((Object)connection2);
            }
            catch (Throwable e) {
                AsyncUtil.addUnhandledError(this.myContext.getErrorHandler(), e, this.myContext.getDataSource().getName(), this.myContext.getDbms());
                throw new ProcessCanceledException();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set2";
                    break;
                }
                case 4: 
                case 8: 
                case 14: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "databases";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession";
                    break;
                }
                case 7: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextToMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnyFromIntersection";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "contextToMap";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "reconnectAndIntrospectDatabases";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "distributeDatabaseTasks";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareIntrospection";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "withFacade";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$reconnectAndIntrospectDatabases$9";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$8";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getAnyFromIntersection$7";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class OutdatedProcessor
        implements DatabaseProcessor {
            private OutdatedProcessor() {
            }

            @Override
            public void processFirstDatabase() {
                IntrospectionSession.this.myIndicator.setText("Preparing to validity check introspection (" + IntrospectionSession.this.myContext.getDbms().getDisplayName() + ")");
            }

            private JBIterable<BasicElement> extract() {
                return JBIterable.from(IntrospectionSession.this.myContext.getSelection()).filterMap(o -> DbImplUtil.getMaybeBasicElement((DasObject)ObjectUtils.tryCast((Object)o, DasObject.class)));
            }

            @Override
            public void processDatabases(@NotNull Collection<BasicDatabase> dbs2) {
                if (dbs2 == null) {
                    OutdatedProcessor.$$$reportNull$$$0(0);
                }
                JBIterable elements = this.extract();
                if (!dbs2.isEmpty()) {
                    elements = elements.filter(e -> {
                        if (dbs2 == null) {
                            OutdatedProcessor.$$$reportNull$$$0(1);
                        }
                        return dbs2.contains(e.getDatabase());
                    });
                }
                IntrospectionSession.this.myIntrospector.retrieveInvalid((Iterable<? extends BasicElement>)elements);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dbs";
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession$OutdatedProcessor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDatabases";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$processDatabases$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class IntrospectionProcessor
        implements DatabaseProcessor {
            private IntrospectionProcessor() {
            }

            @Override
            public void processFirstDatabase() {
                IntrospectionSession.this.myIntrospector.introspectSessionState();
                IntrospectionSession.this.myIndicator.setText("Preparing to " + (IntrospectionSession.this.myFirstTime ? "complete" : "incremental") + " introspection (" + IntrospectionSession.this.myContext.getDbms().getDisplayName() + ")");
                IntrospectionSession.this.introspectDatabaseList();
                if (!IntrospectionSession.this.myContext.isSchemaListOnly()) {
                    IntrospectionSession.this.myIndicator.setText("Introspecting server objects");
                    IntrospectionSession.this.myIntrospector.introspectServerObjects();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processDatabases(@NotNull Collection<BasicDatabase> dbs2) {
                IntrospectionScope firstScope;
                if (dbs2 == null) {
                    IntrospectionProcessor.$$$reportNull$$$0(0);
                }
                IntrospectionScope introspectionScope = firstScope = IntrospectionSession.this.myContext.getDataSource().getIntrospectionScope();
                BasicModModel model = IntrospectionSession.this.myIntrospector.getModel();
                BasicDatabase[] databases = (BasicDatabase[])ContainerUtil.toArray(dbs2, BasicDatabase[]::new);
                try {
                    if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                        IntrospectionSession.this.myIntrospector.introspectDatabaseSchemas(databases);
                        IntrospectionSession.this.setFakeCurrentSc(model);
                        introspectionScope = IntrospectionSession.this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                    }
                }
                finally {
                    if (IntrospectionSession.this.myUpdateScopeFromIntrospector) {
                        introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                        IntrospectionSession.this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                    } else if (!introspectionScope.equals(firstScope)) {
                        IntrospectionSession.this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                    }
                }
                DatabaseModelLoader.updateModelVisibility(model, introspectionScope);
                if (IntrospectionSession.this.myContext.isSchemaListOnly()) {
                    return;
                }
                Object[] namespaces = DatabaseModelLoader.getNamespacesToIntrospect(IntrospectionSession.this.myContext, model);
                if (!dbs2.isEmpty()) {
                    Collection<Object> current = JBIterable.of((Object[])namespaces).filter(n -> {
                        if (dbs2 == null) {
                            IntrospectionProcessor.$$$reportNull$$$0(1);
                        }
                        return dbs2.contains(n) || dbs2.contains(n.getParent());
                    }).toList();
                    if (current.isEmpty()) {
                        current = dbs2;
                    }
                    namespaces = current.toArray(new BasicNamespace[0]);
                }
                IntrospectionSession.this.myIntrospector.introspectAuto((BasicNamespace[])namespaces);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dbs";
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession$IntrospectionProcessor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDatabases";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$processDatabases$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static interface DatabaseProcessor {
            public void processFirstDatabase();

            public void processDatabases(@NotNull Collection<BasicDatabase> var1);
        }
    }
}

