/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gems;

import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.gems.GemsUmlDataModel;
import com.intellij.diagram.gems.GemsUmlDummyModel;
import com.intellij.diagram.gems.GemsUmlElementManager;
import com.intellij.diagram.gems.GemsUmlVfsResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public class GemsUmlDiagramProvider
extends BaseDiagramProvider<RClass> {
    private static final String ID = "GemsDependency";
    private final GemsUmlElementManager myElementManager = new GemsUmlElementManager();
    private final DiagramVfsResolver<RClass> myVfsResolver = new GemsUmlVfsResolver();

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramElementManager<RClass> getElementManager() {
        return this.myElementManager;
    }

    public DiagramVfsResolver<RClass> getVfsResolver() {
        return this.myVfsResolver;
    }

    public String getPresentableName() {
        return "Gem model dependency diagram";
    }

    public DiagramDataModel<RClass> createDataModel(@NotNull Project project, @Nullable RClass element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            GemsUmlDiagramProvider.$$$reportNull$$$0(0);
        }
        GemsUmlDummyModel dummyModel = (GemsUmlDummyModel)element;
        return new GemsUmlDataModel(dummyModel.getModule(), dummyModel.getGem());
    }

    @Nullable
    public static DiagramProvider<RClass> getInstance() {
        return GemsUmlDiagramProvider.findByID((String)ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagram/gems/GemsUmlDiagramProvider", "createDataModel"));
    }
}

