/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.detector;

import b.h.la;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.detector.ImplicitRequireGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class RubyGemDetector
implements GemDetector {
    private static final Logger j;
    @NonNls
    private static final String h = "gem";
    @NonNls
    private static final String i = "gemspec";
    @NonNls
    private static final String a = "path";
    @NonNls
    private static final String d = "group";
    @NonNls
    private static final String e = "run";
    @NonNls
    private static final String b = "env";
    @NonNls
    private static final String g = "platform";
    @NonNls
    private static final String f = "platforms";
    private static final Set<String> c;
    private static final long k;

    @Override
    @NotNull
    public Set<GemDependency> detect(@NotNull Project project, @Nullable Sdk sdk, @Nullable VirtualFile file) {
        if (project == null) {
            RubyGemDetector.a(0);
        }
        if (file == null || !(file.getFileType() instanceof AbstractRubyFileType)) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                RubyGemDetector.a(1);
            }
            return set;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        ApplicationManager.getApplication().runReadAction(() -> {
            long l2 = k ^ 0x37196143912BL;
            if (project == null) {
                RubyGemDetector.a(9);
            }
            if (project.isDisposed() || !file.isValid()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return;
            }
            List<String> list2 = RubyGemDetector.a(psiFile);
            rubyPsiInterpreter.interpret((PsiElement)psiFile, new DetectorCallable(linkedHashMap, sdk, list2));
            for (ImplicitRequireGemProvider implicitRequireGemProvider : ImplicitRequireGemProvider.EP_NAME.getExtensionList()) {
                linkedHashMap.putAll(implicitRequireGemProvider.getImplicitDependency((RFile)psiFile));
            }
            if (!linkedHashMap.containsKey("bundler") && BundlerUtil.isGemfile(project, file)) {
                linkedHashMap.put("bundler", GemDependency.any("bundler"));
            }
        });
        HashSet<GemDependency> hashSet = new HashSet<GemDependency>(linkedHashMap.values());
        if (hashSet == null) {
            RubyGemDetector.a(2);
        }
        return hashSet;
    }

    @NotNull
    private static List<String> a(PsiFile psiFile) {
        Module module;
        List<String> list2 = BundlerUtil.isGemfile((PsiFileSystemItem)psiFile) ? ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) != null ? BundlerUtil.getIgnoredGroupsFromConfig(module) : Collections.emptyList()) : Collections.emptyList();
        List<String> list3 = list2;
        if (list3 == null) {
            RubyGemDetector.a(3);
        }
        return list3;
    }

    public static boolean isGemSupportedBySdk(@NotNull String name, @Nullable GemDependency dependency, @Nullable Sdk sdk) {
        String[] stringArray;
        long l2 = k ^ 0x2EC603B52982L;
        if (name == null) {
            RubyGemDetector.a(4);
        }
        String[] stringArray2 = stringArray = dependency != null ? dependency.getPlatforms() : null;
        if (stringArray != null) {
            List<String> list2 = Arrays.asList(stringArray);
            if (list2.contains("java") && list2.contains("ruby")) {
                return false;
            }
            for (String string : stringArray) {
                if (!("jruby".equals(string) && JRubySdkUtil.isJRubySDK(sdk) || "java".equals(string) && JRubySdkUtil.isJRubySDK(sdk) || "ruby".equals(string) && RubySdkUtil.isRubySDK(sdk) || "mswin".equals(string) && SystemInfo.isWindows || "mingw".equals(string) && SystemInfo.isWindows || string.endsWith("_19") && RubySdkUtil.isRuby19(sdk)) && (!string.endsWith("_18") || !RubySdkUtil.isRuby18(sdk))) continue;
                return true;
            }
            return false;
        }
        return !name.endsWith("19") || RubySdkUtil.isRuby19(sdk);
    }

    @Nullable
    public static GemDependency buildRequirement(String gemName, List<? extends RPsiElement> arguments, String[] platforms, String[] groups, String path, boolean canIgnoreLocker, @NotNull List<String> ignoredGroups) {
        Module module;
        if (ignoredGroups == null) {
            RubyGemDetector.a(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)arguments.get(0)))) == null || RubyGemDetector.a(groups, ignoredGroups)) {
            return null;
        }
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module);
        GemDependency gemDependency = bundlerGitLockReader.getDependency(gemName);
        if (bundlerGitLockReader.isLocked() && BundlerUtil.isGemfile((PsiFileSystemItem)arguments.get(0).getContainingFile()) && (!canIgnoreLocker || gemDependency != null)) {
            return gemDependency;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i10 = 1; i10 < arguments.size(); ++i10) {
            RPsiElement rPsiElement = arguments.get(i10);
            if (!(rPsiElement instanceof RStringLiteral)) continue;
            arrayList.add(TextUtil.removeQuoting(rPsiElement.getText()));
        }
        return GemDependency.create(gemName, ArrayUtil.toStringArray(arrayList), path, null, false, null, true, path != null, platforms);
    }

    private static boolean a(String[] stringArray, List<String> list2) {
        if (stringArray == null || stringArray.length == 0 || list2.size() == 0) {
            return false;
        }
        boolean bl2 = true;
        for (String string : stringArray) {
            bl2 &= list2.contains(string);
        }
        return bl2;
    }

    @Nullable
    private static GemDependency a(List<? extends RPsiElement> list2, int n2, String string, String[] stringArray, String[] stringArray2, String string2, boolean bl2, @NotNull List<String> list3) {
        Module module;
        long l2 = k ^ 0x4B7575A4A10AL;
        if (list3 == null) {
            RubyGemDetector.a(6);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)list2.get(0)))) == null) {
            return null;
        }
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module);
        GemDependency gemDependency = bundlerGitLockReader.getDependency(string);
        if (!bl2 && bundlerGitLockReader.isLocked() && gemDependency == null && BundlerUtil.isGemfile((PsiFileSystemItem)list2.get(0).getContainingFile())) {
            return null;
        }
        String string3 = gemDependency != null ? gemDependency.getVersionString() : null;
        String string4 = null;
        Object object = null;
        boolean bl3 = gemDependency != null && gemDependency.isGit();
        boolean bl4 = false;
        boolean bl5 = true;
        String string5 = gemDependency != null ? gemDependency.getRef() : null;
        for (int i10 = 1; i10 < n2; ++i10) {
            Object object2;
            String string6;
            RPsiElement rPsiElement = list2.get(i10);
            if (!(rPsiElement instanceof RAssoc)) continue;
            RAssoc rAssoc = (RAssoc)rPsiElement;
            RPsiElement rPsiElement2 = rAssoc.getKey();
            RPsiElement rPsiElement3 = rAssoc.getValue();
            if (rPsiElement2 == null || rPsiElement3 == null) continue;
            String string7 = string6 = rPsiElement2 instanceof RSymbol ? ((RSymbol)rPsiElement2).getValue() : rPsiElement2.getText();
            if ("version".equals(string6)) {
                string3 = gemDependency != null ? gemDependency.getVersionString() : rPsiElement3.getText();
                continue;
            }
            if ("source".equals(string6)) {
                string4 = rPsiElement3.getText();
                continue;
            }
            if (a.equals(string6)) {
                object2 = rAssoc.getContainingFile();
                VirtualFile virtualFile = object2.getVirtualFile();
                String string8 = TextUtil.trimTrailingSlashes(RFileUtil.evaluateRequirement(virtualFile, (PsiElement)rPsiElement3));
                if (string8.isEmpty()) {
                    string8 = string2;
                }
                string4 = string8.isEmpty() && gemDependency != null ? gemDependency.getUrl() : GemUtil.getGemUrlFromPath(string8, virtualFile.getParent());
                bl4 = true;
                continue;
            }
            if ("lib".equals(string6) || "require".equals(string6) || "require_as".equals(string6)) {
                object2 = rPsiElement3.getText();
                if ("false".equals(object2)) {
                    bl5 = false;
                    continue;
                }
                if ("true".equals(object2)) continue;
                object = object2;
                continue;
            }
            if ("git".equals(string6) || "github".equals(string6)) {
                bl3 = true;
                continue;
            }
            if ("ref".equals(string6) || "branch".equals(string6) || "tag".equals(string6)) {
                if (string5 != null) continue;
                string5 = rPsiElement3.getText();
                continue;
            }
            if (g.equals(string6) || f.equals(string6)) {
                stringArray = RubyGemDetector.c(rPsiElement3);
                continue;
            }
            if (!d.equals(string6) && !"groups".equals(string6)) continue;
            stringArray2 = RubyGemDetector.c(rPsiElement3);
        }
        if (RubyGemDetector.a(stringArray2, list3)) {
            return null;
        }
        if (string3 == null) {
            return GemDependency.any(string, TextUtil.removeQuoting(string4), TextUtil.removeQuoting(object), bl3, TextUtil.removeQuoting(string5), bl5, bl4, stringArray);
        }
        return GemDependency.create(string, new String[]{TextUtil.removeQuoting(string3)}, TextUtil.removeQuoting(string4), TextUtil.removeQuoting(object), bl3, TextUtil.removeQuoting(string5), bl5, bl4, stringArray);
    }

    private static String[] c(RPsiElement rPsiElement2) {
        if (rPsiElement2 instanceof RArray) {
            RArray rArray = (RArray)rPsiElement2;
            return (String[])ContainerUtil.map2Array((Collection)rArray.getElements(), String.class, rPsiElement -> RubyPsiUtil.getElementText((PsiElement)rPsiElement));
        }
        return new String[]{RubyPsiUtil.getElementText((PsiElement)rPsiElement2)};
    }

    @Nullable
    public static GemDependency buildRequirement(@NotNull RPossibleCall possibleCall, boolean canIgnoreLocker, @Nullable List<String> ignoredGroups) {
        String[] stringArray2;
        List list2;
        if (possibleCall == null) {
            RubyGemDetector.a(7);
        }
        if ((list2 = possibleCall.getArguments()).isEmpty()) {
            return null;
        }
        String string = RCallArguments.evaluateSimpleStringElement((PsiElement)list2.get(0));
        if (StringUtil.isEmpty((String)string) || !GemUtil.NAME_PATTERN.matcher(string).matches()) {
            return null;
        }
        if (ignoredGroups == null) {
            PsiFile psiFile = possibleCall.getContainingFile();
            ignoredGroups = RubyGemDetector.a(psiFile);
        }
        boolean bl2 = false;
        for (String[] stringArray2 : list2) {
            bl2 |= stringArray2 instanceof RAssoc;
        }
        String[] stringArray3 = RubyGemDetector.c(possibleCall);
        stringArray2 = RubyGemDetector.a(possibleCall);
        String string2 = RubyGemDetector.b(possibleCall);
        if (bl2) {
            return RubyGemDetector.a(list2, list2.size(), string, stringArray3, stringArray2, string2 != null ? string2 : "", canIgnoreLocker, ignoredGroups);
        }
        return RubyGemDetector.buildRequirement(string, list2, stringArray3, stringArray2, string2, canIgnoreLocker, ignoredGroups);
    }

    @Nullable
    private static String[] a(RPossibleCall rPossibleCall, String string, String string2) {
        RBlockCall rBlockCall = RBlockCallNavigator.getByCall((RPsiElement)rPossibleCall);
        while (rBlockCall != null) {
            RCall rCall;
            if (rPossibleCall instanceof RCall && (string.equals((rCall = (RCall)rPossibleCall).getCommand()) || string2.equals(rCall.getCommand()))) {
                return (String[])ContainerUtil.map2Array((Collection)rCall.getArguments(), String.class, rPsiElement -> RubyPsiUtil.getElementText((PsiElement)rPsiElement));
            }
            rBlockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rBlockCall, RBlockCall.class, (boolean)true);
        }
        return null;
    }

    @Nullable
    private static String[] c(RPossibleCall rPossibleCall) {
        long l2 = k ^ 0x67AA6AFCF8A7L;
        return RubyGemDetector.a(rPossibleCall, g, f);
    }

    @Nullable
    private static String[] a(RPossibleCall rPossibleCall) {
        long l2 = k ^ 0x690A913254F6L;
        return RubyGemDetector.a(rPossibleCall, d, d);
    }

    @Nullable
    private static String b(RPossibleCall rPossibleCall) {
        long l2 = k ^ 0x73D9A9BB3E71L;
        String[] stringArray = RubyGemDetector.a(rPossibleCall, a, a);
        return stringArray != null && stringArray.length == 1 ? stringArray[0] : null;
    }

    @Override
    public boolean accepts(@NotNull VirtualFile providerCandidate) {
        if (providerCandidate == null) {
            RubyGemDetector.a(8);
        }
        return providerCandidate.getFileType() instanceof AbstractRubyFileType;
    }

    static {
        k = la.a(-5108577204218504713L, -1170170859141692265L, MethodHandles.lookup().lookupClass()).a(241469944513959L);
        long l2 = k ^ 0x19ED5AEB9D2L;
        j = Logger.getInstance(RubyGemDetector.class);
        c = new HashSet<String>(Arrays.asList(d, e, b, g, f, a));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x3C4F69452927L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/detector/RubyGemDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredGroups";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCandidate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/detector/RubyGemDetector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroups";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGemSupportedBySdk";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildRequirement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildRailsRequirement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detect$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DetectorCallable
    implements PsiCallable {
        private final Map<String, GemDependency> a;
        private final Sdk b;
        private final List<String> c;
        private static final long d = la.a(7512931007138403823L, 2864676646936232584L, MethodHandles.lookup().lookupClass()).a(240273300418210L);

        public DetectorCallable(Map<String, GemDependency> deps, @Nullable Sdk sdk, List<String> ignoredGroups) {
            this.a = deps;
            this.b = sdk;
            this.c = ignoredGroups;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = d ^ 0x231145AAB86DL;
            String string = arguments.getCommand();
            if (arguments.hasBlock() && c.contains(string)) {
                arguments.interpretBlockWithGivenSelf(this, new PsiCallable[0]);
                return;
            }
            if (RubyGemDetector.h.equals(string)) {
                GemDependency gemDependency = null;
                PsiElement psiElement = arguments.getRCallElement();
                if (psiElement instanceof RPossibleCall) {
                    gemDependency = RubyGemDetector.buildRequirement((RPossibleCall)psiElement, false, this.c);
                }
                if (gemDependency == null) {
                    return;
                }
                if (!RubyGemDetector.isGemSupportedBySdk(gemDependency.getName(), gemDependency, this.b)) {
                    return;
                }
                j.debug("Detected requirement : " + gemDependency);
                this.a.put(gemDependency.getName(), gemDependency);
            } else if (RubyGemDetector.i.equals(string)) {
                this.b(arguments);
            } else if ("require".equals(string)) {
                this.a(arguments);
            }
        }

        private void a(RCallArguments rCallArguments) {
            String string;
            long l2 = d ^ 0x5302AA33C2CBL;
            PsiElement psiElement = rCallArguments.getRCallElement();
            VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (virtualFile == null || BundlerUtil.isGemfile(psiElement.getProject(), virtualFile) || module == null) {
                return;
            }
            String string2 = string = psiElement instanceof RCall ? RFileUtil.evaluateRequirePath(virtualFile, (RCall)psiElement) : null;
            if (string == null) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            Collection<GemInfo> collection = GemManager.getInstance().getAllGems(sdk, module);
            for (GemInfo gemInfo : collection) {
                VirtualFile virtualFile2 = gemInfo.getLibFolder();
                if (virtualFile2 == null || !virtualFile2.isValid()) continue;
                VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(string + RFileUtil.RB_FILE_SUFFIX);
                if (virtualFile3 != null && !virtualFile3.isDirectory()) {
                    this.a.put(gemInfo.getName(), GemDependency.any(gemInfo.getName()));
                    return;
                }
                virtualFile3 = virtualFile2.findFileByRelativePath(string);
                if (virtualFile3 != null && !virtualFile3.isDirectory()) {
                    this.a.put(gemInfo.getName(), GemDependency.any(gemInfo.getName()));
                    return;
                }
                virtualFile3 = virtualFile2.findFileByRelativePath(string + ".so");
                if (virtualFile3 == null || virtualFile3.isDirectory()) continue;
                this.a.put(gemInfo.getName(), GemDependency.any(gemInfo.getName()));
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void b(RCallArguments rCallArguments) {
            VirtualFile virtualFile;
            long l2 = d ^ 0x35892DCA19C7L;
            PsiElement psiElement = rCallArguments.getCallElement();
            VirtualFile virtualFile2 = psiElement.getContainingFile().getVirtualFile();
            VirtualFile virtualFile3 = virtualFile = virtualFile2 != null ? virtualFile2.getParent() : null;
            if (virtualFile != null) {
                RPsiElement rPsiElement;
                RPsiElement rPsiElement2;
                Object object;
                List<RPsiElement> list2 = rCallArguments.getArguments();
                String string = null;
                String string2 = null;
                if (list2.size() > 0) {
                    for (RPsiElement virtualFile42 : list2) {
                        if (!(virtualFile42 instanceof RAssoc)) continue;
                        object = (RAssoc)virtualFile42;
                        rPsiElement2 = object.getKey();
                        rPsiElement = object.getValue();
                        if (rPsiElement2 == null || rPsiElement == null) continue;
                        String string3 = rPsiElement2.getText();
                        if (":name".equals(string3)) {
                            string = rPsiElement.getText();
                            continue;
                        }
                        if (!":path".equals(string3)) continue;
                        string2 = rPsiElement.getText();
                    }
                }
                Object object2 = virtualFile;
                if (string2 != null) {
                    void var11_13;
                    VirtualFile virtualFile4 = virtualFile.findFileByRelativePath(string2);
                    if (virtualFile4 == null) {
                        VirtualFile virtualFile5 = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl(string2));
                    }
                    if (var11_13 != null) {
                        object2 = var11_13;
                    }
                }
                VirtualFile virtualFile6 = string == null ? GemUtil.getSpecFile((VirtualFile)object2) : object2.findChild(string + ".gemspec");
                object = GemSpecParser.getInstance().getGemSpec(virtualFile, virtualFile6, true);
                rPsiElement2 = object != null ? (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)object) : null;
                rPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (rPsiElement2 != null && rPsiElement != null) {
                    for (GemDependency gemDependency : rPsiElement2) {
                        if (gemDependency == null || !RubyGemDetector.isGemSupportedBySdk(gemDependency.getName(), gemDependency, this.b)) continue;
                        GemDependency gemDependency2 = BundlerGitLockReader.getInstance((Module)rPsiElement).getDependency(string);
                        gemDependency = gemDependency2 != null ? gemDependency2 : gemDependency;
                        j.debug("Detected requirement from gemspec: " + gemDependency);
                        this.a.put(gemDependency.getName(), gemDependency);
                    }
                }
            }
        }
    }
}

