/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalParameterSet {
    private HashMap<StructuredQName, Object> params = new HashMap(10);

    public void put(StructuredQName qName, Object value) {
        if (value == null) {
            this.params.remove(qName);
        } else {
            this.params.put(qName, value);
        }
    }

    public Object get(StructuredQName qName) {
        return this.params.get(qName);
    }

    public boolean containsKey(StructuredQName qName) {
        return this.params.containsKey(qName);
    }

    public Sequence convertParameterValue(StructuredQName qName, SequenceType requiredType, boolean convert, XPathContext context) throws XPathException {
        Sequence val;
        Object obj = this.get(qName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            val = (EmptySequence)obj;
        } else if (obj instanceof String && convert) {
            val = new UntypedAtomicValue((String)obj);
        } else if (requiredType.getPrimaryType() instanceof ExternalObjectType) {
            val = new ObjectValue(obj);
        } else {
            JPConverter converter = JPConverter.allocate(obj.getClass(), context.getConfiguration());
            val = converter.convert(obj, context);
        }
        if (val == null) {
            val = EmptySequence.getInstance();
        }
        if (requiredType != null) {
            if (convert) {
                RoleLocator role = new RoleLocator(3, qName.getDisplayName(), -1);
                Configuration config = context.getConfiguration();
                val = config.getTypeHierarchy().applyFunctionConversionRules(val, requiredType, role, null);
            } else {
                XPathException err = TypeChecker.testConformance(val, requiredType, context);
                if (err != null) {
                    throw err;
                }
            }
        }
        return val;
    }

    public void clear() {
        this.params.clear();
    }

    public Collection<StructuredQName> getKeys() {
        return this.params.keySet();
    }

    public int getNumberOfKeys() {
        return this.params.size();
    }
}

