/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.naming.NamingException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.ejb.access.AbstractSlsbInvokerInterceptor;
import org.springframework.ejb.access.EjbAccessException;

public class LocalSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    private volatile boolean homeAsComponent = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        EJBLocalObject ejb = null;
        try {
            try {
                ejb = this.getSessionBeanInstance();
                Method method = invocation.getMethod();
                if (method.getDeclaringClass().isInstance(ejb)) {
                    Object object2 = method.invoke((Object)ejb, invocation.getArguments());
                    Object var7_10 = null;
                    this.releaseSessionBeanInstance(ejb);
                    return object2;
                }
                Method ejbMethod = ejb.getClass().getMethod(method.getName(), method.getParameterTypes());
                object = ejbMethod.invoke((Object)ejb, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                Throwable targetEx = ex.getTargetException();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method of local EJB [" + this.getJndiName() + "] threw exception"), targetEx);
                }
                if (!(targetEx instanceof CreateException)) throw targetEx;
                throw new EjbAccessException("Could not create local EJB [" + this.getJndiName() + "]", targetEx);
            }
            catch (NamingException ex) {
                throw new EjbAccessException("Failed to locate local EJB [" + this.getJndiName() + "]", ex);
            }
            catch (IllegalAccessException ex) {
                throw new EjbAccessException("Could not access method [" + invocation.getMethod().getName() + "] of local EJB [" + this.getJndiName() + "]", ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.releaseSessionBeanInstance(ejb);
            throw throwable;
        }
        Object var7_11 = null;
        this.releaseSessionBeanInstance(ejb);
        return object;
    }

    protected Method getCreateMethod(Object home) throws EjbAccessException {
        if (this.homeAsComponent) {
            return null;
        }
        if (!(home instanceof EJBLocalHome)) {
            this.homeAsComponent = true;
            return null;
        }
        return super.getCreateMethod(home);
    }

    protected EJBLocalObject getSessionBeanInstance() throws NamingException, InvocationTargetException {
        return this.newSessionBeanInstance();
    }

    protected void releaseSessionBeanInstance(EJBLocalObject ejb) {
        this.removeSessionBeanInstance(ejb);
    }

    protected EJBLocalObject newSessionBeanInstance() throws NamingException, InvocationTargetException {
        Object ejbInstance;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Trying to create reference to local EJB");
        }
        if (!((ejbInstance = this.create()) instanceof EJBLocalObject)) {
            throw new EjbAccessException("EJB instance [" + ejbInstance + "] is not a local SLSB");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained reference to local EJB: " + ejbInstance));
        }
        return (EJBLocalObject)ejbInstance;
    }

    protected void removeSessionBeanInstance(EJBLocalObject ejb) {
        if (ejb != null && !this.homeAsComponent) {
            try {
                ejb.remove();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not invoke 'remove' on local EJB proxy", ex);
            }
        }
    }
}

