/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;

public class TonicLookAndFeelController
extends DefaultLookAndFeelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TonicLookAndFeelController.class);
    private static final ILogger s_log = LoggerController.createLogger(TonicLookAndFeelController.class);
    public static final String TONIC_LAF_CLASS_NAME = "com.digitprop.tonic.TonicLookAndFeel";
    private TonicPreferences _prefs;

    TonicLookAndFeelController(LAFPlugin plugin) throws IOException {
        XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
        Iterator it = cache.getAllForClass(TonicPreferences.class);
        if (it.hasNext()) {
            this._prefs = (TonicPreferences)it.next();
        } else {
            this._prefs = new TonicPreferences();
            try {
                cache.add((IHasIdentifier)this._prefs);
            }
            catch (DuplicateObjectException ex) {
                s_log.error((Object)"TonicPreferences object already in XMLObjectCache", (Throwable)ex);
            }
        }
    }

    @Override
    public void aboutToBeInstalled(LAFRegister lafRegister, LookAndFeel laf) {
    }

    @Override
    public void hasBeenInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        UIManager.getDefaults().put("TabbedPane.thickBorders", (Object)this._prefs.getUseTabbedPaneThickBorders());
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return new TonicPrefsPanel(this);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    public static final class TonicPreferences
    implements IHasIdentifier {
        private boolean _useTabbedPaneThickBorders = false;
        private IntegerIdentifier _id = new IntegerIdentifier(1);

        public boolean getUseTabbedPaneThickBorders() {
            return this._useTabbedPaneThickBorders;
        }

        public void setUseTabbedPaneThickBorders(boolean value) {
            this._useTabbedPaneThickBorders = value;
        }

        public IIdentifier getIdentifier() {
            return this._id;
        }
    }

    private static final class TonicPrefsPanel
    extends BaseLAFPreferencesPanelComponent {
        private static final long serialVersionUID = 1L;
        private TonicLookAndFeelController _ctrl;
        private JCheckBox _useThickBordersChk = new JCheckBox(TonicLookAndFeelController.access$000().getString("laf.tonicUseThickBorders"));

        TonicPrefsPanel(TonicLookAndFeelController ctrl) {
            super(new GridBagLayout());
            this._ctrl = ctrl;
            this.createUserInterface();
        }

        private void createUserInterface() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this._useThickBordersChk, gbc);
        }

        @Override
        public void loadPreferencesPanel() {
            super.loadPreferencesPanel();
            this._useThickBordersChk.setSelected(this._ctrl._prefs.getUseTabbedPaneThickBorders());
        }

        @Override
        public boolean applyChanges() {
            super.applyChanges();
            this._ctrl._prefs.setUseTabbedPaneThickBorders(this._useThickBordersChk.isSelected());
            return true;
        }

        static interface SkinPrefsPanelI18n {
        }
    }
}

