<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns="http://www.tei-c.org/ns/1.0"
  xmlns:s="http://www.ascc.net/xml/schematron"
  xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0"
  xmlns:edate="http://exslt.org/dates-and-times" xmlns:estr="http://exslt.org/strings"
  xmlns:exsl="http://exslt.org/common" xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:html="http://www.w3.org/1999/xhtml" xmlns:local="http://www.pantor.com/ns/local"
  xmlns:rng="http://relaxng.org/ns/structure/1.0" xmlns:tei="http://www.tei-c.org/ns/1.0"
  xmlns:teix="http://www.tei-c.org/ns/Examples" xmlns:xd="http://www.pnp-software.com/XSLTdoc"
  xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  exclude-result-prefixes="exsl estr edate fo s a xd tei html rng local teix xs"
  extension-element-prefixes="edate exsl estr" version="1.0">

  <xd:doc type="stylesheet">
    <xd:short> TEI stylesheet for weaving TEI ODD documents</xd:short>
    <xd:detail> This library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later
    version. This library is distributed in the hope that it will be
    useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
    PURPOSE. See the GNU Lesser General Public License for more
    details. You should have received a copy of the GNU Lesser General
    Public License along with this library; if not, write to the Free
    Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA </xd:detail>
    <xd:author>See AUTHORS</xd:author>
    <xd:cvsId>$Id: tagdocs.xsl 4845 2008-10-22 21:53:52Z rahtz $</xd:cvsId>
    <xd:copyright>2008, TEI Consortium</xd:copyright>
  </xd:doc>

 <xsl:key name="CHILDMOD" match="Element" use="@module"/>

  <xsl:template match="tei:attDef" mode="summary">
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="tei:altIdent">
          <xsl:value-of select="tei:altIdent"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@ident"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_label</xsl:text>
        </xsl:attribute>
        <xsl:element namespace="{$outputNS}" name="{$codeName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>att</xsl:text>
          </xsl:attribute>
          <xsl:value-of select="$name"/>
        </xsl:element>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_value</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="makeDescription"/>
        <xsl:apply-templates select="valList"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:attDef</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:attDef">
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="tei:altIdent">
          <xsl:value-of select="tei:altIdent"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@ident"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_label</xsl:text>
        </xsl:attribute>
	<xsl:value-of select="$name"/>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_value</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="makeDescription"/>
        <xsl:element namespace="{$outputNS}" name="{$tableName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>attDef</xsl:text>
          </xsl:attribute>
          <xsl:element namespace="{$outputNS}" name="{$rowName}">
            <xsl:element namespace="{$outputNS}" name="{$cellName}">
              <xsl:attribute name="{$rendName}">
                <xsl:text>odd_label</xsl:text>
              </xsl:attribute>
              <xsl:call-template name="i18n">
                <xsl:with-param name="word">Status</xsl:with-param>
              </xsl:call-template>
              <xsl:text> </xsl:text>
            </xsl:element>
            <xsl:element namespace="{$outputNS}" name="{$cellName}">
              <xsl:attribute name="{$rendName}">
                <xsl:text>odd_value</xsl:text>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@usage='mwa'">
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Mandatory when applicable</xsl:with-param>
                  </xsl:call-template>
                </xsl:when>
                <xsl:when test="@usage='opt'">
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Optional</xsl:with-param>
                  </xsl:call-template>
                </xsl:when>
                <xsl:when test="@usage='rec'">
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Recommended</xsl:with-param>
                  </xsl:call-template>
                </xsl:when>
                <xsl:when test="@usage='req'">
		  <xsl:element namespace="{$outputNS}"
			       name="{$hiName}">
                    <xsl:attribute name="{$rendName}">
                      <xsl:text>required</xsl:text>
                    </xsl:attribute>
                    <xsl:call-template name="i18n">
                      <xsl:with-param name="word">Required</xsl:with-param>
                    </xsl:call-template>
		  </xsl:element>
                </xsl:when>
                <xsl:when test="@usage='rwa'">
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Required when applicable</xsl:with-param>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Optional</xsl:with-param>
                  </xsl:call-template>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:element>
          </xsl:element>
          <xsl:apply-templates mode="weave"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:attDef/tei:datatype</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:attDef/tei:datatype" mode="weave">
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_label</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="i18n">
          <xsl:with-param name="word">Datatype</xsl:with-param>
        </xsl:call-template>
        <xsl:text> </xsl:text>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_value</xsl:text>
        </xsl:attribute>
        <xsl:variable name="minOccurs">
          <xsl:choose>
            <xsl:when test="@minOccurs">
              <xsl:value-of select="@minOccurs"/>
            </xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="maxOccurs">
          <xsl:choose>
            <xsl:when test="@maxOccurs='unbounded'">
              <xsl:text>∞</xsl:text>
            </xsl:when>
            <xsl:when test="@maxOccurs">
              <xsl:value-of select="@maxOccurs"/>
            </xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="$minOccurs != 1  or  $maxOccurs != 1">
          <xsl:text> </xsl:text>
          <xsl:value-of select="$minOccurs"/>
          <xsl:text>–</xsl:text>
          <xsl:value-of select="$maxOccurs"/>
	  <xsl:text> </xsl:text>
          <xsl:call-template name="i18n">
            <xsl:with-param name="word">occurrences of</xsl:with-param>
          </xsl:call-template>
          <xsl:text>  </xsl:text>
        </xsl:if>
        <xsl:call-template name="bitOut">
          <xsl:with-param name="grammar"/>
          <xsl:with-param name="content">
            <Wrapper>
              <xsl:copy-of select="rng:*"/>
            </Wrapper>
          </xsl:with-param>
          <xsl:with-param name="element">code</xsl:with-param>
        </xsl:call-template>
        <xsl:if test="$minOccurs != 1  or  $maxOccurs != 1">
          <xsl:call-template name="i18n">
            <xsl:with-param name="word">separated by whitespace</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:attList</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:attList" mode="show">
    <xsl:call-template name="displayAttList">
      <xsl:with-param name="mode">summary</xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:classSpec</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:classSpec">
    <xsl:if test="parent::tei:specGrp">
      <xsl:element namespace="{$outputNS}" name="{$dtName}">
        <xsl:element namespace="{$outputNS}" name="{$hiName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>label</xsl:text>
          </xsl:attribute>
          <xsl:call-template name="i18n">
            <xsl:with-param name="word">Class</xsl:with-param>
          </xsl:call-template>
        </xsl:element>: <xsl:value-of select="@ident"/></xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$ddName}">
        <xsl:apply-templates mode="tangle" select="."/>
        <xsl:text>(</xsl:text>
        <xsl:call-template name="i18n">
          <xsl:with-param name="word">Members</xsl:with-param>
        </xsl:call-template>
        <xsl:text>: </xsl:text>
        <xsl:call-template name="generateMembers"/>
        <xsl:text>)</xsl:text>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:classSpec</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:classSpec" mode="weavebody">
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="tei:altIdent">
          <xsl:value-of select="tei:altIdent"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@ident"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element  namespace="{$outputNS}" name="{$sectionName}">
      <xsl:call-template name="makeSectionHead">
	<xsl:with-param name="id">
	  <xsl:value-of select="@ident"/>
	</xsl:with-param>
	<xsl:with-param name="name">
	  <xsl:value-of select="$name"/>
	</xsl:with-param>
      </xsl:call-template>
      <xsl:element namespace="{$outputNS}" name="{$tableName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>wovenodd</xsl:text>
          </xsl:attribute>
          <xsl:element namespace="{$outputNS}" name="{$rowName}">
            <xsl:element namespace="{$outputNS}" name="{$cellName}">
              <xsl:attribute name="{$colspan}">2</xsl:attribute>
              <xsl:attribute name="{$rendName}">
                <xsl:text>wovenodd-col2</xsl:text>
              </xsl:attribute>
              <xsl:element namespace="{$outputNS}" name="{$hiName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>label</xsl:text>
                </xsl:attribute>
                <xsl:value-of select="$name"/>
              </xsl:element>
	      <xsl:call-template name="specHook">
		<xsl:with-param name="name">
		  <xsl:value-of select="$name"/>
		</xsl:with-param>
	      </xsl:call-template>
              <xsl:text> </xsl:text>
              <xsl:call-template name="makeDescription"/>
              <xsl:if test="tei:listRef">
                <xsl:for-each select="tei:listRef/tei:ptr">
                  <xsl:text> </xsl:text>
                  <xsl:apply-templates select="." mode="weave"/>
                </xsl:for-each>
              </xsl:if>
            </xsl:element>
          </xsl:element>
          <xsl:if test="@generate">
            <xsl:element namespace="{$outputNS}" name="{$rowName}">
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col1</xsl:text>
                </xsl:attribute>
                <xsl:call-template name="i18n">
                  <xsl:with-param name="word">
                    <xsl:text>Classes defined</xsl:text>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:element>
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col2</xsl:text>
                </xsl:attribute>
                <xsl:value-of select="@generate"/>
              </xsl:element>
            </xsl:element>
          </xsl:if>
          <xsl:if test="@module">
            <xsl:call-template name="moduleInfo"/>
          </xsl:if>
          <xsl:if test="@type='model'">
            <xsl:element namespace="{$outputNS}" name="{$rowName}">
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col1</xsl:text>
                </xsl:attribute>
                <xsl:element namespace="{$outputNS}" name="{$hiName}">
                  <xsl:attribute name="{$rendName}">
                    <xsl:text>label</xsl:text>
                  </xsl:attribute>
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Used by</xsl:with-param>
                  </xsl:call-template>
                </xsl:element>
              </xsl:element>
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col2</xsl:text>
                </xsl:attribute>
                <xsl:call-template name="generateParents"/>
              </xsl:element>
            </xsl:element>
          </xsl:if>
          <xsl:element namespace="{$outputNS}" name="{$rowName}">
            <xsl:element namespace="{$outputNS}" name="{$cellName}">
              <xsl:attribute name="{$rendName}">
                <xsl:text>wovenodd-col1</xsl:text>
              </xsl:attribute>
              <xsl:element namespace="{$outputNS}" name="{$hiName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>label</xsl:text>
                </xsl:attribute>
                <xsl:call-template name="i18n">
                  <xsl:with-param name="word">Members</xsl:with-param>
                </xsl:call-template>
              </xsl:element>
            </xsl:element>
            <xsl:element namespace="{$outputNS}" name="{$cellName}">
              <xsl:attribute name="{$rendName}">
                <xsl:text>wovenodd-col2</xsl:text>
              </xsl:attribute>
              <xsl:call-template name="generateMembers"/>
            </xsl:element>
          </xsl:element>
          <xsl:if test="@type='atts'">
            <xsl:element namespace="{$outputNS}" name="{$rowName}">
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col1</xsl:text>
                </xsl:attribute>
                <xsl:element namespace="{$outputNS}" name="{$hiName}">
                  <xsl:attribute name="{$rendName}">
                    <xsl:text>label</xsl:text>
                  </xsl:attribute>
                  <xsl:call-template name="i18n">
                    <xsl:with-param name="word">Attributes</xsl:with-param>
                  </xsl:call-template>
                </xsl:element>
              </xsl:element>
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col2</xsl:text>
                </xsl:attribute>
                <xsl:choose>
                  <xsl:when test="not(tei:attList)">
                    <xsl:call-template name="showAttClasses"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:for-each select="tei:attList">
                      <xsl:call-template name="displayAttList">
                        <xsl:with-param name="mode">all</xsl:with-param>
                      </xsl:call-template>
                    </xsl:for-each>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:element>
            </xsl:element>
          </xsl:if>
          <xsl:apply-templates mode="weave"/>
        </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:classes</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:classes" mode="weave"> </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:elementSpec</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:elementSpec">
    <xsl:if test="parent::tei:specGrp">
      <xsl:element namespace="{$outputNS}" name="{$dtName}">
        <xsl:call-template name="i18n">
          <xsl:with-param name="word">Element</xsl:with-param>
        </xsl:call-template>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@ident"/>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$ddName}">
        <xsl:apply-templates mode="tangle" select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:elementSpec</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>

  <xsl:template match="tei:elementSpec" mode="weavebody">
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="tei:altIdent">
          <xsl:value-of select="tei:altIdent"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@ident"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element  namespace="{$outputNS}" name="{$sectionName}">
      <xsl:call-template name="makeSectionHead">
	<xsl:with-param name="id">
	  <xsl:value-of select="@ident"/>
	</xsl:with-param>
	<xsl:with-param name="name">
	  <xsl:text>&lt;</xsl:text>
	  <xsl:choose>
	    <xsl:when test="tei:content/rng:empty">
	      <xsl:call-template name="emptySlash">
		<xsl:with-param name="name">
		  <xsl:value-of select="$name"/>
		</xsl:with-param>
	      </xsl:call-template>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="$name"/>
	    </xsl:otherwise>
	  </xsl:choose>
	  <xsl:text>&gt;</xsl:text>
	</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="specHook">
	<xsl:with-param name="name">
	  <xsl:value-of select="$name"/>
	</xsl:with-param>
      </xsl:call-template>
      <xsl:element namespace="{$outputNS}" name="{$tableName}">
	  <xsl:attribute name="{$rendName}">
	    <xsl:text>wovenodd</xsl:text>
	  </xsl:attribute>
	  <xsl:element  namespace="{$outputNS}" name="{$rowName}">
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$colspan}">2</xsl:attribute>
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col2</xsl:text>
	      </xsl:attribute>
	      <xsl:element namespace="{$outputNS}" name="{$hiName}">
		<xsl:attribute name="{$rendName}">
		  <xsl:text>label</xsl:text>
		</xsl:attribute>
		<xsl:text>&lt;</xsl:text>
		<xsl:choose>
		  <xsl:when test="tei:content/rng:empty">
		    <xsl:call-template name="emptySlash">
		      <xsl:with-param name="name">
			<xsl:value-of select="$name"/>
		      </xsl:with-param>
		    </xsl:call-template>
		  </xsl:when>
		  <xsl:otherwise>
		    <xsl:value-of select="$name"/>
		  </xsl:otherwise>
		</xsl:choose>
		<xsl:text>&gt; </xsl:text>
	      </xsl:element>
	      <xsl:call-template name="makeDescription"/>
	      <xsl:if test="tei:listRef">
		<xsl:for-each select="tei:listRef/tei:ptr">
		  <xsl:text> </xsl:text>
		  <xsl:apply-templates mode="weave" select="."/>
		</xsl:for-each>
	      </xsl:if>
	    </xsl:element>
	  </xsl:element>
	  
	  <xsl:if test="@module">
	    <xsl:call-template name="moduleInfo"/>
	  </xsl:if>
	    
	  <xsl:element namespace="{$outputNS}" name="{$rowName}">
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col1</xsl:text>
	      </xsl:attribute>
	      <xsl:element namespace="{$outputNS}" name="{$hiName}">
		<xsl:attribute name="{$rendName}">
		  <xsl:text>label</xsl:text>
		</xsl:attribute>
		<xsl:call-template name="i18n">
		  <xsl:with-param name="word">Attributes</xsl:with-param>
		</xsl:call-template>
	      </xsl:element>
	    </xsl:element>
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col2</xsl:text>
	      </xsl:attribute>
	      <xsl:choose>
		<xsl:when test="not(tei:attList)">
		  <xsl:call-template name="showAttClasses"/>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:for-each select="tei:attList">
		    <xsl:call-template name="displayAttList">
		      <xsl:with-param name="mode">all</xsl:with-param>
		    </xsl:call-template>
		  </xsl:for-each>
		</xsl:otherwise>
	      </xsl:choose>
	    </xsl:element>
	  </xsl:element>
	  
	  <xsl:element  namespace="{$outputNS}" name="{$rowName}">
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col1</xsl:text>
	      </xsl:attribute>
	      <xsl:element namespace="{$outputNS}" name="{$hiName}">
		<xsl:attribute name="{$rendName}">
		  <xsl:text>label</xsl:text>
		</xsl:attribute>
		<xsl:call-template name="i18n">
		  <xsl:with-param name="word">Used by</xsl:with-param>
		</xsl:call-template>
	      </xsl:element>
	    </xsl:element>
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col2</xsl:text>
	      </xsl:attribute>
	      <xsl:call-template name="generateParents"/>
	    </xsl:element>
	  </xsl:element>
	  
	  <xsl:element  namespace="{$outputNS}" name="{$rowName}">
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col1</xsl:text>
	      </xsl:attribute>
	      <xsl:element namespace="{$outputNS}" name="{$hiName}">
		<xsl:attribute name="{$rendName}">
		  <xsl:text>label</xsl:text>
		</xsl:attribute>
		<xsl:call-template name="i18n">
		  <xsl:with-param name="word">
		    <xsl:text>May contain</xsl:text>
		  </xsl:with-param>
		</xsl:call-template>
	      </xsl:element>     
	    </xsl:element>
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>wovenodd-col2</xsl:text>
	      </xsl:attribute>
	      <xsl:call-template name="generateChildren"/>
	    </xsl:element>
	  </xsl:element>

	  <xsl:apply-templates mode="weave"/>
	  
	  
	</xsl:element>
    </xsl:element>
  </xsl:template>
  
  <xd:doc>
    <xd:short>Process elements tei:elementSpec/tei:content</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:elementSpec/tei:content" mode="weave">
    <xsl:variable name="name">
      <xsl:choose>
	<xsl:when test="../tei:altIdent">
	  <xsl:value-of select="../tei:altIdent"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="../@ident"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
	<xsl:attribute name="{$rendName}">
	  <xsl:text>wovenodd-col1</xsl:text>
	</xsl:attribute>
	<xsl:element namespace="{$outputNS}" name="{$hiName}">
	  <xsl:attribute name="{$rendName}">
	    <xsl:text>label</xsl:text>
	  </xsl:attribute>
	  <xsl:call-template name="i18n">
	    <xsl:with-param name="word">Declaration</xsl:with-param>
	  </xsl:call-template>
	</xsl:element>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
	<xsl:attribute name="{$rendName}">
	  <xsl:text>wovenodd-col2</xsl:text>
	</xsl:attribute>
	<xsl:call-template name="bitOut">
	  <xsl:with-param name="grammar"/>
	  <xsl:with-param name="content">
	    <Wrapper>
	      <rng:element name="{$name}">
		<xsl:if test="not(key('SCHEMASPECS',1))">
		  <rng:ref name="att.global.attributes"/>
		  <xsl:for-each select="..">
		    <xsl:call-template name="showClassAtts"/>
		  </xsl:for-each>
		</xsl:if>
		<xsl:apply-templates mode="tangle" select="../tei:attList"/>
		<xsl:copy-of select="rng:*"/>
	      </rng:element>
	    </Wrapper>
	  </xsl:with-param>
	</xsl:call-template>
	<xsl:if test="s:*">
	  <xsl:element namespace="{$outputNS}" name="{$divName}">
	    <xsl:attribute name="{$rendName}">
	      <xsl:text>pre</xsl:text>
	    </xsl:attribute>
	    <xsl:apply-templates select="s:*" mode="verbatim"/>
	  </xsl:element>
	</xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <xsl:template name="showClassAtts">
    <xsl:for-each select="tei:classes/tei:memberOf">
      <xsl:for-each select="key('IDENTS',@key)">
	<xsl:if test="tei:attList">
	  <rng:ref name="{@ident}.attributes"/>
	</xsl:if>
	<xsl:call-template name="showClassAtts"/>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
  
  <xd:doc>
    <xd:short>Process the specification elements elements, classes and macros</xd:short>
    <xd:param name="atts">attributes we have been asked to display</xd:param>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:elementSpec|tei:classSpec|tei:macroSpec" mode="show">
    <xsl:param name="atts"/>
    <xsl:variable name="name">
      <xsl:choose>
	<xsl:when test="tei:altIdent">
	  <xsl:value-of select="tei:altIdent"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="@ident"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element namespace="{$outputNS}" name="{$hiName}">
      <xsl:attribute name="{$rendName}">
	<xsl:text>specList-</xsl:text>
	<xsl:value-of select="local-name(.)"/>
      </xsl:attribute>
      <xsl:element namespace="{$outputNS}" name="{$xrefName}">
	<xsl:attribute name="{$urlName}">
	  <xsl:choose>
	    <xsl:when test="$splitLevel=-1">
	      <xsl:text>#</xsl:text>
	      <xsl:value-of select="$name"/>
	    </xsl:when>
	    <xsl:when test="$STDOUT='true'">
	      <xsl:for-each select="key('IDENTS',$name)">
		<xsl:call-template name="getSpecURL">
		  <xsl:with-param name="name">
		    <xsl:value-of select="$name"/>
		  </xsl:with-param>
		  <xsl:with-param name="type">
		    <xsl:value-of select="substring-before(local-name(),'Spec')"/>
		  </xsl:with-param>
		</xsl:call-template>
	      </xsl:for-each>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:text>ref-</xsl:text>
	      <xsl:value-of select="$name"/>
	      <xsl:text>.html</xsl:text>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:attribute>
	<xsl:value-of select="$name"/>
	<xsl:for-each select="key('IDENTS',$name)">
	  <xsl:if test="tei:content/rng:empty">
	    <xsl:text>/</xsl:text>
	  </xsl:if>
	</xsl:for-each>
      </xsl:element>
    </xsl:element>
    <xsl:text> </xsl:text>
    <xsl:call-template name="makeDescription"/>
    <xsl:choose>
      <xsl:when test="$atts='-'"/>
      <xsl:when test="$atts='+'">
	<xsl:call-template name="showAttClasses">
	  <xsl:with-param name="minimal">true</xsl:with-param>
	</xsl:call-template>
      </xsl:when>
      <xsl:when test="$atts=''"/>
      <xsl:when test="string-length($atts)&gt;0">
	<xsl:element namespace="{$outputNS}" name="{$tableName}">
	  <xsl:attribute name="{$rendName}">
	    <xsl:text>specDesc</xsl:text>
	  </xsl:attribute>
	  <xsl:variable name="HERE" select="."/>
	  <xsl:call-template name="splitAttTokens">
	    <xsl:with-param name="HERE" select="$HERE"/>
	    <xsl:with-param name="atts" select="$atts"/>
	  </xsl:call-template>
	</xsl:element>
      </xsl:when>
      <xsl:otherwise>
	<xsl:if test="tei:attList//tei:attDef">
	  <xsl:element namespace="{$outputNS}" name="{$tableName}">
	    <xsl:attribute name="{$rendName}">
	      <xsl:text>attList</xsl:text>
	    </xsl:attribute>
	    <xsl:apply-templates mode="summary" 
				 select="tei:attList//tei:attDef"/>
	  </xsl:element>
	</xsl:if>
	<xsl:call-template name="showAttClasses">
	  <xsl:with-param name="minimal">true</xsl:with-param>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xd:doc>
    <xd:short>Show a selected attribute</xd:short>
    <xd:param name="HERE">the starting node </xd:param>
    <xd:param name="TOKEN">attribute we have been asked to display</xd:param>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template name="doAnAttToken">
    <xsl:param name="HERE"/>
    <xsl:param name="TOKEN"/>
    <xsl:choose>
      <xsl:when test="$HERE/tei:attList//tei:attDef[@ident=$TOKEN]">
	<xsl:for-each select="$HERE/tei:attList//tei:attDef[@ident=$TOKEN]">
	  <xsl:call-template name="showAnAttribute"/>
	</xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
	<xsl:for-each select="$HERE/tei:classes/tei:memberOf">
	  <xsl:for-each select="key('IDENTS',@key)/tei:attList//tei:attDef[@ident=$TOKEN]">
	    <xsl:call-template name="showAnAttribute"/>
	  </xsl:for-each>
	</xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xd:doc>
    <xd:short>Split up and process a space-separated list of attribute names</xd:short>
    <xd:param name="HERE">the starting node </xd:param>
    <xd:param name="TOKEN">attributes we have been asked to display</xd:param>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template name="splitAttTokens">
    <xsl:param name="HERE"/>
    <xsl:param name="atts"/>
    <xsl:choose>
      <xsl:when test="contains($atts,' ')">
	<xsl:call-template name="doAnAttToken">
	  <xsl:with-param name="HERE" select="$HERE"/>
	  <xsl:with-param name="TOKEN" select="substring-before($atts,' ')"/>
	</xsl:call-template>
	<xsl:call-template name="splitAttTokens">
	  <xsl:with-param name="HERE" select="$HERE"/>
	  <xsl:with-param name="atts" select="substring-after($atts,' ')"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="doAnAttToken">
	  <xsl:with-param name="HERE" select="$HERE"/>
	  <xsl:with-param name="TOKEN" select="$atts"/>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xd:doc>
    <xd:short>Display of an attribute</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template name="showAnAttribute">
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
	<xsl:attribute name="{$rendName}">
	  <xsl:text>Attribute</xsl:text>
	</xsl:attribute>
	<xsl:element namespace="{$outputNS}" name="{$hiName}">
	  <xsl:attribute name="{$rendName}">
	    <xsl:text>att</xsl:text>
	  </xsl:attribute>
	  <xsl:choose>
	    <xsl:when test="tei:altIdent">
	      <xsl:value-of select="tei:altIdent"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="@ident"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:element>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
	<xsl:call-template name="makeDescription"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  
  <xd:doc>
    <xd:short>Process elements tei:exemplum</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:exemplum" mode="doc">
    <xsl:variable name="documentationLanguage">
      <xsl:call-template name="generateDoc"/>
    </xsl:variable>
<!--
<xsl:message>check example <xsl:value-of select="."/> with lang <xsl:value-of
select="@xml:lang"/> against <xsl:value-of select="$documentationLanguage"/></xsl:message>-->
    <xsl:choose>
      <xsl:when test="@xml:lang and
		      not(@xml:lang='$documentationLanguage')">
<!--	<xsl:message>reject exemplum <xsl:value-of select="."/> cos 1</xsl:message>-->
      </xsl:when>
      <xsl:when test="not(@xml:lang) and
		      not($documentationLanguage='en') 
		      and
		      ../tei:exemplum[@xml:lang='$documentationLanguage']">
<!--      	<xsl:message>reject exemplum <xsl:value-of select="."/> cos 2</xsl:message>-->
      </xsl:when>
      <xsl:when test="parent::tei:attDef">
	<xsl:element namespace="{$outputNS}" name="{$rowName}">
	  <xsl:element namespace="{$outputNS}" name="{$cellName}">
	    <xsl:attribute name="{$colspan}">
	      <xsl:text>2</xsl:text>
	    </xsl:attribute>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element namespace="{$outputNS}" name="{$rowName}">
          <xsl:element namespace="{$outputNS}" name="{$cellName}">
            <xsl:attribute name="{$rendName}">
              <xsl:text>wovenodd-col1</xsl:text>
            </xsl:attribute>
            <xsl:element namespace="{$outputNS}" name="{$hiName}">
              <xsl:attribute name="{$rendName}">
                <xsl:text>label</xsl:text>
              </xsl:attribute>
              <xsl:call-template name="i18n">
                <xsl:with-param name="word">Example</xsl:with-param>
              </xsl:call-template>
            </xsl:element>
          </xsl:element>
	  <xsl:element namespace="{$outputNS}" name="{$cellName}">
	    <xsl:attribute name="{$rendName}">
	      <xsl:text>wovenodd-col2</xsl:text>
	    </xsl:attribute>
	    <xsl:apply-templates/>
	  </xsl:element>
	</xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:item</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:item">
    <xsl:choose>
      <xsl:when test="parent::tei:list[@type='gloss'] or preceding-sibling::tei:label">
        <xsl:element namespace="{$outputNS}" name="{$ddName}">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:when>
      <xsl:when test="parent::tei:list[@type='elementlist']">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element namespace="{$outputNS}" name="{$itemName}">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:macroSpec</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:macroSpec">
    <xsl:if test="parent::tei:specGrp">
      <xsl:element namespace="{$outputNS}" name="{$dtName}">
        <xsl:value-of select="@ident"/>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$ddName}">
        <xsl:apply-templates mode="tangle" select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:macroSpec in weavebody mode</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:macroSpec" mode="weavebody">
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="tei:altIdent">
          <xsl:value-of select="tei:altIdent"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@ident"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element namespace="{$outputNS}" name="{$sectionName}">
      <xsl:call-template name="makeSectionHead">
	<xsl:with-param name="id">
	  <xsl:value-of select="@ident"/>
	</xsl:with-param>
	<xsl:with-param name="name">
	  <xsl:value-of select="$name"/>
	</xsl:with-param>
      </xsl:call-template>
    <xsl:call-template name="specHook">
      <xsl:with-param name="name">
	<xsl:value-of select="$name"/>
      </xsl:with-param>
    </xsl:call-template>
      <xsl:element namespace="{$outputNS}" name="{$tableName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>wovenodd</xsl:text>
          </xsl:attribute>
          <xsl:element namespace="{$outputNS}" name="{$rowName}">
            <xsl:element namespace="{$outputNS}" name="{$cellName}">
              <xsl:attribute name="{$colspan}">2</xsl:attribute>
              <xsl:element namespace="{$outputNS}" name="{$hiName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>label</xsl:text>
                </xsl:attribute>
                <xsl:value-of select="$name"/>
              </xsl:element>
              <xsl:text> </xsl:text>
              <xsl:call-template name="makeDescription"/>
              <xsl:if test="tei:listRef">
                <xsl:for-each select="tei:listRef/tei:ptr">
                  <xsl:text> </xsl:text>
                  <xsl:apply-templates select="." mode="weave"/>
                </xsl:for-each>
              </xsl:if>
            </xsl:element>
          </xsl:element>
          <xsl:if test="@module">
            <xsl:call-template name="moduleInfo"/>
          </xsl:if>
          <xsl:choose>
	    <xsl:when test="@type='pe' or @type='dt'">
	      <xsl:element namespace="{$outputNS}" name="{$rowName}">
		<xsl:element namespace="{$outputNS}" name="{$cellName}">
		  <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col1</xsl:text>
                </xsl:attribute>
                <xsl:element namespace="{$outputNS}" name="{$hiName}">
                  <xsl:attribute name="{$rendName}">
                    <xsl:text>label</xsl:text>
                  </xsl:attribute>
		  <xsl:call-template name="i18n">
		    <xsl:with-param name="word">Used by</xsl:with-param>
		  </xsl:call-template>
                </xsl:element>
              </xsl:element>
              <xsl:element namespace="{$outputNS}" name="{$cellName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>wovenodd-col2</xsl:text>
                </xsl:attribute>
                <xsl:call-template name="generateParents"/>
              </xsl:element>
            </xsl:element>
	    </xsl:when>
	  </xsl:choose>
          <xsl:apply-templates mode="weave"/>
        </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:macroSpec/tei:content</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:macroSpec/tei:content" mode="weave">
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>wovenodd-col1</xsl:text>
        </xsl:attribute>
        <xsl:element namespace="{$outputNS}" name="{$hiName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>label</xsl:text>
          </xsl:attribute>
          <xsl:call-template name="i18n">
            <xsl:with-param name="word">Declaration</xsl:with-param>
          </xsl:call-template>
        </xsl:element>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>wovenodd-col2</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="bitOut">
          <xsl:with-param name="grammar">true</xsl:with-param>
          <xsl:with-param name="content">
            <Wrapper>
              <xsl:variable name="entCont">
                <Stuff>
                  <xsl:apply-templates select="rng:*"/>
                </Stuff>
              </xsl:variable>
              <xsl:variable name="entCount">
                <xsl:for-each select="exsl:node-set($entCont)/html:Stuff">
                  <xsl:value-of select="count(*)"/>
                </xsl:for-each>
              </xsl:variable>
              <xsl:choose>
                <xsl:when test=".=&quot;TEI.singleBase&quot;"/>
                <xsl:otherwise>
                  <rng:define name="{../@ident}">
                    <xsl:if test="starts-with(.,'component')">
                      <xsl:attribute name="combine">choice</xsl:attribute>
                    </xsl:if>
                    <xsl:copy-of select="rng:*"/>
                  </rng:define>
                </xsl:otherwise>
              </xsl:choose>
            </Wrapper>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:moduleSpec</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:moduleSpec">
    <xsl:element namespace="{$outputNS}" name="{$dlName}">
      <xsl:attribute name="{$rendName}">
        <xsl:text>moduleSpec</xsl:text>
      </xsl:attribute>
      <xsl:element namespace="{$outputNS}" name="{$labelName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>moduleSpecHead</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="i18n">
          <xsl:with-param name="word">Module</xsl:with-param>
        </xsl:call-template>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@ident"/>
        <xsl:text>: </xsl:text>
        <xsl:call-template name="makeDescription"/>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$ddName}">
        <xsl:element namespace="{$outputNS}" name="{$ulName}">
          <xsl:if test="key('ElementModule',@ident)">
            <xsl:element namespace="{$outputNS}" name="{$itemName}">
              <xsl:call-template name="i18n">
                <xsl:with-param name="word">Elements defined</xsl:with-param>
              </xsl:call-template>
              <xsl:text>: </xsl:text>
              <xsl:for-each select="key('ElementModule',@ident)">
                <xsl:sort select="@ident"/>
                <xsl:call-template name="linkTogether">
                  <xsl:with-param name="name" select="@ident"/>
                </xsl:call-template>
		<xsl:call-template name="showSpace"/>
              </xsl:for-each>
            </xsl:element>
          </xsl:if>
          <xsl:if test="key('ClassModule',@ident)">
            <xsl:element namespace="{$outputNS}" name="{$itemName}">
              <xsl:call-template name="i18n">
                <xsl:with-param name="word">Classes defined</xsl:with-param>
              </xsl:call-template>
              <xsl:text>: </xsl:text>
              <xsl:for-each select="key('ClassModule',@ident)">
                <xsl:sort select="@ident"/>
                <xsl:call-template name="linkTogether">
                  <xsl:with-param name="name" select="@ident"/>
                </xsl:call-template>
		<xsl:call-template name="showSpace"/>
              </xsl:for-each>
            </xsl:element>
          </xsl:if>
          <xsl:if test="key('MacroModule',@ident)">
            <xsl:element namespace="{$outputNS}" name="{$itemName}">
              <xsl:call-template name="i18n">
                <xsl:with-param name="word">Macros defined</xsl:with-param>
              </xsl:call-template>
              <xsl:text>: </xsl:text>
              <xsl:for-each select="key('MacroModule',@ident)">
                <xsl:sort select="@ident"/>
                <xsl:call-template name="linkTogether">
                  <xsl:with-param name="name" select="@ident"/>
                </xsl:call-template>
		<xsl:call-template name="showSpace"/>
              </xsl:for-each>
            </xsl:element>
          </xsl:if>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process tei:remarks</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:remarks" mode="doc">
    <xsl:if test="string-length(.)&gt;0">
      <xsl:element namespace="{$outputNS}" name="{$rowName}">
        <xsl:element namespace="{$outputNS}" name="{$cellName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>wovenodd-col1</xsl:text>
          </xsl:attribute>
          <xsl:element namespace="{$outputNS}" name="{$hiName}">
            <xsl:attribute name="{$rendName}">
              <xsl:text>label</xsl:text>
            </xsl:attribute>
            <xsl:call-template name="i18n">
              <xsl:with-param name="word">Note</xsl:with-param>
            </xsl:call-template>
          </xsl:element>
        </xsl:element>
        <xsl:element namespace="{$outputNS}" name="{$cellName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>wovenodd-col2</xsl:text>
          </xsl:attribute>
          <xsl:comment> </xsl:comment>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
  </xsl:template>


  <xd:doc>
    <xd:short>Process elements tei:specDesc</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:specDesc">
    <xsl:element namespace="{$outputNS}" name="{$itemName}">
      <xsl:call-template name="processSpecDesc"/>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:specGrp</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:specGrp"/>

  <xd:doc>
    <xd:short>Process elements tei:specGrpRef</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:specGrpRef"/>

  <xd:doc>
    <xd:short>Process elements tei:specList</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:specList">
    <xsl:element namespace="{$outputNS}" name="{$ulName}">
      <xsl:attribute name="{$rendName}">specList</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:valDesc</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:valDesc" mode="weave">
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_label</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="i18n">
          <xsl:with-param name="word">Values</xsl:with-param>
        </xsl:call-template>
        <xsl:text> </xsl:text>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>attribute</xsl:text>
        </xsl:attribute>
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:val</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:val">
    <xsl:element namespace="{$outputNS}" name="{$hiName}">
      <xsl:attribute name="{$rendName}">
        <xsl:text>val</xsl:text>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:att</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:att">
    <xsl:element namespace="{$outputNS}" name="{$hiName}">
      <xsl:attribute name="{$rendName}">
        <xsl:text>att</xsl:text>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:tag</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:tag">
    <xsl:element namespace="{$outputNS}" name="{$hiName}">
      <xsl:attribute name="{$rendName}">
        <xsl:text>tag</xsl:text>
      </xsl:attribute>
      <xsl:text>&lt;</xsl:text>
      <xsl:apply-templates/>
      <xsl:text>&gt;</xsl:text>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>Process elements tei:valList</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:valList" mode="contents">
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_label</xsl:text>
        </xsl:attribute>
        <xsl:choose>
          <xsl:when test="@type='semi'"><xsl:call-template name="i18n">
              <xsl:with-param name="word">Suggested values include</xsl:with-param>
            </xsl:call-template>:</xsl:when>
          <xsl:when test="@type='open'"><xsl:call-template name="i18n">
              <xsl:with-param name="word">Sample values include</xsl:with-param>
            </xsl:call-template>:</xsl:when>
          <xsl:when test="@type='closed'"><xsl:call-template name="i18n">
              <xsl:with-param name="word">Legal values are</xsl:with-param>
            </xsl:call-template>:</xsl:when>
          <xsl:otherwise>Values are:</xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>odd_value</xsl:text>
        </xsl:attribute>
        <xsl:element namespace="{$outputNS}" name="{$dlName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>valList</xsl:text>
          </xsl:attribute>
          <xsl:for-each select="tei:valItem">
            <xsl:variable name="name">
              <xsl:choose>
                <xsl:when test="tei:altIdent">
                  <xsl:value-of select="tei:altIdent"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="@ident"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
	    <xsl:element namespace="{$outputNS}" name="{$dtName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>odd_label</xsl:text>
                </xsl:attribute>
                <xsl:value-of select="$name"/>
              </xsl:element>
              <xsl:element namespace="{$outputNS}" name="{$ddName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>odd_value</xsl:text>
                </xsl:attribute>
                <xsl:call-template name="makeDescription"/>
                <xsl:if test="@ident=../../tei:defaultVal">
                  <xsl:element namespace="{$outputNS}" name="{$hiName}">
                    <xsl:attribute name="{$rendName}">
                      <xsl:text>defaultVal</xsl:text>
                    </xsl:attribute>
                    <xsl:text> [</xsl:text>
                    <xsl:call-template name="i18n">
                      <xsl:with-param name="word">Default</xsl:with-param>
                    </xsl:call-template>
                    <xsl:text>]</xsl:text>
                  </xsl:element>
                </xsl:if>
              </xsl:element>
          </xsl:for-each>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xd:doc>
    <xd:short>[odds] </xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template name="moduleInfo">
    <xsl:element namespace="{$outputNS}" name="{$rowName}">
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>wovenodd-col1</xsl:text>
        </xsl:attribute>
        <xsl:element namespace="{$outputNS}" name="{$hiName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>label</xsl:text>
          </xsl:attribute>
          <xsl:call-template name="i18n">
            <xsl:with-param name="word">Module</xsl:with-param>
          </xsl:call-template>
        </xsl:element>
      </xsl:element>
      <xsl:element namespace="{$outputNS}" name="{$cellName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>wovenodd-col2</xsl:text>
        </xsl:attribute>
        <xsl:call-template name="makeTagsetInfo"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>


  <xd:doc>
    <xd:short>[odds] </xd:short>
    <xd:param name="mode">mode</xd:param>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template name="displayAttList">
    <xsl:param name="mode"/>
    <xsl:call-template name="showAttClasses"/>
    <xsl:if test=".//tei:attDef">
      <xsl:element namespace="{$outputNS}" name="{$tableName}">
        <xsl:attribute name="{$rendName}">
          <xsl:text>attList</xsl:text>
        </xsl:attribute>
        <xsl:choose>
          <xsl:when test="$mode='all'">
            <xsl:apply-templates/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates mode="summary"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template name="generateParents">
    <xsl:element  namespace="{$outputNS}" name="{$divName}">
      <xsl:attribute name="{$rendName}">parent</xsl:attribute>
      <xsl:call-template name="generateParentsByElement"/>
      <xsl:call-template name="generateParentsByAttribute"/>
      <xsl:call-template name="generateParentsByMacro"/>
      <xsl:call-template name="generateParentsByClass"/>
    </xsl:element>
  </xsl:template>

  <xsl:template name="generateMembers">
    <xsl:param name="depth">1</xsl:param>
    <xsl:param name="me"/>
    <xsl:variable name="this" select="@ident"/>
    <xsl:choose>
      <xsl:when test="$this=$me"/>
      <xsl:when test="key('CLASSMEMBERS',$this)">
        <xsl:element namespace="{$outputNS}" name="{$hiName}">
          <xsl:attribute name="{$rendName}">
            <xsl:text>showmembers</xsl:text>
            <xsl:value-of select="$depth"/>
          </xsl:attribute>
          <xsl:if test="$depth &gt; 1"> [</xsl:if>
          <xsl:for-each select="key('CLASSMEMBERS',$this)">
            <xsl:sort select="local-name()"/>
            <xsl:sort select="@ident"/>
            <xsl:call-template name="showSpace"/>
            <xsl:variable name="cl">
              <xsl:choose>
                <xsl:when test="self::tei:elementSpec">
                  <xsl:text>link_odd_element</xsl:text>
                </xsl:when>
                <xsl:when test="self::tei:classSpec">
                  <xsl:text>link_odd_class</xsl:text>
                </xsl:when>
              </xsl:choose>
            </xsl:variable>
            <xsl:call-template name="linkTogether">
              <xsl:with-param name="name" select="@ident"/>
              <xsl:with-param name="class">
                <xsl:value-of select="$cl"/>
              </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="generateMembers">
              <xsl:with-param name="depth">
                <xsl:value-of select="$depth + 1"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
          <xsl:if test="$depth &gt; 1">] </xsl:if>
        </xsl:element>
      </xsl:when>
      <xsl:when test="$lookupDatabase='true'">
        <xsl:choose>
          <xsl:when test="not($localsource='')">
            <xsl:for-each select="document($localsource)/tei:TEI">
              <xsl:for-each select="tei:elementSpec[tei:classes/tei:memberOf[@key=$this]]">
                <xsl:call-template name="showElement">
                  <xsl:with-param name="name" select="@ident"/>
                </xsl:call-template>
		<xsl:call-template name="showSpace"/>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="address">
              <xsl:value-of select="$TEISERVER"/>
              <xsl:text>classmembers.xq?class=</xsl:text>
              <xsl:value-of select="@ident"/>
            </xsl:variable>
            <xsl:if test="$verbose='true'">
              <xsl:message>Accessing TEISERVER: <xsl:value-of select="$address"/></xsl:message>
            </xsl:if>
            <xsl:for-each select="document($address)/list/item">
              <xsl:call-template name="showElement">
                <xsl:with-param name="name" select="."/>
              </xsl:call-template>
              <xsl:if test="following::item">
                <xsl:text> &#10;</xsl:text>
              </xsl:if>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="generateParentsByElement">
    <xsl:variable name="this" select="@ident"/>
    <xsl:for-each select="key('REFS',$this)/ancestor::tei:elementSpec">
      <xsl:sort select="@ident"/>
      <xsl:call-template name="linkTogether">
        <xsl:with-param name="name" select="@ident"/>
        <xsl:with-param name="class">link_odd_element</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="showSpace"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="generateParentsByAttribute">
    <xsl:variable name="this" select="@ident"/>
    <xsl:if test="count(key('ATTREFS-CLASS',$this))&gt;0">
      <xsl:call-template name="i18n">
	<xsl:with-param name="word">
	  <xsl:text> Class</xsl:text>
	</xsl:with-param>
      </xsl:call-template>
      <xsl:text>: </xsl:text>
      <xsl:element namespace="{$outputNS}" name="{$ulName}">
	<xsl:for-each select="key('ATTREFS-CLASS',$this)">
	  <xsl:sort select="ancestor::tei:classSpec/@ident"/>
	  <xsl:sort select="@ident"/>
	  <xsl:element namespace="{$outputNS}" name="{$itemName}">
	    <xsl:for-each select="ancestor::tei:classSpec">
	      <xsl:call-template name="linkTogether">
		<xsl:with-param name="name">
		  <xsl:value-of select="@ident"/>
		</xsl:with-param>
		<xsl:with-param name="class">
		  <xsl:text>link_odd_class</xsl:text>
		</xsl:with-param>
	      </xsl:call-template>
	    </xsl:for-each>
	    <xsl:text>/@</xsl:text>
	    <xsl:value-of select="ancestor::tei:attDef/@ident"/>
	    <xsl:call-template name="showSpace"/>
	  </xsl:element>
	</xsl:for-each>
      </xsl:element>
    </xsl:if>

    <xsl:if test="count(key('ATTREFS-ELEMENT',$this))&gt;0">
	<xsl:call-template name="i18n">
	  <xsl:with-param name="word">
	    <xsl:text>Element</xsl:text>
	  </xsl:with-param>
	</xsl:call-template>
	<xsl:text>: </xsl:text>
      <xsl:element namespace="{$outputNS}" name="{$ulName}">
	<xsl:for-each select="key('ATTREFS-ELEMENT',$this)">
	  <xsl:sort select="ancestor::tei:elementSpec/@ident"/>
	  <xsl:sort select="@ident"/>
	  <xsl:element namespace="{$outputNS}" name="{$itemName}">
	    <xsl:for-each select="ancestor::tei:elementSpec">
	      <xsl:call-template name="linkTogether">
		<xsl:with-param name="name">
		  <xsl:value-of select="@ident"/>
		</xsl:with-param>
		<xsl:with-param name="class">
		  <xsl:text>link_odd_element</xsl:text>
		</xsl:with-param>
	      </xsl:call-template>
	    </xsl:for-each>
	    <xsl:text>/@</xsl:text>
	    <xsl:value-of select="ancestor::tei:attDef/@ident"/>
	    <xsl:call-template name="showSpace"/>
	  </xsl:element>
	</xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>

  <xsl:template name="generateParentsByMacro">
    <xsl:variable name="this" select="@ident"/>
    <xsl:if test="key('MACROREFS',$this)">
      <xsl:for-each select="key('MACROREFS',$this)/ancestor::tei:macroSpec">
        <xsl:sort select="@ident"/>
	<xsl:call-template name="showSpace"/>
        <xsl:call-template name="linkTogether">
          <xsl:with-param name="name" select="@ident"/>
          <xsl:with-param name="class">link_odd_macro</xsl:with-param>
        </xsl:call-template>
	<xsl:call-template name="showSpace"/>
      </xsl:for-each>
    </xsl:if>
    <!--
      <xsl:for-each select="key('REFS',@ident)/ancestor::tei:elementSpec">
	<xsl:call-template name="linkTogether">
	  <xsl:with-param name="name" select="@ident"/>
	</xsl:call-template>
      </xsl:for-each>
      <xsl:call-template name="generateParentsByMacro"/>
-->
  </xsl:template>

  <xsl:template name="generateParentsByClass">
    <xsl:variable name="this" select="@ident"/>
    <xsl:for-each select="tei:classes/tei:memberOf">
      <xsl:for-each select="key('CLASSES',@key)">
        <xsl:sort select="@ident"/>
        <xsl:if test="@type='model'">
	  <xsl:call-template name="showSpace"/>
          <xsl:call-template name="linkTogether">
            <xsl:with-param name="name" select="@ident"/>
            <xsl:with-param name="class">link_odd_class</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <!--
	  <xsl:for-each select="key('REFS',@ident)/ancestor::tei:elementSpec">
	    <xsl:call-template name="linkTogether">
	      <xsl:with-param name="name" select="@ident"/>
	    </xsl:call-template>
	  </xsl:for-each>
	    <xsl:call-template name="generateParentsByClass"/>
	    <xsl:call-template name="generateParentsByMacro"/>
	-->
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>


<xsl:template match="tei:classSpec|tei:elementSpec|tei:macroSpec" mode="weave">
  <xsl:call-template name="refdoc"/>
</xsl:template>


<xsl:template match="tei:divGen[@type='modelclasscat']">
    <xsl:apply-templates mode="weave" select="key('MODELCLASSDOCS',1)">
      <xsl:sort select="@ident"/>
    </xsl:apply-templates>
  </xsl:template>

<xsl:template match="tei:divGen[@type='attclasscat']">
    <xsl:apply-templates mode="weave" select="key('ATTCLASSDOCS',1)">
      <xsl:sort select="@ident"/>
    </xsl:apply-templates>
  </xsl:template>


  <xsl:template match="tei:divGen[@type='macrocat']">
    <xsl:apply-templates mode="weave" select="key('MACRODOCS',1)">
      <xsl:sort select="@ident"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="tei:divGen[@type='elementcat']">
    <xsl:apply-templates mode="weave" select="key('ELEMENTDOCS',1)">
      <xsl:sort select="@ident"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="tei:divGen[@type='attcat']">
    <xsl:element namespace="{$outputNS}" name="{$tableName}">
      <xsl:attribute name="{$rendName}">
	<xsl:text>attcat</xsl:text>
      </xsl:attribute>
      <xsl:for-each select="key('ATTDOCS',1)">
	<xsl:sort select="@ident"/>
	<xsl:variable name="this">
	  <xsl:value-of select="@ident"/>
	</xsl:variable>
	<xsl:if test="generate-id()=generate-id(key('ATTRIBUTES',$this)[1])">
	  <xsl:element namespace="{$outputNS}" name="{$rowName}">
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>attcat-col1</xsl:text>
	      </xsl:attribute>
	      <xsl:value-of select="$this"/>
	    </xsl:element>
	    <xsl:element namespace="{$outputNS}" name="{$cellName}">
	      <xsl:attribute name="{$rendName}">
		<xsl:text>attcat-col2</xsl:text>
	      </xsl:attribute>
	    <xsl:for-each select="key('ATTRIBUTES-CLASS',$this)">
	      <xsl:sort select="ancestor::tei:classSpec/@ident"/>
	      <xsl:for-each select="ancestor::tei:classSpec|ancestor::elementSpec">
		<xsl:call-template name="linkTogether">
		  <xsl:with-param name="name">
		    <xsl:value-of select="@ident"/>
		  </xsl:with-param>
		  <xsl:with-param name="class">
		    <xsl:text>link_odd</xsl:text>
		  </xsl:with-param>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:text> </xsl:text>
	    </xsl:for-each>
	    <xsl:for-each select="key('ATTRIBUTES-ELEMENT',$this)">
	      <xsl:sort select="ancestor::tei:elementSpec/@ident"/>
	      <xsl:for-each select="ancestor::tei:elementSpec">
		<xsl:call-template name="linkTogether">
		  <xsl:with-param name="name">
		    <xsl:value-of select="@ident"/>
		  </xsl:with-param>
		  <xsl:with-param name="class">
		    <xsl:text>link_odd</xsl:text>
		  </xsl:with-param>
		</xsl:call-template>
	      </xsl:for-each>
	      <xsl:value-of select="$spaceCharacter"/>
	      <xsl:text> </xsl:text>
	    </xsl:for-each>
	    </xsl:element>
	  </xsl:element>
	</xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>


  <xsl:template match="tei:exemplum" mode="weave">
    <xsl:if test="teix:egXML/* or teix:egXML/text() or text()">
      <xsl:apply-templates select="." mode="doc"/>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:short>No-op processing of elements tei:gloss and tei:desc in
    normal modes, as they will always be called explicitly if
    needed.</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>

  <xsl:template match="tei:desc|tei:gloss" mode="weave"/>

  <xsl:template match="tei:remarks" mode="weave">
    <xsl:variable name="documentationLanguage">
      <xsl:call-template name="generateDoc"/>
    </xsl:variable>
    <xsl:variable name="langs">
      <xsl:value-of
	  select="concat(normalize-space($documentationLanguage),' ')"/>
    </xsl:variable>
    <xsl:variable name="firstLang">
      <xsl:value-of select="substring-before($langs,' ')"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="@xml:lang=$firstLang">
	<xsl:apply-templates select="." mode="doc"/>
      </xsl:when>
      <xsl:when test="not(@xml:lang) and $documentationLanguage='en'">
	<xsl:apply-templates select="." mode="doc"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:variable name="currentLang">
	  <xsl:call-template name="findLanguage"/>
	</xsl:variable>
	<xsl:if test="contains($langs,concat($currentLang,' '))">
	  <xsl:apply-templates select="." mode="doc"/>
	</xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xd:doc>
    <xd:short>Process elements tei:valList</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:valList" mode="weave">
    <xsl:apply-templates mode="contents" select="."/>
  </xsl:template>


  <xd:doc>
    <xd:short>Process elements tei:attList</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:attList" mode="weave"/>

  <xd:doc>
    <xd:short>Process elements tei:defaultVal</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:defaultVal" mode="weave" />

  <xd:doc>
    <xd:short>Process elements tei:desc</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:desc">
    <xsl:apply-templates/>
  </xsl:template>

  <!-- pretty printing of RNC -->
  <xsl:template match="nc" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_nc</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="declaration" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_decl</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="prefix" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_prefix</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="param" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_param</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

 
  <xsl:template match="op" mode="keep">
   <xsl:value-of select="translate (., ' ', ' ')"/>
  </xsl:template>

  <xsl:template match="atom" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_atom</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="t" mode="keep">
    <xsl:choose>
      <xsl:when test=". = '[' or . = ']'">
	<xsl:call-template name="showRNC">
	  <xsl:with-param name="style">
	    <xsl:text>rnc_annot</xsl:text>
	  </xsl:with-param>
	  <xsl:with-param name="contents">
	    <xsl:value-of select="."/>
	  </xsl:with-param>
	</xsl:call-template>
	</xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="doc" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_comment</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="annot" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_annot</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="type" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_type</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="keyword" mode="keep">
    <xsl:call-template name="showRNC">
      <xsl:with-param name="style">
        <xsl:text>rnc_keyword</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="contents">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="tei:attList[@org='choice']">
    <xsl:apply-templates/>
  </xsl:template>


<xsl:template name="showAttClasses">
  <xsl:param name="minimal">false</xsl:param>
  <xsl:variable name="clatts">
    <xsl:for-each
	select="ancestor-or-self::tei:elementSpec|ancestor-or-self::tei:classSpec">
      <xsl:call-template name="attClassDetails"/>
    </xsl:for-each>
  </xsl:variable>
  <xsl:if test="$minimal='true'">
    <xsl:text> — </xsl:text>
  </xsl:if>
  <xsl:choose>
      <xsl:when test="$minimal='true' and not($clatts='')">
	<xsl:text> [+ </xsl:text>
	<xsl:copy-of select="$clatts"/>
	<xsl:text>]</xsl:text>
      </xsl:when>
      <xsl:when test="not($clatts='')">
	<xsl:if test="ancestor::tei:schemaSpec and key('CLASSES','att.global')">
	  
	  <xsl:call-template name="i18n">
	    <xsl:with-param name="word">
	      <xsl:choose>
		<xsl:when test=".//tei:attDef">
		  <xsl:call-template name="i18n">
	  <xsl:with-param name="word">In addition to global attributes and those inherited from</xsl:with-param></xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:call-template name="i18n">
	  <xsl:with-param name="word">Global attributes and those inherited from</xsl:with-param></xsl:call-template>
		</xsl:otherwise>
	      </xsl:choose>
	    </xsl:with-param>
        </xsl:call-template>
	</xsl:if>
	<xsl:text> </xsl:text>
	<xsl:copy-of select="$clatts"/>
      </xsl:when>
      <xsl:when test="ancestor::tei:schemaSpec and
		      not(key('CLASSES','att.global'))">
      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="i18n">
	  <xsl:with-param name="word">
	    <xsl:choose>
	      <xsl:when test=".//tei:attDef">
				  <xsl:call-template name="i18n">
	  <xsl:with-param name="word">In addition to global attributes</xsl:with-param></xsl:call-template>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:call-template name="i18n">
	  <xsl:with-param name="word">Global attributes only</xsl:with-param></xsl:call-template>
              </xsl:otherwise>
	    </xsl:choose>
	  </xsl:with-param>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="attClassDetails">
    <xsl:param name="depth">1</xsl:param>
      <xsl:for-each select="tei:classes/tei:memberOf">
	<xsl:choose>
	  <xsl:when test="key('CLASSES',@key)">
	    <xsl:for-each select="key('CLASSES',@key)">
	      <xsl:if test="@type='atts'">
		<xsl:if test="$depth > 1"> (</xsl:if>
		<xsl:call-template name="makeLink">
		  <xsl:with-param name="class">classlink</xsl:with-param>
		  <xsl:with-param name="name">
		    <xsl:value-of select="@ident"/>
		  </xsl:with-param>
		  <xsl:with-param name="text">
		    <xsl:value-of select="@ident"/>
		  </xsl:with-param>
		</xsl:call-template>
		<xsl:if test=".//tei:attDef">
		  <xsl:text> (</xsl:text>
		  <xsl:for-each select=".//tei:attDef">
		    <xsl:call-template name="emphasize">
		      <xsl:with-param name="class">attribute</xsl:with-param>
		      <xsl:with-param name="content">
			<xsl:text>@</xsl:text>
			<xsl:choose>
			  <xsl:when test="tei:altIdent">
			    <xsl:value-of select="tei:altIdent"/>
			  </xsl:when>
			  <xsl:otherwise>
			    <xsl:value-of select="@ident"/>
			  </xsl:otherwise>
			</xsl:choose>
		      </xsl:with-param>
		    </xsl:call-template>
		    <xsl:if test="following-sibling::tei:attDef">
		      <xsl:text>, </xsl:text>
		    </xsl:if>
		  </xsl:for-each>
		  <xsl:text>)</xsl:text>
		  <xsl:if test="$depth=1">
		    <xsl:call-template name="showSpace"/>
		  </xsl:if>
		</xsl:if>
		<xsl:call-template name="attClassDetails">
		  <xsl:with-param name="depth">
		    <xsl:value-of select="$depth + 1"/>
		  </xsl:with-param>
		</xsl:call-template>
		<xsl:if test="$depth > 1">) </xsl:if>
	      </xsl:if>
	    </xsl:for-each>
	  </xsl:when>
	  <xsl:when test="ancestor::tei:schemaSpec">
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="@key"/>
	    <xsl:call-template name="showSpace"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:for-each>
  </xsl:template>

  <xsl:template name="showElement">
    <xsl:param name="name"/>
    <xsl:variable name="documentationLanguage">
      <xsl:call-template name="generateDoc"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$oddmode='tei'">
        <tei:ref target="#{$name}">
          <xsl:value-of select="$name"/>
        </tei:ref>
      </xsl:when>
      <xsl:when test="$oddmode='html'">
        <xsl:choose>
          <xsl:when test="key('IDENTS',$name) and $splitLevel=-1">
            <a class="link_element" href="#{$name}"
              xmlns="http://www.w3.org/1999/xhtml">
              <xsl:value-of select="$name"/>
            </a>
          </xsl:when>
          <xsl:when test="key('IDENTS',$name) and $STDOUT='true'">
            <a class="link_element"
	       xmlns="http://www.w3.org/1999/xhtml">
	      <xsl:attribute name="href">
		<xsl:call-template name="getSpecURL">
		  <xsl:with-param name="name">
		    <xsl:value-of select="$name"/>
		  </xsl:with-param>
		  <xsl:with-param name="type">
		    <xsl:value-of select="substring-before(local-name(),'Spec')"/>
		  </xsl:with-param>
		</xsl:call-template>
	      </xsl:attribute>
	      <xsl:value-of select="$name"/>
            </a>
          </xsl:when>
          <xsl:when test="key('IDENTS',$name)">
            <a class="link_element" href="ref-{$name}{$outputSuffix}"
              xmlns="http://www.w3.org/1999/xhtml">
              <xsl:value-of select="$name"/>
            </a>
          </xsl:when>
          <xsl:when test="$TEIC='true'">
	    <a xmlns="http://www.w3.org/1999/xhtml">
	      <xsl:attribute name="href">
		<xsl:value-of select="$TEISERVER"/>
		<xsl:text>tag.xq?name=</xsl:text>
		<xsl:value-of select="$name"/>
		<xsl:text>&amp;documentationLanguage=</xsl:text>
		<xsl:value-of select="$documentationLanguage"/>
	      </xsl:attribute>
              <xsl:value-of select="$name"/>
            </a>
	  </xsl:when>
          <xsl:otherwise>
	    <xsl:value-of select="$name"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$oddmode='pdf'">
        <fo:inline font-style="italic">
          <xsl:value-of select="$name"/>
        </fo:inline>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="processSpecDesc">
    <xsl:variable name="name">
      <xsl:value-of select="@key"/>
    </xsl:variable>
    <xsl:variable name="atts">
      <xsl:choose>
        <xsl:when test="@rend='noatts'">-</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="normalize-space(@atts)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$name=''">
        <xsl:message>ERROR: no key attribute on specDesc</xsl:message>
      </xsl:when>
      <xsl:when test="key('IDENTS',$name)">
        <xsl:apply-templates mode="show" select="key('IDENTS',$name)">
          <xsl:with-param name="atts" select="$atts"/>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:when test="not($localsource='')">
        <xsl:for-each select="document($localsource)/tei:TEI">
          <xsl:apply-templates mode="show" select="tei:*[@ident=$name]">
            <xsl:with-param name="atts" select="$atts"/>
          </xsl:apply-templates>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="loc">
          <xsl:value-of select="$TEISERVER"/>
          <xsl:text>copytag.xq?name=</xsl:text>
          <xsl:value-of select="$name"/>
        </xsl:variable>
        <xsl:if test="$verbose='true'">
          <xsl:message>Accessing TEISERVER: <xsl:value-of select="$loc"
          /></xsl:message>
        </xsl:if>
        <xsl:apply-templates mode="show" select="document($loc)/tei:*">
          <xsl:with-param name="atts" select="$atts"/>
        </xsl:apply-templates>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="processatts">
    <xsl:param name="values"/>
    <xsl:if test="not($values = '')">
      <xsl:apply-templates select="key('IDENTS',substring-before($values,' '))"/>
      <xsl:call-template name="processatts">
        <xsl:with-param name="values" select="substring-after($values,' ')"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>


  <xd:doc>
    <xd:short>Process elements tei:attList</xd:short>
    <xd:detail> </xd:detail>
  </xd:doc>
  <xsl:template match="tei:attList" mode="show">
    <xsl:call-template name="displayAttList">
      <xsl:with-param name="mode">summary</xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="makeTagsetInfo">
    <xsl:value-of select="@module"/>
    <xsl:for-each
	select="key('MODULES',@module)/ancestor::tei:div[last()]">
      <xsl:text> — </xsl:text>
        <xsl:call-template name="makeInternalLink">
          <xsl:with-param name="target" select="@xml:id"/>
          <xsl:with-param name="ptr">true</xsl:with-param>
          <xsl:with-param name="dest">
            <xsl:value-of select="tei:head"/>
	  </xsl:with-param>
        </xsl:call-template>
    </xsl:for-each>
    <xsl:if test="$verbose='true'">
      <xsl:message> tagset <xsl:value-of select="@xml:id"/>: <xsl:value-of
          select="@module"/></xsl:message>
    </xsl:if>
  </xsl:template>


  <xsl:template name="generateChildren">
    <xsl:variable name="name" select="@ident"/>
    <xsl:variable name="Original" select="/"/>
    <xsl:choose>
      <xsl:when test="tei:content/rng:empty">
	<xsl:call-template name="i18n">
	  <xsl:with-param name="word">Empty element</xsl:with-param>
	</xsl:call-template>
      </xsl:when>
      <xsl:when test="tei:content/rng:text and count(tei:content/rng:*)=1">
	<xsl:call-template name="i18n">
	  <xsl:with-param name="word">Character data only</xsl:with-param>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="Children">
          <Children xmlns="">
            <xsl:for-each select="tei:content">
              <xsl:call-template name="followRef"/>
            </xsl:for-each>
          </Children>
        </xsl:variable>
        <xsl:for-each select="exsl:node-set($Children)/Children">
          <xsl:choose>
	    <xsl:when test="Text and count(Element)=0">
	      <xsl:call-template name="i18n">
		<xsl:with-param name="word">Character data only</xsl:with-param>
	      </xsl:call-template>
	    </xsl:when>
            <xsl:when test="count(Element)=0">
	      <xsl:call-template name="i18n">
		<xsl:with-param name="word">Empty element</xsl:with-param>
	      </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:element namespace="{$outputNS}" name="{$divName}">
                <xsl:attribute name="{$rendName}">
                  <xsl:text>specChildren</xsl:text>
                </xsl:attribute>
                <xsl:for-each select="Element">
                  <xsl:sort select="@module"/>
                  <xsl:sort select="@name"/>
                  <xsl:if test="generate-id(.)=generate-id(key('CHILDMOD',@module)[1])">
                    <xsl:element namespace="{$outputNS}" name="{$divName}">
                      <xsl:attribute name="{$rendName}">
                        <xsl:text>specChild</xsl:text>
                      </xsl:attribute>
                        <xsl:if test="string-length(@module)&gt;0">

			  <xsl:element namespace="{$outputNS}" name="{$segName}">
			    <xsl:attribute name="{$rendName}">
			      <xsl:text>specChildModule</xsl:text>
			    </xsl:attribute>
			    <xsl:value-of select="@module"/>
			    <xsl:text>: </xsl:text>
			  </xsl:element>
			</xsl:if>
			<xsl:element namespace="{$outputNS}" name="{$segName}">
			  <xsl:attribute name="{$rendName}">
			    <xsl:text>specChildElements</xsl:text>
			  </xsl:attribute>
			  <xsl:for-each select="key('CHILDMOD',@module)">
			    <xsl:sort select="@name"/>
			    <xsl:variable name="me">
			      <xsl:value-of select="@name"/>
			    </xsl:variable>
			    <xsl:if
				test="not(preceding-sibling::Element/@name=$me)">
			      <xsl:for-each select="$Original">
				<xsl:call-template name="linkTogether">
				  <xsl:with-param name="name" select="$me"/>
				</xsl:call-template>
			      </xsl:for-each>
			      <xsl:call-template name="showSpace"/>
			    </xsl:if>
			  </xsl:for-each>
			</xsl:element>
		    </xsl:element>
		  </xsl:if>
		</xsl:for-each>
	      </xsl:element>
	    </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="followRef">
    <xsl:for-each select=".//rng:ref">
      <xsl:if test="not(starts-with(@name,'any') 
		    or starts-with(@name,'macro.any')
		    or @name='AnyThing')">
	<xsl:variable name="Name">
	  <xsl:choose>
	    <xsl:when test="contains(@name,'_sequence')">
	      <xsl:value-of select="substring-before(@name,'_')"/>
	    </xsl:when>
	    <xsl:when test="contains(@name,'_alternat')">
	      <xsl:value-of select="substring-before(@name,'_')"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="@name"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:variable>
        <xsl:for-each select="key('IDENTS',$Name)">
          <xsl:choose>
            <xsl:when test="self::tei:elementSpec">
              <Element xmlns="" name="{@ident}" module="{@module}"/>
            </xsl:when>
            <xsl:when test="self::tei:macroSpec">
              <xsl:for-each select="tei:content">
		<xsl:choose>
		  <xsl:when test="rng:text and count(rng:*)=1">
		    <Text xmlns=""/>
		  </xsl:when>
		  <xsl:otherwise>
		    <xsl:call-template name="followRef"/>
		  </xsl:otherwise>
		</xsl:choose>
              </xsl:for-each>
            </xsl:when>
            <xsl:when test="self::tei:classSpec">
              <xsl:call-template name="followMembers"/>
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="followMembers">
    <xsl:for-each select="key('CLASSMEMBERS',@ident)">
      <xsl:choose>
        <xsl:when test="self::tei:elementSpec">
          <Element xmlns="" name="{@ident}" module="{@module}"/>
        </xsl:when>
        <xsl:when test="self::tei:classSpec">
          <xsl:call-template name="followMembers"/>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>




</xsl:stylesheet>
