/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.awt.Rectangle;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYChartContext;

final class PointsComputer {
    private static final int INDEXES_STEP = 1000;
    private int[] arr1;
    private int[] arr2;
    private final int[] count = new int[1];
    private final int[][] ret = new int[2][];

    PointsComputer() {
    }

    void reset() {
        this.arr1 = null;
        this.arr2 = null;
    }

    private int[] arr1(int size) {
        if (this.arr1 == null || this.arr1.length < size) {
            this.arr1 = this.newArr(size + 1000, true);
        }
        return this.arr1;
    }

    private int[] arr2(int size) {
        if (this.arr2 == null || this.arr2.length < size) {
            this.arr2 = this.newArr(size + 1000, false);
        }
        return this.arr2;
    }

    private int[] newArr(int size, boolean arr1) {
        int[] arr = new int[size];
        if (arr1) {
            this.ret[0] = arr;
        }
        return arr;
    }

    int[][] getVisible(Rectangle dirtyArea, int valuesCount, SynchronousXYChartContext context, int extraFactor, int extraTrailing) {
        int i;
        int itemsStep;
        int lastFirst;
        int lastIndex;
        if (context.getViewWidth() == 0L) {
            return null;
        }
        int[][] visibleBounds = context.getVisibleBounds(dirtyArea);
        int firstFirst = visibleBounds[0][0];
        int firstIndex = firstFirst;
        if (firstIndex == -1) {
            firstIndex = visibleBounds[0][1];
        }
        if (firstIndex == -1) {
            return null;
        }
        if (firstFirst != -1) {
            firstIndex = Math.max(firstIndex - 2, 0);
        }
        if ((lastIndex = (lastFirst = visibleBounds[1][0])) == -1) {
            lastIndex = visibleBounds[1][1];
        }
        if (lastIndex == -1) {
            lastIndex = valuesCount - 1;
        }
        if (lastFirst != -1) {
            lastIndex = Math.min(lastIndex + 2, valuesCount - 1);
        }
        if ((itemsStep = (int)Math.ceil((long)valuesCount / context.getViewWidth())) == 0) {
            itemsStep = 1;
        }
        int visibleCount = lastIndex - firstIndex + 1;
        if (itemsStep > 1) {
            int firstMod = firstIndex % itemsStep;
            int lastMod = lastIndex % itemsStep;
            lastIndex = lastIndex - lastMod + itemsStep;
            visibleCount = (lastIndex - (firstIndex -= firstMod)) / itemsStep + 1;
            lastIndex = Math.min(lastIndex, valuesCount - 1);
        }
        int visibleCountEx = extraFactor == 1 ? visibleCount : (visibleCount - 1) * extraFactor + 2;
        this.count[0] = visibleCountEx + extraTrailing;
        int[] visibleIndexes = this.arr1(this.count[0]);
        for (i = 0; i < visibleCountEx; ++i) {
            int index = firstIndex + i / extraFactor * itemsStep;
            if (index > lastIndex) {
                index = lastIndex;
            }
            visibleIndexes[i] = index;
        }
        for (i = visibleCountEx; i < visibleIndexes.length; ++i) {
            visibleIndexes[i] = -1;
        }
        this.ret[1] = this.count;
        return this.ret;
    }

    int getZeroY(SynchronousXYChartContext context) {
        int zeroY = Utils.checkedInt((double)context.getViewY((double)context.getDataOffsetY()));
        zeroY = Math.max(Utils.checkedInt((double)context.getViewportOffsetY()), zeroY);
        zeroY = Math.min(Utils.checkedInt((double)(context.getViewportOffsetY() + (long)context.getViewportHeight())), zeroY);
        return zeroY;
    }

    int[][] createPoints(int[] indexes, int itemsCount, XYItem item, double dataFactor, SynchronousXYChartContext context) {
        int[] xPoints = indexes;
        int[] yPoints = this.arr2(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            int dataIndex = xPoints[i];
            if (dataIndex == -1) continue;
            xPoints[i] = Utils.checkedInt((double)Math.ceil(context.getViewX((double)item.getXValue(dataIndex))));
            yPoints[i] = Utils.checkedInt((double)Math.ceil(context.getViewY((double)item.getYValue(dataIndex) * dataFactor)));
        }
        this.ret[1] = yPoints;
        return this.ret;
    }
}

