/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class NamedServicesProvider {
    private static final Map<String, Reference<Lookup>> namedServicesProviders = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal<Boolean> IN = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lookup forPath(String string) {
        Lookup lookup;
        Reference<Lookup> reference = namedServicesProviders.get(string);
        Lookup lookup2 = lookup = reference == null ? null : reference.get();
        if (lookup != null) {
            return lookup;
        }
        NamedServicesProvider namedServicesProvider = Lookup.getDefault().lookup(NamedServicesProvider.class);
        if (namedServicesProvider != null && IN.get() == null) {
            IN.set(true);
            try {
                lookup = namedServicesProvider.create(string);
            }
            finally {
                IN.set(null);
            }
        } else {
            ClassLoader classLoader = Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = NamedServicesProvider.class.getClassLoader();
            }
            lookup = Lookups.metaInfServices(classLoader, "META-INF/namedservices/" + string);
        }
        namedServicesProviders.put(string, new WeakReference<Lookup>(lookup));
        return lookup;
    }

    public static <T> T getConfigObject(String string, Class<T> clazz) {
        NamedServicesProvider namedServicesProvider = Lookup.getDefault().lookup(NamedServicesProvider.class);
        return namedServicesProvider != null ? (T)namedServicesProvider.lookupObject(string, clazz) : null;
    }

    public static Lookup createLookupFor(Object object) {
        NamedServicesProvider namedServicesProvider = Lookup.getDefault().lookup(NamedServicesProvider.class);
        return namedServicesProvider != null ? namedServicesProvider.lookupFor(object) : null;
    }

    static void clearCache() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!bl) {
            throw new IllegalStateException();
        }
        namedServicesProviders.clear();
    }

    protected NamedServicesProvider() {
        if (this.getClass().getName().equals("org.openide.util.lookup.PathInLookupTest$P")) {
            return;
        }
        if (this.getClass().getName().equals("org.openide.util.UtilitiesTest$NamedServicesProviderImpl")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.filesystems.RecognizeInstanceFiles")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.settings.RecognizeInstanceObjects")) {
            return;
        }
        throw new IllegalStateException();
    }

    protected abstract Lookup create(String var1);

    protected <T> T lookupObject(String string, Class<T> clazz) {
        return this.create(string).lookup(clazz);
    }

    protected Lookup lookupFor(Object object) {
        return null;
    }
}

