/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.ProblemListener;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.xml.sax.SAXException;

public abstract class ApplyXSL
extends HttpServlet {
    protected ApplyXSLProperties ourDefaultParameters;
    public static final String EOL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final String ROOT = System.getProperty("server.root");
    public static String CURRENTDIR;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        CURRENTDIR = ROOT != null ? String.valueOf(ROOT) + FS + "servlets" + FS : String.valueOf(System.getProperty("user.dir")) + FS;
        this.setDefaultParameters(servletConfig);
    }

    protected void setDefaultParameters(ServletConfig servletConfig) {
        this.ourDefaultParameters = new ApplyXSLProperties(servletConfig);
    }

    protected abstract XSLTInputSource getDocument(XSLTProcessor var1, HttpServletRequest var2, ApplyXSLListener var3) throws ApplyXSLException;

    protected abstract XSLTInputSource getStylesheet(HttpServletRequest var1, XSLTInputSource var2, ApplyXSLListener var3, XSLTProcessor var4) throws ApplyXSLException;

    public String getContentType(StylesheetRoot stylesheetRoot) {
        String string = stylesheetRoot.getOutputEncoding();
        String string2 = stylesheetRoot.getOutputMediaType();
        if (string != null) {
            return String.valueOf(string2) + "; charset=" + string;
        }
        return string2;
    }

    public void setStylesheetParams(XSLTProcessor xSLTProcessor, HttpServletRequest httpServletRequest) {
        xSLTProcessor.getXMLProcessorLiaison();
        try {
            xSLTProcessor.setStylesheetParam("servlet-request", new XObject((Object)httpServletRequest));
        }
        catch (Exception exception) {
            return;
        }
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                String[] stringArray = httpServletRequest.getParameterValues(string);
                if (stringArray == null) continue;
                xSLTProcessor.setStylesheetParam(string, (XObject)new XString(stringArray[0]));
            }
            catch (Exception exception) {}
        }
        try {
            xSLTProcessor.setStylesheetParam("servlet-RemoteAddr", (XObject)new XString(httpServletRequest.getRemoteAddr()));
        }
        catch (Exception exception) {}
        try {
            xSLTProcessor.setStylesheetParam("servlet-RemoteHost", (XObject)new XString(httpServletRequest.getRemoteHost()));
        }
        catch (Exception exception) {}
        try {
            xSLTProcessor.setStylesheetParam("servlet-RemoteUser", (XObject)new XString(httpServletRequest.getRemoteUser()));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            XSLTProcessor xSLTProcessor = XSLTProcessorFactory.getProcessor();
            this.process(xSLTProcessor, httpServletRequest, httpServletResponse);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void process(XSLTProcessor xSLTProcessor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl = this.ourDefaultParameters.isDebug(httpServletRequest);
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        ApplyXSLListener applyXSLListener = new ApplyXSLListener();
        XSLTInputSource xSLTInputSource = null;
        XSLTInputSource xSLTInputSource2 = null;
        try {
            xSLTInputSource = this.getDocument(xSLTProcessor, httpServletRequest, applyXSLListener);
            if (xSLTInputSource == null) {
                throw new ApplyXSLException("getDocument() returned null", new NullPointerException(), 404);
            }
        }
        catch (ApplyXSLException applyXSLException) {
            applyXSLException.appendMessage(String.valueOf(EOL) + "getDocument() resulted in ApplyXSLException" + EOL + applyXSLListener.getMessage());
            if (bl) {
                this.writeLog(applyXSLException);
            }
            this.displayException(httpServletResponse, applyXSLException, bl);
            xSLTInputSource = null;
        }
        if (xSLTInputSource != null) {
            try {
                xSLTInputSource2 = this.getStylesheet(httpServletRequest, xSLTInputSource, applyXSLListener, xSLTProcessor);
                if (xSLTInputSource2 == null) {
                    throw new ApplyXSLException("getStylesheet() returned null", new NullPointerException(), 404);
                }
                xSLTInputSource = this.getDocument(xSLTProcessor, httpServletRequest, applyXSLListener);
            }
            catch (ApplyXSLException applyXSLException) {
                applyXSLException.appendMessage(String.valueOf(EOL) + "getStylesheet() resulted in ApplyXSLException" + EOL + applyXSLListener.getMessage());
                if (bl) {
                    this.writeLog(applyXSLException);
                }
                this.displayException(httpServletResponse, applyXSLException, bl);
                xSLTInputSource2 = null;
            }
        }
        if (xSLTInputSource != null && xSLTInputSource2 != null) {
            try {
                XSLTProcessor xSLTProcessor2 = XSLTProcessorFactory.getProcessor();
                try {
                    try {
                        String string = null;
                        string = this.getContentType(xSLTProcessor2.processStylesheet(xSLTInputSource2));
                        if (string != null) {
                            httpServletResponse.setContentType(string);
                        }
                        xSLTProcessor2.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(httpServletRequest));
                        xSLTProcessor2.setProblemListener((ProblemListener)applyXSLListener);
                        if (bl) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            XSLTResultTarget xSLTResultTarget = new XSLTResultTarget((OutputStream)byteArrayOutputStream);
                            this.setStylesheetParams(xSLTProcessor2, httpServletRequest);
                            xSLTProcessor2.process(xSLTInputSource, xSLTInputSource2, xSLTResultTarget);
                            byteArrayOutputStream.writeTo((OutputStream)httpServletResponse.getOutputStream());
                            this.writeLog(applyXSLListener.getMessage(), 200);
                        } else {
                            this.setStylesheetParams(xSLTProcessor2, httpServletRequest);
                            xSLTProcessor2.process(xSLTInputSource, xSLTInputSource2, new XSLTResultTarget((Writer)httpServletResponse.getWriter()));
                        }
                    }
                    catch (Exception exception) {
                        ApplyXSLException applyXSLException = new ApplyXSLException("Exception occurred during Transformation:" + EOL + applyXSLListener.getMessage() + EOL + exception.getMessage(), exception, 500);
                        if (bl) {
                            this.writeLog(applyXSLException);
                        }
                        this.displayException(httpServletResponse, applyXSLException, bl);
                    }
                    Object var12_18 = null;
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    xSLTProcessor2.reset();
                    throw throwable;
                }
                xSLTProcessor2.reset();
            }
            catch (SAXException sAXException) {
                ApplyXSLException applyXSLException = new ApplyXSLException("Exception occurred during ctor/Transformation:" + EOL + applyXSLListener.getMessage() + EOL + sAXException.getMessage(), sAXException, 500);
                if (bl) {
                    this.writeLog(applyXSLException);
                }
                this.displayException(httpServletResponse, applyXSLException, bl);
            }
        }
        if (bl) {
            l = System.currentTimeMillis() - l;
            this.writeLog("  No Conflict Warnings = " + this.ourDefaultParameters.isNoCW(httpServletRequest) + "  Transformation time: " + l + " ms", 200);
        }
    }

    protected void writeLog(ApplyXSLException applyXSLException) {
        this.writeLog(applyXSLException.getMessage(), applyXSLException.getStatusCode(), applyXSLException.getException());
    }

    protected void writeLog(String string, int n, Throwable throwable) {
        if (throwable == null) {
            this.writeLog(string, n);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        System.out.println("Exception is " + throwable.getClass().getName());
        throwable.printStackTrace(printWriter);
        this.log("HTTP Status Code: " + n + " - " + string + EOL + byteArrayOutputStream.toString());
    }

    protected void writeLog(String string, int n) {
        this.log("HTTP Status Code: " + n + " - " + string);
    }

    protected void displayException(HttpServletResponse httpServletResponse, ApplyXSLException applyXSLException, boolean bl) {
        String string = applyXSLException.getMessage();
        string = string == null ? "" : "<B>" + string + "</B>";
        StringTokenizer stringTokenizer = new StringTokenizer(string, EOL);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(String.valueOf(stringTokenizer.nextToken()) + EOL + "<BR>");
        }
        string = stringBuffer.toString();
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            applyXSLException.getException().printStackTrace(printWriter);
            string = String.valueOf(string) + " <PRE> " + byteArrayOutputStream.toString() + " </PRE> ";
        }
        httpServletResponse.setContentType("text/html");
        try {
            httpServletResponse.sendError(applyXSLException.getStatusCode(), string);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException is occurring when sendError is called");
            return;
        }
    }
}

