/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Serializable;
import java.util.Arrays;
import org.trie4j.bv.SuccinctBitVector;

public class LongsRank1OnlySuccinctBitVector
implements Serializable,
SuccinctBitVector {
    static final int BITS_IN_BLOCK = 64;
    static final int BITS_IN_COUNTCACHE = 64;
    private long[] longs;
    private int size;
    private int size1;
    private int[] countCache1;
    private static final byte[][] BITPOS1 = new byte[][]{new byte[0], {7}, {6}, {6, 7}, {5}, {5, 7}, {5, 6}, {5, 6, 7}, {4}, {4, 7}, {4, 6}, {4, 6, 7}, {4, 5}, {4, 5, 7}, {4, 5, 6}, {4, 5, 6, 7}, {3}, {3, 7}, {3, 6}, {3, 6, 7}, {3, 5}, {3, 5, 7}, {3, 5, 6}, {3, 5, 6, 7}, {3, 4}, {3, 4, 7}, {3, 4, 6}, {3, 4, 6, 7}, {3, 4, 5}, {3, 4, 5, 7}, {3, 4, 5, 6}, {3, 4, 5, 6, 7}, {2}, {2, 7}, {2, 6}, {2, 6, 7}, {2, 5}, {2, 5, 7}, {2, 5, 6}, {2, 5, 6, 7}, {2, 4}, {2, 4, 7}, {2, 4, 6}, {2, 4, 6, 7}, {2, 4, 5}, {2, 4, 5, 7}, {2, 4, 5, 6}, {2, 4, 5, 6, 7}, {2, 3}, {2, 3, 7}, {2, 3, 6}, {2, 3, 6, 7}, {2, 3, 5}, {2, 3, 5, 7}, {2, 3, 5, 6}, {2, 3, 5, 6, 7}, {2, 3, 4}, {2, 3, 4, 7}, {2, 3, 4, 6}, {2, 3, 4, 6, 7}, {2, 3, 4, 5}, {2, 3, 4, 5, 7}, {2, 3, 4, 5, 6}, {2, 3, 4, 5, 6, 7}, {1}, {1, 7}, {1, 6}, {1, 6, 7}, {1, 5}, {1, 5, 7}, {1, 5, 6}, {1, 5, 6, 7}, {1, 4}, {1, 4, 7}, {1, 4, 6}, {1, 4, 6, 7}, {1, 4, 5}, {1, 4, 5, 7}, {1, 4, 5, 6}, {1, 4, 5, 6, 7}, {1, 3}, {1, 3, 7}, {1, 3, 6}, {1, 3, 6, 7}, {1, 3, 5}, {1, 3, 5, 7}, {1, 3, 5, 6}, {1, 3, 5, 6, 7}, {1, 3, 4}, {1, 3, 4, 7}, {1, 3, 4, 6}, {1, 3, 4, 6, 7}, {1, 3, 4, 5}, {1, 3, 4, 5, 7}, {1, 3, 4, 5, 6}, {1, 3, 4, 5, 6, 7}, {1, 2}, {1, 2, 7}, {1, 2, 6}, {1, 2, 6, 7}, {1, 2, 5}, {1, 2, 5, 7}, {1, 2, 5, 6}, {1, 2, 5, 6, 7}, {1, 2, 4}, {1, 2, 4, 7}, {1, 2, 4, 6}, {1, 2, 4, 6, 7}, {1, 2, 4, 5}, {1, 2, 4, 5, 7}, {1, 2, 4, 5, 6}, {1, 2, 4, 5, 6, 7}, {1, 2, 3}, {1, 2, 3, 7}, {1, 2, 3, 6}, {1, 2, 3, 6, 7}, {1, 2, 3, 5}, {1, 2, 3, 5, 7}, {1, 2, 3, 5, 6}, {1, 2, 3, 5, 6, 7}, {1, 2, 3, 4}, {1, 2, 3, 4, 7}, {1, 2, 3, 4, 6}, {1, 2, 3, 4, 6, 7}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 5, 7}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 6, 7}, {0}, {0, 7}, {0, 6}, {0, 6, 7}, {0, 5}, {0, 5, 7}, {0, 5, 6}, {0, 5, 6, 7}, {0, 4}, {0, 4, 7}, {0, 4, 6}, {0, 4, 6, 7}, {0, 4, 5}, {0, 4, 5, 7}, {0, 4, 5, 6}, {0, 4, 5, 6, 7}, {0, 3}, {0, 3, 7}, {0, 3, 6}, {0, 3, 6, 7}, {0, 3, 5}, {0, 3, 5, 7}, {0, 3, 5, 6}, {0, 3, 5, 6, 7}, {0, 3, 4}, {0, 3, 4, 7}, {0, 3, 4, 6}, {0, 3, 4, 6, 7}, {0, 3, 4, 5}, {0, 3, 4, 5, 7}, {0, 3, 4, 5, 6}, {0, 3, 4, 5, 6, 7}, {0, 2}, {0, 2, 7}, {0, 2, 6}, {0, 2, 6, 7}, {0, 2, 5}, {0, 2, 5, 7}, {0, 2, 5, 6}, {0, 2, 5, 6, 7}, {0, 2, 4}, {0, 2, 4, 7}, {0, 2, 4, 6}, {0, 2, 4, 6, 7}, {0, 2, 4, 5}, {0, 2, 4, 5, 7}, {0, 2, 4, 5, 6}, {0, 2, 4, 5, 6, 7}, {0, 2, 3}, {0, 2, 3, 7}, {0, 2, 3, 6}, {0, 2, 3, 6, 7}, {0, 2, 3, 5}, {0, 2, 3, 5, 7}, {0, 2, 3, 5, 6}, {0, 2, 3, 5, 6, 7}, {0, 2, 3, 4}, {0, 2, 3, 4, 7}, {0, 2, 3, 4, 6}, {0, 2, 3, 4, 6, 7}, {0, 2, 3, 4, 5}, {0, 2, 3, 4, 5, 7}, {0, 2, 3, 4, 5, 6}, {0, 2, 3, 4, 5, 6, 7}, {0, 1}, {0, 1, 7}, {0, 1, 6}, {0, 1, 6, 7}, {0, 1, 5}, {0, 1, 5, 7}, {0, 1, 5, 6}, {0, 1, 5, 6, 7}, {0, 1, 4}, {0, 1, 4, 7}, {0, 1, 4, 6}, {0, 1, 4, 6, 7}, {0, 1, 4, 5}, {0, 1, 4, 5, 7}, {0, 1, 4, 5, 6}, {0, 1, 4, 5, 6, 7}, {0, 1, 3}, {0, 1, 3, 7}, {0, 1, 3, 6}, {0, 1, 3, 6, 7}, {0, 1, 3, 5}, {0, 1, 3, 5, 7}, {0, 1, 3, 5, 6}, {0, 1, 3, 5, 6, 7}, {0, 1, 3, 4}, {0, 1, 3, 4, 7}, {0, 1, 3, 4, 6}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 5}, {0, 1, 3, 4, 5, 7}, {0, 1, 3, 4, 5, 6}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 2}, {0, 1, 2, 7}, {0, 1, 2, 6}, {0, 1, 2, 6, 7}, {0, 1, 2, 5}, {0, 1, 2, 5, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 4}, {0, 1, 2, 4, 7}, {0, 1, 2, 4, 6}, {0, 1, 2, 4, 6, 7}, {0, 1, 2, 4, 5}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 4, 5, 6, 7}, {0, 1, 2, 3}, {0, 1, 2, 3, 7}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 5, 7}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6, 7}};
    private static final long serialVersionUID = -7658605229245494623L;

    public LongsRank1OnlySuccinctBitVector() {
        this(16);
    }

    public LongsRank1OnlySuccinctBitVector(int initialCapacity) {
        if (initialCapacity == 0) {
            this.longs = new long[0];
            this.countCache1 = new int[0];
        } else {
            this.longs = new long[LongsRank1OnlySuccinctBitVector.longsSize(initialCapacity)];
            this.countCache1 = new int[LongsRank1OnlySuccinctBitVector.countCacheSize(initialCapacity)];
        }
    }

    public LongsRank1OnlySuccinctBitVector(byte[] bytes, int bitsSize) {
        this.size = bitsSize;
        this.longs = new long[LongsRank1OnlySuccinctBitVector.longsSize(bitsSize)];
        this.countCache1 = new int[LongsRank1OnlySuccinctBitVector.countCacheSize(bitsSize)];
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            int b = bytes[i] & 0xFF;
            int n2 = i / 8;
            this.longs[n2] = this.longs[n2] | (long)b << (7 - i % 8) * 8;
            byte[] onePosInB = BITPOS1[b];
            int rest = bitsSize - i * 8;
            if (rest < 8) {
                int nz = onePosInB.length;
                for (int j = 0; j < nz; ++j) {
                    if (onePosInB[j] < rest) continue;
                    onePosInB = Arrays.copyOf(onePosInB, j);
                    break;
                }
            }
            this.size1 += onePosInB.length;
            if ((i + 1) % 8 == 0) {
                this.countCache1[i / 8] = this.size1;
            }
            if (rest < 8) break;
        }
        this.countCache1[(this.size - 1) / 64] = this.size1;
    }

    public LongsRank1OnlySuccinctBitVector(long[] longs, int size, int size1, int[] countCache1) {
        this.longs = longs;
        this.size = size;
        this.size1 = size1;
        this.countCache1 = countCache1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 64);
        for (int i = 0; i < n; ++i) {
            long m = Long.MIN_VALUE >>> i % 64;
            long bi = this.longs[i / 64] & m;
            b.append(bi != 0L ? "1" : "0");
        }
        return b.toString();
    }

    public long[] getLongs() {
        return this.longs;
    }

    public int[] getCountCache1() {
        return this.countCache1;
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.longs[pos / 64] & Long.MIN_VALUE >>> pos % 64) == 0L;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.longs[pos / 64] & Long.MIN_VALUE >>> pos % 64) != 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getSize1() {
        return this.size1;
    }

    @Override
    public void trimToSize() {
        this.longs = Arrays.copyOf(this.longs, LongsRank1OnlySuccinctBitVector.longsSize(this.size));
        this.countCache1 = Arrays.copyOf(this.countCache1, LongsRank1OnlySuccinctBitVector.countCacheSize(this.size));
    }

    @Override
    public void append1() {
        int longsi = this.size / 64;
        int countCachei = this.size / 64;
        if (longsi >= this.longs.length) {
            this.extendLongsAndCountCache();
        }
        if (this.size % 64 == 0 && countCachei > 0) {
            this.countCache1[countCachei] = this.countCache1[countCachei - 1];
        }
        int n = longsi;
        this.longs[n] = this.longs[n] | Long.MIN_VALUE >>> this.size % 64;
        ++this.size;
        int n2 = countCachei;
        this.countCache1[n2] = this.countCache1[n2] + 1;
        ++this.size1;
    }

    @Override
    public void append0() {
        int longsi = this.size / 64;
        int countCachei = this.size / 64;
        if (longsi >= this.longs.length) {
            this.extendLongsAndCountCache();
        }
        if (this.size % 64 == 0 && countCachei > 0) {
            this.countCache1[countCachei] = this.countCache1[countCachei - 1];
        }
        ++this.size;
    }

    public void append(boolean bit) {
        if (bit) {
            this.append1();
        } else {
            this.append0();
        }
    }

    @Override
    public int rank0(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return (cn + 1) * 64 - this.countCache1[cn];
        }
        int ret = cn > 0 ? cn * 64 - this.countCache1[cn - 1] : 0;
        int n = pos / 64;
        for (int i = cn * 64 / 64; i < n; ++i) {
            ret += Long.bitCount(this.longs[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return ret + Long.bitCount((this.longs[n] ^ 0xFFFFFFFFFFFFFFFFL) & Long.MIN_VALUE >> pos % 64);
    }

    @Override
    public int rank1(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache1[cn];
        }
        int ret = cn > 0 ? this.countCache1[cn - 1] : 0;
        int n = pos / 64;
        for (int i = cn * 64 / 64; i < n; ++i) {
            ret += Long.bitCount(this.longs[i]);
        }
        return ret + Long.bitCount(this.longs[n] & Long.MIN_VALUE >> pos % 64);
    }

    public int rank(int pos, boolean b) {
        if (b) {
            return this.rank1(pos);
        }
        return this.rank0(pos);
    }

    @Override
    public int select0(int count) {
        for (int i = 0; i < this.longs.length; ++i) {
            if (i * 64 >= this.size) {
                return -1;
            }
            long v = this.longs[i];
            int c = 64 - Long.bitCount(v);
            if (count <= c) {
                for (int j = 0; j < 64; ++j) {
                    if (i * 64 + j >= this.size) {
                        return -1;
                    }
                    if ((v & Long.MIN_VALUE) == 0L && --count == 0) {
                        return i * 64 + j;
                    }
                    v <<= 1;
                }
                return -1;
            }
            count -= c;
        }
        return -1;
    }

    @Override
    public int select1(int count) {
        for (int i = 0; i < this.longs.length; ++i) {
            if (i * 64 >= this.size) {
                return -1;
            }
            long v = this.longs[i];
            int c = Long.bitCount(v);
            if (count <= c) {
                for (int j = 0; j < 64; ++j) {
                    if (i * 64 + j >= this.size) {
                        return -1;
                    }
                    if ((v & Long.MIN_VALUE) != 0L && --count == 0) {
                        return i * 64 + j;
                    }
                    v <<= 1;
                }
                return -1;
            }
            count -= c;
        }
        return -1;
    }

    public int select(int count, boolean b) {
        if (b) {
            return this.select1(count);
        }
        return this.select0(count);
    }

    @Override
    public int next0(int pos) {
        if (pos >= this.size) {
            return -1;
        }
        int s = pos % 64;
        for (int longsi = pos / 64; longsi < this.longs.length; ++longsi) {
            long v = this.longs[longsi];
            for (int i = s; i < 64; ++i) {
                int p = longsi * 64 + i;
                if (p >= this.size) {
                    return -1;
                }
                if ((v & Long.MIN_VALUE >>> i) != 0L) continue;
                return p;
            }
            s = 0;
        }
        return -1;
    }

    private void extendLongsAndCountCache() {
        int longsSize = (int)((double)this.longs.length * 1.2) + 1;
        this.longs = Arrays.copyOf(this.longs, longsSize);
        int cacheSize = longsSize * 64 / 64 + 1;
        this.countCache1 = Arrays.copyOf(this.countCache1, cacheSize);
    }

    private static int longsSize(int bitSize) {
        return (bitSize - 1) / 64 + 1;
    }

    private static int countCacheSize(int bitSize) {
        return (bitSize - 1) / 64 + 1;
    }
}

