/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.util.concurrent.RateLimiter;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.net.BackPressureState;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.utils.SlidingTimeRate;
import org.apache.cassandra.utils.TimeSource;
import org.apache.cassandra.utils.concurrent.IntervalLock;

class RateBasedBackPressureState
extends IntervalLock
implements BackPressureState {
    private final InetAddress host;
    private final long windowSize;
    final SlidingTimeRate incomingRate;
    final SlidingTimeRate outgoingRate;
    final RateLimiter rateLimiter;

    RateBasedBackPressureState(InetAddress host, TimeSource timeSource, long windowSize) {
        super(timeSource);
        this.host = host;
        this.windowSize = windowSize;
        this.incomingRate = new SlidingTimeRate(timeSource, this.windowSize, this.windowSize / 10L, TimeUnit.MILLISECONDS);
        this.outgoingRate = new SlidingTimeRate(timeSource, this.windowSize, this.windowSize / 10L, TimeUnit.MILLISECONDS);
        this.rateLimiter = RateLimiter.create((double)Double.POSITIVE_INFINITY);
    }

    @Override
    public void onMessageSent(MessageOut<?> message) {
    }

    @Override
    public void onResponseReceived() {
        this.readLock().lock();
        try {
            this.incomingRate.update(1);
            this.outgoingRate.update(1);
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public void onResponseTimeout() {
        this.readLock().lock();
        try {
            this.outgoingRate.update(1);
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public double getBackPressureRateLimit() {
        return this.rateLimiter.getRate();
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RateBasedBackPressureState) {
            RateBasedBackPressureState other = (RateBasedBackPressureState)obj;
            return this.host.equals(other.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    @Override
    public String toString() {
        return String.format("[host: %s, incoming rate: %.3f, outgoing rate: %.3f, rate limit: %.3f]", this.host, this.incomingRate.get(TimeUnit.SECONDS), this.outgoingRate.get(TimeUnit.SECONDS), this.rateLimiter.getRate());
    }
}

