/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring.security2;

import org.jasypt.digest.StringDigester;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.jasypt.util.password.PasswordEncryptor;

public class PasswordEncoder
implements org.springframework.security.providers.encoding.PasswordEncoder {
    private PasswordEncryptor passwordEncryptor = null;
    private StringDigester stringDigester = null;
    private Boolean useEncryptor = null;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
        this.useEncryptor = Boolean.TRUE;
    }

    public void setStringDigester(StringDigester stringDigester) {
        this.stringDigester = stringDigester;
        this.useEncryptor = Boolean.FALSE;
    }

    public String encodePassword(String rawPass, Object salt) {
        this.checkInitialization();
        if (this.useEncryptor.booleanValue()) {
            return this.passwordEncryptor.encryptPassword(rawPass);
        }
        return this.stringDigester.digest(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        this.checkInitialization();
        if (this.useEncryptor.booleanValue()) {
            return this.passwordEncryptor.checkPassword(rawPass, encPass);
        }
        return this.stringDigester.matches(rawPass, encPass);
    }

    private synchronized void checkInitialization() {
        if (this.useEncryptor == null) {
            this.passwordEncryptor = new BasicPasswordEncryptor();
            this.useEncryptor = Boolean.TRUE;
        } else if (this.useEncryptor.booleanValue()) {
            if (this.passwordEncryptor == null) {
                throw new EncryptionInitializationException("Password encoder not initialized: password encryptor is null");
            }
        } else if (this.stringDigester == null) {
            throw new EncryptionInitializationException("Password encoder not initialized: string digester is null");
        }
    }
}

