/*****
 NAME
 	pcommand.h - protocols for command classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PCOMMAND_H_INCLUDED)
#define PCOMMAND_H_INCLUDED

#include <coconut/ptext.h>
#include <coconut/pstream.h>
#include <coconut/pxmlparser.h>
#include <coconut/pmath.h>
#include <coconut/tcommand.h>

@protocol PCommandPart <PDebug>
  - (command_t) type ;
  - (id <PError>) exec: p1 with: p2 ;
  - print: (id) stream ;
@end

@protocol PCommand <PCommandPart, PNode>
@end

@protocol PCmdTextPart <PCommandPart>
  - appendStr: (id <PBasicStr>) str ;
  - appendPtr: (const utf8_char *) text length: (u_int) len ;
  - (id <PText>) text ;
  - doPrintWithNewline: (boolean) flag ;
@end

@protocol PCmdText <PCmdTextPart, PNode>
@end

@protocol PCmdEnvPart <PCommandPart>
    /* if you give null pointer as "name", the original name is used. And if you
       give null pointer as "value", "unset" routine will be called */
  - setNameAndValue: (const char *) name value: (const char *) value ;
  - setName: (const char *) name ;
  - setValue: (const char *) value ;
  - unsetName: (const char *) name ;
  - (const char *) name ;
  - (const char *) value ;
@end

@protocol PCmdEnv <PCmdEnvPart, PNode>
@end

@protocol PCmdNumPart <PCommandPart>
  - setNum: (id <PNumber>) num ;
  - (id <PNumber>) number ;
@end

@protocol PCmdNum <PCmdNumPart, PNode>
@end

@protocol PCmdExitPart <PCommandPart>
  - setExp: (id <PExp>) exp ;
  - (int) intValue ;
@end

@protocol PCmdExit <PCmdExitPart, PNode>
@end

@protocol PCmdPrintPart <PCommandPart>
  - setOutput: (id <PStream>) stream ;
  - (u_int) firstLeftSpaces ;
  - setFirstLeftSpaces: (u_int) spaces ;
@end

@protocol PCmdPrint <PCmdPrintPart, PNode>
@end

@protocol PCmdParserIF <PXMLParserIF>
  - parseNode: (id <PTree>) dst node: (id <PXMLNode>) node ;
@end

@protocol PCmdParser <PCmdParserIF, PXMLParserPart>
@end

#endif /* !defined(PCOMMAND_H_INCLUDED) */

