/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.JavaDateMathParser;

class JavaDateFormatter
implements DateFormatter {
    private static final Map<TemporalField, Long> ROUND_UP_BASE_FIELDS = new HashMap<TemporalField, Long>(6);
    private final String format;
    private final DateTimeFormatter printer;
    private final List<DateTimeFormatter> parsers;
    private final DateTimeFormatter roundupParser;

    JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        this(format, printer, (DateTimeFormatterBuilder builder) -> ROUND_UP_BASE_FIELDS.forEach(builder::parseDefaulting), parsers);
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, Consumer<DateTimeFormatterBuilder> roundupParserConsumer, DateTimeFormatter ... parsers) {
        ROUND_UP_BASE_FIELDS.put(ChronoField.MONTH_OF_YEAR, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.DAY_OF_MONTH, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        long distinctZones = Arrays.stream(parsers).map(DateTimeFormatter::getZone).distinct().count();
        if (distinctZones > 1L) {
            throw new IllegalArgumentException("formatters must have the same time zone");
        }
        long distinctLocales = Arrays.stream(parsers).map(DateTimeFormatter::getLocale).distinct().count();
        if (distinctLocales > 1L) {
            throw new IllegalArgumentException("formatters must have the same locale");
        }
        this.printer = printer;
        this.format = format.startsWith("8") ? format : "8" + format;
        this.parsers = parsers.length == 0 ? Collections.singletonList(printer) : Arrays.asList(parsers);
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        if (!format.contains("||")) {
            builder.append(this.parsers.get(0));
        }
        roundupParserConsumer.accept(builder);
        DateTimeFormatter roundupFormatter = builder.toFormatter(this.locale());
        if (printer.getZone() != null) {
            roundupFormatter = roundupFormatter.withZone(this.zone());
        }
        this.roundupParser = roundupFormatter;
    }

    DateTimeFormatter getRoundupParser() {
        return this.roundupParser;
    }

    DateTimeFormatter getPrinter() {
        return this.printer;
    }

    @Override
    public TemporalAccessor parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty date");
        }
        try {
            return this.doParse(input);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.format + "]", e);
        }
    }

    private TemporalAccessor doParse(String input) {
        if (this.parsers.size() > 1) {
            for (DateTimeFormatter formatter : this.parsers) {
                ParsePosition pos = new ParsePosition(0);
                Object object = formatter.toFormat().parseObject(input, pos);
                if (!this.parsingSucceeded(object, input, pos)) continue;
                return (TemporalAccessor)object;
            }
            throw new DateTimeParseException("Failed to parse with all enclosed parsers", input, 0);
        }
        return this.parsers.get(0).parse(input);
    }

    private boolean parsingSucceeded(Object object, String input, ParsePosition pos) {
        return object != null && pos.getIndex() == input.length();
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.zone())) {
            return this;
        }
        return new JavaDateFormatter(this.format, this.printer.withZone(zoneId), (DateTimeFormatter[])this.parsers.stream().map(p -> p.withZone(zoneId)).toArray(DateTimeFormatter[]::new));
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.locale())) {
            return this;
        }
        return new JavaDateFormatter(this.format, this.printer.withLocale(locale), (DateTimeFormatter[])this.parsers.stream().map(p -> p.withLocale(locale)).toArray(DateTimeFormatter[]::new));
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(DateFormatters.from(accessor));
    }

    @Override
    public String pattern() {
        return this.format;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this.format, this, this.getRoundupParser());
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }

    Collection<DateTimeFormatter> getParsers() {
        return this.parsers;
    }
}

