/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Replace
extends ScalarFunction {
    private final Expression source;
    private final Expression pattern;
    private final Expression replacement;

    public Replace(Source source, Expression src, Expression pattern, Expression replacement) {
        super(source, Arrays.asList(src, pattern, replacement));
        this.source = src;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact(this.source, this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution patternResolution = TypeResolutions.isStringAndExact(this.pattern, this.sourceText(), Expressions.ParamOrdinal.SECOND);
        if (patternResolution.unresolved()) {
            return patternResolution;
        }
        return TypeResolutions.isStringAndExact(this.replacement, this.sourceText(), Expressions.ParamOrdinal.THIRD);
    }

    @Override
    protected Pipe makePipe() {
        return new ReplaceFunctionPipe(this.source(), this, Expressions.pipe(this.source), Expressions.pipe(this.pattern), Expressions.pipe(this.replacement));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Replace::new, this.source, this.pattern, this.replacement);
    }

    @Override
    public boolean foldable() {
        return this.source.foldable() && this.pattern.foldable() && this.replacement.foldable();
    }

    @Override
    public Object fold() {
        return ReplaceFunctionProcessor.doProcess(this.source.fold(), this.pattern.fold(), this.replacement.fold());
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate sourceScript = this.asScript(this.source);
        ScriptTemplate patternScript = this.asScript(this.pattern);
        ScriptTemplate replacementScript = this.asScript(this.replacement);
        return this.asScriptFrom(sourceScript, patternScript, replacementScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate sourceScript, ScriptTemplate patternScript, ScriptTemplate replacementScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s)"), "replace", sourceScript.template(), patternScript.template(), replacementScript.template()), ParamsBuilder.paramsBuilder().script(sourceScript.params()).script(patternScript.params()).script(replacementScript.params()).build(), this.dataType());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Replace(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }
}

